/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.api;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.service.entity.operate.imp.HRMPOperationServiceImpl;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hies.api.dto.EntityFieldConfig;
import kd.hr.hies.api.dto.HRTemplate;
import kd.sdk.annotation.SdkService;

@SdkService(name="HR\u5bfc\u5165\u5bfc\u51fa\u677f\u914d\u7f6e\u57fa\u7840SDK\u670d\u52a1")
public class HRImExptTemplateServiceHelper {
    private static HRBaseServiceHelper helper = new HRBaseServiceHelper("hies_diaetplconf");

    public static OperationResult disableTemplate(List<String> entitys) {
        QFilter qFilter = new QFilter("entity", "in", entitys);
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject[] dynamicObjects = helper.loadDynamicObjectArray(new QFilter[]{qFilter});
        HRMPOperationServiceImpl impl = new HRMPOperationServiceImpl("hies_diaetplconf");
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ishasright", String.valueOf(true));
        OperationResult operationResult = impl.localInvokeOperation("disable", dynamicObjects, operateOption);
        return operationResult;
    }

    public static OperationResult addTemplate(List<HRTemplate> templates) {
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(templates.size());
        for (HRTemplate template : templates) {
            DynamicObject dy = helper.generateEmptyDynamicObject();
            dy.set("number", (Object)template.getNumber());
            dy.set("name", (Object)template.getName());
            dy.set("enable", (Object)"1");
            dy.set("creator", (Object)RequestContext.get().getCurrUserId());
            dy.set("entitytype", (Object)template.getEntitytype());
            dy.set("tmpltype", (Object)template.getTmpltype());
            dy.set("queryentity", (Object)template.getQueryentity());
            dy.set("entity", (Object)template.getEntity());
            if (template.getQueryentity() == null) {
                dy.set("queryentity", (Object)template.getEntity());
            }
            dy.set("orgfield", (Object)template.getOrgfield());
            dy.set("instruction", (Object)template.getInstruction());
            dy.set("allocationpolicy", (Object)template.getAllocationpolicy());
            dy.set("importtype", (Object)template.getImporttype());
            dy.set("mainentityuniqueval", (Object)template.getMainentityuniqueval());
            dy.set("source", (Object)"external");
            dy.set("tplgenmode", (Object)"sysgen");
            dy.set("tpltreeentryentity", (Object)HRImExptTemplateServiceHelper.getEntityFieldConfigs("hies_diaetplconf", template.getEntityFieldConfigs()));
            dynamicObjects.add(dy);
        }
        HRMPOperationServiceImpl impl = new HRMPOperationServiceImpl("hies_diaetplconf");
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ishasright", String.valueOf(true));
        OperationResult operationResult = impl.localInvokeOperation("save", dynamicObjects.toArray(new DynamicObject[0]), operateOption);
        return operationResult;
    }

    private static DynamicObjectCollection getEntityFieldConfigs(String entityId, List<EntityFieldConfig> entityFieldConfigs) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityId);
        EntityType tpltreeentryentity = (EntityType)dataEntityType.getAllEntities().get("tpltreeentryentity");
        DynamicObjectCollection list = new DynamicObjectCollection();
        Map entityMap = entityFieldConfigs.stream().collect(Collectors.groupingBy(item -> item.getEntityName(), Collectors.toList()));
        for (Map.Entry next : entityMap.entrySet()) {
            DynamicObjectCollection entityFileds = new DynamicObjectCollection();
            LinkedHashMap orderTempData = Maps.newLinkedHashMapWithExpectedSize((int)3);
            Map parentEntityNameMap = next.getValue().stream().collect(Collectors.groupingBy(item -> item.getParentEntityName(), Collectors.toList()));
            Iterator iterator1 = parentEntityNameMap.entrySet().iterator();
            long entityPkid = ID.genLongId();
            while (iterator1.hasNext()) {
                DynamicObject one;
                Map.Entry next1 = iterator1.next();
                DynamicObjectCollection fileds = new DynamicObjectCollection();
                long headerPid = 0L;
                if (next1.getKey().equalsIgnoreCase(next.getKey())) {
                    orderTempData.put("header", fileds);
                    one = new DynamicObject((DynamicObjectType)tpltreeentryentity);
                    one.set("id", (Object)entityPkid);
                    one.set("fieldnumber", (Object)next.getKey());
                    one.set("childentity", (Object)next.getKey());
                    one.set("pid", (Object)0L);
                    fileds.add((Object)one);
                    DynamicObject tow = new DynamicObject((DynamicObjectType)tpltreeentryentity);
                    tow.set("id", (Object)ID.genLongId());
                    tow.set("childentity", (Object)next.getKey());
                    tow.set("pid", (Object)one.getLong("id"));
                    fileds.add((Object)tow);
                    headerPid = tow.getLong("id");
                } else {
                    orderTempData.put("entry", fileds);
                    one = new DynamicObject((DynamicObjectType)tpltreeentryentity);
                    one.set("id", (Object)ID.genLongId());
                    one.set("fieldnumber", (Object)next1.getKey());
                    one.set("childentity", (Object)next.getKey());
                    one.set("pid", (Object)entityPkid);
                    fileds.add((Object)one);
                    headerPid = one.getLong("id");
                }
                DynamicObjectCollection items = HRImExptTemplateServiceHelper.getFieldDy(next1.getValue(), next.getKey(), headerPid, tpltreeentryentity);
                fileds.addAll((Collection)items);
                entityFileds.addAll((Collection)fileds);
            }
            HRImExptTemplateServiceHelper.setFiledDataSeq(orderTempData);
            list.addAll((Collection)entityFileds);
        }
        return list;
    }

    private static DynamicObjectCollection getFieldDy(List<EntityFieldConfig> fieldConfigs, String entityName, long pid, EntityType tpltreeentryentity) {
        DynamicObjectCollection fileds = new DynamicObjectCollection();
        for (EntityFieldConfig fieldConfig : fieldConfigs) {
            DynamicObject entryitem = new DynamicObject((DynamicObjectType)tpltreeentryentity);
            entryitem.set("fieldnumber", (Object)fieldConfig.getFieldnumber());
            entryitem.set("isimport", (Object)true);
            entryitem.set("ismustinput", (Object)fieldConfig.isIsmustinput());
            entryitem.set("fieldimportdesc", (Object)fieldConfig.getFieldimportdesc());
            entryitem.set("isfield", (Object)true);
            entryitem.set("imptattr", (Object)fieldConfig.getImptattr());
            entryitem.set("exptattr", (Object)fieldConfig.getExptattr());
            entryitem.set("issheet", (Object)fieldConfig.getIssheet());
            entryitem.set("childentity", (Object)entityName);
            entryitem.set("pid", (Object)pid);
            fileds.add((Object)entryitem);
        }
        return fileds;
    }

    private static void setFiledDataSeq(Map<String, DynamicObjectCollection> orderTempData) {
        AtomicInteger seq = new AtomicInteger(0);
        DynamicObjectCollection header = orderTempData.get("header");
        if (CollectionUtils.isNotEmpty((Collection)header)) {
            header.forEach(item -> item.set("seq", (Object)seq.getAndIncrement()));
        }
        orderTempData.remove("header");
        orderTempData.values().forEach(set -> set.forEach(item -> item.set("seq", (Object)seq.getAndIncrement())));
    }
}

