/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.formplugin;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.KeyValue;
import kd.bos.entity.property.BasedataProp;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.domain.model.newhismodel.HisBaseDataInfoBo;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.common.constants.newhismodel.EnumEntityTpl;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hies.formplugin.hismodel.common.HisModelEntryComHRService;
import kd.hrmp.hies.entry.business.ExportEntryDataHelper;
import kd.hrmp.hies.entry.common.dto.FieldHeaderWriterFormat;
import kd.hrmp.hies.entry.common.plugin.EntryBaseAfterQueryRefBdEventArgs;
import kd.hrmp.hies.entry.common.plugin.EntryBaseBeforeQueryRefBdEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.AfterF7MatchedEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.AfterInitContextArgs;
import kd.hrmp.hies.entry.common.plugin.impt.AfterQueryRefBdEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.BeforeCreateHeaderColumnEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.BeforeQueryRefBdEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.BeforeValidateEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.HREntryImportPlugin;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class HisModelEntryComHRImptPlugin
extends HRDataBaseList
implements HREntryImportPlugin,
HisModelEntryComHRService {
    private boolean isVersionF7 = false;
    private Map.Entry<String, IDataEntityProperty> entryBoidInfo;
    private Set<String> businessF7Fields = new HashSet<String>(8);
    private Set<String> baseDataCtrlFields = new HashSet<String>(8);

    public void beforeCreateHeaderColumn(BeforeCreateHeaderColumnEventArgs args) {
        List fieldCaptions = args.getHeaderWriterFormats();
        if (CollectionUtils.isEmpty((Collection)fieldCaptions)) {
            return;
        }
        this.entryBoidInfo = ExportEntryDataHelper.getEntryBoidEntityProperty((String)args.getEntityId(), (String)args.getEntryKey());
        if (this.entryBoidInfo != null) {
            FieldHeaderWriterFormat idFormat = new FieldHeaderWriterFormat();
            idFormat.setComment(ResManager.loadKDString((String)"1.\u4ec5\u5bfc\u5165\u5355\u636e\u4f53\u65f6\uff0c\u6b64\u5b57\u6bb5\u662f\u5339\u914d\u5355\u636e\u4f53\u6570\u636e\u7684\u552f\u4e00\u6807\u8bc6\uff1b\n2.\u82e5\u9700\u8981\u66f4\u65b0\u5355\u636e\u4f53\u6570\u636e\uff0c\u5219\u9700\u8981\u586b\u5199\u6b64\u5b57\u6bb5\uff1b\u82e5\u9700\u8981\u65b0\u589e\u5355\u636e\u4f53\u6570\u636e\uff0c\u5219\u4e0d\u9700\u8981\u586b\u5199\u6b64\u5b57\u6bb5\uff1b\n3.\u83b7\u53d6\u6b64\u5b57\u6bb5\u503c\u65b9\u5f0f\uff1a\u9009\u4e2d\u5355\u636e\u4f53\u6570\u636e\u5e76\u5bfc\u51fa\u540e\uff0c\u53ef\u5bfc\u51fa\u6b64\u5b57\u6bb5\u503c\u3002", (String)"HisModelEntryComHRExptPlugin_1", (String)"hrmp-hies-ext", (Object[])new Object[0]));
            KeyValue entryBoidKeyValue = new KeyValue(this.entryBoidInfo.getKey(), (Object)this.entryBoidInfo.getValue().getDisplayName().getLocaleValue(), new Object[]{idFormat}, Integer.valueOf(0));
            fieldCaptions.set(0, entryBoidKeyValue);
        }
    }

    public void afterInitContext(AfterInitContextArgs args) {
        this.entryBoidInfo = ExportEntryDataHelper.getEntryBoidEntityProperty((String)args.getEntityId(), (String)args.getEntryKey());
        if (this.entryBoidInfo != null) {
            args.getUniqueFields().clear();
            args.getUniqueFields().add(this.entryBoidInfo.getKey());
        }
    }

    public void beforeQueryRefBd(BeforeQueryRefBdEventArgs args) {
        this.isVersionF7 = this.beforeQueryRefBdCom((EntryBaseBeforeQueryRefBdEventArgs)args, true);
    }

    public void afterQueryRefBd(AfterQueryRefBdEventArgs args) {
        this.afterQueryRefBdCom((EntryBaseAfterQueryRefBdEventArgs)args, this.isVersionF7);
    }

    public void beforeValidate(BeforeValidateEventArgs args) {
        String entityId = args.getEntityId();
        String entryKey = args.getEntryKey();
        HashMap f7ExtUniqueValMap = Maps.newHashMapWithExpectedSize((int)8);
        HashMap f7ExtUniqueValFieldMap = Maps.newHashMapWithExpectedSize((int)8);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityId);
        Map allFields = ((EntityType)type.getAllEntities().get(entryKey)).getFields();
        for (Map.Entry field : allFields.entrySet()) {
            IDataEntityProperty property = (IDataEntityProperty)field.getValue();
            if (!(property instanceof BasedataProp)) continue;
            String baseDataName = ((BasedataProp)property).getBaseEntityId();
            String entityType = HisCommonService.getInstance().entityInhRelation(baseDataName);
            boolean isExtendsHisLineTimeSeq = EnumEntityTpl.LINETIMESEQ_TPL.getNumber().equals(entityType);
            if (!isExtendsHisLineTimeSeq) continue;
            String fieldId = (String)field.getKey();
            String importEntityType = HisCommonService.getInstance().entityInhRelation(entityId);
            boolean isImportEntityHisLineType = EnumEntityTpl.LINETIMESEQ_TPL.getNumber().equals(importEntityType);
            HisBaseDataInfoBo hisControlAttribute = HisCommonService.getInstance().getHisControlAttribute(entityId, fieldId);
            String bsedField = isImportEntityHisLineType ? "bsed" : hisControlAttribute.getBsedField();
            LOGGER.info("\u4e1a\u52a1\u751f\u6548\u65e5\u671f\u5173\u8054\u5b57\u6bb5id:{}", (Object)bsedField);
            IDataEntityProperty bsedFieldProperty = (IDataEntityProperty)allFields.get(bsedField);
            if (ObjectUtils.isEmpty((Object)bsedFieldProperty)) continue;
            if (entityId.equals(bsedFieldProperty.getParent().getName())) {
                return;
            }
            boolean selData = hisControlAttribute.isSelData();
            if (selData) {
                this.businessF7Fields.add(fieldId);
                boolean isBaseDataCtrl = Boolean.TRUE.equals(BaseDataServiceHelper.checkBaseDataCtrl((String)baseDataName));
                if (!isBaseDataCtrl) continue;
                f7ExtUniqueValMap.put(fieldId, "firstbsed");
                Map f7ExtUniqueValFieldMapSub = f7ExtUniqueValFieldMap.computeIfAbsent(fieldId, val -> Maps.newHashMapWithExpectedSize((int)8));
                f7ExtUniqueValFieldMapSub.put("firstbsed", bsedField);
                this.baseDataCtrlFields.add(fieldId);
                continue;
            }
            f7ExtUniqueValMap.put(fieldId, "bsed,bsled");
            Map f7ExtUniqueValFieldMapSub = f7ExtUniqueValFieldMap.computeIfAbsent(fieldId, val -> Maps.newHashMapWithExpectedSize((int)8));
            f7ExtUniqueValFieldMapSub.put("bsed", bsedField);
            f7ExtUniqueValFieldMapSub.put("bsled", bsedField);
        }
        args.setF7ExtUniqueValMap((Map)f7ExtUniqueValMap);
        args.setF7ExtUniqueValFieldMap((Map)f7ExtUniqueValFieldMap);
    }

    public void afterF7Matched(AfterF7MatchedEventArgs args) {
        String fieldId = args.getFieldId();
        if (this.businessF7Fields.contains(fieldId) && !this.baseDataCtrlFields.contains(fieldId)) {
            return;
        }
        String currentF7Key = (String)args.getCurrentF7Key();
        if (StringUtils.isBlank((CharSequence)currentF7Key)) {
            return;
        }
        String[] split = currentF7Key.split(",");
        if (split.length == 1) {
            return;
        }
        String bsedKey = split[1];
        Map f7QueryDataMap = args.getF7QueryDataMap();
        if (MapUtils.isEmpty((Map)f7QueryDataMap)) {
            return;
        }
        ArrayList baseDataDys = new ArrayList(f7QueryDataMap.size());
        for (Map.Entry entry : f7QueryDataMap.entrySet()) {
            String key = (String)entry.getKey();
            String[] split2 = key.split(",");
            String bdKey = split2[0];
            if (!bdKey.equals(split[0])) continue;
            if (this.baseDataCtrlFields.contains(fieldId)) {
                String firstbsed = split2[1];
                if (bsedKey.compareTo(firstbsed) < 0) continue;
                baseDataDys.addAll((Collection)entry.getValue());
                continue;
            }
            String dateStart = split2[1];
            String dateEnd = split2[2];
            if (bsedKey.compareTo(dateStart) < 0 || bsedKey.compareTo(dateEnd) > 0) continue;
            args.setBaseDataDys((List)entry.getValue());
            return;
        }
        if (CollectionUtils.isNotEmpty(baseDataDys)) {
            args.setBaseDataDys(baseDataDys);
        }
    }
}

