/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.formplugin.odc.filter;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.domain.odc.service.DataFilterService;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.impt.common.plugin.BeforeQueryRefBdEventArgs;
import kd.hr.impt.common.plugin.HRImportPlugin;

@ExcludeFromJacocoGeneratedReport
public class OdcFilterImportPlugin
extends HRDataBaseList
implements HRImportPlugin {
    private static final String HAOS_ADMINORGHR = "haos_adminorghr";
    private static final String HBPM_POSITIONHR = "hbpm_positionhr";
    private static final String HBPM_STPOSITION = "hbpm_stposition";
    private static final String HBPM_JOBGRADEHR = "hbjm_jobgradehr";
    private static final String HBPM_JOBLEVELHR = "hbjm_joblevelhr";
    private static final String HBJM_JOBHR = "hbjm_jobhr";

    public void beforeQueryRefBd(BeforeQueryRefBdEventArgs args) {
        String baseDataName = args.getBaseDataName();
        String entityId = args.getEntityId();
        QFilter[] filters = args.getFilters();
        List<QFilter> filtersList = Arrays.stream(filters).collect(Collectors.toList());
        switch (baseDataName) {
            case "haos_adminorghr": {
                filtersList.add(new QFilter("isvirtualorg", "=", (Object)"0"));
                args.setFilters(filtersList.toArray(new QFilter[0]));
                break;
            }
            case "hbpm_positionhr": {
                filtersList.add(new QFilter("datastatus", "!=", (Object)"0"));
                filtersList.add(this.getCreatemodeFilter());
                args.setFilters(filtersList.toArray(new QFilter[0]));
                break;
            }
            case "hbpm_stposition": {
                filtersList.add(this.getCreatemodeFilter());
                QFilter adminOrgSuitRangeFilter = DataFilterService.getInstance().getAdminorgSuitRangeFilter(entityId);
                if (!HRObjectUtils.isEmpty((Object)adminOrgSuitRangeFilter)) {
                    filtersList.add(adminOrgSuitRangeFilter);
                }
                args.setFilters(filtersList.toArray(new QFilter[0]));
                break;
            }
            case "hbjm_jobgradehr": {
                QFilter jobGradeScmFilter = DataFilterService.getInstance().getJobGradeScmFilter(entityId);
                if (!HRObjectUtils.isEmpty((Object)jobGradeScmFilter)) {
                    filtersList.add(jobGradeScmFilter);
                }
                args.setFilters(filtersList.toArray(new QFilter[0]));
                break;
            }
            case "hbjm_joblevelhr": {
                QFilter jobLevelScmFilter = DataFilterService.getInstance().getJobLevelScmFilter(entityId);
                if (!HRObjectUtils.isEmpty((Object)jobLevelScmFilter)) {
                    filtersList.add(jobLevelScmFilter);
                }
                args.setFilters(filtersList.toArray(new QFilter[0]));
                break;
            }
            case "hbjm_jobhr": {
                break;
            }
        }
    }

    private QFilter getCreatemodeFilter() {
        return new QFilter("createmode", "!=", (Object)"3");
    }
}

