/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.earlywarn.expfield;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.function.service.ReportFunctionExecuteService;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.function.ReportFunctionSubPagePlugin;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.calfield.WarnCalcFieldService;
import kd.hr.hrcs.common.constants.earlywarn.WarnCalFieldConstants;
import kd.hr.hrcs.common.model.earlywarn.WarnCalFieldBo;
import kd.hr.hrcs.common.util.earlywarn.WarningCommonUtils;
import org.apache.commons.lang3.StringUtils;

public class WarnExpFieldPlugin
extends ReportFunctionSubPagePlugin
implements WarnCalFieldConstants {
    public static final String RETURN_LIST_EXP_FIELD_KEY = "RETURN_LIST_EXP_FIELD_KEY";
    public static final String RETURN_CURRENT_EXP_FIELD_KEY = "RETURN_CURRENT_EXP_FIELD_KEY";
    private static final Pattern NUMBER_START_PATTERN = Pattern.compile("^[0-9]");
    private static final String FUNCTION_FLEX = "functionflex";
    private static final Log LOGGER = LogFactory.getLog(WarnExpFieldPlugin.class);
    private final Random rand = new SecureRandom();

    @ExcludeFromJacocoGeneratedReport
    public void afterCreateNewData(EventObject eventObject) {
        try {
            String currentExpFieldStr = (String)this.getView().getFormShowParameter().getCustomParam("currentCalField");
            String allCalFieldsStr = (String)this.getView().getFormShowParameter().getCustomParam("calFields");
            String expr = "";
            if (HRStringUtils.isNotEmpty((String)currentExpFieldStr)) {
                WarnCalFieldBo currentCalField = (WarnCalFieldBo)SerializationUtils.fromJsonString((String)currentExpFieldStr, WarnCalFieldBo.class);
                this.getModel().setValue("name", (Object)currentCalField.getFieldName());
                this.getModel().setValue("number", (Object)currentCalField.getFieldNumber());
                this.getModel().setValue("type", (Object)currentCalField.getValueType());
                this.getModel().setValue("confway", (Object)currentCalField.getConfWay());
                this.getModel().setValue("serviceclass", (Object)currentCalField.getServiceClass());
                expr = currentCalField.getViewExpr();
                if (HRStringUtils.isEmpty((String)expr)) {
                    expr = currentCalField.getExpr();
                }
                this.getModel().setValue("expr", (Object)expr);
                if (HRStringUtils.isNotEmpty((String)allCalFieldsStr)) {
                    List allCalFields = JSON.parseArray((String)allCalFieldsStr, WarnCalFieldBo.class);
                    allCalFields.removeIf(field -> HRStringUtils.equals((String)currentCalField.getFieldNumber(), (String)field.getFieldNumber()));
                    allCalFieldsStr = SerializationUtils.toJsonString((Object)allCalFields);
                }
                this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
            }
            this.getPageCache().put("calFields", allCalFieldsStr);
            List<Map<String, Object>> fields = this.getAllSelectedFields(false);
            this.initFuncPageView(FUNCTION_FLEX, fields, ReportFunctionExecuteService.class.getName(), expr);
        }
        catch (Exception exception) {
            LOGGER.error("WarnExpFieldPlugin.afterCreateNewData_error:", (Throwable)exception);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public void beforeBindData(EventObject eventObject) {
        try {
            super.beforeBindData(eventObject);
            HashMap map = new HashMap(1);
            HashMap<String, String> item = new HashMap<String, String>(1);
            map.put("item", item);
            if (WarningCommonUtils.validateNumberByISVIsKD()) {
                item.put("emptytip", String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5f00\u5934\uff0c\u652f\u6301\u82f1\u6587\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\u3002", (String)"WarnExpFieldPlugin_0", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0]), "kdhr_"));
            } else {
                item.put("emptytip", ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u82f1\u6587\u5927\u5c0f\u5199\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\u3002", (String)"WarnExpFieldPlugin_1", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0]));
            }
            this.getView().updateControlMetadata("number", map);
        }
        catch (Exception exception) {
            LOGGER.error("WarnExpFieldPlugin.beforeBindData_error:", (Throwable)exception);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.getModel().setDataChanged(false);
        this.setConfiguration((String)this.getModel().getValue("confway"));
    }

    @ExcludeFromJacocoGeneratedReport
    public void beforePropertyChanged(PropertyChangedArgs changedArgs) {
        String fieldKey = changedArgs.getProperty().getName();
        if ("confway".equals(fieldKey)) {
            if (StringUtils.isNotBlank((CharSequence)((String)this.getModel().getValue("serviceclass"))) || StringUtils.isNotBlank((CharSequence)this.getExpr())) {
                ConfirmCallBackListener confirmListener = new ConfirmCallBackListener("confway_change_confirm", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u914d\u7f6e\u65b9\u5f0f\uff0c\u5c06\u6e05\u7a7a\u89c4\u5219\u914d\u7f6e\uff0c\u786e\u5b9a\u4fee\u6539\u5417\uff1f", (String)"WarnExpFieldPlugin_14", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.OKCancel, null, confirmListener, null, (String)changedArgs.getChangeSet()[0].getOldValue());
            } else {
                this.setConfiguration((String)changedArgs.getChangeSet()[0].getNewValue());
                super.updateFunctionViewForExpr("");
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private String getExpr() {
        String functionViewPageId = this.getPageCache().get("functionViewPageId");
        IFormView functionView = this.getView().getView(functionViewPageId);
        if (null != functionView) {
            return (String)functionView.getModel().getValue("displayfunctiontext");
        }
        return "";
    }

    @ExcludeFromJacocoGeneratedReport
    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if ("confway_change_confirm".equals(event.getCallBackId())) {
            if (MessageBoxResult.Yes.equals((Object)event.getResult())) {
                this.setConfiguration((String)this.getModel().getValue("confway"));
                this.getModel().setValue("serviceclass", (Object)"");
                String functionViewPageId = this.getPageCache().get("functionViewPageId");
                IFormView functionView = this.getView().getView(functionViewPageId);
                if (null != functionView) {
                    functionView.getModel().setValue("displayfunctiontext", (Object)"");
                    super.updateFunctionViewForExpr("");
                }
            } else {
                this.getModel().beginInit();
                this.getModel().setValue("confway", (Object)event.getCustomVaule());
                this.getView().updateView("confway");
                this.getModel().endInit();
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void setConfiguration(String radiogroupfield) {
        if ("1".equals(radiogroupfield)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"serviceclass"});
            this.getView().setVisible(Boolean.TRUE, new String[]{FUNCTION_FLEX});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"serviceclass"});
            this.getView().setVisible(Boolean.FALSE, new String[]{FUNCTION_FLEX});
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        try {
            super.beforeDoOperation(args);
            AbstractOperate op = (AbstractOperate)args.getSource();
            String operateKey = op.getOperateKey();
            if (HRStringUtils.equals((String)operateKey, (String)"ok") && this.validateNumberAndName(args)) {
                boolean isReport = false;
                StringBuilder errorMsg = new StringBuilder();
                Map exprMap = this.parseFunctionExpr(errorMsg);
                if (exprMap == null) {
                    this.getView().showTipNotification(errorMsg.toString());
                    args.setCancel(true);
                } else {
                    String expr = (String)exprMap.get("expr");
                    if (HRStringUtils.isBlank((CharSequence)expr) && "1".equals(this.getModel().getValue("confway"))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WarnExpFieldPlugin_2", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    ArrayList newGenCalculateFields = Lists.newArrayListWithCapacity((int)10);
                    errorMsg = new StringBuilder();
                    WarnCalFieldBo currentCalField = this.getCurrentCalField();
                    String calculateStr = this.getPageCache().get("calFields");
                    List<Object> calculateFieldBos = Lists.newArrayListWithCapacity((int)10);
                    if (HRStringUtils.isNotEmpty((String)calculateStr)) {
                        calculateFieldBos = JSON.parseArray((String)calculateStr, WarnCalFieldBo.class);
                    }
                    if (currentCalField != null) {
                        // empty if block
                    }
                    calculateFieldBos.addAll(newGenCalculateFields);
                    String runExpr = (String)exprMap.get("runExpr");
                    ArrayList<String> refFieldNums = new ArrayList<String>((Set)exprMap.get("refFieldNums"));
                    if ("1".equals(this.getModel().getValue("confway"))) {
                        Map<String, Object> defaultValMap = this.getDefaultValMap(refFieldNums);
                        Object executeResult = this.preExecuteExpr(runExpr, defaultValMap, errorMsg);
                        if (executeResult == null && errorMsg.length() > 0) {
                            this.getView().showTipNotification(errorMsg.toString());
                            args.setCancel(true);
                            return;
                        }
                        if (!this.validateExpr(args, executeResult)) {
                            return;
                        }
                    } else {
                        Pattern compile = Pattern.compile("^[a-zA-Z0-9_.]+$");
                        String serviceClass = (String)this.getModel().getValue("serviceclass");
                        if (StringUtils.isNotBlank((CharSequence)serviceClass) && !compile.matcher(serviceClass).matches()) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u89c4\u5219\u670d\u52a1\u7c7b\u683c\u5f0f\u9519\u8bef\uff0c\u4ec5\u652f\u6301\u8f93\u5165\u82f1\u6587\u3001\u6570\u5b57\u3001\u201c_\u201d\u6216\u201c.\u201d \u3002", (String)"WarnExpFieldPlugin_12", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0]));
                            args.setCancel(true);
                            return;
                        }
                        HRBaseServiceHelper appHelper = new HRBaseServiceHelper("bos_devportal_bizapp");
                        if (StringUtils.isNotBlank((CharSequence)serviceClass) && (serviceClass.split("\\.").length == 0 || !appHelper.isExists(new QFilter("number", "=", (Object)serviceClass.split("\\.")[0])))) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u89c4\u5219\u670d\u52a1\u7c7b\u9519\u8bef\uff0c\u8bf7\u6309\u89c4\u8303\u201c\u670d\u52a1\u7c7b\u6240\u5c5e\u5e94\u7528\u7f16\u7801.\u670d\u52a1\u7c7b\u540d\u201d\u586b\u5199\u3002", (String)"WarnExpFieldPlugin_13", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0]));
                            args.setCancel(true);
                            return;
                        }
                    }
                    currentCalField = this.setCurrentCalculateField(currentCalField, calculateFieldBos, newGenCalculateFields, exprMap);
                    this.handleCalculateRefFieldAndOrder(args, currentCalField, calculateFieldBos, newGenCalculateFields, refFieldNums);
                    calculateFieldBos = calculateFieldBos.stream().sorted(Comparator.comparingInt(WarnCalFieldBo::getIndex)).collect(Collectors.toList());
                    HashMap returnData = Maps.newHashMapWithExpectedSize((int)2);
                    returnData.put(RETURN_LIST_EXP_FIELD_KEY, SerializationUtils.toJsonString((Object)calculateFieldBos));
                    returnData.put(RETURN_CURRENT_EXP_FIELD_KEY, SerializationUtils.toJsonString((Object)currentCalField));
                    this.getView().returnDataToParent((Object)returnData);
                    this.closeConfirmStatus = true;
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("WarnExpFieldPlugin.beforeDoOperation_error:", (Throwable)exception);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void handleCalculateRefFieldAndOrder(BeforeDoOperationEventArgs args, WarnCalFieldBo currentCalField, List<WarnCalFieldBo> calculateFieldBos, List<WarnCalFieldBo> newGenCalculateFields, List<String> refFieldNums) {
        for (WarnCalFieldBo newGenCalculateField : newGenCalculateFields) {
            this.parseCalFieldRef(newGenCalculateField.getExpr(), newGenCalculateField, calculateFieldBos, refFieldNums);
        }
        this.parseCalFieldRef(currentCalField.getExpr(), currentCalField, calculateFieldBos, refFieldNums);
        ArrayList refLinks = Lists.newArrayListWithCapacity((int)10);
        refLinks.add(currentCalField.getFieldName().getLocaleValue());
        ArrayList rings = Lists.newArrayListWithCapacity((int)10);
        calculateFieldBos.add(currentCalField);
        this.addCalFieldOrder(refLinks, currentCalField, calculateFieldBos, rings);
        this.handleRefPreIndexOrder(calculateFieldBos);
        if (rings.size() > 0) {
            StringBuilder ringSb = new StringBuilder();
            for (List ring : rings) {
                ringSb.append(ring).append(",");
            }
            String msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5b58\u5728\u5faa\u73af\u8ba1\u7b97\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"WarnExpFieldPlugin_3", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0]), ringSb.substring(0, ringSb.length() - 1));
            this.getView().showTipNotification(msg);
            args.setCancel(true);
            return;
        }
        Optional<Integer> minOrder = calculateFieldBos.stream().map(WarnCalFieldBo::getOrder).min(Comparator.naturalOrder());
        if (minOrder.isPresent() && minOrder.get() > 0) {
            calculateFieldBos.forEach(field -> field.setOrder(Integer.valueOf(field.getOrder() - (Integer)minOrder.get())));
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private WarnCalFieldBo setCurrentCalculateField(WarnCalFieldBo currentCalField, List<WarnCalFieldBo> expFieldBos, List<WarnCalFieldBo> newGenCalculateFields, Map<String, Object> exprMap) {
        OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
        String number = (String)this.getModel().getValue("number");
        String valueType = (String)this.getModel().getValue("type");
        if (currentCalField == null) {
            currentCalField = new WarnCalFieldBo(AnalyseObjectUtil.getLocaleString((OrmLocaleValue)name), number);
            currentCalField.setSelected(Boolean.valueOf(true));
            Optional<Integer> maxIndex = expFieldBos.stream().map(WarnCalFieldBo::getIndex).max(Comparator.naturalOrder());
            if (maxIndex.isPresent()) {
                currentCalField.setIndex(Integer.valueOf(maxIndex.get() + 1));
            } else {
                currentCalField.setIndex(Integer.valueOf(0));
            }
        } else {
            this.modifyRefNumbers(currentCalField.getFieldNumber(), expFieldBos);
            currentCalField.setFieldName(AnalyseObjectUtil.getLocaleString((OrmLocaleValue)name));
            currentCalField.setFieldNumber(number);
            currentCalField.setTitle(currentCalField.getFieldName().getLocaleValue() + " | " + currentCalField.getFieldNumber());
        }
        if (newGenCalculateFields.size() > 0) {
            currentCalField.setCalMethod("summary");
        }
        String runExpr = (String)exprMap.get("runExpr");
        String viewExpr = (String)exprMap.get("viewExpr");
        boolean isUseFunc = (Boolean)exprMap.get("isUseFunc");
        currentCalField.setValueType(valueType);
        currentCalField.setExpr(runExpr);
        currentCalField.setViewExpr(viewExpr);
        if (isUseFunc) {
            currentCalField.setType("complex");
        } else {
            currentCalField.setType("simple");
        }
        currentCalField.setConfWay((String)this.getModel().getValue("confway"));
        currentCalField.setServiceClass((String)this.getModel().getValue("serviceclass"));
        String controlType = WarnCalcFieldService.getInstance().getControlTypeByValueType(valueType);
        currentCalField.setControlType(controlType);
        return currentCalField;
    }

    @ExcludeFromJacocoGeneratedReport
    private boolean validateExpr(BeforeDoOperationEventArgs args, Object executeResult) {
        boolean sameNumberType;
        String type = (String)this.getModel().getValue("type");
        String executeResultType = this.getExecuteResultType(executeResult);
        boolean bl = sameNumberType = this.isNumberType(type) && this.isNumberType(executeResultType);
        if (!HRStringUtils.equals((String)type, (String)executeResultType) && !sameNumberType) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8ba1\u7b97\u7ed3\u679c\u7c7b\u578b\u4e0e\u5df2\u9009\u5b57\u6bb5\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"WarnExpFieldPlugin_11", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        return true;
    }

    @ExcludeFromJacocoGeneratedReport
    private boolean isNumberType(String type) {
        return HRStringUtils.equals((String)type, (String)DataTypeEnum.INTEGER.getDataTypeKey()) || HRStringUtils.equals((String)type, (String)DataTypeEnum.LONG.getDataTypeKey()) || HRStringUtils.equals((String)type, (String)DataTypeEnum.BIGDECIMAL.getDataTypeKey());
    }

    @ExcludeFromJacocoGeneratedReport
    private String getExecuteResultType(Object executeResult) {
        String type = null;
        if (executeResult instanceof Integer) {
            type = DataTypeEnum.INTEGER.getDataTypeKey();
        } else if (executeResult instanceof Long) {
            type = DataTypeEnum.LONG.getDataTypeKey();
        } else if (executeResult instanceof Double || executeResult instanceof Float || executeResult instanceof BigDecimal) {
            type = DataTypeEnum.BIGDECIMAL.getDataTypeKey();
        } else if (executeResult instanceof CharSequence) {
            type = DataTypeEnum.STRING.getDataTypeKey();
        } else if (executeResult instanceof Boolean) {
            type = DataTypeEnum.BOOLEAN.getDataTypeKey();
        } else if (executeResult instanceof Date) {
            type = DataTypeEnum.DATETIME.getDataTypeKey();
        }
        return type;
    }

    @ExcludeFromJacocoGeneratedReport
    private boolean validateNumberAndName(BeforeDoOperationEventArgs args) {
        String name = ((ILocaleString)this.getModel().getValue("name")).getLocaleValue();
        String number = (String)this.getModel().getValue("number");
        List<Map<String, Object>> fields = this.getAllSelectedFields(true);
        if (WarningCommonUtils.validateNumberByISVIsKD()) {
            if (!number.startsWith("kdhr_") || !WarningCommonUtils.validateNumber((String)number)) {
                this.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u7801\u4ee5%s\u5f00\u5934\uff0c\u4ec5\u652f\u6301\u82f1\u6587\u5927\u5c0f\u5199\u3001\u6570\u5b57\u4e0e\u4e0b\u5212\u7ebf\uff0c\u4e0d\u533a\u5206\u5927\u5c0f\u5199\u3002", (String)"WarnExpFieldPlugin_5", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0]), "kdhr_"));
                args.setCancel(true);
                return false;
            }
        } else if (number.startsWith("kdhr_") || !WarningCommonUtils.validateNumber((String)number)) {
            this.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u7801\u7981\u6b62\u4ee5%s\u5f00\u5934\uff0c\u4ec5\u652f\u6301\u82f1\u6587\u5927\u5c0f\u5199\u3001\u6570\u5b57\u4e0e\u4e0b\u5212\u7ebf\uff0c\u4e0d\u533a\u5206\u5927\u5c0f\u5199\u3002", (String)"WarnExpFieldPlugin_6", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0]), "kdhr_"));
            args.setCancel(true);
            return false;
        }
        for (Map<String, Object> field : fields) {
            boolean numberRepeat;
            String fieldName = this.getFieldNameStr(field.get("fieldName"));
            String fieldNumber = (String)field.get("fieldNumber");
            boolean nameRepeat = fieldName != null && HRStringUtils.equals((String)name, (String)fieldName);
            boolean bl = numberRepeat = fieldNumber != null && HRStringUtils.equals((String)number.toLowerCase(), (String)fieldNumber.toLowerCase());
            if (nameRepeat && numberRepeat) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u3001\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"WarnExpFieldPlugin_7", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return false;
            }
            if (nameRepeat) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"WarnExpFieldPlugin_8", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return false;
            }
            if (!numberRepeat) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"WarnExpFieldPlugin_9", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        if (NUMBER_START_PATTERN.matcher(number).find()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4ee5\u6570\u5b57\u5f00\u5934\uff0c\u8bf7\u4fee\u6539\u3002", (String)"WarnExpFieldPlugin_10", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        return true;
    }

    @ExcludeFromJacocoGeneratedReport
    private List<Map<String, Object>> getQueryFields(boolean forValidateNumberAndName) {
        String fieldStr = (String)this.getView().getFormShowParameter().getCustomParam("fields");
        List<Object> fields = Lists.newArrayListWithCapacity((int)10);
        if (HRStringUtils.isNotEmpty((String)fieldStr)) {
            fields = (List)SerializationUtils.fromJsonString((String)fieldStr, List.class);
            if (!forValidateNumberAndName) {
                fields = fields.stream().filter(field -> field.get("isSelected") != null && (Boolean)field.get("isSelected") != false).collect(Collectors.toList());
            }
        }
        return fields;
    }

    @ExcludeFromJacocoGeneratedReport
    private List<Map<String, Object>> getCalculateFields() {
        String calculateStr = this.getPageCache().get("calFields");
        List calculateFields = Lists.newArrayListWithCapacity((int)10);
        if (HRStringUtils.isNotEmpty((String)calculateStr)) {
            calculateFields = (List)SerializationUtils.fromJsonString((String)calculateStr, List.class);
        }
        return calculateFields;
    }

    @ExcludeFromJacocoGeneratedReport
    private List<Map<String, Object>> getAllSelectedFields(boolean forValidateNumberAndName) {
        List<Map<String, Object>> fields = this.getQueryFields(forValidateNumberAndName);
        fields.addAll(this.getCalculateFields());
        List hideFields = (List)this.getView().getFormShowParameter().getCustomParam("hideFields");
        if (hideFields != null) {
            for (Map<String, Object> field : fields) {
                String fieldNum = (String)field.get("fieldNumber");
                if (!hideFields.contains(fieldNum)) continue;
                field.put("hide", "true");
            }
        }
        return fields;
    }

    @ExcludeFromJacocoGeneratedReport
    private String getFieldNameStr(Object fieldName) {
        if (fieldName == null) {
            return null;
        }
        if (fieldName instanceof JSONObject) {
            String language = RequestContext.get().getLang().name();
            return ((JSONObject)fieldName).getString(language);
        }
        if (fieldName instanceof Map) {
            String language = RequestContext.get().getLang().name();
            return (String)((Map)fieldName).get(language);
        }
        return (String)fieldName;
    }

    @ExcludeFromJacocoGeneratedReport
    private void modifyRefNumbers(String oldNumber, List<WarnCalFieldBo> calculateFieldBos) {
        String newNumber = (String)this.getModel().getValue("number");
        if (HRStringUtils.equals((String)oldNumber, (String)newNumber)) {
            return;
        }
        for (WarnCalFieldBo expFieldBo : calculateFieldBos) {
            List refExpFields = expFieldBo.getRefCalculateFields();
            for (WarnCalFieldBo refExpField : refExpFields) {
                if (!HRStringUtils.equals((String)refExpField.getFieldNumber(), (String)oldNumber)) continue;
                refExpField.setFieldNumber(newNumber);
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private Map<String, Object> getDefaultValMap(List<String> refFieldNums) {
        if (refFieldNums == null || refFieldNums.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap defaultValMap = Maps.newHashMapWithExpectedSize((int)16);
        String fieldMapStr = this.getPageCache().get("fieldMapKey");
        Map fieldMap = (Map)SerializationUtils.fromJsonString((String)fieldMapStr, Map.class);
        for (String refFieldNum : refFieldNums) {
            boolean isBaseData;
            if (refFieldNum.endsWith(".id")) continue;
            Map field = (Map)fieldMap.get(refFieldNum);
            String type = (String)field.get("valueType");
            String baseDataNum = (String)field.get("baseDataNum");
            DataTypeEnum typeEnum = DataTypeEnum.of((String)type);
            boolean bl = isBaseData = HRStringUtils.isNotEmpty((String)baseDataNum) && (refFieldNum.endsWith(".name") || refFieldNum.endsWith(".number"));
            if (isBaseData) {
                String idType = this.getBaseDataIdType(baseDataNum);
                DataTypeEnum idTypeEnum = DataTypeEnum.of((String)idType);
                String idNum = refFieldNum.substring(0, refFieldNum.lastIndexOf(".") + 1) + "id";
                if (idTypeEnum == DataTypeEnum.STRING) {
                    defaultValMap.put(idNum, "testID");
                } else {
                    defaultValMap.put(idNum, this.rand.nextLong());
                }
            }
            switch (typeEnum) {
                case STRING: 
                case LOCALESTRING: {
                    defaultValMap.put(refFieldNum, "2023-02-03");
                    break;
                }
                case DATETIME: {
                    defaultValMap.put(refFieldNum, new Date());
                    break;
                }
                case INTEGER: {
                    defaultValMap.put(refFieldNum, this.rand.nextInt());
                    break;
                }
                case LONG: {
                    defaultValMap.put(refFieldNum, this.rand.nextLong());
                    break;
                }
                case BIGDECIMAL: {
                    defaultValMap.put(refFieldNum, this.rand.nextDouble());
                    break;
                }
                case BOOLEAN: {
                    defaultValMap.put(refFieldNum, "1");
                    break;
                }
            }
        }
        return defaultValMap;
    }

    @ExcludeFromJacocoGeneratedReport
    private String getBaseDataIdType(String baseDataNum) {
        Class propertyType = EntityMetadataCache.getDataEntityType((String)baseDataNum).getPrimaryKey().getPropertyType();
        if (propertyType == Long.TYPE || propertyType == Long.class) {
            return "long";
        }
        return "string";
    }

    @ExcludeFromJacocoGeneratedReport
    private void parseCalFieldRef(String parsedExpr, WarnCalFieldBo currentCalField, List<WarnCalFieldBo> calculateFieldBos, List<String> refFieldNums) {
        if (calculateFieldBos.isEmpty() && refFieldNums.isEmpty()) {
            return;
        }
        Map<String, WarnCalFieldBo> calFieldMap = calculateFieldBos.stream().collect(Collectors.toMap(WarnCalFieldBo::getFieldNumber, field -> field));
        int currentOrder = 0;
        ArrayList refCalFields = Lists.newArrayListWithExpectedSize((int)16);
        char[] exprArr = parsedExpr.toCharArray();
        StringBuilder fieldSb = new StringBuilder();
        boolean isQuotation = false;
        boolean isReport = false;
        for (char chr : exprArr) {
            if (this.specialChar.contains(Character.valueOf(chr))) {
                if (chr == '\"') {
                    boolean bl = isQuotation = !isQuotation;
                }
                if (fieldSb.length() <= 0) continue;
                if (chr == '(' || isQuotation || numberPattern.matcher(fieldSb.toString()).matches()) {
                    fieldSb = new StringBuilder();
                    continue;
                }
                if (!fieldSb.toString().startsWith("$") || !fieldSb.toString().endsWith("$")) {
                    fieldSb = new StringBuilder();
                    continue;
                }
                currentOrder = this.handleRefField(fieldSb, currentOrder, calFieldMap, refCalFields, refFieldNums, isReport);
                fieldSb = new StringBuilder();
                continue;
            }
            fieldSb.append(chr);
        }
        if (fieldSb.length() > 0 && !numberPattern.matcher(fieldSb.toString()).matches() && fieldSb.toString().startsWith("$") && fieldSb.toString().endsWith("$")) {
            currentOrder = this.handleRefField(fieldSb, currentOrder, calFieldMap, refCalFields, refFieldNums, isReport);
        }
        currentCalField.setRefEntityFields(refFieldNums);
        currentCalField.setRefCalculateFields((List)refCalFields);
        currentCalField.setOrder(Integer.valueOf(++currentOrder));
    }

    @ExcludeFromJacocoGeneratedReport
    private void handleRefPreIndexOrder(List<WarnCalFieldBo> calculateFieldBos) {
        List refPreIndexCalFields = calculateFieldBos.stream().filter(calField -> calField.getRefCalculateFields() != null && !calField.getRefEntityFields().isEmpty()).collect(Collectors.toList());
        if (refPreIndexCalFields.isEmpty()) {
            return;
        }
        Integer minOrder = refPreIndexCalFields.stream().map(WarnCalFieldBo::getOrder).min(Integer::compareTo).get();
        calculateFieldBos.stream().filter(calField -> calField.getRefCalculateFields() == null || calField.getRefEntityFields().isEmpty()).max(Comparator.comparing(WarnCalFieldBo::getOrder)).ifPresent(maxOrderCalFiled -> {
            Integer maxOrder = maxOrderCalFiled.getOrder();
            int offset = 1;
            if (maxOrder >= minOrder) {
                offset = maxOrder.equals(minOrder) ? 1 : maxOrder - minOrder;
                for (WarnCalFieldBo refPreIndexCalField : refPreIndexCalFields) {
                    refPreIndexCalField.setOrder(Integer.valueOf(refPreIndexCalField.getOrder() + offset));
                }
            }
        });
    }

    @ExcludeFromJacocoGeneratedReport
    private int handleRefField(StringBuilder fieldSb, int currentOrder, Map<String, WarnCalFieldBo> calFieldMap, List<WarnCalFieldBo> refCalFields, List<String> refFieldNums, boolean isReport) {
        String newFieldNum = fieldSb.substring(1, fieldSb.length() - 1);
        WarnCalFieldBo calField = calFieldMap.get(newFieldNum);
        if (calField != null) {
            refCalFields.add(calField);
            currentOrder = calField.getOrder() > currentOrder ? calField.getOrder() : currentOrder;
            refFieldNums.remove(newFieldNum);
        }
        return currentOrder;
    }

    @ExcludeFromJacocoGeneratedReport
    private void addCalFieldOrder(List<String> refLinks, WarnCalFieldBo currentField, List<WarnCalFieldBo> calculateFields, List<List<String>> rings) {
        for (WarnCalFieldBo calField : calculateFields) {
            Optional<WarnCalFieldBo> refFieldOp;
            List refCalculateFields = calField.getRefCalculateFields();
            if (refCalculateFields == null || refCalculateFields.isEmpty() || HRStringUtils.equals((String)currentField.getFieldNumber(), (String)calField.getFieldNumber()) || !(refFieldOp = refCalculateFields.stream().filter(field -> HRStringUtils.equals((String)field.getFieldNumber(), (String)currentField.getFieldNumber())).findAny()).isPresent()) continue;
            int order = calField.getOrder();
            if (order <= currentField.getOrder()) {
                calField.setOrder(Integer.valueOf(currentField.getOrder() + 1));
            }
            if (refLinks.stream().distinct().count() != (long)refLinks.size()) continue;
            refLinks.add(calField.getFieldName().getLocaleValue());
            if (refLinks.stream().distinct().count() != (long)refLinks.size()) {
                rings.add(refLinks);
                continue;
            }
            this.addCalFieldOrder(refLinks, calField, calculateFields, rings);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private WarnCalFieldBo getCurrentCalField() {
        String currentCalFieldStr = (String)this.getView().getFormShowParameter().getCustomParam("currentCalField");
        if (HRStringUtils.isEmpty((String)currentCalFieldStr)) {
            return null;
        }
        return (WarnCalFieldBo)SerializationUtils.fromJsonString((String)currentCalFieldStr, WarnCalFieldBo.class);
    }
}

