/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.earlywarn.expfield;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.function.service.ReportFunctionExecuteService;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.function.ReportFunctionSubPagePlugin;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.calfield.WarnCalcFieldService;
import kd.hr.hrcs.common.constants.earlywarn.WarnCalFieldConstants;
import kd.hr.hrcs.common.constants.earlywarn.WarnSceneComConditionConstants;
import kd.hr.hrcs.common.model.earlywarn.WarnCalFieldBo;

@ExcludeFromJacocoGeneratedReport
public class WarnSceneComCdCalFieldPlugin
extends ReportFunctionSubPagePlugin
implements WarnCalFieldConstants,
WarnSceneComConditionConstants {
    private static final Log LOG = LogFactory.getLog(WarnSceneComCdCalFieldPlugin.class);
    private static final String FUNCTION_FLEX = "functionflex";
    private static final String COMMON_CONDITION_CAL_FIELD_PREFIX = "commonConditionCalField_";
    private final Random rand = new SecureRandom();

    public void afterCreateNewData(EventObject eventObject) {
        try {
            String currentCalFieldStr = (String)this.getView().getFormShowParameter().getCustomParam("currentCalField");
            String allCalFieldsStr = (String)this.getView().getFormShowParameter().getCustomParam("calFields");
            String expr = "";
            if (HRStringUtils.isNotEmpty((String)currentCalFieldStr)) {
                WarnCalFieldBo currentCalField = (WarnCalFieldBo)SerializationUtils.fromJsonString((String)currentCalFieldStr, WarnCalFieldBo.class);
                this.getModel().setValue("name", (Object)currentCalField.getFieldName());
                this.getModel().setValue("type", (Object)currentCalField.getValueType());
                this.getModel().setValue("number", (Object)currentCalField.getFieldNumber());
                expr = currentCalField.getViewExpr();
                if (HRStringUtils.isEmpty((String)expr)) {
                    expr = currentCalField.getExpr();
                }
                this.getModel().setValue("expr", (Object)expr);
            } else {
                String rowIndex = (String)this.getView().getFormShowParameter().getCustomParam("");
                this.getModel().setValue("name", (Object)(COMMON_CONDITION_CAL_FIELD_PREFIX + rowIndex));
                this.getModel().setValue("number", (Object)(COMMON_CONDITION_CAL_FIELD_PREFIX + rowIndex));
            }
            this.getPageCache().put("calFields", allCalFieldsStr);
            List<Map<String, Object>> fields = this.getAllSelectedFields();
            this.initFuncPageView(FUNCTION_FLEX, fields, ReportFunctionExecuteService.class.getName(), expr);
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
        }
    }

    public void afterBindData(EventObject eventObject) {
        try {
            super.afterBindData(eventObject);
            this.getModel().setDataChanged(false);
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        try {
            super.beforeDoOperation(args);
            AbstractOperate op = (AbstractOperate)args.getSource();
            String operateKey = op.getOperateKey();
            if (HRStringUtils.equals((String)operateKey, (String)"ok")) {
                StringBuilder errorMsg = new StringBuilder();
                Map exprMap = this.parseFunctionExpr(errorMsg);
                if (exprMap == null) {
                    this.getView().showTipNotification(errorMsg.toString());
                    args.setCancel(true);
                } else {
                    ArrayList<String> refFieldNums;
                    Map<String, Object> defaultValMap;
                    String runExpr;
                    Object executeResult;
                    String expr = (String)exprMap.get("expr");
                    if (HRStringUtils.isEmpty((String)expr) || HRStringUtils.isBlank((CharSequence)expr)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WarnSceneComCdCalFieldPlugin_0", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    errorMsg = new StringBuilder();
                    WarnCalFieldBo currentCalField = this.getCurrentCalField();
                    String calculateStr = this.getPageCache().get("calFields");
                    List calculateFieldBos = Lists.newArrayListWithCapacity((int)10);
                    if (HRStringUtils.isNotEmpty((String)calculateStr)) {
                        calculateFieldBos = JSON.parseArray((String)calculateStr, WarnCalFieldBo.class);
                    }
                    if ((executeResult = this.preExecuteExpr(runExpr = (String)exprMap.get("runExpr"), defaultValMap = this.getDefaultValMap(refFieldNums = new ArrayList<String>((Set)exprMap.get("refFieldNums"))), errorMsg)) == null && errorMsg.length() > 0) {
                        this.getView().showTipNotification(errorMsg.toString());
                        args.setCancel(true);
                        return;
                    }
                    if (!this.validateExpr(args, executeResult)) {
                        return;
                    }
                    currentCalField = this.setCurrentCalculateField(currentCalField, calculateFieldBos, exprMap);
                    this.handleCalculateRefFieldAndOrder(currentCalField, calculateFieldBos, refFieldNums);
                    this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)currentCalField));
                    this.closeConfirmStatus = true;
                }
            }
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void handleCalculateRefFieldAndOrder(WarnCalFieldBo currentCalField, List<WarnCalFieldBo> calculateFieldBos, List<String> refFieldNums) {
        this.parseCalFieldRef(currentCalField.getExpr(), currentCalField, calculateFieldBos, refFieldNums);
    }

    private WarnCalFieldBo setCurrentCalculateField(WarnCalFieldBo currentCalField, List<WarnCalFieldBo> calFieldBos, Map<String, Object> exprMap) {
        OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
        String number = (String)this.getModel().getValue("number");
        String valueType = (String)this.getModel().getValue("type");
        if (currentCalField == null) {
            currentCalField = new WarnCalFieldBo(AnalyseObjectUtil.getLocaleString((OrmLocaleValue)name), number);
            Optional<Integer> maxIndex = calFieldBos.stream().map(WarnCalFieldBo::getIndex).max(Comparator.naturalOrder());
            currentCalField.setSelected(Boolean.valueOf(true));
            if (maxIndex.isPresent()) {
                currentCalField.setIndex(Integer.valueOf(maxIndex.get() + 1));
            } else {
                currentCalField.setIndex(Integer.valueOf(0));
            }
        }
        String runExpr = (String)exprMap.get("runExpr");
        String viewExpr = (String)exprMap.get("viewExpr");
        boolean isUseFunc = (Boolean)exprMap.get("isUseFunc");
        currentCalField.setExpr(runExpr);
        currentCalField.setViewExpr(viewExpr);
        currentCalField.setValueType(valueType);
        if (isUseFunc) {
            currentCalField.setType("complex");
        } else {
            currentCalField.setType("simple");
        }
        String controlType = WarnCalcFieldService.getInstance().getControlTypeByValueType(valueType);
        currentCalField.setControlType(controlType);
        currentCalField.setSource("warncondition");
        return currentCalField;
    }

    @ExcludeFromJacocoGeneratedReport
    private boolean validateExpr(BeforeDoOperationEventArgs args, Object executeResult) {
        if (!(executeResult instanceof Integer || executeResult instanceof Long || executeResult instanceof Float || executeResult instanceof Double || executeResult instanceof BigDecimal)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u521b\u5efa\u6570\u503c\u7c7b\u578b\u8868\u8fbe\u5f0f\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"WarnSceneComCdCalFieldPlugin_1", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        String executeResultType = this.getExecuteResultType(executeResult);
        this.getModel().setValue("type", (Object)executeResultType);
        return true;
    }

    @ExcludeFromJacocoGeneratedReport
    private String getExecuteResultType(Object executeResult) {
        String type = null;
        if (executeResult instanceof Integer) {
            type = DataTypeEnum.INTEGER.getDataTypeKey();
        } else if (executeResult instanceof Long) {
            type = DataTypeEnum.LONG.getDataTypeKey();
        } else if (executeResult instanceof Double || executeResult instanceof Float || executeResult instanceof BigDecimal) {
            type = DataTypeEnum.BIGDECIMAL.getDataTypeKey();
        } else if (executeResult instanceof CharSequence) {
            type = DataTypeEnum.STRING.getDataTypeKey();
        } else if (executeResult instanceof Boolean) {
            type = DataTypeEnum.BOOLEAN.getDataTypeKey();
        } else if (executeResult instanceof Date) {
            type = DataTypeEnum.DATETIME.getDataTypeKey();
        }
        return type;
    }

    private List<Map<String, Object>> getQueryFields() {
        String fieldStr = (String)this.getView().getFormShowParameter().getCustomParam("fields");
        List<Object> fields = Lists.newArrayListWithCapacity((int)10);
        if (HRStringUtils.isNotEmpty((String)fieldStr)) {
            fields = (List)SerializationUtils.fromJsonString((String)fieldStr, List.class);
            fields = fields.stream().filter(field -> field.get("isSelected") != null && (Boolean)field.get("isSelected") != false).collect(Collectors.toList());
        }
        return fields;
    }

    private List<Map<String, Object>> getCalculateFields() {
        String calculateStr = this.getPageCache().get("calFields");
        List<Object> calculateFields = Lists.newArrayListWithCapacity((int)10);
        if (HRStringUtils.isNotEmpty((String)calculateStr)) {
            calculateFields = (List)SerializationUtils.fromJsonString((String)calculateStr, List.class);
            calculateFields = calculateFields.stream().filter(calField -> (Boolean)calField.get("selected")).collect(Collectors.toList());
        }
        return calculateFields;
    }

    private List<Map<String, Object>> getAllSelectedFields() {
        List<Map<String, Object>> fields = this.getQueryFields();
        fields.addAll(this.getCalculateFields());
        return fields;
    }

    @ExcludeFromJacocoGeneratedReport
    private Map<String, Object> getDefaultValMap(List<String> refFieldNums) {
        if (refFieldNums == null || refFieldNums.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap defaultValMap = Maps.newHashMapWithExpectedSize((int)16);
        String fieldMapStr = this.getPageCache().get("fieldMapKey");
        Map fieldMap = (Map)SerializationUtils.fromJsonString((String)fieldMapStr, Map.class);
        for (String refFieldNum : refFieldNums) {
            boolean isBaseData;
            if (refFieldNum.endsWith(".id")) continue;
            Map field = (Map)fieldMap.get(refFieldNum);
            String type = (String)field.get("valueType");
            String baseDataNum = (String)field.get("baseDataNum");
            DataTypeEnum typeEnum = DataTypeEnum.of((String)type);
            boolean bl = isBaseData = HRStringUtils.isNotEmpty((String)baseDataNum) && (refFieldNum.endsWith(".name") || refFieldNum.endsWith(".number"));
            if (isBaseData) {
                String idType = this.getBaseDataIdType(baseDataNum);
                DataTypeEnum idTypeEnum = DataTypeEnum.of((String)idType);
                String idNum = refFieldNum.substring(0, refFieldNum.lastIndexOf(".") + 1) + "id";
                if (idTypeEnum == DataTypeEnum.STRING) {
                    defaultValMap.put(idNum, "testID");
                } else {
                    defaultValMap.put(idNum, this.rand.nextLong());
                }
            }
            switch (typeEnum) {
                case STRING: 
                case LOCALESTRING: {
                    defaultValMap.put(refFieldNum, "2023-02-03");
                    break;
                }
                case DATETIME: {
                    defaultValMap.put(refFieldNum, new Date());
                    break;
                }
                case INTEGER: {
                    defaultValMap.put(refFieldNum, this.rand.nextInt());
                    break;
                }
                case LONG: {
                    defaultValMap.put(refFieldNum, this.rand.nextLong());
                    break;
                }
                case BIGDECIMAL: {
                    defaultValMap.put(refFieldNum, this.rand.nextDouble());
                    break;
                }
                case BOOLEAN: {
                    defaultValMap.put(refFieldNum, "1");
                    break;
                }
            }
        }
        return defaultValMap;
    }

    private String getBaseDataIdType(String baseDataNum) {
        Class propertyType = EntityMetadataCache.getDataEntityType((String)baseDataNum).getPrimaryKey().getPropertyType();
        if (propertyType == Long.TYPE || propertyType == Long.class) {
            return "long";
        }
        return "string";
    }

    @ExcludeFromJacocoGeneratedReport
    private void parseCalFieldRef(String parsedExpr, WarnCalFieldBo currentCalField, List<WarnCalFieldBo> calculateFieldBos, List<String> refFieldNums) {
        if (refFieldNums.isEmpty() && calculateFieldBos.isEmpty()) {
            return;
        }
        Map<String, WarnCalFieldBo> calFieldMap = calculateFieldBos.stream().collect(Collectors.toMap(WarnCalFieldBo::getFieldNumber, field -> field));
        int currentOrder = 0;
        ArrayList refCalFields = Lists.newArrayListWithExpectedSize((int)16);
        char[] exprArr = parsedExpr.toCharArray();
        StringBuilder fieldSb = new StringBuilder();
        boolean isQuotation = false;
        for (char chr : exprArr) {
            if (this.specialChar.contains(Character.valueOf(chr))) {
                if (chr == '\"') {
                    boolean bl = isQuotation = !isQuotation;
                }
                if (fieldSb.length() <= 0) continue;
                if (chr == '(' || isQuotation || numberPattern.matcher(fieldSb.toString()).matches()) {
                    fieldSb = new StringBuilder();
                    continue;
                }
                if (!fieldSb.toString().startsWith("$") || !fieldSb.toString().endsWith("$")) {
                    fieldSb = new StringBuilder();
                    continue;
                }
                currentOrder = this.handleRefField(fieldSb, currentOrder, calFieldMap, refCalFields, refFieldNums);
                fieldSb = new StringBuilder();
                continue;
            }
            fieldSb.append(chr);
        }
        if (fieldSb.length() > 0 && !numberPattern.matcher(fieldSb.toString()).matches() && fieldSb.toString().startsWith("$") && fieldSb.toString().endsWith("$")) {
            currentOrder = this.handleRefField(fieldSb, currentOrder, calFieldMap, refCalFields, refFieldNums);
        }
        currentCalField.setRefEntityFields(refFieldNums);
        currentCalField.setOrder(Integer.valueOf(++currentOrder));
    }

    @ExcludeFromJacocoGeneratedReport
    private int handleRefField(StringBuilder fieldSb, int currentOrder, Map<String, WarnCalFieldBo> calFieldMap, List<WarnCalFieldBo> refCalFields, List<String> refFieldNums) {
        String newFieldNum = fieldSb.substring(1, fieldSb.length() - 1);
        WarnCalFieldBo calField = calFieldMap.get(newFieldNum);
        if (calField != null) {
            refCalFields.add(calField);
            currentOrder = calField.getOrder() > currentOrder ? calField.getOrder() : currentOrder;
            refFieldNums.remove(newFieldNum);
        }
        return currentOrder;
    }

    private WarnCalFieldBo getCurrentCalField() {
        String currentCalFieldStr = (String)this.getView().getFormShowParameter().getCustomParam("currentCalField");
        if (HRStringUtils.isEmpty((String)currentCalFieldStr)) {
            return null;
        }
        return (WarnCalFieldBo)SerializationUtils.fromJsonString((String)currentCalFieldStr, WarnCalFieldBo.class);
    }
}

