/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.earlywarn.msgpersist;

import com.alibaba.fastjson.JSONArray;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.mcontrol.mobtable.IMobTablePackageDataHandler;
import kd.bos.form.mcontrol.mobtable.MobTable;
import kd.bos.form.mcontrol.mobtable.events.BeforeCreateMobTableColumnsEvent;
import kd.bos.form.mcontrol.mobtable.events.IBeforeCreateMobTableColumnsListener;
import kd.bos.form.mcontrol.mobtable.tablecolumn.MobTableColumn;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.msgpersist.MsgDataHeadFieldBo;
import kd.hr.hrcs.common.constants.msgpersist.MsgPersistConstants;
import kd.hr.hrcs.formplugin.web.earlywarn.msgpersist.MyMobTablePackageDataHandler;

@ExcludeFromJacocoGeneratedReport
public class MsgDataPersistMobileEdit
extends AbstractMobFormPlugin
implements MsgPersistConstants,
IBeforeCreateMobTableColumnsListener {
    private static final Log LOGGER = LogFactory.getLog(MsgDataPersistMobileEdit.class);
    private static final String CONTROL_OPEN_LABEL = "openlabel";
    private static final String CONTROL_CLOSE_LABEL = "closelabel";
    private static final String OP_KEY_OPEN_MAIN = "openmain";
    private static final String OP_KEY_CLOSE_MAIN = "closemain";
    static final String CUSTOM_PROPERTY_DATA_TYPE = "dataType";
    static final String CUSTOM_PROPERTY_DATE_FORMAT = "dateFormat";
    static final String CUSTOM_PROPERTY_CONTROL_TYPE = "controlType";

    public void registerListener(EventObject e) {
        try {
            super.registerListener(e);
            Label openLabel = (Label)this.getControl(CONTROL_OPEN_LABEL);
            openLabel.addClickListener((ClickListener)this);
            Label closeLabel = (Label)this.getControl(CONTROL_CLOSE_LABEL);
            closeLabel.addClickListener((ClickListener)this);
        }
        catch (Exception exception) {
            LOGGER.error("registerListener_error_", (Throwable)exception);
        }
    }

    public void initialize() {
        try {
            MobTable mobTable = (MobTable)this.getControl("showentitymobiletable");
            mobTable.addBeforeCreateMobTableColumnsListener((IBeforeCreateMobTableColumnsListener)this);
            mobTable.addMobTablePackageDataHandlerListener(mobTablePackageDataHandlerEvent -> mobTablePackageDataHandlerEvent.setMobTablePackageDataHandler((IMobTablePackageDataHandler)new MyMobTablePackageDataHandler()));
        }
        catch (Exception exception) {
            LOGGER.error("initialize_error_", (Throwable)exception);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs eventArgs) {
        try {
            super.preOpenForm(eventArgs);
            FormShowParameter formShowParameter = eventArgs.getFormShowParameter();
            formShowParameter.setCaption(formShowParameter.getFormConfig().getCaption().getLocaleValue());
        }
        catch (Exception exception) {
            LOGGER.error("preOpenForm_error_", (Throwable)exception);
        }
    }

    public void afterBindData(EventObject e) {
        try {
            super.afterBindData(e);
            String msgTitle = this.getModel().getDataEntity().getString("msgtitle");
            String msgMain = this.getModel().getDataEntity().getString("msgmain");
            Label msgTitleLabel = (Label)this.getControl("msgtitlelabel");
            String msgEnd = this.getModel().getDataEntity().getString("msgend");
            Label msgEndLabel = (Label)this.getControl("msgendlabel");
            Label msgMainLabel = (Label)this.getControl("msgmainlabel");
            msgTitleLabel.setText(msgTitle);
            int enterIndex = msgMain.indexOf("\n");
            if (HRStringUtils.isNotEmpty((String)msgMain) && (msgMain.length() > 30 || enterIndex > 0 && enterIndex < 30)) {
                Label msgMainExtLabel = (Label)this.getControl("msgmainextlabel");
                int subIndex = enterIndex > 0 && enterIndex < 30 ? enterIndex : 30;
                String mainText = msgMain.substring(0, subIndex);
                if (enterIndex == subIndex) {
                    ++subIndex;
                }
                msgMainLabel.setText(mainText);
                String msgMainExt = msgMain.substring(subIndex);
                if (HRStringUtils.isNotEmpty((String)msgMainExt)) {
                    msgMainExtLabel.setText(msgMainExt);
                    this.getView().setVisible(Boolean.TRUE, new String[]{CONTROL_OPEN_LABEL});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_OPEN_LABEL});
                }
            } else {
                msgMainLabel.setText(msgMain);
                this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_OPEN_LABEL});
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"msgmainextlabel", CONTROL_CLOSE_LABEL});
            msgEndLabel.setText(msgEnd);
        }
        catch (Exception exception) {
            LOGGER.error("afterBindData_error_", (Throwable)exception);
        }
    }

    public void beforeCreateMobTableColumns(BeforeCreateMobTableColumnsEvent event) {
        try {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            List mobTableColumns = event.getMobTableColumns();
            String rowHeadFieldStr = dataEntity.getString("datahead");
            List msgDataHeadFieldBos = JSONArray.parseArray((String)rowHeadFieldStr, MsgDataHeadFieldBo.class);
            if (msgDataHeadFieldBos != null) {
                for (MsgDataHeadFieldBo msgDataHeadFieldBo : msgDataHeadFieldBos) {
                    MobTableColumn column = new MobTableColumn();
                    column.setId(msgDataHeadFieldBo.getFieldAliasWithDot());
                    column.setFieldKey(msgDataHeadFieldBo.getFieldAliasWithDot());
                    column.setCaption(new LocaleString(msgDataHeadFieldBo.getFieldName()));
                    column.setModel(this.getModel());
                    column.setView(this.getView());
                    column.setFontSize(12);
                    Map customProperties = column.getCustomProperties();
                    customProperties.put(CUSTOM_PROPERTY_DATA_TYPE, msgDataHeadFieldBo.getDataType());
                    customProperties.put(CUSTOM_PROPERTY_DATE_FORMAT, msgDataHeadFieldBo.getDateShowFormatMask());
                    customProperties.put(CUSTOM_PROPERTY_CONTROL_TYPE, msgDataHeadFieldBo.getControlType());
                    mobTableColumns.add(column);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("beforeCreateMobTableColumns_error_", (Throwable)exception);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        try {
            super.beforeDoOperation(args);
            FormOperate formOperate = (FormOperate)args.getSource();
            if (OP_KEY_OPEN_MAIN.equals(formOperate.getOperateKey())) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"msgmainextlabel", CONTROL_CLOSE_LABEL});
                this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_OPEN_LABEL});
            } else if (OP_KEY_CLOSE_MAIN.equals(formOperate.getOperateKey())) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"msgmainextlabel", CONTROL_CLOSE_LABEL});
                this.getView().setVisible(Boolean.TRUE, new String[]{CONTROL_OPEN_LABEL});
            }
        }
        catch (Exception exception) {
            LOGGER.error("beforeDoOperation_error_", (Throwable)exception);
        }
    }
}

