/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.earlywarn.msgpersist.control;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.input.OrmInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.FilterFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.MapFunction;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.entryfilter.EntryFilterItemInfo;
import kd.bos.entity.property.entryfilter.EntryQueryParam;
import kd.bos.entity.property.entryfilter.EntrySortItemInfo;
import kd.bos.form.control.EntryGrid;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.trace.util.TraceIdUtil;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.msgpersist.MsgDataHeadFieldBo;
import kd.hr.hrcs.common.constants.msgpersist.MsgPersistConstants;
import kd.hr.hrcs.formplugin.web.earlywarn.msgpersist.control.function.GridDataTransMapFunction;
import kd.hr.hrcs.formplugin.web.earlywarn.msgpersist.control.function.RowDataFilterFunction;

@ExcludeFromJacocoGeneratedReport
public class MsgShowEntryGrid
extends EntryGrid
implements MsgPersistConstants {
    private static final Log LOGGER = LogFactory.getLog(MsgShowEntryGrid.class);
    private static final Set<String> NOT_DB_QUERY_COMPARE_TYPES = Sets.newHashSet((Object[])new String[]{"83", "34", "37", "9", "58", "21", "36", "19", "65", "13", "10", "63", "92", "51", "24", "1", "1"});
    private static final int COMMIT_TIME_OUT = 1800;
    private boolean isFetchPage;
    private JobSession session;
    private DataSetX dataSetX;
    private Integer rowCount;

    public void getGridDataByFilter(List<Map<String, List<Object>>> filter) {
        try {
            EntryQueryParam queryParam = this.buildFilterCondition(filter);
            if (queryParam != null) {
                this.getEntryState().put("entryQueryParam", (Object)SerializationUtils.toJsonString((Object)queryParam));
                this.getEntryState().put("entryIsFilter", (Object)queryParam.needFilterAndSort());
            }
            this.setPageIndex(1);
        }
        catch (Exception exception) {
            LOGGER.error("getGridDataByFilter_error_", (Throwable)exception);
        }
    }

    protected DynamicObject[] getEntryDataEntities(int startIndex, int endIndex) {
        try {
            DataSet dataSet;
            int pageRow = this.getPageRow();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(this.getEntryKey());
            entryEntity.clear();
            DataSetX dataSetX = this.getQueryDataSetX();
            dataSetX = this.addOrderBy(dataSetX);
            if (this.isFetchPage) {
                dataSetX = dataSetX.top(endIndex);
            }
            if ((dataSet = this.dataSetOutput(dataSetX)) != null) {
                dataSet = dataSet.limit(startIndex, pageRow);
                Field[] fields = dataSet.getRowMeta().getFields();
                int seq = 1;
                for (Row row : dataSet) {
                    DynamicObject rowDy = entryEntity.addNew();
                    rowDy.set("seq", (Object)seq);
                    ++seq;
                    for (Field field : fields) {
                        rowDy.set(field.getAlias(), row.get(field.getAlias()));
                    }
                }
            }
            return (DynamicObject[])entryEntity.toArray((Object[])new DynamicObject[0]);
        }
        catch (Exception exception) {
            LOGGER.error("getEntryDataEntities_error_", (Throwable)exception);
            return new DynamicObject[0];
        }
    }

    public boolean isNeedPaged() {
        return true;
    }

    protected int getRowCount() {
        try {
            if (this.rowCount != null) {
                return this.rowCount;
            }
            DataSetX dataSetX = this.getQueryDataSetX();
            DataSet dataSet = this.dataSetOutput(dataSetX);
            int count = 0;
            if (dataSet != null) {
                for (Row row : dataSet) {
                    ++count;
                }
            }
            this.rowCount = count;
            return count;
        }
        catch (Exception exception) {
            LOGGER.error("getRowCount_error_", (Throwable)exception);
            return 0;
        }
    }

    protected boolean onFetchPageData(int pageIndex, int pageRows) {
        this.isFetchPage = true;
        return true;
    }

    private DataSetX getQueryDataSetX() {
        if (this.dataSetX != null) {
            return this.dataSetX;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"hrcs_warnmsgrowdata");
        List aliasList = entityType.getProperties().stream().map(property -> (DynamicProperty)property).map(DynamicProperty::getName).collect(Collectors.toList());
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        List msgDataHeadFieldBos = JSONArray.parseArray((String)this.getMsgDataHeadFields(this.getView(), pkValue), MsgDataHeadFieldBo.class);
        Map<String, MsgDataHeadFieldBo> msgDataHeadFieldBoMap = msgDataHeadFieldBos.stream().collect(Collectors.toMap(MsgDataHeadFieldBo::getFieldAliasWithDot, Function.identity()));
        QFilter idFilter = new QFilter("msgpersist", "=", pkValue);
        idFilter.and(this.getQueryQFilter(msgDataHeadFieldBoMap));
        if (this.session == null) {
            String traceId = TraceIdUtil.getCurrentTraceIdString();
            this.session = AlgoX.createSession((String)("MsgShowEntryGrid_" + traceId), (String)("MsgShowEntryGrid_" + traceId));
        }
        DataSetX dataSetX = this.session.fromInput((Input)new OrmInput("hrcs_warnmsgrowdata", "hrcs_warnmsgrowdata", String.join((CharSequence)",", aliasList), new QFilter[]{idFilter}));
        dataSetX = dataSetX.map((MapFunction)new GridDataTransMapFunction(dataSetX.getRowMeta(), msgDataHeadFieldBos));
        this.dataSetX = dataSetX = this.addDataFilter(dataSetX, msgDataHeadFieldBoMap);
        return dataSetX;
    }

    private QFilter getQueryQFilter(Map<String, MsgDataHeadFieldBo> msgDataHeadFieldBoMap) {
        QFilter startFilter = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
        EntryQueryParam queryParam = this.getModel().getEntryQueryParam(this.getEntryKey());
        List filterItems = queryParam.getFilterItems();
        if (filterItems != null && !filterItems.isEmpty()) {
            for (EntryFilterItemInfo filterItem : filterItems) {
                MsgDataHeadFieldBo msgDataHeadFieldBo = msgDataHeadFieldBoMap.get(filterItem.getPropName());
                String compareType = filterItem.getCompareType();
                String controlType = msgDataHeadFieldBo.getControlType();
                Object filterItemValue = filterItem.getValue();
                if (FieldControlType.CHECKBOX.getValue().equals(controlType)) {
                    filterItemValue = filterItemValue instanceof Collection ? ((Collection)filterItemValue).stream().map(obj -> "1".equals(String.valueOf(obj))).collect(Collectors.toList()) : ("1".equals(String.valueOf(filterItemValue)) ? Boolean.valueOf(true) : Boolean.valueOf(false));
                } else if (FieldControlType.DECIMAL.getValue().equals(controlType)) continue;
                if (NOT_DB_QUERY_COMPARE_TYPES.contains(compareType)) continue;
                if (filterItemValue instanceof Collection) {
                    QFilter collectionFilter = QFilter.of((String)"1 != 1", (Object[])new Object[0]);
                    for (Object value : (Collection)filterItemValue) {
                        collectionFilter.or(new QFilter("rowdata", "like", (Object)("%" + value + "%")));
                    }
                    startFilter.and(collectionFilter);
                    continue;
                }
                startFilter.and(new QFilter("rowdata", "like", (Object)("%" + filterItemValue + "%")));
            }
        }
        return startFilter;
    }

    private DataSetX addDataFilter(DataSetX dataSetX, Map<String, MsgDataHeadFieldBo> msgDataHeadFieldBoMap) {
        RowMeta rowMeta = dataSetX.getRowMeta();
        Set fieldAliasSet = Arrays.stream(rowMeta.getFields()).map(Field::getAlias).collect(Collectors.toSet());
        EntryQueryParam queryParam = this.getModel().getEntryQueryParam(this.getEntryKey());
        List filterItems = queryParam.getFilterItems();
        if (filterItems != null && !filterItems.isEmpty()) {
            for (EntryFilterItemInfo filterItem : filterItems) {
                String propName = filterItem.getPropName();
                if (!fieldAliasSet.contains(propName)) continue;
                MsgDataHeadFieldBo msgDataHeadFieldBo = msgDataHeadFieldBoMap.get(propName);
                dataSetX = dataSetX.filter((FilterFunction)new RowDataFilterFunction(rowMeta, msgDataHeadFieldBo, propName, filterItem.getCompareType(), filterItem.getValue()));
            }
        }
        return dataSetX;
    }

    private DataSetX addOrderBy(DataSetX dataSetX) {
        RowMeta rowMeta = dataSetX.getRowMeta();
        Set fieldAliasSet = Arrays.stream(rowMeta.getFields()).map(Field::getAlias).collect(Collectors.toSet());
        EntryQueryParam queryParam = this.getModel().getEntryQueryParam(this.getEntryKey());
        List sortItems = queryParam.getSortItems();
        if (sortItems != null && !sortItems.isEmpty()) {
            ArrayList orderBy = Lists.newArrayListWithExpectedSize((int)sortItems.size());
            for (EntrySortItemInfo sortItem : sortItems) {
                if (!fieldAliasSet.contains(sortItem.getSortColumnName())) continue;
                String orderByStr = sortItem.getSortColumnName();
                orderByStr = 1 == sortItem.getSortStyle() ? orderByStr + " asc" : orderByStr + " desc";
                orderBy.add(orderByStr);
            }
            dataSetX = dataSetX.orderBy(orderBy.toArray(new String[0]));
        }
        return dataSetX;
    }

    private DataSet dataSetOutput(DataSetX dataSetX) {
        if (this.session == null) {
            return null;
        }
        DataSetOutput output = new DataSetOutput(dataSetX.getRowMeta());
        String id = output.getId();
        dataSetX.output((Output)output);
        this.session.commit(1800, TimeUnit.SECONDS);
        return this.session.readDataSet(id);
    }

    private EntryQueryParam buildFilterCondition(List<Map<String, List<Object>>> filterList) {
        if (CollectionUtils.isEmpty(filterList)) {
            return null;
        }
        EntryQueryParam param = this.getModel().getEntryQueryParam(this.getEntryKey());
        if (param == null) {
            return null;
        }
        boolean isReset = false;
        Map<String, List<Object>> filterDetailMap = filterList.get(0);
        if (filterDetailMap.get("Value") == null || filterDetailMap.get("Value").isEmpty()) {
            isReset = true;
        }
        for (Map<String, List<Object>> map : filterList) {
            List<Object> compareList;
            EntryFilterItemInfo newItemInfo;
            List<Object> fieldNameList = map.get("FieldName");
            if (fieldNameList == null || fieldNameList.isEmpty()) continue;
            String fieldName = String.valueOf(fieldNameList.get(0));
            List itemInfoList = param.getFilterItems();
            if (itemInfoList == null) {
                itemInfoList = Lists.newArrayListWithExpectedSize((int)10);
            }
            if (!itemInfoList.isEmpty()) {
                Iterator iterator = itemInfoList.iterator();
                while (iterator.hasNext()) {
                    newItemInfo = (EntryFilterItemInfo)iterator.next();
                    String oldFieldName = newItemInfo.getPropName();
                    if (!fieldName.equals(oldFieldName)) continue;
                    iterator.remove();
                }
            }
            if (isReset || (compareList = map.get("Compare")) == null || compareList.isEmpty()) continue;
            String compareTypeId = String.valueOf(compareList.get(0));
            if (CollectionUtils.isEmpty((Collection)map.get("Value")) || map.get("Value").get(0) == null) continue;
            newItemInfo = new EntryFilterItemInfo(fieldName, (Object)map.get("Value").get(0).toString(), compareTypeId);
            if (map.get("Value").size() > 1) {
                newItemInfo = new EntryFilterItemInfo(fieldName, map.get("Value"), compareTypeId);
            }
            IDataEntityProperty property = this.getModel().getProperty(fieldName);
            newItemInfo.setDisplayProps(EntityTypeUtil.getBasedataDisplayProps((IDataEntityProperty)property));
            itemInfoList.add(newItemInfo);
        }
        return param;
    }

    protected DataSetX printDataSetX(DataSetX dataSetX, String tag) {
        DataSet dataSetAll = this.dataSetOutput(dataSetX);
        if (dataSetAll != null) {
            DataSet copy = dataSetAll.copy();
            this.printDataSet(copy, tag);
            return this.session.fromInput((Input)new DataSetInput(dataSetAll));
        }
        return dataSetX;
    }

    private void printDataSet(DataSet dataSet, String tag) {
        int index = 0;
        LOGGER.info("print_out_{},head:{}", (Object)tag, (Object)Arrays.toString(dataSet.getRowMeta().getFieldNames()));
        while (dataSet.hasNext()) {
            LOGGER.info("print_out_{},detail:{}", (Object)tag, (Object)dataSet.next().toString());
            ++index;
        }
        LOGGER.info("print_out_{},count:{}", (Object)tag, (Object)index);
    }
}

