/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.earlywarn.objecttpl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.ext.hr.ruleengine.infos.ConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.hr.hbp.common.model.complexobj.labelandreport.FieldTreeNode;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hrcs.common.constants.earlywarn.WarnObjTplConstants;
import kd.hr.hrcs.common.model.earlywarn.WarnCalFieldBo;
import kd.hr.hrcs.common.model.earlywarn.WarnJoinEntityBo;
import kd.hr.hrcs.common.model.earlywarn.WarnQueryFieldBo;
import kd.hr.hrcs.formplugin.web.earlywarn.scene.enums.WarnSceneControlSceneEnum;

public class WarnObjTplCommonProcessor
implements WarnObjTplConstants {
    public static final String CUSTOM_CONTROL = "customcontrolap";
    private HRDataBaseEdit basePlugin;

    public WarnObjTplCommonProcessor(HRDataBaseEdit basePlugin) {
        this.basePlugin = basePlugin;
    }

    public List<WarnJoinEntityBo> getAllJoinEntity() {
        List warnJoinEntityBos = Collections.emptyList();
        String entityStr = this.getView().getPageCache().get("joinEntities");
        if (HRStringUtils.isNotEmpty((String)entityStr)) {
            warnJoinEntityBos = JSON.parseArray((String)entityStr, WarnJoinEntityBo.class);
        }
        return warnJoinEntityBos;
    }

    public List<WarnQueryFieldBo> getSelectedQueryFields(Object entityNodes) {
        if (entityNodes == null) {
            return Collections.emptyList();
        }
        String queryFieldsStr = this.getView().getPageCache().get("originQueryFields");
        Map<Object, Object> queryFieldMap = Collections.emptyMap();
        if (HRStringUtils.isNotEmpty((String)queryFieldsStr)) {
            List WarnQueryFieldBos = JSON.parseArray((String)queryFieldsStr, WarnQueryFieldBo.class);
            queryFieldMap = WarnQueryFieldBos.stream().collect(Collectors.toMap(QueryFieldCommonBo::getFieldAlias, field -> field));
        }
        String changeNameAliasStr = this.getView().getPageCache().get("changeNameQueryFieldAlias");
        List changeNameFieldAliasList = Lists.newArrayListWithExpectedSize((int)0);
        if (HRStringUtils.isNotEmpty((String)changeNameAliasStr)) {
            changeNameFieldAliasList = JSON.parseArray((String)changeNameAliasStr, String.class);
        }
        ArrayList selectedQueryFields = Lists.newArrayListWithCapacity((int)10);
        List fieldTreeNodes = JSON.parseArray((String)SerializationUtils.toJsonString((Object)entityNodes), FieldTreeNode.class);
        for (FieldTreeNode fieldTreeNode : fieldTreeNodes) {
            if (!fieldTreeNode.getSelected().booleanValue() || !fieldTreeNode.getField().booleanValue()) continue;
            WarnQueryFieldBo warnQueryFieldBo = (WarnQueryFieldBo)queryFieldMap.get(fieldTreeNode.getFieldAlias());
            if (warnQueryFieldBo == null) {
                warnQueryFieldBo = new WarnQueryFieldBo();
            }
            warnQueryFieldBo.setFieldName(fieldTreeNode.getName());
            warnQueryFieldBo.setFieldNumber(fieldTreeNode.getFieldAlias());
            warnQueryFieldBo.setEntityNumber(fieldTreeNode.getEntityNumber());
            warnQueryFieldBo.setEntityName(fieldTreeNode.getEntityName());
            warnQueryFieldBo.setFieldAlias(fieldTreeNode.getFieldAlias());
            warnQueryFieldBo.setFieldPath(fieldTreeNode.getFieldPath());
            warnQueryFieldBo.setValueType(fieldTreeNode.getValueType());
            warnQueryFieldBo.setComplexType(fieldTreeNode.getComplexType());
            warnQueryFieldBo.setBaseDataNum(fieldTreeNode.getBaseDataNum());
            warnQueryFieldBo.setBaseDataIdType(fieldTreeNode.getBaseDataIdType());
            if (changeNameFieldAliasList.contains(warnQueryFieldBo.getFieldAlias())) {
                warnQueryFieldBo.setChangeShowName(true);
            }
            selectedQueryFields.add(warnQueryFieldBo);
        }
        return selectedQueryFields;
    }

    public List<Map<String, Object>> getAllFieldsForCalFieldPage(Object fieldNodes) {
        String allTreeNodeStr = this.getView().getPageCache().get("allFieldTreeNodes");
        if (allTreeNodeStr == null) {
            return Collections.emptyList();
        }
        List selectedNodeAlias = Collections.emptyList();
        if (fieldNodes != null) {
            List selectedNodes = JSON.parseArray((String)SerializationUtils.toJsonString((Object)fieldNodes), FieldTreeNode.class);
            selectedNodeAlias = selectedNodes.stream().map(FieldTreeNode::getFieldAlias).collect(Collectors.toList());
        }
        ArrayList fields = Lists.newArrayListWithCapacity((int)10);
        List fieldTreeNodes = JSON.parseArray((String)allTreeNodeStr, FieldTreeNode.class);
        for (FieldTreeNode fieldTreeNode : fieldTreeNodes) {
            if (!fieldTreeNode.getField().booleanValue() || fieldTreeNode.getFieldPath().endsWith(".id")) continue;
            HashMap fieldMap = Maps.newHashMapWithExpectedSize((int)6);
            fieldMap.put("fieldName", fieldTreeNode.getName());
            fieldMap.put("fieldNumber", fieldTreeNode.getFieldAlias());
            fieldMap.put("valueType", fieldTreeNode.getValueType());
            if (HRStringUtils.isNotEmpty((String)fieldTreeNode.getBaseDataNum())) {
                fieldMap.put("baseDataNum", fieldTreeNode.getBaseDataNum());
            }
            if (HRStringUtils.isNotEmpty((String)fieldTreeNode.getEnumEntityNum())) {
                fieldMap.put("enumEntityNum", fieldTreeNode.getEnumEntityNum());
            }
            fieldMap.put("isSelected", selectedNodeAlias.contains(fieldTreeNode.getFieldAlias()));
            fields.add(fieldMap);
        }
        return fields;
    }

    public List<WarnCalFieldBo> getAllCalculateFields(Object calFields) {
        if (calFields == null) {
            return Collections.emptyList();
        }
        return JSON.parseArray((String)SerializationUtils.toJsonString((Object)calFields), WarnCalFieldBo.class);
    }

    public List<String> getAllRefFieldAliasByCalField(List<WarnCalFieldBo> calFields) {
        ArrayList refFieldAliasList = Lists.newArrayListWithCapacity((int)10);
        calFields.forEach(field -> {
            refFieldAliasList.addAll(field.getRefEntityFields().stream().filter(fieldAlias -> !fieldAlias.endsWith(".id")).collect(Collectors.toSet()));
            for (WarnCalFieldBo refCalculateField : field.getRefCalculateFields()) {
                refFieldAliasList.add(refCalculateField.getFieldNumber());
            }
        });
        return refFieldAliasList;
    }

    public Map<WarnSceneControlSceneEnum, Set<String>> getAllControlRefFieldAlias() {
        HashMap refFieldAliasMap = Maps.newHashMapWithExpectedSize((int)3);
        HashSet dataFilterRefFieldAlias = Sets.newHashSetWithExpectedSize((int)16);
        String dataFilter = (String)this.getModel().getValue("datafilter");
        if (HRStringUtils.isNotEmpty((String)dataFilter)) {
            RuleConditionInfo conditionInfo = (RuleConditionInfo)SerializationUtils.fromJsonString((String)dataFilter, RuleConditionInfo.class);
            List paramList = conditionInfo.getConditionList().stream().map(ConditionInfo::getParam).collect(Collectors.toList());
            String queryFieldsStr = this.getView().getPageCache().get("queryFields");
            if (HRStringUtils.isNotEmpty((String)queryFieldsStr)) {
                List WarnQueryFieldBoList = JSON.parseArray((String)queryFieldsStr, WarnQueryFieldBo.class);
                dataFilterRefFieldAlias.addAll(WarnQueryFieldBoList.stream().filter(WarnQueryFieldBo2 -> paramList.contains(WarnQueryFieldBo2.getHRFilterParam())).map(QueryFieldCommonBo::getFieldAlias).collect(Collectors.toList()));
            }
        }
        refFieldAliasMap.put(WarnSceneControlSceneEnum.DATA_FILTER, dataFilterRefFieldAlias);
        return refFieldAliasMap;
    }

    public void setAllFieldsToCache(List<FieldTreeNode> entityAllFields) {
        String allFieldTreeNodesStr = this.getView().getPageCache().get("allFieldTreeNodes");
        if (HRStringUtils.isNotEmpty((String)allFieldTreeNodesStr)) {
            List fieldTreeNodes = JSON.parseArray((String)allFieldTreeNodesStr, FieldTreeNode.class);
            entityAllFields.forEach(field -> this.addFieldTreeNode((FieldTreeNode)field, fieldTreeNodes));
            this.getView().getPageCache().put("allFieldTreeNodes", SerializationUtils.toJsonString((Object)fieldTreeNodes));
        } else {
            ArrayList allFieldTreeNodes = Lists.newArrayListWithCapacity((int)10);
            entityAllFields.forEach(field -> this.addFieldTreeNode((FieldTreeNode)field, allFieldTreeNodes));
            this.getView().getPageCache().put("allFieldTreeNodes", SerializationUtils.toJsonString((Object)allFieldTreeNodes));
        }
    }

    private void addFieldTreeNode(FieldTreeNode node, List<FieldTreeNode> allFieldTreeNodes) {
        if (node.getField().booleanValue()) {
            allFieldTreeNodes.add(node);
        }
        if (node.getChildren() != null) {
            for (FieldTreeNode child : node.getChildren()) {
                this.addFieldTreeNode(child, allFieldTreeNodes);
            }
        }
    }

    public void setFieldLock() {
        this.setFieldLock(null);
    }

    public void setFieldLock(List<WarnSceneControlSceneEnum> ignoreEnum) {
        HashSet refFieldAlias = Sets.newHashSetWithExpectedSize((int)16);
        Map<WarnSceneControlSceneEnum, Set<String>> allControlRefFieldAlias = this.getAllControlRefFieldAlias();
        for (Map.Entry<WarnSceneControlSceneEnum, Set<String>> entry : allControlRefFieldAlias.entrySet()) {
            Set<String> value = entry.getValue();
            if (value == null || ignoreEnum == null || ignoreEnum.contains((Object)entry.getKey())) continue;
            refFieldAlias.addAll(value);
        }
        CustomControl customcontrol = (CustomControl)this.getView().getControl(CUSTOM_CONTROL);
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
        dataMap.put("method", "updateFilterFieldAliasList");
        dataMap.put("filterFieldAliasList", refFieldAlias);
        customcontrol.setData((Object)dataMap);
    }

    public IFormView getView() {
        return this.basePlugin.getView();
    }

    public IDataModel getModel() {
        return this.basePlugin.getView().getModel();
    }

    public IPageCache getPageCache() {
        return this.basePlugin.getPageCache();
    }

    public HRDataBaseEdit getPlugin() {
        return this.basePlugin;
    }

    public void setPlugin(HRDataBaseEdit plugin) {
        this.basePlugin = plugin;
    }
}

