/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.earlywarn.scene;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.perm.role.HRRolePermHelper;

public class WarningRolePermF7TreeListPlugin
extends AbstractTreeListPlugin {
    private static final Log LOGGER = LogFactory.getLog(WarningRolePermF7TreeListPlugin.class);

    public void initialize() {
        super.initialize();
        this.setOnlyHasPerm();
    }

    private void setOnlyHasPerm() {
        FieldEdit onlyHasPerm = (FieldEdit)this.getControl("onlyhasperm");
        if (onlyHasPerm != null) {
            if (HRStringUtils.isNotEmpty((String)this.getBizApp()) && HRStringUtils.isNotEmpty((String)this.getEntity()) && HRStringUtils.isNotEmpty((String)this.getOnlyPermCheckboxMsg())) {
                onlyHasPerm.setCaption(new LocaleString(this.getOnlyPermCheckboxMsg()));
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"onlyhasperm"});
            }
        }
    }

    private String getBizApp() {
        return (String)this.getView().getFormShowParameter().getCustomParam("rolePermBizApp");
    }

    private String getEntity() {
        return (String)this.getView().getFormShowParameter().getCustomParam("rolePermEntity");
    }

    private String getOnlyPermCheckboxMsg() {
        return (String)this.getView().getFormShowParameter().getCustomParam("onlyPermCheckboxMsg");
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String changeKey = args.getProperty().getName();
        if ("onlyhasperm".equals(changeKey)) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refresh();
        }
    }

    public void setFilter(SetFilterEvent e) {
        long currUserId = RequestContext.get().getCurrUserId();
        e.getQFilters().add(new QFilter("id", "in", (Object)HRRolePermHelper.queryViewableRoles((long)currUserId)));
        if (((Boolean)this.getModel().getValue("onlyhasperm")).booleanValue() && HRStringUtils.isNotEmpty((String)this.getBizApp()) && HRStringUtils.isNotEmpty((String)this.getEntity())) {
            List<String> roleIdList = this.getHasPermRoles(this.getBizApp(), this.getEntity());
            e.getQFilters().add(new QFilter("id", "in", roleIdList));
        }
    }

    private List<String> getHasPermRoles(String appId, String entity) {
        QFilter bizAppFilter = new QFilter("roleperm.bizapp", "=", (Object)appId);
        QFilter entityFilter = new QFilter("roleperm.entity", "=", (Object)entity);
        DynamicObject[] rolePerms = BusinessDataServiceHelper.load((String)"perm_roleperm", (String)"roleid", (QFilter[])new QFilter[]{bizAppFilter, entityFilter});
        List<String> roleIdList = Arrays.stream(rolePerms).filter(item -> item.getDynamicObject("roleid") != null).map(it -> it.getDynamicObject("roleid").getString("id")).collect(Collectors.toList());
        return roleIdList;
    }
}

