/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.earlywarn.scene;

import java.util.LinkedList;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.hr.hbp.formplugin.web.template.HRF7TreeListPlugin;

public class WarningSceneTreeListPlugin
extends HRF7TreeListPlugin {
    private static final String BTN_NEW = "btn_new";
    private static final String BTN_COPY = "btn_copy";

    public String getBizAppId() {
        return "bizapp";
    }

    public void search(SearchEnterEvent evt) {
        String searchText = evt.getText();
        if (!StringUtils.isBlank((CharSequence)searchText)) {
            List treeNodes;
            TreeNode rootNode = this.getTreeModel().getRoot();
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            String searchNodesCacheKey = this.getView().getPageId() + "_searchNodes";
            String matchNodesCacheKey = this.getView().getPageId() + "_matchNodes";
            String oldSearchTextCacheKey = this.getView().getPageId() + "_oldSearchText";
            String searchIndexCacheKey = this.getView().getPageId() + "_searchIndex";
            String oldSearchText = pageCache.get(oldSearchTextCacheKey);
            pageCache.put(oldSearchTextCacheKey, searchText);
            String matchNodesCache = pageCache.get(matchNodesCacheKey);
            TreeView treeView = this.getTreeListView().getTreeView();
            if ((oldSearchText == null || oldSearchText.equals(searchText)) && !StringUtils.isBlank((CharSequence)matchNodesCache)) {
                String searchNodesCache = pageCache.get(searchNodesCacheKey);
                treeNodes = StringUtils.isBlank((CharSequence)searchNodesCache) ? SerializationUtils.fromJsonStringToList((String)matchNodesCache, TreeNode.class) : SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
            } else {
                treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, 10);
                pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
                pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
                pageCache.put(searchIndexCacheKey, String.valueOf(0));
            }
            if (treeNodes.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u5df2\u5b8c\u6210\uff0c\u672a\u627e\u5230\u5339\u914d\u9879\u3002", (String)"WarningSceneTreeListPlugin_0", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0]));
            } else {
                if (StringUtils.isNotEmpty((CharSequence)pageCache.get(searchIndexCacheKey))) {
                    int indexCache = Integer.parseInt(pageCache.get(searchIndexCacheKey));
                    if (indexCache == treeNodes.size()) {
                        indexCache = 0;
                    }
                    this.focusNode(treeView, (TreeNode)treeNodes.get(indexCache));
                    pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
                } else {
                    this.focusNode(treeView, (TreeNode)treeNodes.get(0));
                    pageCache.put(searchIndexCacheKey, String.valueOf(0));
                }
                pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            }
        }
    }

    private void focusNode(TreeView treeView, TreeNode searchTreeNode) {
        treeView.showNode(searchTreeNode.getId());
        treeView.treeNodeClick(searchTreeNode.getParentid(), searchTreeNode.getId());
        treeView.checkNode(searchTreeNode);
        treeView.focusNode(searchTreeNode);
    }

    public void refreshNode(RefreshNodeEvent refreshNodeEvent) {
        String nodeId = refreshNodeEvent.getNodeId().toString();
        TreeNode node = this.getTreeModel().getRoot().getTreeNode(nodeId, 15);
        if (node.getChildren() != null && node.getChildren().size() > 0) {
            node.setIsOpened(true);
        }
        this.focusNode(this.getTreeListView().getTreeView(), node);
        refreshNodeEvent.setChildNodes(node.getChildren());
    }

    private void doCopy() {
        IListView view = (IListView)this.getView();
        ListSelectedRowCollection collection = view.getSelectedRows();
        if (null == collection || collection.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u590d\u5236\u7684\u9884\u8b66\u573a\u666f\u3002", (String)"WarningSceneTreeListPlugin_1", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0]));
            return;
        }
        if (collection.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u6279\u91cf\u590d\u5236\u9884\u8b66\u573a\u666f\u3002", (String)"WarningSceneTreeListPlugin_2", (String)"hrmp-hrcs-warn-formplugin", (Object[])new Object[0]));
            return;
        }
        String id = String.valueOf(collection.get(0).getPrimaryKeyValue());
        this.showEditForm("", id, Boolean.TRUE, Boolean.FALSE);
    }

    private void showEditForm(String bizAppId, String id, boolean copy, boolean isView) {
        CloseCallBack callback = new CloseCallBack((IFormPlugin)this, BTN_NEW);
        FormShowParameter parameter = this.show(bizAppId, id, copy, callback);
        String cacheKey = copy ? id + "_copy" : id;
        String pageId = this.getPageCache().get(cacheKey);
        if (pageId == null) {
            this.getView().getPageCache().put(cacheKey, parameter.getPageId());
        } else {
            parameter.setPageId(pageId);
        }
        if (isView) {
            parameter.setStatus(OperationStatus.VIEW);
        }
        this.getView().showForm(parameter);
    }

    private FormShowParameter show(String bizAppId, String warnSceneId, boolean copy, CloseCallBack callback) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hrcs_warnscene");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setCloseCallBack(callback);
        parameter.setCustomParam("bizAppId", (Object)bizAppId);
        parameter.setCustomParam("warnSceneId", (Object)warnSceneId);
        parameter.setCustomParam("copy", (Object)copy);
        return parameter;
    }
}

