/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.earlywarn.scene.process;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.CustomEventArgs;
import kd.hr.hbp.business.service.labelandreport.FieldDefineService;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.labelandreport.EntityRelationCommonBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.WarnSchemeService;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.WarningSceneService;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.calfield.WarnCalcFieldService;
import kd.hr.hrcs.common.model.earlywarn.WarnCalFieldBo;
import kd.hr.hrcs.common.model.earlywarn.WarnEntityRelationBo;
import kd.hr.hrcs.common.model.earlywarn.WarnJoinEntityBo;
import kd.hr.hrcs.common.model.earlywarn.WarnQueryFieldBo;
import kd.hr.hrcs.formplugin.web.earlywarn.scene.WarnSceneCommonEdit;
import kd.hr.hrcs.formplugin.web.earlywarn.scene.process.WarnObjCommonProcessor;

@ExcludeFromJacocoGeneratedReport
public class WarnObjDataProcessor
extends WarnObjCommonProcessor {
    private static final String DATA_SOURCE = "changeDataSourceConfirm_dataSource";

    public WarnObjDataProcessor(WarnSceneCommonEdit plugin) {
        super(plugin);
    }

    public void getAllData(CustomEventArgs args) {
        Map dataMap = (Map)SerializationUtils.fromJsonString((String)args.getEventArgs(), Map.class);
        Object entityNodes = dataMap.get("entityNodes");
        String joinEntitiesStr = SerializationUtils.toJsonString(entityNodes);
        this.getView().getPageCache().put("joinEntities", joinEntitiesStr);
        List<Object> entityRelationBos = Lists.newArrayListWithCapacity((int)10);
        if (HRStringUtils.isNotEmpty((String)joinEntitiesStr)) {
            List queryEntityBos = JSON.parseArray((String)joinEntitiesStr, WarnJoinEntityBo.class);
            entityRelationBos = queryEntityBos.stream().map(WarnJoinEntityBo::getEntityRelation).filter(Objects::nonNull).collect(Collectors.toList());
        }
        this.getView().getPageCache().put("entityRelations", SerializationUtils.toJsonString((Object)entityRelationBos));
        Object queryFields = dataMap.get("queryFields");
        List<WarnQueryFieldBo> queryFieldBos = this.getSelectedQueryFields(queryFields);
        this.getView().getPageCache().put("queryFields", SerializationUtils.toJsonString(queryFieldBos));
        Object calFields = dataMap.get("calFields");
        List calculateFieldBos = Lists.newArrayListWithCapacity((int)10);
        String calFieldsStr = SerializationUtils.toJsonString(calFields);
        if (HRStringUtils.isNotEmpty((String)calFieldsStr)) {
            calculateFieldBos = JSON.parseArray((String)calFieldsStr, WarnCalFieldBo.class);
        }
        this.getView().getPageCache().put("calculateFields", SerializationUtils.toJsonString((Object)calculateFieldBos));
        String operate = (String)dataMap.get("operate");
        if (HRStringUtils.equals((String)operate, (String)"dataPreview")) {
            this.getView().invokeOperation("previewdata");
        } else if (HRStringUtils.equals((String)operate, (String)"nextStep")) {
            this.getView().invokeOperation("nextstep");
        } else if (HRStringUtils.equals((String)operate, (String)"save")) {
            this.getView().invokeOperation("save");
        }
    }

    public boolean validateNumber(String nextTab) {
        if (HRStringUtils.equals((String)nextTab, (String)"definefield")) {
            String number = (String)this.getModel().getValue("number");
            return Pattern.matches("^[a-zA-Z0-9_]*$", number);
        }
        return true;
    }

    public boolean validateFieldDefineData(String op) {
        List joinEntities = Collections.emptyList();
        List entityRelations = Collections.emptyList();
        List queryFields = Collections.emptyList();
        List calculateFields = Collections.emptyList();
        String joinEntitiesStr = this.getView().getPageCache().get("joinEntities");
        String queryFieldsStr = this.getView().getPageCache().get("queryFields");
        String entityRelationsStr = this.getView().getPageCache().get("entityRelations");
        String calculateFieldsStr = this.getView().getPageCache().get("calculateFields");
        if (HRStringUtils.isNotEmpty((String)joinEntitiesStr)) {
            joinEntities = JSON.parseArray((String)joinEntitiesStr, WarnJoinEntityBo.class);
        }
        if (HRStringUtils.isNotEmpty((String)entityRelationsStr)) {
            entityRelations = JSON.parseArray((String)entityRelationsStr, WarnEntityRelationBo.class);
        }
        if (HRStringUtils.isEmpty((String)joinEntitiesStr) || joinEntities.isEmpty()) {
            String dataSource = this.getView().getPageCache().get(DATA_SOURCE);
            if (HRStringUtils.equals((String)dataSource, (String)"virtual")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u865a\u62df\u5bf9\u8c61\u540e\u91cd\u8bd5\u3002", (String)"WarnObjDataProcessor_17", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61\u540e\u91cd\u8bd5\u3002", (String)"WarnObjDataProcessor_12", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        for (WarnJoinEntityBo joinEntity : joinEntities) {
            if (HRStringUtils.equals((String)joinEntity.getType(), (String)"main")) continue;
            Optional<WarnEntityRelationBo> relationOptional = entityRelations.stream().filter(relation -> relation != null && HRStringUtils.isNotEmpty((String)relation.getEntityAlias()) && HRStringUtils.equals((String)relation.getJoinEntityAlias(), (String)joinEntity.getEntityAlias())).findAny();
            boolean noSet = false;
            if (relationOptional.isPresent()) {
                EntityRelationCommonBo entityRelation;
                List conditions;
                if (HRStringUtils.equals((String)relationOptional.get().getJoinType(), (String)"none")) {
                    noSet = true;
                }
                if ((conditions = (entityRelation = (EntityRelationCommonBo)relationOptional.get()).getConditions()) == null || conditions.isEmpty() || HRStringUtils.isEmpty((String)entityRelation.getJoinType())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u4e1a\u52a1\u5bf9\u8c61\u672a\u8bbe\u7f6e\u5173\u8054\u5173\u7cfb\u6761\u4ef6\uff0c\u8bf7\u64cd\u4f5c\u540e\u91cd\u8bd5\u3002", (String)"WarnObjDataProcessor_24", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                    return false;
                }
            } else {
                noSet = true;
            }
            if (!noSet) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u4e1a\u52a1\u5bf9\u8c61\u672a\u8bbe\u7f6e\u5173\u8054\u5173\u7cfb\uff0c\u8bf7\u64cd\u4f5c\u540e\u91cd\u8bd5\u3002", (String)"WarnObjDataProcessor_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (HRStringUtils.isNotEmpty((String)queryFieldsStr)) {
            queryFields = JSON.parseArray((String)queryFieldsStr, WarnQueryFieldBo.class);
        }
        if (HRStringUtils.isNotEmpty((String)calculateFieldsStr)) {
            calculateFields = JSON.parseArray((String)calculateFieldsStr, WarnCalFieldBo.class);
        }
        if (queryFields.isEmpty() && calculateFields.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u5b57\u6bb5\u540e\u91cd\u8bd5\u3002", (String)"WarnObjDataProcessor_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (queryFields.isEmpty()) {
            boolean hasSelected = false;
            for (WarnCalFieldBo calculateField : calculateFields) {
                if (!calculateField.getSelected().booleanValue()) continue;
                hasSelected = true;
                break;
            }
            if (!hasSelected) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u5b57\u6bb5\u540e\u91cd\u8bd5\u3002", (String)"WarnObjDataProcessor_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        if ("nextstep".equalsIgnoreCase(op)) {
            return this.validateQueryFieldRefByScheme(queryFields, calculateFields);
        }
        return true;
    }

    private boolean validateQueryFieldRefByScheme(List<WarnQueryFieldBo> queryFields, List<WarnCalFieldBo> calFields) {
        DynamicObject sceneDy = this.getModel().getDataEntity();
        if (!sceneDy.getDataEntityState().getFromDatabase()) {
            return true;
        }
        Long sceneObjPkId = sceneDy.getLong("id");
        HashSet fieldAliasSet = Sets.newHashSetWithExpectedSize((int)16);
        calFields = calFields.stream().filter(WarnCalFieldBo::getSelected).collect(Collectors.toList());
        fieldAliasSet.addAll(queryFields.stream().map(QueryFieldCommonBo::getFieldAlias).collect(Collectors.toSet()));
        fieldAliasSet.addAll(calFields.stream().map(WarnCalFieldBo::getFieldNumber).collect(Collectors.toSet()));
        DynamicObject[] refSchemeDys = WarnSchemeService.getSceneRefSchemeDys((Object)sceneObjPkId);
        HashSet refFieldAll = Sets.newHashSetWithExpectedSize((int)16);
        HashMap refFieldMap = Maps.newHashMapWithExpectedSize((int)16);
        if (refSchemeDys != null && refSchemeDys.length > 0) {
            DynamicObject[] schemeMsgConfDys = WarnSchemeService.getSchemeMsgConfDys((Object[])Arrays.stream(refSchemeDys).map(DataEntityBase::getPkValue).toArray());
            Map schemeIdToMsgConf = Arrays.stream(schemeMsgConfDys).collect(Collectors.toMap(dy -> dy.get("sourceid"), Function.identity(), (x, y) -> y));
            for (DynamicObject refSchemeDy : refSchemeDys) {
                DynamicObjectCollection detailEntry;
                HashSet refFields = Sets.newHashSetWithExpectedSize((int)16);
                refFields.addAll(WarnSchemeService.getSchemeDyBCRefFieldAlias((DynamicObject)refSchemeDy));
                DynamicObject msgConfig = (DynamicObject)schemeIdToMsgConf.get(refSchemeDy.getPkValue());
                if (msgConfig != null) {
                    refFields.addAll(WarnSchemeService.getMsgConfigRefFieldAlias((DynamicObject)msgConfig));
                }
                if ((detailEntry = refSchemeDy.getDynamicObjectCollection("rcrelationentryentity")) != null) {
                    refFields.addAll(detailEntry.stream().map(m -> m.getString("rcuser")).collect(Collectors.toSet()));
                }
                refFieldMap.put(refSchemeDy.getString("name"), refFields);
            }
        }
        for (Map.Entry entry : refFieldMap.entrySet()) {
            ((Set)entry.getValue()).removeAll(fieldAliasSet);
            refFieldAll.addAll((Collection)entry.getValue());
        }
        if (!refFieldAll.isEmpty()) {
            Set entityNames;
            DynamicObject[] dbQueryFields = WarningSceneService.getInstance().loadSceneQueryFieldsByFieldAlias((Object)sceneObjPkId, (Set)refFieldAll);
            Set entityNumbers = Arrays.stream(dbQueryFields).map(e -> e.getString("entitynumber")).collect(Collectors.toSet());
            HashSet entityNumberRemain = Sets.newHashSetWithExpectedSize((int)16);
            entityNumberRemain.addAll(entityNumbers);
            entityNumberRemain.removeAll(queryFields.stream().map(e -> e.getEntityNumber()).collect(Collectors.toSet()));
            HashSet refSchemeNames = Sets.newHashSetWithExpectedSize((int)16);
            for (Map.Entry entry : refFieldMap.entrySet()) {
                if (((Set)entry.getValue()).size() <= 0) continue;
                refSchemeNames.add(entry.getKey());
            }
            if (entityNumberRemain.size() > 0) {
                entityNames = entityNumbers.stream().map(e -> EntityMetadataCache.getDataEntityType((String)e).getDisplayName().getLocaleValue()).collect(Collectors.toSet());
                this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u4fee\u6539\u5931\u8d25\uff0c\u9884\u8b66\u65b9\u6848{1}\u5f15\u7528\u4e86\u6b64\u9884\u8b66\u5bf9\u8c61\u5b57\u6bb5\u3002", (String)"WarnSceneValidator_1", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]), String.join((CharSequence)"\u201d\u3001\u201c", entityNames), String.join((CharSequence)"\u201d\u3001\u201c", refSchemeNames)));
                return false;
            }
            if (entityNumbers == null || entityNumbers.size() == 0) {
                DynamicObject[] calculateFields = WarnCalcFieldService.getInstance().loadAllFieldCalFieldsBySourceId((Object)sceneObjPkId);
                Set calFieldNames = Arrays.stream(calculateFields).filter(e -> refFieldAll.contains(e.getString("number"))).map(e -> e.getString("name")).collect(Collectors.toSet());
                this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u201c{0}\u201d\u8ba1\u7b97\u5b57\u6bb5\u5220\u9664\u5931\u8d25\uff0c\u8be5\u5b57\u6bb5\u5df2\u88ab\u9884\u8b66\u65b9\u6848\u201c{1}\u201d\u5f15\u7528\u3002", (String)"WarnSceneValidator_6", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]), String.join((CharSequence)"\u201d\u3001\u201c", calFieldNames), String.join((CharSequence)"\u201d\u3001\u201c", refSchemeNames)));
                return false;
            }
            entityNames = entityNumbers.stream().map(e -> EntityMetadataCache.getDataEntityType((String)e).getDisplayName().getLocaleValue()).collect(Collectors.toSet());
            this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u201c{0}\u201d\u4e1a\u52a1\u5bf9\u8c61\u4e2d\u7684\u201c{1}\u201d\u5b57\u6bb5\u53d6\u6d88\u9009\u4e2d\u5931\u8d25\uff0c\u5176\u5df2\u88ab\u9884\u8b66\u65b9\u6848\u201c{2}\u201d\u5f15\u7528\u3002", (String)"WarnSceneValidator_2", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]), String.join((CharSequence)"\u201d\u3001\u201c", entityNames), String.join((CharSequence)"\u201d\u3001\u201c", Arrays.stream(dbQueryFields).map(e -> e.getString("fieldname")).collect(Collectors.toList())), String.join((CharSequence)"\u201d\u3001\u201c", refSchemeNames)));
            return false;
        }
        return true;
    }

    public void confirmChangeDataSource(int result) {
        String dataSource = this.getView().getPageCache().get(DATA_SOURCE);
        if (result == MessageBoxResult.Yes.getValue()) {
            this.changeDataSource(dataSource);
        } else if (HRStringUtils.equals((String)dataSource, (String)"virtual")) {
            this.getView().getPageCache().put(DATA_SOURCE, "business");
        } else {
            this.getView().getPageCache().put(DATA_SOURCE, "virtual");
        }
    }

    private void changeDataSource(String dataSource) {
        FieldDefineService fieldDefineService = new FieldDefineService();
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
        dataMap.put("method", "changeDataSource");
        List dataSourceCloudBos = fieldDefineService.getDataSourceTree();
        dataMap.put("dataSource", dataSourceCloudBos);
        dataMap.put("entities", fieldDefineService.getAllEntities(dataSourceCloudBos));
        dataMap.put("time", new Date());
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        customcontrol.setData((Object)dataMap);
        this.clearEntityAndFields();
    }

    private void clearEntityAndFields() {
        this.getView().getPageCache().remove("allFieldTreeNodes");
        this.getView().getPageCache().remove("joinEntities");
        this.getView().getPageCache().remove("entityRelations");
        this.getView().getPageCache().remove("queryFields");
        this.getView().getPageCache().remove("calculateFields");
    }
}

