/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.common.util.earlywarn;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.LongProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.complexobj.ComplexConstant;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.enums.FilterOperatorEnum;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.FieldComplexType;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hrcs.common.model.earlywarn.WarnBaseConditionBo;
import kd.hr.hrcs.common.model.earlywarn.WarnQueryFieldBo;
import kd.hr.hrcs.common.model.earlywarn.vo.WarnBaseConditionReturnVo;

@ExcludeFromJacocoGeneratedReport
public class WarnFilterUtils {
    private static final Log LOG = LogFactory.getLog(WarnFilterUtils.class);
    public static final String LOGIC_ALL_AND = "0";
    public static final String LOGIC_ALL_OR = "1";
    public static final String LOGIC_CUSTOM = "2";
    public static final String AND = "AND";
    public static final String OR = "OR";
    public static final String LEFT_BRACKET_STR = "(";
    public static final String RIGHT_BRACKET_STR = ")";
    private static final Map<String, String> COMMON_OPERATOR_MAP = ImmutableMap.builder().put((Object)FilterOperatorEnum.LESS_THAN.getValue(), (Object)"<").put((Object)FilterOperatorEnum.GREATER_THAN.getValue(), (Object)">").put((Object)FilterOperatorEnum.LESS_OR_EQUAL.getValue(), (Object)"<=").put((Object)FilterOperatorEnum.GREATER_OR_EQUAL.getValue(), (Object)">=").put((Object)FilterOperatorEnum.EQUAL.getValue(), (Object)"=").put((Object)FilterOperatorEnum.NOT_EQUAL.getValue(), (Object)"!=").put((Object)FilterOperatorEnum.IS_NULL.getValue(), (Object)"is null").put((Object)FilterOperatorEnum.IS_NOT_NULL.getValue(), (Object)"is not null").build();
    private static final Set<String> DATE_OP_SET = Sets.newHashSet((Object[])new String[]{FilterOperatorEnum.TODAY.getValue(), FilterOperatorEnum.LESS_OR_EQUALS_TODAY.getValue(), FilterOperatorEnum.GREATER_OR_EQUALS_TODAY.getValue(), FilterOperatorEnum.YESTERDAY.getValue(), FilterOperatorEnum.TOMORROW.getValue(), FilterOperatorEnum.THIS_WEEK.getValue(), FilterOperatorEnum.LAST_WEEK.getValue(), FilterOperatorEnum.NEXT_WEEK.getValue(), FilterOperatorEnum.THIS_MONTH.getValue(), FilterOperatorEnum.LAST_MONTH.getValue(), FilterOperatorEnum.NEXT_MONTH.getValue(), FilterOperatorEnum.LAST3MONTH.getValue(), FilterOperatorEnum.NEXT3MONTH.getValue(), FilterOperatorEnum.THIS_QUARTER.getValue(), FilterOperatorEnum.LAST_QUARTER.getValue(), FilterOperatorEnum.NEXT_QUARTER.getValue(), FilterOperatorEnum.THIS_YEAR.getValue(), FilterOperatorEnum.LAST_YEAR.getValue(), FilterOperatorEnum.NEXT_YEAR.getValue(), FilterOperatorEnum.LAST1MONTH.getValue(), FilterOperatorEnum.NEXT1MONTH.getValue(), FilterOperatorEnum.LESS_TODAY.getValue(), FilterOperatorEnum.GREATER_TODAY.getValue(), FilterOperatorEnum.LAST3DAY.getValue(), FilterOperatorEnum.LAST7DAY.getValue(), FilterOperatorEnum.LAST15DAY.getValue(), FilterOperatorEnum.LAST60DAY.getValue(), FilterOperatorEnum.MONTH2TODAY.getValue(), FilterOperatorEnum.YEAR2TODAY.getValue()});

    public static QFilter condition2QFilter4Warn(String conditionJson, String queryFieldBoJson) {
        try {
            WarnBaseConditionReturnVo ruleConditionInfo = (WarnBaseConditionReturnVo)SerializationUtils.fromJsonString((String)conditionJson, WarnBaseConditionReturnVo.class);
            List<WarnBaseConditionBo> conditionList = ruleConditionInfo.getBaseConditionBos();
            if (CollectionUtils.isEmpty(conditionList)) {
                return null;
            }
            ArrayList<String> dateParamList = new ArrayList<String>(conditionList.size());
            List queryFieldBos = JSONArray.parseArray((String)queryFieldBoJson, WarnQueryFieldBo.class);
            String expressStr = ruleConditionInfo.getLogicExpressStr();
            for (int i = 0; i < conditionList.size(); ++i) {
                QFilter qFilter = WarnFilterUtils.condition2QFilter(conditionList.get(i), queryFieldBos, dateParamList);
                if (qFilter == null) continue;
                WarnFilterUtils.encodeQFilter(qFilter);
                String filterStr = qFilter.toString();
                String re = i < 9 ? "T0" + (i + 1) : "T" + (i + 1);
                expressStr = expressStr.replace(re, filterStr);
            }
            return WarnFilterUtils.decodeQFilter(QFilter.of((String)expressStr, (Object[])new Object[0]), dateParamList);
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
            return QFilter.of((String)"1 = 1 ", (Object[])new Object[0]);
        }
    }

    private static void encodeQFilter(QFilter qFilter) {
        List nestList;
        String value;
        if (qFilter == null) {
            return;
        }
        String property = qFilter.getProperty();
        if (property.contains("_")) {
            property = property.replaceAll("_", "ENCODE_ENCODE");
        }
        if (property.contains("\u03b4")) {
            property = property.replaceAll("\u03b4", "__");
        }
        qFilter.__setProperty(property);
        if (qFilter.getValue() instanceof String && (value = qFilter.getValue().toString()).contains(QEmptyValue.value.toString())) {
            qFilter.__setValue((Object)value.replaceAll(QEmptyValue.value.toString(), ComplexConstant.ENCODE_EMPTY));
        }
        if (!CollectionUtils.isEmpty((Collection)(nestList = qFilter.getNests(false)))) {
            for (QFilter.QFilterNest qFilterNest : nestList) {
                WarnFilterUtils.encodeQFilter(qFilterNest.getFilter());
            }
        }
    }

    private static QFilter decodeQFilter(QFilter qFilter, List<String> dateParamList) {
        List nestList;
        String property = qFilter.getProperty();
        if (property.contains("_")) {
            property = property.replaceAll("__", "\u03b4");
            property = property.replaceAll("ENCODE_ENCODE", "_");
        }
        qFilter.__setProperty(property);
        if (qFilter.getValue() instanceof String) {
            String value = qFilter.getValue().toString();
            if (value.equals(QEmptyValue.value.toString())) {
                qFilter.__setValue((Object)QEmptyValue.value);
            } else if (value.contains(ComplexConstant.ENCODE_EMPTY)) {
                qFilter.__setValue((Object)value.replaceAll(ComplexConstant.ENCODE_EMPTY, QEmptyValue.value.toString()));
            }
            if (dateParamList.contains(property)) {
                try {
                    qFilter.__setValue((Object)HRDateTimeUtils.parseDate((String)value, (String)"yyyy-MM-dd"));
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(nestList = qFilter.getNests(false)))) {
            for (QFilter.QFilterNest qFilterNest : nestList) {
                WarnFilterUtils.decodeQFilter(qFilterNest.getFilter(), dateParamList);
            }
        }
        return qFilter;
    }

    public static QFilter condition2QFilter(WarnBaseConditionBo conditionInfo, List<WarnQueryFieldBo> queryFieldBos, List<String> dateParamList) {
        String[] split;
        String param = conditionInfo.getRuleValue();
        String opt = conditionInfo.getOperator();
        String value = conditionInfo.getSelectValue();
        String valueType = conditionInfo.getValueType();
        String complexType = conditionInfo.getComplexType();
        boolean isBaseData = WarnFilterUtils.isBaseData(complexType);
        boolean isMultiCombo = WarnFilterUtils.isMultiEnum(conditionInfo.getControlType());
        if (isMultiCombo) {
            if (FilterOperatorEnum.EQUAL.getValue().equals(opt) || FilterOperatorEnum.IN.getValue().equals(opt)) {
                opt = FilterOperatorEnum.CONTAINS.getValue();
            } else if (FilterOperatorEnum.NOT_EQUAL.getValue().equals(opt) || FilterOperatorEnum.NOT_IN.getValue().equals(opt)) {
                opt = FilterOperatorEnum.NOT_CONTAINS.getValue();
            }
        }
        MainEntityType baseDataEntityType = null;
        if (isBaseData) {
            baseDataEntityType = EntityMetadataCache.getDataEntityType((String)conditionInfo.getBaseDataNumber());
        }
        ISimpleProperty baseDataPrimaryKey = null;
        if (baseDataEntityType != null) {
            baseDataPrimaryKey = baseDataEntityType.getPrimaryKey();
        }
        if (DataTypeEnum.BOOLEAN.getDataTypeKey().equals(valueType) && "true".equals(value)) {
            value = LOGIC_ALL_OR;
        }
        if (DataTypeEnum.BOOLEAN.getDataTypeKey().equals(valueType) && "false".equals(value)) {
            value = LOGIC_ALL_AND;
        }
        if ("plugin".equals(conditionInfo.getSource())) {
            param = "PLUGIN_FIELD_ALIAS_PREFIX_" + param;
        } else if ("warnObject".equals(conditionInfo.getSource())) {
            for (QueryFieldCommonBo queryFieldCommonBo : queryFieldBos) {
                if (!queryFieldCommonBo.getHRFilterParam().equals(param)) continue;
                param = queryFieldCommonBo.getFieldAlias();
            }
        }
        if (DATE_OP_SET.contains(opt)) {
            dateParamList.add(param);
            return WarnFilterUtils.date2QFilter(param, opt);
        }
        if (FilterOperatorEnum.STARTS_WITH.getValue().equals(opt)) {
            return new QFilter(param, "like", (Object)(value + "%"));
        }
        if (FilterOperatorEnum.ENDS_WITH.getValue().equals(opt)) {
            return new QFilter(param, "like", (Object)("%" + value));
        }
        if (FilterOperatorEnum.IS_NULL.getValue().equals(opt)) {
            if (WarnFilterUtils.isBaseData(complexType)) {
                return new QFilter(param, "=", (Object)QEmptyValue.value).or(new QFilter(WarnFilterUtils.removeBaseDataKey(param) + ".id", "=", (Object)QEmptyValue.value));
            }
            return new QFilter(param, "=", (Object)QEmptyValue.value);
        }
        if (FilterOperatorEnum.IS_NOT_NULL.getValue().equals(opt)) {
            if (DataTypeEnum.DATETIME.getDataTypeKey().equals(valueType)) {
                return new QFilter(param, "is not null", null);
            }
            if (WarnFilterUtils.isBaseData(complexType)) {
                return new QFilter(param, "is not null", null);
            }
            return new QFilter(param, "is not null", null).and(new QFilter(param, "!=", (Object)"")).and(new QFilter(param, "!=", (Object)" "));
        }
        if (FilterOperatorEnum.CONTAINS.getValue().equals(opt)) {
            if (isBaseData) {
                param = WarnFilterUtils.removeBaseDataKey(param) + ".id";
                return new QFilter(param, "=", (Object)value);
            }
            if (isMultiCombo) {
                if (value.contains(",")) {
                    split = value.split(",");
                    QFilter qFilter = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
                    for (String splitValue : split) {
                        qFilter.or(new QFilter(param, "like", (Object)("%," + splitValue + ",%")));
                    }
                    return qFilter;
                }
                value = "," + value + ",";
            }
            return new QFilter(param, "like", (Object)("%" + value + "%"));
        }
        if (FilterOperatorEnum.NOT_CONTAINS.getValue().equals(opt)) {
            if (WarnFilterUtils.isBaseData(complexType)) {
                param = WarnFilterUtils.removeBaseDataKey(param) + ".id";
                return new QFilter(param, "!=", (Object)value).or(new QFilter(param, "=", (Object)QEmptyValue.value));
            }
            if (isMultiCombo) {
                if (value.contains(",")) {
                    split = value.split(",");
                    QFilter qFilter = QFilter.of((String)"1 == 1", (Object[])new Object[0]);
                    for (String splitValue : split) {
                        qFilter.and(new QFilter(param, "not like", (Object)("%," + splitValue + ",%")));
                    }
                    return qFilter;
                }
                value = "," + value + ",";
            }
            return new QFilter(param, "not like", (Object)("%" + value + "%"));
        }
        if (FilterOperatorEnum.IN.getValue().equals(opt)) {
            if (WarnFilterUtils.isBaseData(complexType)) {
                param = WarnFilterUtils.removeBaseDataKey(param) + ".id";
            }
            if (baseDataPrimaryKey instanceof LongProp || DataTypeEnum.LONG.getDataTypeKey().equals(conditionInfo.getValueType())) {
                return new QFilter(param, "in", Arrays.stream(value.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            }
            return new QFilter(param, "in", (Object)value.split(","));
        }
        if (FilterOperatorEnum.NOT_IN.getValue().equals(opt)) {
            if (WarnFilterUtils.isBaseData(complexType)) {
                param = WarnFilterUtils.removeBaseDataKey(param) + ".id";
            }
            if (baseDataPrimaryKey instanceof LongProp || DataTypeEnum.LONG.getDataTypeKey().equals(conditionInfo.getValueType())) {
                return new QFilter(param, "not in", Arrays.stream(value.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            }
            return new QFilter(param, "not in", (Object)value.split(","));
        }
        if (WarnFilterUtils.isBaseData(complexType)) {
            param = WarnFilterUtils.removeBaseDataKey(param) + ".id";
        }
        if (DataTypeEnum.BIGDECIMAL.getDataTypeKey().equals(conditionInfo.getValueType()) || DataTypeEnum.INTEGER.getDataTypeKey().equals(conditionInfo.getValueType()) || DataTypeEnum.LONG.getDataTypeKey().equals(conditionInfo.getValueType())) {
            return new QFilter(param, COMMON_OPERATOR_MAP.get(opt), (Object)new BigDecimal(value));
        }
        if (DataTypeEnum.DATETIME.getDataTypeKey().equals(conditionInfo.getValueType())) {
            try {
                dateParamList.add(param);
                return new QFilter(param, COMMON_OPERATOR_MAP.get(opt), (Object)HRDateTimeUtils.parseDate((String)value, (String)"yyyy-MM-dd"));
            }
            catch (ParseException e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u7c7b\u578b\u8f6c\u6362\u9519\u8bef", (String)"HRFilterUtil_0", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            }
        }
        if (WarnFilterUtils.isBaseData(complexType) && (baseDataPrimaryKey instanceof LongProp || DataTypeEnum.LONG.getDataTypeKey().equals(conditionInfo.getValueType()))) {
            return new QFilter(param, COMMON_OPERATOR_MAP.get(opt), (Object)Long.parseLong(value));
        }
        return new QFilter(param, COMMON_OPERATOR_MAP.get(opt), (Object)value);
    }

    private static QFilter date2QFilter(String param, String opt) {
        LocalDate date = LocalDate.now();
        int dayOfWeek = date.getDayOfWeek().getValue();
        int year = date.getYear();
        int quarter = (int)Math.ceil((double)date.getMonthValue() / 3.0);
        FilterOperatorEnum filterOperatorEnum = FilterOperatorEnum.getEnum((String)opt);
        if (filterOperatorEnum == null) {
            return null;
        }
        switch (filterOperatorEnum) {
            case TODAY: {
                return new QFilter(param, "=", (Object)date);
            }
            case LESS_OR_EQUALS_TODAY: {
                return new QFilter(param, "<=", (Object)date);
            }
            case GREATER_OR_EQUALS_TODAY: {
                return new QFilter(param, ">=", (Object)date);
            }
            case YESTERDAY: {
                return new QFilter(param, "=", (Object)date.plusDays(-1L));
            }
            case TOMORROW: {
                return new QFilter(param, "=", (Object)date.plusDays(1L));
            }
            case THIS_WEEK: {
                return new QFilter(param, ">", (Object)date.plusDays(-dayOfWeek)).and(new QFilter(param, "<=", (Object)date.plusDays(7 - dayOfWeek)));
            }
            case LAST_WEEK: {
                return new QFilter(param, ">", (Object)date.plusDays(-dayOfWeek - 7)).and(new QFilter(param, "<=", (Object)date.plusDays(-dayOfWeek)));
            }
            case NEXT_WEEK: {
                return new QFilter(param, ">", (Object)date.plusDays(-dayOfWeek + 7)).and(new QFilter(param, "<=", (Object)date.plusDays(14 - dayOfWeek)));
            }
            case THIS_MONTH: {
                return new QFilter(param, ">=", (Object)date.withDayOfMonth(1)).and(new QFilter(param, "<", (Object)date.plusMonths(1L).withDayOfMonth(1)));
            }
            case LAST_MONTH: {
                return new QFilter(param, ">=", (Object)date.minusMonths(1L).withDayOfMonth(1)).and(new QFilter(param, "<", (Object)date.withDayOfMonth(1)));
            }
            case NEXT_MONTH: {
                return new QFilter(param, ">=", (Object)date.plusMonths(1L).withDayOfMonth(1)).and(new QFilter(param, "<", (Object)date.plusMonths(2L).withDayOfMonth(1)));
            }
            case LAST3MONTH: {
                return new QFilter(param, ">=", (Object)date.minusMonths(3L)).and(new QFilter(param, "<=", (Object)date));
            }
            case NEXT3MONTH: {
                return new QFilter(param, ">=", (Object)date).and(new QFilter(param, "<=", (Object)date.plusMonths(3L)));
            }
            case THIS_QUARTER: {
                return new QFilter(param, ">=", (Object)WarnFilterUtils.getQuarterFirstDay(year, quarter)).and(new QFilter(param, "<", (Object)WarnFilterUtils.getQuarterFirstDay(year, quarter + 1)));
            }
            case LAST_QUARTER: {
                return new QFilter(param, ">=", (Object)WarnFilterUtils.getQuarterFirstDay(year, quarter - 1)).and(new QFilter(param, "<", (Object)WarnFilterUtils.getQuarterFirstDay(year, quarter)));
            }
            case NEXT_QUARTER: {
                return new QFilter(param, ">=", (Object)WarnFilterUtils.getQuarterFirstDay(year, quarter + 1)).and(new QFilter(param, "<", (Object)WarnFilterUtils.getQuarterFirstDay(year, quarter + 2)));
            }
            case THIS_YEAR: {
                return new QFilter(param, ">=", (Object)date.withYear(year)).and(new QFilter(param, "<", (Object)date.withYear(year + 1)));
            }
            case LAST_YEAR: {
                return new QFilter(param, ">=", (Object)date.withYear(year - 1)).and(new QFilter(param, "<", (Object)date.withYear(year)));
            }
            case NEXT_YEAR: {
                return new QFilter(param, ">=", (Object)date.withYear(year + 1)).and(new QFilter(param, "<", (Object)date.withYear(year + 2)));
            }
            case LAST1MONTH: {
                return new QFilter(param, ">=", (Object)date.minusMonths(1L)).and(new QFilter(param, "<=", (Object)date));
            }
            case NEXT1MONTH: {
                return new QFilter(param, ">=", (Object)date).and(new QFilter(param, "<=", (Object)date.plusMonths(1L)));
            }
            case LESS_TODAY: {
                return new QFilter(param, "<", (Object)date);
            }
            case GREATER_TODAY: {
                return new QFilter(param, ">", (Object)date);
            }
            case LAST3DAY: {
                return new QFilter(param, ">", (Object)date.plusDays(-3L)).and(new QFilter(param, "<=", (Object)date));
            }
            case LAST7DAY: {
                return new QFilter(param, ">", (Object)date.plusDays(-7L)).and(new QFilter(param, "<=", (Object)date));
            }
            case LAST15DAY: {
                return new QFilter(param, ">", (Object)date.plusDays(-15L)).and(new QFilter(param, "<=", (Object)date));
            }
            case LAST60DAY: {
                return new QFilter(param, ">", (Object)date.plusDays(-60L)).and(new QFilter(param, "<=", (Object)date));
            }
            case MONTH2TODAY: {
                return new QFilter(param, ">=", (Object)date.withDayOfMonth(1)).and(new QFilter(param, "<=", (Object)date));
            }
            case YEAR2TODAY: {
                return new QFilter(param, ">=", (Object)date.withDayOfYear(1)).and(new QFilter(param, "<=", (Object)date));
            }
        }
        return null;
    }

    @ExcludeFromJacocoGeneratedReport
    private static LocalDate getQuarterFirstDay(int year, int quarter) {
        if (quarter == 0) {
            return LocalDate.of(year - 1, 10, 1);
        }
        if (quarter == 1) {
            return LocalDate.of(year, 1, 1);
        }
        if (quarter == 2) {
            return LocalDate.of(year, 4, 1);
        }
        if (quarter == 3) {
            return LocalDate.of(year, 7, 1);
        }
        if (quarter == 4) {
            return LocalDate.of(year, 10, 1);
        }
        if (quarter == 5) {
            return LocalDate.of(year + 1, 1, 1);
        }
        if (quarter == 6) {
            return LocalDate.of(year + 1, 4, 1);
        }
        return null;
    }

    private static String removeBaseDataKey(String param) {
        return param.substring(0, param.lastIndexOf("."));
    }

    private static boolean isBaseData(String complexType) {
        return FieldComplexType.ADMIN_ORG.getValue().equals(complexType) || FieldComplexType.BASE_DATA.getValue().equals(complexType) || FieldComplexType.HIS_BASE_DATA.getValue().equals(complexType);
    }

    private static boolean isMultiEnum(String controlType) {
        return FieldControlType.MUL_COMBO.getValue().equals(controlType);
    }
}

