/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.common.util.earlywarn;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.ISVInfo;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.labelandreport.FieldTreeNode;
import kd.hr.hbp.common.util.HRStringUtils;

@ExcludeFromJacocoGeneratedReport
public class WarningCommonUtils {
    public static boolean validateNumberByISVIsKD() {
        ISVInfo isvInfo = ISVServiceHelper.getISVInfo();
        String isvId = isvInfo.getId();
        return HRStringUtils.equals((String)isvId, (String)"kingdee");
    }

    public static boolean validateNumber(String number) {
        return Pattern.matches("^[a-zA-Z0-9_]*$", number);
    }

    public static boolean validateNumberNoUpper(String number) {
        return Pattern.matches("^[a-z0-9_]*$", number);
    }

    public static void deleteFieldTreeNode(FieldTreeNode node, Map<String, String> fieldMap, Set<String> refFieldKeys, boolean isReset) {
        if (node.getChildren() != null) {
            Iterator iterator = node.getChildren().iterator();
            while (iterator.hasNext()) {
                FieldTreeNode child = (FieldTreeNode)iterator.next();
                WarningCommonUtils.deleteFieldTreeNode(child, fieldMap, refFieldKeys, isReset);
                if (fieldMap.containsValue(child.getEntityNumber())) {
                    if (fieldMap.containsKey(child.getFieldAlias()) || child.getEntry().booleanValue() || child.getSubEntry().booleanValue()) {
                        if (refFieldKeys.contains(child.getFieldAlias()) || !isReset) continue;
                        child.setSelected(Boolean.valueOf(false));
                        continue;
                    }
                    iterator.remove();
                    continue;
                }
                iterator.remove();
            }
        }
    }

    public static void changeFieldTreeNodeName(FieldTreeNode node, Map<String, LocaleString> fieldMap) {
        LocaleString name = fieldMap.get(node.getFieldAlias());
        if (name != null) {
            node.setName(name);
        }
        if (node.getChildren() != null) {
            for (FieldTreeNode child : node.getChildren()) {
                WarningCommonUtils.changeFieldTreeNodeName(child, fieldMap);
            }
        }
    }
}

