/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.validator.earlywarn.scene;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleValidateInfo;
import kd.bos.ext.hr.ruleengine.utils.RuleValidateUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.WarnSchemeService;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.WarningSceneService;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.calfield.WarnCalcFieldService;
import kd.hr.hrcs.common.constants.earlywarn.WarnSceneFieldConstants;
import kd.hr.hrcs.common.constants.earlywarn.WarningSceneConstants;
import kd.hr.hrcs.common.model.earlywarn.WarnCalFieldBo;
import kd.hr.hrcs.common.model.earlywarn.WarnQueryFieldBo;

@ExcludeFromJacocoGeneratedReport
public class WarnSceneValidator
extends AbstractValidator
implements WarnSceneFieldConstants,
WarningSceneConstants {
    private static final Log LOGGER = LogFactory.getLog(WarnSceneValidator.class);
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^[a-zA-Z0-9_]*$");

    public boolean isAddBillNoForContent() {
        return false;
    }

    public void validate() {
        try {
            String operation = this.getOperateKey();
            ExtendedDataEntity[] dataEntities = this.getDataEntities();
            if (HRStringUtils.equals((String)operation, (String)"save")) {
                RuleValidateInfo info;
                ExtendedDataEntity dataEntity = dataEntities[0];
                String dataFilter = dataEntity.getDataEntity().getString("datafilter");
                if (StringUtils.isNotEmpty((CharSequence)dataFilter) && !(info = RuleValidateUtil.validCondition((String)dataFilter, (boolean)true)).isSuccess()) {
                    for (String msg : info.getMsgList()) {
                        this.addErrorMessage(dataEntity, msg);
                    }
                }
                this.validateQueryFieldRefByScheme(dataEntity);
            } else if ("nextstep".equals(operation)) {
                this.checkMustInput();
                this.checkFormatError();
            } else if (HRStringUtils.equals((String)operation, (String)"delete")) {
                boolean single = dataEntities.length == 1;
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObjectCollection dynamicObjectCollection = new HRBaseServiceHelper("hrcs_warnscheme").queryOriginalCollection("name,warnscene", new QFilter[]{new QFilter("warnscene", "in", dataEntity.getDataEntity().getPkValue())});
                    if (dynamicObjectCollection.size() <= 0) continue;
                    if (single) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u8be5\u9884\u8b66\u573a\u666f\u5df2\u88ab\u9884\u8b66\u65b9\u6848%1$s\u5f15\u7528\u3002", (String)"WarnSceneValidator_5", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]), dynamicObjectCollection.stream().map(it -> "\u201c" + it.getString("name") + "\u201d").collect(Collectors.joining("\uff0c"))));
                        continue;
                    }
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5220\u9664\u5931\u8d25\uff0c\u8be5\u9884\u8b66\u573a\u666f\u5df2\u88ab\u9884\u8b66\u65b9\u6848%2$s\u5f15\u7528\u3002", (String)"WarnSceneValidator_4", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]), dataEntity.getDataEntity().getString("name"), dynamicObjectCollection.stream().map(it -> "\u201c" + it.getString("name") + "\u201d").collect(Collectors.joining("\uff0c"))));
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("WarnSceneValidator_validate_error:", (Throwable)exception);
        }
    }

    private void validateQueryFieldRefByScheme(ExtendedDataEntity sceneObjEntity) {
        Long sceneObjPkId = (Long)sceneObjEntity.getBillPkId();
        DynamicObject sceneDy = sceneObjEntity.getDataEntity();
        if (!sceneDy.getDataEntityState().getFromDatabase()) {
            return;
        }
        List queryFields = Lists.newArrayListWithExpectedSize((int)0);
        List<Object> calFields = Lists.newArrayListWithExpectedSize((int)0);
        String queryFieldsStr = this.getOption().getVariableValue("queryFields", "");
        String calFieldsStr = this.getOption().getVariableValue("calculateFields", "");
        HashSet fieldAliasSet = Sets.newHashSetWithExpectedSize((int)16);
        if (HRStringUtils.isNotEmpty((String)queryFieldsStr)) {
            queryFields = JSON.parseArray((String)queryFieldsStr, WarnQueryFieldBo.class);
        }
        if (HRStringUtils.isNotEmpty((String)calFieldsStr)) {
            calFields = JSON.parseArray((String)calFieldsStr, WarnCalFieldBo.class);
            calFields = calFields.stream().filter(WarnCalFieldBo::getSelected).collect(Collectors.toList());
        }
        fieldAliasSet.addAll(queryFields.stream().map(QueryFieldCommonBo::getFieldAlias).collect(Collectors.toSet()));
        fieldAliasSet.addAll(calFields.stream().map(WarnCalFieldBo::getFieldNumber).collect(Collectors.toSet()));
        DynamicObject[] refSchemeDys = WarnSchemeService.getSceneRefSchemeDys((Object)sceneObjPkId);
        HashSet refFieldAll = Sets.newHashSetWithExpectedSize((int)16);
        HashMap refFieldMap = Maps.newHashMapWithExpectedSize((int)16);
        if (refSchemeDys != null && refSchemeDys.length > 0) {
            DynamicObject[] schemeMsgConfDys = WarnSchemeService.getSchemeMsgConfDys((Object[])Arrays.stream(refSchemeDys).map(DataEntityBase::getPkValue).toArray());
            Map schemeIdToMsgConf = Arrays.stream(schemeMsgConfDys).collect(Collectors.toMap(dy -> dy.get("sourceid"), Function.identity(), (x, y) -> y));
            for (DynamicObject refSchemeDy : refSchemeDys) {
                DynamicObjectCollection detailEntry;
                HashSet refFields = Sets.newHashSetWithExpectedSize((int)16);
                refFields.addAll(WarnSchemeService.getSchemeDyBCRefFieldAlias((DynamicObject)refSchemeDy));
                DynamicObject msgConfig = (DynamicObject)schemeIdToMsgConf.get(refSchemeDy.getPkValue());
                if (msgConfig != null) {
                    refFields.addAll(WarnSchemeService.getMsgConfigRefFieldAlias((DynamicObject)msgConfig));
                }
                if ((detailEntry = refSchemeDy.getDynamicObjectCollection("rcrelationentryentity")) != null) {
                    refFields.addAll(detailEntry.stream().map(m -> m.getString("rcuser")).collect(Collectors.toSet()));
                }
                refFieldMap.put(refSchemeDy.getString("name"), refFields);
            }
        }
        for (Map.Entry entry : refFieldMap.entrySet()) {
            ((Set)entry.getValue()).removeAll(fieldAliasSet);
            refFieldAll.addAll((Collection)entry.getValue());
        }
        if (!refFieldAll.isEmpty()) {
            Set entityNames;
            DynamicObject[] dbQueryFields = WarningSceneService.getInstance().loadSceneQueryFieldsByFieldAlias((Object)sceneObjPkId, (Set)refFieldAll);
            Set entityNumbers = Arrays.stream(dbQueryFields).map(e -> e.getString("entitynumber")).collect(Collectors.toSet());
            HashSet entityNumberRemain = Sets.newHashSetWithExpectedSize((int)16);
            entityNumberRemain.addAll(entityNumbers);
            entityNumberRemain.removeAll(queryFields.stream().map(e -> e.getEntityNumber()).collect(Collectors.toSet()));
            HashSet refSchemeNames = Sets.newHashSetWithExpectedSize((int)16);
            for (Map.Entry entry : refFieldMap.entrySet()) {
                if (((Set)entry.getValue()).size() <= 0) continue;
                refSchemeNames.add(entry.getKey());
            }
            if (entityNumberRemain.size() > 0) {
                entityNames = entityNumbers.stream().map(e -> EntityMetadataCache.getDataEntityType((String)e).getDisplayName().getLocaleValue()).collect(Collectors.toSet());
                this.addErrorMessage(sceneObjEntity, MessageFormat.format(ResManager.loadKDString((String)"\u4fee\u6539\u5931\u8d25\uff0c\u9884\u8b66\u65b9\u6848{1}\u5f15\u7528\u4e86\u6b64\u9884\u8b66\u5bf9\u8c61\u5b57\u6bb5\u3002", (String)"WarnSceneValidator_1", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]), String.join((CharSequence)"\u201d\u3001\u201c", entityNames), String.join((CharSequence)"\u201d\u3001\u201c", refSchemeNames)));
                return;
            }
            if (entityNumbers == null || entityNumbers.size() == 0) {
                DynamicObject[] calculateFields = WarnCalcFieldService.getInstance().loadAllFieldCalFieldsBySourceId((Object)sceneObjPkId);
                Set calFieldNames = Arrays.stream(calculateFields).filter(e -> refFieldAll.contains(e.getString("number"))).map(e -> e.getString("name")).collect(Collectors.toSet());
                this.addErrorMessage(sceneObjEntity, MessageFormat.format(ResManager.loadKDString((String)"\u201c{0}\u201d\u8ba1\u7b97\u5b57\u6bb5\u5220\u9664\u5931\u8d25\uff0c\u8be5\u5b57\u6bb5\u5df2\u88ab\u9884\u8b66\u65b9\u6848\u201c{1}\u201d\u5f15\u7528\u3002", (String)"WarnSceneValidator_6", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]), String.join((CharSequence)"\u201d\u3001\u201c", calFieldNames), String.join((CharSequence)"\u201d\u3001\u201c", refSchemeNames)));
                return;
            }
            entityNames = entityNumbers.stream().map(e -> EntityMetadataCache.getDataEntityType((String)e).getDisplayName().getLocaleValue()).collect(Collectors.toSet());
            this.addErrorMessage(sceneObjEntity, MessageFormat.format(ResManager.loadKDString((String)"\u201c{0}\u201d\u4e1a\u52a1\u5bf9\u8c61\u4e2d\u7684\u201c{1}\u201d\u5b57\u6bb5\u53d6\u6d88\u9009\u4e2d\u5931\u8d25\uff0c\u5176\u5df2\u88ab\u9884\u8b66\u65b9\u6848\u201c{2}\u201d\u5f15\u7528\u3002", (String)"WarnSceneValidator_2", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]), String.join((CharSequence)"\u201d\u3001\u201c", entityNames), String.join((CharSequence)"\u201d\u3001\u201c", Arrays.stream(dbQueryFields).map(e -> e.getString("fieldname")).collect(Collectors.toList())), String.join((CharSequence)"\u201d\u3001\u201c", refSchemeNames)));
        }
    }

    private void checkMustInput() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            ILocaleString description;
            ILocaleString name;
            DynamicObject entity = dataEntity.getDataEntity();
            DynamicObjectType objectType = entity.getDynamicObjectType();
            ArrayList emptyPropertyNames = Lists.newArrayListWithExpectedSize((int)10);
            String number = entity.getString("number");
            ArrayList emptyProperties = Lists.newArrayListWithExpectedSize((int)3);
            if (HRStringUtils.isEmpty((String)number)) {
                emptyPropertyNames.add("\u201c" + objectType.getProperty("number").getDisplayName().getLocaleValue() + "\u201d");
                emptyProperties.add("number");
            }
            if ((name = entity.getLocaleString("name")) == null || name.isEmpty() || name.values().stream().allMatch(HRStringUtils::isEmpty)) {
                emptyPropertyNames.add("\u201c" + objectType.getProperty("name").getDisplayName().getLocaleValue() + "\u201d");
                emptyProperties.add("name");
            }
            if ((description = entity.getLocaleString("description")) == null || description.isEmpty() || description.values().stream().allMatch(HRStringUtils::isEmpty)) {
                emptyPropertyNames.add("\u201c" + objectType.getProperty("description").getDisplayName().getLocaleValue() + "\u201d");
                emptyProperties.add("description");
            }
            if (emptyPropertyNames.isEmpty()) continue;
            this.addErrorMessage(dataEntity, String.join((CharSequence)",", emptyProperties), MessageFormat.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199{0}\u3002", (String)"WarnSceneValidator_0", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", emptyPropertyNames)));
        }
    }

    private void checkFormatError() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject entity = dataEntity.getDataEntity();
            String number = entity.getString("number");
            if (!HRStringUtils.isNotEmpty((String)number) || NUMBER_PATTERN.matcher(number).matches()) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7f16\u7801\u4ec5\u652f\u6301\u82f1\u6587\u5927\u5c0f\u5199\u3001\u6570\u5b57\u4e0e\u4e0b\u5212\u7ebf\u3002", (String)"WarnSceneValidator_7", (String)"hrmp-hrcs-warn-opplugin", (Object[])new Object[0]));
        }
    }

    protected void addErrorMessage(ExtendedDataEntity dataEntity, String fieldKeys, String content) {
        Object pkId = dataEntity.getBillPkId();
        int dataIndex = dataEntity.getDataEntityIndex();
        ValidationErrorInfo info = new ValidationErrorInfo(fieldKeys, pkId, dataIndex, dataEntity.getRowIndex(), "MUST_INPUT_ERROR", this.getOperationName(), content, ErrorLevel.Error);
        info.setEntityKey(this.getEntityKey());
        info.setSubRowIndex(dataEntity.getSubRowIndex());
        info.setSubRowIndex(dataEntity.getSubRowIndex());
        info.setFieldKey(fieldKeys);
        this.validateResult.addErrorInfo((OperateErrorInfo)info);
        this.getFalseDataEntities().add(dataEntity);
    }
}

