/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.esign3rd.fadada.v51.client;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.exception.KDBizException;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hrcs.esign3rd.fadada.bean.base.BaseReq;
import kd.hr.hrcs.esign3rd.fadada.bean.base.BaseRes;
import kd.hr.hrcs.esign3rd.fadada.bean.base.BaseResponseEntity;
import kd.hr.hrcs.esign3rd.fadada.bean.base.HttpInfoRes;
import kd.hr.hrcs.esign3rd.fadada.config.HttpConfig;
import kd.hr.hrcs.esign3rd.fadada.enums.http.SignTypeEnum;
import kd.hr.hrcs.esign3rd.fadada.stratey.DefaultJsonStrategy;
import kd.hr.hrcs.esign3rd.fadada.stratey.JsonStrategy;
import kd.hr.hrcs.esign3rd.fadada.utils.crypt.FddCryptUtil;
import kd.hr.hrcs.esign3rd.fadada.utils.http.HttpUtil;
import kd.hr.hrcs.esign3rd.fadada.utils.json.ParameterizedTypeBaseRes;
import kd.hr.hrcs.esign3rd.fadada.utils.random.UUIDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiClient {
    private final Logger log = LoggerFactory.getLogger(OpenApiClient.class);
    private final String appId;
    private final String appSecret;
    private final String serverUrl;
    private String signType = SignTypeEnum.HMAC_SHA256.getType();
    private JsonStrategy jsonStrategy;
    private HttpConfig httpConfig;

    public OpenApiClient(String appId, String appSecret, String serverUrl) {
        this.appId = appId;
        this.appSecret = appSecret;
        this.serverUrl = serverUrl;
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public void setHttpConfig(HttpConfig httpConfig) {
        if (httpConfig != null) {
            HttpUtil.httpConfig = this.httpConfig = httpConfig;
        }
    }

    public String getSignType() {
        return this.signType;
    }

    public void setSignType(String signType) {
        if (signType != null) {
            this.signType = signType;
        }
    }

    public void setJsonStrategy(JsonStrategy jsonStrategy) {
        if (jsonStrategy != null) {
            this.jsonStrategy = jsonStrategy;
        }
    }

    public JsonStrategy getJsonStrategy() {
        if (this.jsonStrategy == null) {
            this.jsonStrategy = new DefaultJsonStrategy();
        }
        return this.jsonStrategy;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    <T> BaseRes<T> invokeApi(BaseReq req, String path, Class<T> clzz) throws KDBizException {
        return this.httpRequest(req, path, null, clzz);
    }

    <T> BaseRes<List<T>> invokeApiList(BaseReq req, String path, Class<T> clzz) throws KDBizException {
        return this.httpRequestList(req, path, clzz);
    }

    <T> BaseRes<T> invokeApi(BaseReq req, String path, Map<String, File> files, Class<T> clzz) throws KDBizException {
        return this.httpRequest(req, path, files, clzz);
    }

    BaseRes<BaseResponseEntity> invokeApiDownload(BaseReq req, String path) throws KDBizException {
        BaseRes res;
        String accessToken = req.getAccessToken();
        HashMap<String, String> bodyMap = this.getBodyMap(req);
        Map<String, String> headerMap = this.getSign(this.getHeaderMap(accessToken), bodyMap);
        String method = this.getMethod(path);
        path = path.replace(method, "").trim();
        String url = this.serverUrl + path;
        BaseResponseEntity baseResponseEntity = this.request(url, headerMap, bodyMap);
        if (baseResponseEntity.getData() != null) {
            res = this.getJsonStrategy().toJavaBean(baseResponseEntity.getData(), BaseRes.class);
        } else {
            res = new BaseRes();
            res.setData(baseResponseEntity);
        }
        res.setHttpStatusCode(baseResponseEntity.getHttpStatusCode());
        return res;
    }

    private <T> BaseRes<List<T>> httpRequestList(BaseReq req, String path, Class<T> clzz) throws KDBizException {
        HttpInfoRes httpInfoRes = this.httpRequest(req, path, null);
        if (httpInfoRes == null) {
            return null;
        }
        BaseRes baseRes = this.getJsonStrategy().toJavaBean(httpInfoRes.getBody(), BaseRes.class);
        baseRes.setHttpStatusCode(httpInfoRes.getHttpStatusCode());
        Object data = baseRes.getData();
        if (data != null) {
            String jsonStr = data instanceof String ? String.valueOf(data) : this.getJsonStrategy().toJson(data);
            List<T> lists = this.getJsonStrategy().toList(jsonStr, clzz);
            baseRes.setData(lists);
        }
        return baseRes;
    }

    private <T> BaseRes<T> httpRequest(BaseReq req, String path, Map<String, File> files, Class<T> clzz) throws KDBizException {
        HttpInfoRes httpInfoRes = this.httpRequest(req, path, files);
        if (httpInfoRes == null) {
            return null;
        }
        BaseRes baseRes = (BaseRes)this.getJsonStrategy().toJavaBean(httpInfoRes.getBody(), new ParameterizedTypeBaseRes(clzz));
        baseRes.setHttpStatusCode(httpInfoRes.getHttpStatusCode());
        return baseRes;
    }

    private HttpInfoRes httpRequest(BaseReq req, String path, Map<String, File> files) throws KDBizException {
        String accessToken = req == null ? null : req.getAccessToken();
        HashMap<String, String> bodyMap = this.getBodyMap(req);
        Map<String, String> headerMap = this.getSign(this.getHeaderMap(accessToken), bodyMap);
        String method = this.getMethod(path);
        path = path.replace(method, "").trim();
        String url = this.serverUrl + path;
        return this.request(url, method, headerMap, bodyMap, files);
    }

    private String getMethod(String path) {
        String method;
        if (path.startsWith("POST")) {
            method = "POST";
        } else if (path.startsWith("GET")) {
            method = "GET";
        } else {
            throw new KDBizException("path error");
        }
        return method;
    }

    private Map<String, String> getSign(Map<String, String> headerMap, Map<String, String> bodyMap) {
        try {
            HashMap<String, String> signMap = new HashMap<String, String>(headerMap);
            if (null != bodyMap) {
                signMap.putAll(bodyMap);
            }
            String sortParam = FddCryptUtil.sortParameters(signMap);
            String sign = FddCryptUtil.sign(sortParam, headerMap.get("X-FASC-Timestamp"), this.appSecret);
            headerMap.put("X-FASC-Sign", sign);
        }
        catch (Exception e) {
            this.log.error("\u8ba1\u7b97\u7b7e\u540d\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        return headerMap;
    }

    private HashMap<String, String> getHeaderMap(String accessToken) {
        HashMap<String, String> paraMap = new HashMap<String, String>(8);
        paraMap.put("X-FASC-App-Id", this.appId);
        paraMap.put("X-FASC-Api-SubVersion", "5.1");
        paraMap.put("X-FASC-Sign-Type", this.signType);
        if (accessToken != null) {
            paraMap.put("X-FASC-AccessToken", accessToken);
            paraMap.remove("bizContent");
        } else {
            paraMap.put("X-FASC-Grant-Type", "client_credential");
        }
        paraMap.put("X-FASC-Timestamp", String.valueOf(System.currentTimeMillis()));
        paraMap.put("X-FASC-Nonce", UUIDGenerator.getUuid());
        return paraMap;
    }

    private HashMap<String, String> getBodyMap(BaseReq req) throws KDBizException {
        if (req == null) {
            return new HashMap<String, String>(1);
        }
        req.setAccessToken(null);
        String bizContent = this.getJsonStrategy().toJson(req);
        HashMap<String, String> bodyMap = new HashMap<String, String>(1);
        bodyMap.put("bizContent", bizContent);
        return bodyMap;
    }

    private HttpInfoRes request(String url, String method, Map<String, String> headerMap, Map<String, String> bodyMap, Map<String, File> fileMap) throws KDBizException {
        this.log.info("Fadada HTTP request url:{}", (Object)url);
        this.log.info("Fadada HTTP request method:{}", (Object)method);
        this.log.info("Fadada HTTP request bodyMap:{} ", bodyMap);
        HttpInfoRes result = null;
        try {
            if ("GET".equals(method)) {
                result = HttpUtil.get(url, headerMap, bodyMap);
            } else if ("POST".equals(method)) {
                result = HttpUtil.post(url, headerMap, bodyMap, fileMap);
            }
        }
        catch (KDBizException apie) {
            this.log.info("Fadada HTTP request bodyMap:{}", bodyMap);
            throw apie;
        }
        catch (Exception e) {
            this.log.info("Fadada HTTP request bodyMap:{}", bodyMap);
            this.log.error("http\u8bf7\u6c42\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new KDBizException("http request error");
        }
        if (result != null && result.getHttpStatusCode() == 401 && result.getBody() != null && result.getBody().indexOf("100002") > -1) {
            HRAppCache.get((String)"hrcs").remove(this.getCacheKey());
        }
        return result;
    }

    private String getCacheKey() {
        return "fdd" + this.getAppId();
    }

    private BaseResponseEntity request(String url, Map<String, String> headerMap, Map<String, String> bodyMap) throws KDBizException {
        try {
            return HttpUtil.downLoadFiles(url, headerMap, bodyMap);
        }
        catch (Exception e) {
            this.log.error("httpDownLoad\u8bf7\u6c42\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new KDBizException("httpDownLoad request error");
        }
    }
}

