/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.common.constants.perm;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.IFormController;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class PermFormCommonUtil {
    private static final String IDPROPERTY_SUFFIX = ".id";
    private static final String EXCEPTION_MSG = "IDataModel can not be null";
    private static final Log logger = LogFactory.getLog(PermFormCommonUtil.class);

    public static String getEntityPropertyDisplayName(DynamicObjectType dynamicObjectType, String propertyName) {
        String[] propertyNameArray;
        LinkedBlockingDeque<String> displayNameStack = new LinkedBlockingDeque<String>();
        for (String subPropertyName : propertyNameArray = propertyName.split("\\s*[.]+\\s*")) {
            DynamicProperty subProperty = dynamicObjectType.getProperty(subPropertyName);
            LocaleString subPropertyLocaleDisplayName = subProperty.getDisplayName();
            String subPropertyDisplayName = subPropertyLocaleDisplayName == null ? "" : subPropertyLocaleDisplayName.toString();
            displayNameStack.offerLast(subPropertyDisplayName);
            if (!EntryProp.class.isInstance(subProperty)) continue;
            EntryProp entryProp = (EntryProp)EntryProp.class.cast(subProperty);
            EntryType entryType = (EntryType)entryProp.getItemType();
            dynamicObjectType = entryType;
        }
        Iterator displayNameIterator = displayNameStack.iterator();
        StringBuilder displayNameBuffer = new StringBuilder();
        while (displayNameIterator.hasNext()) {
            displayNameBuffer.append((String)displayNameIterator.next());
            if (!displayNameIterator.hasNext()) continue;
            displayNameBuffer.append(".");
        }
        return displayNameBuffer.toString();
    }

    public static void closeClientForm(IFormView fv) {
        IFormView mainview;
        FormShowParameter param = fv.getFormShowParameter();
        if (param.getOpenStyle().getShowType().equals((Object)ShowType.NewTabPage) && (mainview = fv.getMainView()) != null) {
            PermFormCommonUtil.doClose(fv, param, mainview);
        }
        HashMap<String, String> arg = new HashMap<String, String>();
        arg.put("pageId", fv.getPageId());
        ((IClientViewProxy)fv.getService(IClientViewProxy.class)).addAction("closeWindow", arg);
        IFormView parentView = fv.getParentView();
        if (parentView != null && fv.getFormShowParameter().getCloseCallBack() != null) {
            IFormController srv = (IFormController)parentView.getService(IFormController.class);
            srv.formClosedCallBack(fv);
            fv.sendFormAction(parentView);
        }
    }

    private static void doClose(IFormView fv, FormShowParameter param, IFormView mainview) {
        IFormView parentView = fv.getView(fv.getFormShowParameter().getParentPageId());
        if (param.getOpenStyle().getShowType() != ShowType.Modal) {
            Control control;
            Control control2 = control = parentView == null ? null : parentView.getControl("_submaintab_");
            if (control instanceof Tab) {
                param.getOpenStyle().setTargetKey("_submaintab_");
            } else if (control == null) {
                IPageCache pageCache = (IPageCache)mainview.getService(IPageCache.class);
                String submaintabCount = pageCache.get("_submaintab_count_");
                int count = submaintabCount == null ? 3 : Integer.parseInt(submaintabCount);
                pageCache.put("_submaintab_count_", Integer.toString(--count) + "");
            }
        }
    }

    public static Map<Long, String[]> getOrgInfo(List<Long> orgIds) {
        DynamicObject[] arrDObj;
        HashMap<Long, String[]> result = new HashMap<Long, String[]>(16);
        String selFields = "id" + "," + "number" + "," + "name";
        for (DynamicObject dObj : arrDObj = BusinessDataServiceHelper.load((String)"bos_org", (String)selFields, (QFilter[])new QFilter[]{new QFilter("id", "in", orgIds)})) {
            Long orgId = dObj.getLong("id");
            String orgNumber = dObj.getString("number");
            String orgName = dObj.getString("name");
            result.put(orgId, new String[]{orgNumber, orgName});
        }
        return result;
    }

    public static void setFilterGridAddBtnVisible(IFormView fv, String filterGridKey, boolean visible) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)fv.getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(filterGridKey, "setAddBtnStatus", new Object[]{!visible});
    }

    public static void setDataChanged(IDataModel dataModel, boolean includeEntry, boolean changed) {
        dataModel.setDataChanged(changed);
        dataModel.getDataEntity(includeEntry).getDataEntityState().setRemovedItems(Boolean.valueOf(changed));
    }

    public static Map<Long, String> getAllIndustryInfo() {
        HashMap<Long, String> industryMap = new HashMap<Long, String>(16);
        Map industries = BusinessDataServiceHelper.loadFromCache((String)"bos_devp_industry", (String)"id, name", (QFilter[])new QFilter[0]);
        for (Map.Entry entry : industries.entrySet()) {
            DynamicObject industry = (DynamicObject)entry.getValue();
            Long industryId = industry.getLong("id");
            String industryName = industry.getString("name");
            industryMap.put(industryId, industryName);
        }
        return industryMap;
    }

    public static String getRuntimeFormName(String formNum) {
        String name = "";
        try {
            String entityNum = FormMetadataCache.getFormConfig((String)formNum).getEntityTypeId();
            name = FormMetadataCache.getFormConfig((String)entityNum).getCaption().getLocaleValue();
        }
        catch (Exception e) {
            name = formNum;
        }
        return name;
    }

    public static Map<String, List<String>> getAllExtAppIds(List<String> originalAppIds) {
        StringBuilder sbAppIds = new StringBuilder();
        if (originalAppIds != null && !originalAppIds.isEmpty()) {
            for (int i = 0; i < originalAppIds.size(); ++i) {
                sbAppIds.append("'").append(originalAppIds.get(i)).append("'");
                if (i == originalAppIds.size() - 1) continue;
                sbAppIds.append(",");
            }
        } else {
            return null;
        }
        String appIds = sbAppIds.toString();
        StringBuilder sbSql = new StringBuilder("select fid, fmasterid from t_meta_bizapp where fmasterid in (").append(appIds).append(")").append(" and fid not in(").append(appIds).append(")");
        final HashMap<String, List<String>> result = new HashMap<String, List<String>>(16);
        DB.query((DBRoute)DBRoute.meta, (String)sbSql.toString(), null, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    String extAppId = rs.getString("fid");
                    String orignalAppId = rs.getString("fmasterid");
                    if (StringUtils.isEmpty((String)orignalAppId)) continue;
                    result.computeIfAbsent(orignalAppId, key -> new ArrayList()).add(extAppId);
                }
                return null;
            }
        });
        return result;
    }

    public static List<String> getAllExtAppId(String originalAppId) {
        StringBuilder sb = new StringBuilder("select fid from t_meta_bizapp where fmasterid = '").append(originalAppId).append("'").append(" and fid <> '").append(originalAppId).append("'");
        final ArrayList<String> result = new ArrayList<String>();
        DB.query((DBRoute)DBRoute.meta, (String)sb.toString(), null, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    result.add(rs.getString("fid"));
                }
                return null;
            }
        });
        return result;
    }

    public static Map<String, String> getExtAppAndOrgnlAppRel() {
        HashMap<String, String> map = new HashMap<String, String>();
        Map appInfoMap = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (String)"id, masterid", null);
        for (DynamicObject dObj : appInfoMap.values()) {
            String id = dObj.getString("id");
            String masterid = dObj.getString("masterid");
            if (StringUtils.isEmpty((String)masterid)) {
                map.put(id, id);
                continue;
            }
            map.put(id, masterid);
        }
        return map;
    }

    public static List<String> getAllExtAppId(List<String> appIds) {
        Map<String, List<String>> allExtAppIdMap = PermFormCommonUtil.getAllExtAppIds(appIds);
        ArrayList<String> finalFilterAppIds = new ArrayList<String>(appIds);
        if (allExtAppIdMap != null && !allExtAppIdMap.isEmpty()) {
            for (String appId : appIds) {
                List<String> extAppIds = allExtAppIdMap.get(appId);
                if (extAppIds == null || extAppIds.isEmpty()) continue;
                finalFilterAppIds.addAll(extAppIds);
            }
        }
        return finalFilterAppIds;
    }
}

