/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.common.constants.perm;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.entity.tree.TreeNode;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.util.StringUtils;
import kd.hr.hrcs.common.constants.perm.PermTreeLevel;

public class PermTreeUtil {
    public static final int RECURSIVE_MAXLEVEL = PermTreeLevel.FIFTH.getIntLevel() + 1;
    public static final String ID_ROOTNODE = "root#FIRST";
    public static final String NODESUFFIX_FIRST = "#" + (Object)((Object)PermTreeLevel.FIRST);
    public static final String NODESUFFIX_CLOUD = "#cloud";
    public static final String NODESUFFIX_APP = "#app";
    public static final String NODESUFFIX_ENTITY = "#entity";
    public static final String NODESUFFIX_PERMITEM = "#permItem";

    public static void trimSubNode(TreeNode allNode, int delLevel) {
        PermTreeLevel level = PermTreeLevel.findPermTreeLevel(delLevel);
        allNode.iterate(delLevel, node -> {
            if (node.getId().contains("#" + (Object)((Object)level))) {
                node.setChildren(new ArrayList());
            }
        });
    }

    public static TreeNode copyNewTreeNode(TreeNode oldTree) {
        boolean isParent = oldTree.getChildren() != null;
        TreeNode newTree = new TreeNode(oldTree.getParentid(), oldTree.getId(), oldTree.getText(), isParent, oldTree.getData());
        if (isParent) {
            List oldChildList = oldTree.getChildren();
            ArrayList<TreeNode> newChildList = new ArrayList<TreeNode>(16);
            for (int i = 0; i < oldChildList.size(); ++i) {
                TreeNode newChildNode = PermTreeUtil.copyNewTreeNode((TreeNode)oldChildList.get(i));
                newChildList.add(newChildNode);
            }
            newTree.setChildren(newChildList);
        } else {
            newTree.setChildren(null);
        }
        return newTree;
    }

    public static int getTreeNodeLevel(String treeNodeId) {
        String suffix = treeNodeId.substring(treeNodeId.indexOf(35));
        int level = -1;
        if (suffix.equals(NODESUFFIX_FIRST)) {
            level = 0;
        } else if (suffix.equals(NODESUFFIX_CLOUD)) {
            level = 1;
        } else if (suffix.equals(NODESUFFIX_APP)) {
            level = 2;
        } else if (suffix.equals(NODESUFFIX_ENTITY)) {
            level = 3;
        } else if (suffix.equals(NODESUFFIX_PERMITEM)) {
            level = 4;
        }
        return level;
    }

    public static List<AppMenuElement> getSortedMenuList(String appId) {
        List listMenuNode = BizAppServiceHelp.getAllAppMenusByAppID((String)appId);
        Collections.sort(listMenuNode, new Comparator<AppMenuElement>(){

            @Override
            public int compare(AppMenuElement ame1, AppMenuElement ame2) {
                return ame1.getSeq() - ame2.getSeq();
            }
        });
        ArrayList<AppMenuElement> allLevelOneMenu = new ArrayList<AppMenuElement>(16);
        Iterator iterator = listMenuNode.iterator();
        while (iterator.hasNext()) {
            AppMenuElement appMenuElement = (AppMenuElement)iterator.next();
            String parentId = appMenuElement.getParentId();
            if (!StringUtils.isEmpty((String)parentId) && !appId.equals(parentId)) continue;
            allLevelOneMenu.add(appMenuElement);
            iterator.remove();
        }
        ArrayList newListMenuNode = Lists.newArrayListWithExpectedSize((int)16);
        for (int i = 0; i < allLevelOneMenu.size(); ++i) {
            AppMenuElement levelOneMenu = (AppMenuElement)allLevelOneMenu.get(i);
            String curMenuId = levelOneMenu.getId();
            newListMenuNode.add(levelOneMenu);
            Iterator iterator2 = listMenuNode.iterator();
            while (iterator2.hasNext()) {
                AppMenuElement levelTwoMenu = (AppMenuElement)iterator2.next();
                String parentId = levelTwoMenu.getParentId();
                if (!curMenuId.equals(parentId)) continue;
                newListMenuNode.add(levelTwoMenu);
                iterator2.remove();
            }
        }
        listMenuNode = newListMenuNode;
        return listMenuNode;
    }
}

