/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.common.util;

import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.config.ORMConfig;
import kd.bos.orm.query.MultiBaseDataFilterValue;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QFilterUtil;
import kd.bos.orm.query.QParameter;
import kd.bos.orm.query.hugein.HugeInConfig;
import kd.bos.util.ThreadLocals;
import kd.bos.xdb.util.DateUtil;
import org.apache.commons.collections4.CollectionUtils;

public class LoggerStrUtil {
    private static final Log LOGGER = LogFactory.getLog(QFilterUtil.class);
    private static int maxPrintSize = 50;
    private static final ThreadLocal<SimpleDateFormat> thSDF = ThreadLocals.create(() -> DateUtil.getDateFormat((String)"yyyy-MM-dd HH:mm:ss"));

    public static <V> String collectionToStr(Collection<V> coll) {
        if (CollectionUtils.isEmpty(coll)) {
            return "[]";
        }
        try {
            if (coll.size() <= maxPrintSize) {
                return coll.toString();
            }
            StringBuilder sb = new StringBuilder();
            sb.append("[(size:").append(coll.size()).append("),");
            Iterator<V> iter = coll.iterator();
            for (int idx = 0; iter.hasNext() && idx < maxPrintSize; ++idx) {
                V value = iter.next();
                sb.append(value.toString()).append(", ");
            }
            sb.append("...]");
            return sb.toString();
        }
        catch (Exception ex) {
            LOGGER.error("collectionToStr error.", (Throwable)ex);
            return coll.toString();
        }
    }

    public static <K> String mapToString(Map<K, QFilter> qfilterMap) {
        Iterator<Map.Entry<K, QFilter>> i = qfilterMap.entrySet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            Map.Entry<K, QFilter> e = i.next();
            K key = e.getKey();
            QFilter value = e.getValue();
            sb.append((Object)(key == qfilterMap ? "(this Map)" : key));
            sb.append('=');
            sb.append(value == qfilterMap ? "(this Map)" : LoggerStrUtil.qFilterToString(value));
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }

    public static String qFilterToString(QFilter qFilter) {
        if (qFilter == null) {
            return "null";
        }
        try {
            Function<Object, String> param2StringFnc = LoggerStrUtil::parametertoString;
            StringBuilder s = new StringBuilder(128);
            if (qFilter.isJoinSQLFilter()) {
                s.append(qFilter.getProperty());
            } else {
                s.append(qFilter.getProperty()).append(' ').append(qFilter.getCP());
                if (qFilter.isExpressValue()) {
                    s.append(String.valueOf(qFilter.getOriginValue()));
                } else {
                    String lcp = qFilter.getCP();
                    if (lcp.equalsIgnoreCase("in") || lcp.equalsIgnoreCase("not in")) {
                        s.append(" (").append(param2StringFnc.apply(qFilter.getOriginValue())).append(')');
                    } else {
                        s.append(' ').append(param2StringFnc.apply(qFilter.getOriginValue()));
                    }
                }
            }
            if (!qFilter.getNests(false).isEmpty()) {
                LoggerStrUtil.resloveNests(qFilter, s, nest -> {
                    s.append(' ').append(nest.getOp()).append(' ').append(nest.getFilter().__toStringWithParamEncode(param2StringFnc));
                    return null;
                });
            }
            return s.toString();
        }
        catch (Exception ex) {
            LOGGER.error("QFilter toString error.", (Throwable)ex);
            return qFilter.toString();
        }
    }

    private static void resloveNests(QFilter qFilter, StringBuilder s, Function<QFilter.QFilterNest, Void> nestFun) {
        boolean withOr = false;
        boolean allOr = true;
        List nests = qFilter.getNests(false);
        for (QFilter.QFilterNest nest : nests) {
            if (nest.isAnd()) {
                allOr = false;
                continue;
            }
            withOr = true;
        }
        if (withOr) {
            s.insert(0, '(');
        }
        if (allOr) {
            for (QFilter.QFilterNest nest : nests) {
                nestFun.apply(nest);
            }
        } else {
            boolean preIsAnd = true;
            for (QFilter.QFilterNest nest : nests) {
                boolean and = nest.isAnd();
                if (!preIsAnd && and) {
                    s.insert(0, '(');
                    s.append(')');
                }
                nestFun.apply(nest);
                preIsAnd = and;
            }
        }
        if (withOr) {
            s.append(')');
        }
    }

    private static String parametertoString(Object value) {
        QParameter p = LoggerStrUtil.getInQParameter(value);
        if (p == null) {
            return "";
        }
        Object[] params = p.getParameters();
        StringBuilder s = new StringBuilder(params.length * 10);
        if (params.length > 10) {
            s.append("[size:").append(params.length).append("]");
        }
        int printSize = Math.min(maxPrintSize, params.length);
        for (int idx = 0; idx < printSize; ++idx) {
            Object param = params[idx];
            if (s.length() > 0) {
                s.append(',');
            }
            if (param == null) {
                s.append("''");
                continue;
            }
            Class<?> cls = param.getClass();
            if (QFilterUtil.isNumber(cls) || cls == Boolean.class) {
                s.append(param);
                continue;
            }
            if (Date.class.isAssignableFrom(cls)) {
                s.append('\'').append(thSDF.get().format((Date)param)).append('\'');
                continue;
            }
            if (cls.isArray()) {
                int n = Array.getLength(param);
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        s.append(',');
                    }
                    s.append(LoggerStrUtil.parametertoString(Array.get(param, i)));
                }
                continue;
            }
            if (value instanceof MultiBaseDataFilterValue) {
                MultiBaseDataFilterValue multi = (MultiBaseDataFilterValue)value;
                s.append("{\"baseDataName\":\"").append(multi.getBaseDataName()).append("\",\"joinProperty\":\"").append(multi.getJoinProperty()).append("\",\"value\":\"").append(multi.getValue()).append("\"}");
                continue;
            }
            s.append('\'').append(LoggerStrUtil.toSqlValueString(param)).append('\'');
        }
        if (params.length > maxPrintSize) {
            s.append("...");
        }
        return s.toString();
    }

    private static String toSqlValueString(Object value) {
        String v = String.valueOf(value);
        return v.replaceAll("'", "''");
    }

    private static QParameter getInQParameter(Object value) {
        if (value == null) {
            return null;
        }
        Object[] params = LoggerStrUtil.getWithoutDuplicateInValues(value);
        int c = params.length;
        if (c > 0) {
            String sql = LoggerStrUtil.multiParamsSQL(c);
            return new QParameter(sql, params);
        }
        return null;
    }

    private static Object[] getWithoutDuplicateInValues(Object values) {
        if (values == null) {
            return null;
        }
        long startTime = System.currentTimeMillis();
        Object[] params = null;
        if (values.getClass().isArray()) {
            int c = Array.getLength(values);
            HashSet<Object> set = new HashSet<Object>(c);
            for (int i = 0; i < c; ++i) {
                set.add(Array.get(values, i));
            }
            c = set.size();
            HugeInConfig.limitInSize((int)c);
            params = set.toArray(new Object[c]);
        } else if (values instanceof Set) {
            params = ((Set)values).toArray(new Object[((Set)values).size()]);
        } else if (values instanceof Collection) {
            HashSet set = new HashSet((Collection)values);
            int c = set.size();
            HugeInConfig.limitInSize((int)c);
            params = set.toArray(new Object[c]);
        } else if (values instanceof Iterable) {
            HashSet set = new HashSet(16);
            for (Object item : (Iterable)values) {
                set.add(item);
            }
            int c = set.size();
            HugeInConfig.limitInSize((int)c);
            params = set.toArray(new Object[c]);
        } else {
            Object originValue;
            params = values instanceof MultiBaseDataFilterValue ? ((originValue = ((MultiBaseDataFilterValue)values).getValue()) instanceof Collection ? ((Collection)originValue).toArray() : new Object[]{originValue}) : new Object[]{values};
        }
        if (ORMConfig.LOG_RECORD.getBoolean()) {
            LOGGER.info("getWithoutDuplicateInValues cost : [" + (System.currentTimeMillis() - startTime) + "]ms");
        }
        return params;
    }

    private static String multiParamsSQL(int c) {
        StringBuilder s = new StringBuilder(c * 2);
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                s.append(',');
            }
            s.append('?');
        }
        return s.toString();
    }
}

