/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.common.utils;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import kd.bos.orm.util.CollectionUtils;

public class CodeCheckUtils {
    public static Optional<String> getImportCodeByClassType(String classType) {
        if ("Date".equals(classType) || "Date[]".equals(classType)) {
            return Optional.of("import java.util.Date;\n");
        }
        if ("BigDecimal".equals(classType) || "BigDecimal[]".equals(classType)) {
            return Optional.of("import java.math.BigDecimal;\n");
        }
        return Optional.empty();
    }

    public static List<String> checkJavaFunctionCode(String functionCode, Set<String> importCodes) {
        StringBuilder codes = new StringBuilder();
        if (!CollectionUtils.isEmpty(importCodes)) {
            for (String importCode : importCodes) {
                codes.append(importCode);
            }
        }
        String classCode = "class checkCode {\n" + functionCode + "}";
        codes.append(classCode);
        ArrayList<String> errorMsg = new ArrayList<String>();
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector collector = new DiagnosticCollector();
        StandardJavaFileManager javaFileManager = compiler.getStandardFileManager(collector, null, null);
        ArrayList<String> options = new ArrayList<String>();
        options.add("-target");
        options.add("8");
        MyJavaFileObject javaFileObject = new MyJavaFileObject("checkCode", codes.toString());
        compiler.getTask(null, javaFileManager, collector, options, null, Collections.singletonList(javaFileObject)).call();
        collector.getDiagnostics().forEach(item -> errorMsg.add(item.toString()));
        return errorMsg;
    }

    private static class MyJavaFileObject
    extends SimpleJavaFileObject {
        private String source;

        MyJavaFileObject(String name, String source) {
            super(URI.create(name), JavaFileObject.Kind.SOURCE);
            this.source = source;
        }

        public MyJavaFileObject(String name, JavaFileObject.Kind kind) {
            super(URI.create(name), kind);
            this.source = null;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            return this.source;
        }
    }
}

