/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.domain.service.earlywarn;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.model.complexobj.labelandreport.JoinConditionBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.JoinEntityCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.common.constants.earlywarn.WarnObjTplConstants;
import kd.hr.hrcs.common.model.earlywarn.WarnCalFieldBo;
import kd.hr.hrcs.common.model.earlywarn.WarnEntityRelationBo;
import kd.hr.hrcs.common.model.earlywarn.WarnJoinEntityBo;
import kd.hr.hrcs.common.model.earlywarn.WarnObjTplBo;
import kd.hr.hrcs.common.model.earlywarn.WarnQueryFieldBo;

@ExcludeFromJacocoGeneratedReport
public class WarnObjTplService
implements WarnObjTplConstants {
    private static final Log LOG = LogFactory.getLog(WarnObjTplService.class);
    private static volatile WarnObjTplService service = null;
    private final HRBaseServiceHelper warnObjTplHelper = new HRBaseServiceHelper("hrcs_warnobjtpl");
    private final HRBaseServiceHelper joinEntityHelper = new HRBaseServiceHelper("hrcs_warnscenejoinentity");
    private final HRBaseServiceHelper queryFieldHelper = new HRBaseServiceHelper("hrcs_warnscenequeryfield");
    private final HRBaseServiceHelper entityRelationHelper = new HRBaseServiceHelper("hrcs_warnsceneentityrel");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WarnObjTplService getInstance() {
        if (service != null) return service;
        Class<WarnObjTplService> clazz = WarnObjTplService.class;
        synchronized (WarnObjTplService.class) {
            if (service != null) return service;
            service = new WarnObjTplService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public DynamicObject loadSingle(Object pk) {
        return this.warnObjTplHelper.loadSingle(pk);
    }

    public List<WarnObjTplBo> queryFields(String enable) {
        QFilter[] qFilters = new QFilter[]{new QFilter("enable", "=", (Object)enable)};
        DynamicObjectCollection dyColl = this.warnObjTplHelper.queryOriginalCollection("id,name", qFilters, "name");
        ArrayList warnObjTplBoList = Lists.newArrayListWithExpectedSize((int)dyColl.size());
        for (DynamicObject dynamicObject : dyColl) {
            WarnObjTplBo warnObjTplBo = new WarnObjTplBo();
            warnObjTplBo.setId(dynamicObject.getString("id"));
            warnObjTplBo.setName(dynamicObject.getString("name"));
            warnObjTplBoList.add(warnObjTplBo);
        }
        return warnObjTplBoList;
    }

    public String getCloudNmuByAppNum(String appNum) {
        String appId = (String)DispatchServiceHelper.invokeBOSService((String)"bos", (String)"BizAppService", (String)"getAppIdByAppNumber", (Object[])new Object[]{appNum});
        DynamicObject dynamicObject = (DynamicObject)DispatchServiceHelper.invokeBOSService((String)"bos", (String)"BizCloudService", (String)"getBizCloudByAppID", (Object[])new Object[]{appId});
        if (Objects.nonNull(dynamicObject)) {
            return dynamicObject.getString("number").toLowerCase(Locale.ROOT);
        }
        return "";
    }

    public DynamicObject[] loadJoinEntities(Long sourceId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("sourceid", "=", (Object)sourceId)};
        return this.joinEntityHelper.loadDynamicObjectArray(qFilters);
    }

    public DynamicObject[] loadEntityRelations(Long sourceId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("sourceid", "=", (Object)sourceId)};
        return this.entityRelationHelper.loadDynamicObjectArray(qFilters);
    }

    public DynamicObject[] loadQueryFieldsByFieldAlias(Long sourceId, Set<String> fieldAliasSet) {
        QFilter[] qFilters = new QFilter[]{new QFilter("sourceid", "=", (Object)sourceId), new QFilter("fieldalias", "in", fieldAliasSet)};
        return this.queryFieldHelper.loadDynamicObjectArray(qFilters);
    }

    public DynamicObject[] loadQueryFields(Long sourceId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("sourceid", "=", (Object)sourceId)};
        return this.queryFieldHelper.loadDynamicObjectArray(qFilters);
    }

    public List<WarnJoinEntityBo> queryAndAssembleJoinEntities(Long sourceId) {
        DynamicObject[] joinEntityCol = this.loadJoinEntities(sourceId);
        ArrayList joinEntities = Lists.newArrayListWithCapacity((int)joinEntityCol.length);
        Set entityNums = Arrays.stream(joinEntityCol).map(dy -> dy.getString("entitynumber")).collect(Collectors.toSet());
        HRBaseServiceHelper entityHelper = new HRBaseServiceHelper("bos_entityobject");
        DynamicObjectCollection entityDys = entityHelper.queryOriginalCollection("number, name", new QFilter[]{new QFilter("number", "in", entityNums)});
        Map<String, String> entityNumMap = entityDys.stream().collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy.getString("name")));
        for (DynamicObject joinEntityDy : joinEntityCol) {
            WarnJoinEntityBo joinEntity = new WarnJoinEntityBo();
            joinEntity.setId(joinEntityDy.getString("id"));
            joinEntity.setSource(joinEntityDy.getString("source"));
            joinEntity.setSourceId(joinEntityDy.getString("sourceid"));
            String type = joinEntityDy.getString("type");
            String longNumber = joinEntityDy.getString("longnumber");
            if (HRStringUtils.isEmpty((String)longNumber)) {
                if (HRStringUtils.equals((String)type, (String)"main")) {
                    joinEntity.setLongNumber("0");
                } else {
                    int index = joinEntityDy.getInt("index");
                    joinEntity.setLongNumber("0!" + index);
                }
            } else {
                joinEntity.setLongNumber(joinEntityDy.getString("longnumber"));
            }
            longNumber = joinEntity.getLongNumber();
            if (longNumber.contains("!")) {
                joinEntity.setParentLongNumber(longNumber.substring(0, longNumber.lastIndexOf("!")));
            } else {
                joinEntity.setParentLongNumber(null);
            }
            if (HRStringUtils.equals((String)longNumber, (String)"0")) {
                joinEntity.setLevel(Integer.valueOf(0));
            } else {
                String[] longNumberSp = longNumber.split("!");
                joinEntity.setLevel(Integer.valueOf(longNumberSp.length - 1));
            }
            joinEntity.setEntityNumber(joinEntityDy.getString("entitynumber"));
            joinEntity.setEntityAlias(joinEntityDy.getString("entityalias"));
            joinEntity.setType(joinEntityDy.getString("type"));
            joinEntity.setCore(joinEntityDy.getBoolean("iscore"));
            String entityName = entityNumMap.get(joinEntity.getEntityNumber());
            String[] split = joinEntity.getEntityAlias().split("\u03b4");
            if (split.length > 1) {
                joinEntity.setDisplayName(entityName + split[1]);
            } else {
                joinEntity.setDisplayName(entityName);
            }
            joinEntities.add(joinEntity);
        }
        return joinEntities.stream().sorted(Comparator.comparing(JoinEntityCommonBo::getLongNumber)).collect(Collectors.toList());
    }

    public List<WarnEntityRelationBo> queryAndAssembleEntityRelations(Long sourceId) {
        DynamicObject[] entityRelationCol = this.loadEntityRelations(sourceId);
        ArrayList entityRelations = Lists.newArrayListWithCapacity((int)entityRelationCol.length);
        for (DynamicObject entityRelationDy : entityRelationCol) {
            WarnEntityRelationBo entityRelation = new WarnEntityRelationBo();
            DynamicObject entityDy = entityRelationDy.getDynamicObject("entityid");
            DynamicObject joinEntityDy = entityRelationDy.getDynamicObject("joinentityid");
            entityRelation.setId(entityRelationDy.getString("id"));
            entityRelation.setSource(entityRelationDy.getString("source"));
            entityRelation.setSourceId(entityRelationDy.getString("sourceid"));
            entityRelation.setEntityId(entityDy.getString("id"));
            entityRelation.setEntityNumber(entityDy.getString("entitynumber"));
            entityRelation.setEntityAlias(entityDy.getString("entityalias"));
            entityRelation.setJoinType(entityRelationDy.getString("jointype"));
            entityRelation.setJoinEntityId(joinEntityDy.getString("id"));
            entityRelation.setJoinEntityNumber(joinEntityDy.getString("entitynumber"));
            entityRelation.setJoinEntityAlias(joinEntityDy.getString("entityalias"));
            DynamicObjectCollection joinConditionCol = entityRelationDy.getDynamicObjectCollection("joinconditions");
            ArrayList joinConditions = Lists.newArrayListWithCapacity((int)joinConditionCol.size());
            for (DynamicObject joinConditionDy : joinConditionCol) {
                JoinConditionBo joinCondition = new JoinConditionBo();
                joinCondition.setId(joinConditionDy.getString("id"));
                joinCondition.setLeftProp(joinConditionDy.getString("leftprop"));
                joinCondition.setCompareType(joinConditionDy.getString("comparetype"));
                String rightPropType = joinConditionDy.getString("rightproptype");
                joinCondition.setRightPropType(rightPropType);
                if (HRStringUtils.equals((String)rightPropType, (String)"field")) {
                    joinCondition.setRightProp(joinConditionDy.getString("rightprop"));
                } else {
                    joinCondition.setRightPropVal(joinConditionDy.getString("rightpropval"));
                }
                joinCondition.setLogicType(joinConditionDy.getString("logictype"));
                joinConditions.add(joinCondition);
            }
            entityRelation.setConditions((List)joinConditions);
            entityRelations.add(entityRelation);
        }
        return entityRelations;
    }

    public List<WarnQueryFieldBo> queryAndAssembleQueryFieldsByFieldAlias(Long warnObjTplId, Set<String> fieldAliasSet) {
        DynamicObject[] queryFieldCol = this.loadQueryFieldsByFieldAlias(warnObjTplId, fieldAliasSet);
        return this.assembleQueryFields(queryFieldCol);
    }

    public List<WarnQueryFieldBo> queryAndAssembleQueryFields(Long sourceId) {
        DynamicObject[] queryFieldCol = this.loadQueryFields(sourceId);
        return this.assembleQueryFields(queryFieldCol);
    }

    private List<WarnQueryFieldBo> assembleQueryFields(DynamicObject[] queryFieldCol) {
        ArrayList queryFields = Lists.newArrayListWithCapacity((int)queryFieldCol.length);
        MainEntityTypeUtil entityTypeUtil = new MainEntityTypeUtil();
        HRBaseServiceHelper entityHelper = new HRBaseServiceHelper("bos_entityobject");
        Set entityNums = Arrays.stream(queryFieldCol).map(dy -> dy.getString("entitynumber")).collect(Collectors.toSet());
        DynamicObjectCollection entityDys = entityHelper.queryOriginalCollection("number, name", new QFilter[]{new QFilter("number", "in", entityNums)});
        Map<String, String> entityNumMap = entityDys.stream().collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy.getString("name")));
        for (DynamicObject queryFieldDy : queryFieldCol) {
            Map baseDataNumAndPkType;
            WarnQueryFieldBo queryField = new WarnQueryFieldBo();
            queryField.setId(queryFieldDy.getString("id"));
            queryField.setSource(queryFieldDy.getString("source"));
            queryField.setSourceId(queryFieldDy.getString("sourceid"));
            queryField.setChangeShowName(false);
            String entityNumber = queryFieldDy.getString("entitynumber");
            queryField.setEntityNumber(entityNumber);
            String fieldAlias = queryFieldDy.getString("fieldalias");
            if (!queryField.isVirtualEntityField()) {
                String nameSuffix = "";
                if (fieldAlias.contains("\u03b4")) {
                    nameSuffix = fieldAlias.substring(fieldAlias.indexOf(948), fieldAlias.indexOf(46));
                }
                String entityName = entityNumMap.get(entityNumber);
                entityName = entityName + nameSuffix;
                queryField.setEntityName(entityName);
            }
            OrmLocaleValue fieldName = (OrmLocaleValue)queryFieldDy.getLocaleString("fieldname");
            queryField.setFieldName(AnalyseObjectUtil.getLocaleString((OrmLocaleValue)fieldName));
            queryField.setFieldAlias(fieldAlias);
            queryField.setFieldPath(queryFieldDy.getString("fieldpath"));
            String complexType = queryFieldDy.getString("complextype");
            queryField.setComplexType(complexType);
            if (queryField.isVirtualEntityField()) {
                queryField.setFieldNumber(queryField.getFieldAlias());
                if (AnalyseObjectUtil.isBaseDataType((String)complexType)) {
                    baseDataNumAndPkType = AnalyseObjectUtil.parseFieldAliasGetBaseDataNumAndPkType((String)queryField.getFieldPath().split("\\.")[0], (String)queryField.getFieldPath(), (MainEntityTypeUtil)entityTypeUtil);
                    queryField.setBaseDataNum((String)baseDataNumAndPkType.get("baseDataNum"));
                    queryField.setBaseDataIdType((String)baseDataNumAndPkType.get("pkType"));
                } else {
                    queryField.setBaseDataNum(queryField.getFieldPath().split("\\.")[0]);
                }
            } else {
                queryField.setFieldNumber(this.getFieldShortNumber(entityNumber, fieldAlias, complexType));
                if (AnalyseObjectUtil.isBaseDataType((String)complexType)) {
                    baseDataNumAndPkType = AnalyseObjectUtil.parseFieldAliasGetBaseDataNumAndPkType((String)entityNumber, (String)fieldAlias, (MainEntityTypeUtil)entityTypeUtil);
                    queryField.setBaseDataNum((String)baseDataNumAndPkType.get("baseDataNum"));
                    queryField.setBaseDataIdType((String)baseDataNumAndPkType.get("pkType"));
                }
            }
            queryField.setValueType(queryFieldDy.getString("valuetype"));
            queryField.setControlType(queryFieldDy.getString("controltype"));
            queryField.setSelectedField(Boolean.TRUE);
            queryFields.add(queryField);
        }
        return queryFields;
    }

    private String getFieldShortNumber(String entityNumber, String fieldAlias, String fieldComplexType) {
        if (AnalyseObjectUtil.isBaseDataType((String)fieldComplexType) && fieldAlias.contains(".")) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            String[] aliasArr = fieldAlias.split("\\.");
            if (aliasArr.length > 2) {
                String parentFieldName = aliasArr[aliasArr.length - 3];
                IDataEntityProperty parentProp = (IDataEntityProperty)dataEntityType.getAllFields().get(parentFieldName);
                if (parentProp instanceof BasedataProp) {
                    return aliasArr[aliasArr.length - 3] + "." + aliasArr[aliasArr.length - 2] + "." + aliasArr[aliasArr.length - 1];
                }
            }
            return aliasArr[aliasArr.length - 2] + "." + aliasArr[aliasArr.length - 1];
        }
        return fieldAlias.substring(fieldAlias.lastIndexOf(46) + 1);
    }

    public void removeRefByFieldAliasCache(Long warnObjTplId) {
        if (warnObjTplId != null && warnObjTplId != 0L) {
            IAppCache appCache = AppCache.get((String)"hrcs");
            appCache.remove("WarnObjTplFieldRefBy#" + warnObjTplId);
        }
    }

    public Set<String> getRefByFieldAliasCollection(Long warnObjTplId) {
        Set refFields = Sets.newHashSetWithExpectedSize((int)16);
        if (warnObjTplId == null || warnObjTplId == 0L) {
            return refFields;
        }
        IAppCache appCache = AppCache.get((String)"hrcs");
        refFields = (Set)appCache.get("WarnObjTplFieldRefBy#" + warnObjTplId, Set.class);
        if (refFields != null) {
            return refFields;
        }
        Set<String> refByFieldAliasList = this.getRefByFieldAliasList(warnObjTplId);
        appCache.put("WarnObjTplFieldRefBy#" + warnObjTplId, refByFieldAliasList);
        return refByFieldAliasList;
    }

    public Set<String> getRefByFieldAliasList(Long warnObjTplId) {
        HashSet aliasSet = Sets.newHashSetWithExpectedSize((int)16);
        return aliasSet;
    }

    public boolean isWarnObjRefByScene(Long warnObjTplId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_warnscene");
        return helper.isExists(new QFilter("warnobjtpl", "=", (Object)warnObjTplId));
    }

    public String getNextTab(Tab tab) {
        String currentTab = tab.getCurrentTab();
        List items = tab.getItems();
        String nextTab = null;
        boolean foundCurrent = false;
        for (Control item : items) {
            if (foundCurrent) {
                nextTab = item.getKey();
                break;
            }
            if (!HRStringUtils.equals((String)currentTab, (String)item.getKey())) continue;
            foundCurrent = true;
        }
        return nextTab;
    }

    public List<WarnQueryFieldBo> getCacheQueryFields(IFormView formView, boolean removeIdFields) {
        String queryFieldsStr = formView.getPageCache().get("queryFields");
        List queryFields = Collections.emptyList();
        if (HRStringUtils.isNotEmpty((String)queryFieldsStr)) {
            queryFields = JSON.parseArray((String)queryFieldsStr, WarnQueryFieldBo.class);
            if (removeIdFields) {
                queryFields.removeIf(field -> field.getFieldPath().endsWith(".id"));
            }
        }
        return queryFields;
    }

    public List<WarnCalFieldBo> getCacheCalculateFields(IFormView formView, boolean removeUnSelected) {
        String calculateFieldsStr = formView.getPageCache().get("calculateFields");
        List calculateFields = Collections.emptyList();
        if (HRStringUtils.isNotEmpty((String)calculateFieldsStr)) {
            calculateFields = JSON.parseArray((String)calculateFieldsStr, WarnCalFieldBo.class);
            if (removeUnSelected) {
                calculateFields.removeIf(field -> field.getSelected() == false);
            }
        }
        return calculateFields;
    }

    public void setQueryFieldEnumComboItems(List<WarnQueryFieldBo> queryFieldBos) {
        Map<String, String> entityFieldMap = this.entityFieldMap(queryFieldBos);
        for (WarnQueryFieldBo queryFieldBo : queryFieldBos) {
            if (queryFieldBo.isBaseDataId() || this.isIndex(queryFieldBo.getValueType())) continue;
            String key = queryFieldBo.getEntityNumber() + "_" + queryFieldBo.getFieldNumber();
            if (entityFieldMap.containsKey(key)) {
                queryFieldBo.setData(entityFieldMap.get(key));
                continue;
            }
            if (!FieldControlType.CHECKBOX.getValue().equals(queryFieldBo.getControlType()) || !DataTypeEnum.BOOLEAN.getDataTypeKey().equals(queryFieldBo.getValueType())) continue;
            queryFieldBo.setData(this.getBooleanData());
        }
    }

    private Map<String, String> entityFieldMap(List<WarnQueryFieldBo> queryFields) {
        Map<String, List<String>> entityEnumMap = this.getEntityEnumMap(queryFields);
        HashMap<String, String> entityFieldMap = new HashMap<String, String>(16);
        entityEnumMap.forEach((key, value) -> {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)key);
            for (String enumField : value) {
                IDataEntityProperty property = mainEntityType.findProperty(enumField);
                if (!(property instanceof ComboProp)) continue;
                List comboItems = ((ComboProp)property).getComboItems();
                entityFieldMap.put(key + "_" + enumField, SerializationUtils.toJsonString((Object)comboItems));
            }
        });
        return entityFieldMap;
    }

    private Map<String, List<String>> getEntityEnumMap(List<WarnQueryFieldBo> queryFields) {
        HashMap<String, List<String>> entityEnumMap = new HashMap<String, List<String>>(16);
        for (WarnQueryFieldBo queryFieldBo : queryFields) {
            if (queryFieldBo.isVirtualEntityField() || !this.isComboControl(queryFieldBo.getControlType())) continue;
            String entityNumber = queryFieldBo._getFieldEntityNumber();
            if (!entityEnumMap.containsKey(entityNumber)) {
                ArrayList<String> enumField = new ArrayList<String>(10);
                enumField.add(queryFieldBo._getField());
                entityEnumMap.put(entityNumber, enumField);
                continue;
            }
            ((List)entityEnumMap.get(entityNumber)).add(queryFieldBo._getField());
        }
        return entityEnumMap;
    }

    private boolean isComboControl(String controlType) {
        return FieldControlType.COMBO.getValue().equals(controlType) || FieldControlType.MUL_COMBO.getValue().equals(controlType);
    }

    public String getBooleanData() {
        ArrayList<ValueMapItem> comboItems = new ArrayList<ValueMapItem>();
        comboItems.add(new ValueMapItem("", "1", new LocaleString(ResManager.loadKDString((String)"\u662f", (String)"WarningSceneService_0", (String)"hrmp-hrcs-warn-business", (Object[])new Object[0]))));
        comboItems.add(new ValueMapItem("", "0", new LocaleString(ResManager.loadKDString((String)"\u5426", (String)"WarningSceneService_1", (String)"hrmp-hrcs-warn-business", (Object[])new Object[0]))));
        return SerializationUtils.toJsonString(comboItems);
    }

    private boolean isIndex(String valueType) {
        return DataTypeEnum.INTEGER.getDataTypeKey().equals(valueType) || DataTypeEnum.LONG.getDataTypeKey().equals(valueType) || DataTypeEnum.BIGDECIMAL.getDataTypeKey().equals(valueType);
    }
}

