/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.domain.service.earlywarn.calfield;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.business.service.labelandreport.FieldDefineService;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.labelandreport.FieldTreeNode;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.WarningSceneService;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.calfield.WarnCalcFieldService;
import kd.hr.hrcs.common.constants.earlywarn.WarnCalFieldConstants;
import kd.hr.hrcs.common.model.earlywarn.WarnCalFieldBo;

public class CalFieldHelper
implements WarnCalFieldConstants {
    private static final Log LOG = LogFactory.getLog(CalFieldHelper.class);

    @ExcludeFromJacocoGeneratedReport
    public static List<FieldTreeNode> getAllEntityFieldsByTree(DynamicObject warnScene) {
        try {
            if (warnScene == null) {
                return Collections.emptyList();
            }
            long warnTplId = warnScene.getLong("id");
            WarningSceneService warningSceneService = WarningSceneService.getInstance();
            List warnJoinEntityBos = warningSceneService.queryAllJoinEntitiesAndAssemble(warnScene).stream().map(join -> join).collect(Collectors.toList());
            List warnQueryFieldBos = warningSceneService.queryWarnQueryFieldsAndAssemble(warnScene).stream().map(field -> field).collect(Collectors.toList());
            FieldDefineService fieldDefineService = new FieldDefineService();
            return fieldDefineService.getEntityAllFields(warnJoinEntityBos, warnQueryFieldBos);
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
            return null;
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public static List<WarnCalFieldBo> getAllCalculateFields(DynamicObject warnSceneObj) {
        try {
            if (warnSceneObj == null) {
                return Collections.emptyList();
            }
            long warningObjId = warnSceneObj.getLong("id");
            WarnCalcFieldService expFieldService = WarnCalcFieldService.getInstance();
            return expFieldService.loadAllFieldCalFieldsBySourceIdForBo(warningObjId, true);
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
            return null;
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public static List<Map<String, Object>> buildEntityFieldList(List<FieldTreeNode> treeNodeFields, boolean getSelect) {
        ArrayList fields = Lists.newArrayListWithExpectedSize((int)10);
        try {
            for (FieldTreeNode fieldTreeNode : treeNodeFields) {
                List children = fieldTreeNode.getChildren();
                if (fieldTreeNode.getField().booleanValue() && !fieldTreeNode.getFieldPath().endsWith(".id")) {
                    if (getSelect && (fieldTreeNode.getSelected() == null || !fieldTreeNode.getSelected().booleanValue())) continue;
                    HashMap fieldMap = Maps.newHashMapWithExpectedSize((int)6);
                    fieldMap.put("fieldName", fieldTreeNode.getName());
                    fieldMap.put("fieldNumber", fieldTreeNode.getFieldAlias());
                    fieldMap.put("valueType", fieldTreeNode.getValueType());
                    if (HRStringUtils.isNotEmpty((String)fieldTreeNode.getBaseDataNum())) {
                        fieldMap.put("baseDataNum", fieldTreeNode.getBaseDataNum());
                    }
                    if (HRStringUtils.isNotEmpty((String)fieldTreeNode.getEnumEntityNum())) {
                        fieldMap.put("enumEntityNum", fieldTreeNode.getEnumEntityNum());
                    }
                    fieldMap.put("isSelected", fieldTreeNode.getSelected());
                    fields.add(fieldMap);
                    continue;
                }
                if (children == null || children.isEmpty()) continue;
                fields.addAll(CalFieldHelper.buildEntityFieldList(children, getSelect));
            }
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
        }
        return fields;
    }

    @ExcludeFromJacocoGeneratedReport
    public static List<WarnCalFieldBo> assembleCalFields(DynamicObject[] calFields, List<WarnCalFieldBo> refCalFieldBos, boolean edited) {
        if (calFields == null || calFields.length == 0) {
            return Lists.newArrayListWithExpectedSize((int)16);
        }
        ArrayList calFieldBoList = Lists.newArrayListWithCapacity((int)10);
        for (DynamicObject calFieldDy : calFields) {
            calFieldBoList.add(CalFieldHelper.assembleCalFieldBo(calFieldDy, edited));
        }
        Map<String, WarnCalFieldBo> calFieldMap = calFieldBoList.stream().collect(Collectors.toMap(WarnCalFieldBo::getId, bo -> bo));
        if (refCalFieldBos != null && !refCalFieldBos.isEmpty()) {
            calFieldMap.putAll(refCalFieldBos.stream().collect(Collectors.toMap(WarnCalFieldBo::getId, bo -> bo)));
        }
        for (DynamicObject calFieldDy : calFields) {
            CalFieldHelper.assembleCalFieldRefCalField(calFieldDy, calFieldMap);
        }
        return calFieldBoList.stream().sorted(Comparator.comparing(WarnCalFieldBo::getIndex)).collect(Collectors.toList());
    }

    @ExcludeFromJacocoGeneratedReport
    private static void assembleCalFieldRefCalField(DynamicObject calFieldDy, Map<String, WarnCalFieldBo> calFieldMap) {
        String calId = calFieldDy.getString("id");
        String calFieldNumber = calFieldDy.getString("number");
        DynamicObjectCollection refFieldEntry = calFieldDy.getDynamicObjectCollection("reffieldentry");
        ArrayList refCalFields = Lists.newArrayListWithCapacity((int)10);
        for (DynamicObject refFieldDy : refFieldEntry) {
            String refType = refFieldDy.getString("reftype");
            if (!HRStringUtils.equals((String)refType, (String)"calfield")) continue;
            DynamicObject refCalFieldDy = refFieldDy.getDynamicObject("refcalfield");
            if (refCalFieldDy == null) {
                String tips = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8ba1\u7b97\u5b57\u6bb5%s\u7684\u5f15\u7528\u5b57\u6bb5\u8bbe\u7f6e\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u521b\u5efa\u8be5\u8ba1\u7b97\u5b57\u6bb5\u3002", (String)"WarnExpFieldService_1", (String)"hrmp-hrcs-warn-business", (Object[])new Object[0]), calFieldNumber);
                LOG.error(tips);
                continue;
            }
            String refCalId = refCalFieldDy.getString("id");
            refCalFields.add(calFieldMap.get(refCalId));
        }
        WarnCalFieldBo calFieldBo = calFieldMap.get(calId);
        calFieldBo.setRefCalculateFields((List)refCalFields);
    }

    @ExcludeFromJacocoGeneratedReport
    private static WarnCalFieldBo assembleCalFieldBo(DynamicObject calFieldDy, boolean edited) {
        WarnCalFieldBo calField = new WarnCalFieldBo(AnalyseObjectUtil.getLocaleString((OrmLocaleValue)((OrmLocaleValue)calFieldDy.getLocaleString("name"))), calFieldDy.getString("number"));
        calField.setId(calFieldDy.getString("id"));
        calField.setIndex(Integer.valueOf(calFieldDy.getInt("index")));
        calField.setExpr(calFieldDy.getString("expr"));
        calField.setViewExpr(calFieldDy.getString("viewexpr"));
        calField.setType(calFieldDy.getString("type"));
        calField.setOrder(Integer.valueOf(calFieldDy.getInt("order")));
        calField.setValueType(calFieldDy.getString("valuetype"));
        calField.setControlType(calFieldDy.getString("controltype"));
        calField.setConfWay(calFieldDy.getString("confway"));
        calField.setServiceClass(calFieldDy.getString("serviceclass"));
        if (!edited) {
            calField.setSelected(Boolean.valueOf(false));
        } else {
            calField.setSelected(Boolean.valueOf(calFieldDy.getBoolean("isselected")));
        }
        String calMethod = calFieldDy.getString("calmethod");
        if (HRStringUtils.isEmpty((String)calMethod)) {
            calMethod = "normal";
        }
        calField.setCalMethod(calMethod);
        calField.setHideField(calFieldDy.getBoolean("hidefield"));
        calField.setSource(calFieldDy.getString("source"));
        calField.setSourceId(calFieldDy.getString("sourceid"));
        DynamicObjectCollection refFieldEntry = calFieldDy.getDynamicObjectCollection("reffieldentry");
        ArrayList refEntityFields = Lists.newArrayListWithCapacity((int)10);
        for (DynamicObject refFieldDy : refFieldEntry) {
            String refType = refFieldDy.getString("reftype");
            String fieldAlias = "";
            if (!HRStringUtils.equals((String)refType, (String)"entityfield")) continue;
            fieldAlias = refFieldDy.getString("reffieldalias");
            refEntityFields.add(fieldAlias);
        }
        calField.setRefEntityFields((List)refEntityFields);
        calField.setEdited(edited);
        return calField;
    }
}

