/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.domain.service.earlywarn.calfield;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.WarnObjTplService;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.WarningSceneService;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.calfield.CalFieldHelper;
import kd.hr.hrcs.common.constants.earlywarn.WarnCalFieldConstants;
import kd.hr.hrcs.common.model.earlywarn.WarnCalFieldBo;

public class WarnCalcFieldService
implements WarnCalFieldConstants {
    private static final Log LOG = LogFactory.getLog(WarnCalcFieldService.class);
    private final HRBaseServiceHelper calFieldHelper = new HRBaseServiceHelper("hrcs_warncalfield");
    private static volatile WarnCalcFieldService service = null;

    private WarnCalcFieldService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WarnCalcFieldService getInstance() {
        if (service != null) return service;
        Class<WarnCalcFieldService> clazz = WarnCalcFieldService.class;
        synchronized (WarnCalcFieldService.class) {
            if (service != null) return service;
            service = new WarnCalcFieldService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public DynamicObject[] loadAllCalFieldsByType(Object sourceId, String ... source) {
        try {
            ArrayList qFilters = Lists.newArrayListWithExpectedSize((int)2);
            qFilters.add(new QFilter("sourceid", "=", sourceId));
            if (source != null && source.length > 0) {
                qFilters.add(new QFilter("source", "in", (Object)Lists.newArrayList((Object[])source)));
            }
            return this.calFieldHelper.loadDynamicObjectArray(qFilters.toArray(new QFilter[0]));
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
            return new DynamicObject[0];
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public DynamicObject[] loadAllFieldCalFieldsBySourceId(Object sourceId) {
        try {
            return this.loadAllCalFieldsByType(sourceId, "warnfield");
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
            return new DynamicObject[0];
        }
    }

    @Deprecated
    @ExcludeFromJacocoGeneratedReport
    public DynamicObject[] loadCommonConditionCalFieldsBySourceId(Long sourceId) {
        try {
            QFilter[] qFilters = new QFilter[]{new QFilter("sourceid", "=", (Object)sourceId), new QFilter("source", "=", (Object)"warncondition")};
            return this.calFieldHelper.loadDynamicObjectArray(qFilters);
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
            return new DynamicObject[0];
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public DynamicObject[] loadSchemeCalFieldBySchemeId(Object schemeId) {
        try {
            return this.loadAllCalFieldsByType(schemeId, "warnscheme");
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
            return new DynamicObject[0];
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public DynamicObject[] loadCalFieldByWarnSchemeIds(Object[] warnSchemeIds) {
        try {
            QFilter[] qFilters = new QFilter[]{new QFilter("sourceid", "in", (Object)warnSchemeIds), new QFilter("source", "=", (Object)"warnscheme")};
            return this.calFieldHelper.loadDynamicObjectArray(qFilters);
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
            return new DynamicObject[0];
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public List<WarnCalFieldBo> loadSceneAllFieldCalFieldsBySourceId(DynamicObject sceneDy) {
        try {
            ArrayList allCalFields = Lists.newArrayListWithExpectedSize((int)10);
            DynamicObject objTplDy = sceneDy.getDynamicObject("warnobjtpl");
            List<WarnCalFieldBo> allObjTplCalFields = this.loadAllFieldCalFieldsBySourceIdForScene(objTplDy.getPkValue(), false, "warnfield");
            DynamicObject[] sceneCalFieldsDys = this.loadAllFieldCalFieldsBySourceId(sceneDy.getPkValue());
            List<WarnCalFieldBo> allSceneCalFields = CalFieldHelper.assembleCalFields(sceneCalFieldsDys, allObjTplCalFields, true);
            Iterator<WarnCalFieldBo> it = allObjTplCalFields.iterator();
            block2: while (it.hasNext()) {
                WarnCalFieldBo data = it.next();
                for (WarnCalFieldBo warnCalFieldBo : allSceneCalFields) {
                    if (!data.getFieldNumber().equalsIgnoreCase(warnCalFieldBo.getFieldNumber())) continue;
                    it.remove();
                    warnCalFieldBo.setEdited(false);
                    continue block2;
                }
            }
            allCalFields.addAll(allObjTplCalFields);
            allCalFields.addAll(allSceneCalFields);
            return allCalFields;
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
            return Collections.emptyList();
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public List<WarnCalFieldBo> loadSceneAllFieldCalFieldsBySourceIdForBo(DynamicObject sceneDy) {
        try {
            ArrayList allCalFields = Lists.newArrayListWithExpectedSize((int)10);
            DynamicObject objTplDy = sceneDy.getDynamicObject("warnobjtpl");
            allCalFields.addAll(this.loadAllFieldCalFieldsBySourceIdForBo(objTplDy.getPkValue(), false));
            allCalFields.addAll(this.loadAllFieldCalFieldsBySourceIdForBo(sceneDy.getPkValue(), true));
            return allCalFields;
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
            return Collections.emptyList();
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public List<WarnCalFieldBo> loadAllFieldCalFieldsBySourceIdForBo(Object sourceId, boolean edited) {
        try {
            DynamicObject[] calFields = this.loadAllFieldCalFieldsBySourceId(sourceId);
            return CalFieldHelper.assembleCalFields(calFields, null, edited);
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
            return Collections.emptyList();
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public List<WarnCalFieldBo> loadAllFieldCalFieldsBySourceIdForScene(Object sourceId, boolean edited, String sourceType) {
        try {
            ArrayList qFilters = Lists.newArrayListWithExpectedSize((int)2);
            qFilters.add(new QFilter("sourceid", "=", sourceId));
            qFilters.add(new QFilter("source", "=", (Object)"warnfield"));
            if ("warnfield".equalsIgnoreCase(sourceType)) {
                qFilters.add(new QFilter("isselected", "=", (Object)Character.valueOf('1')));
            }
            DynamicObject[] calFields = this.calFieldHelper.loadDynamicObjectArray(qFilters.toArray(new QFilter[0]));
            return CalFieldHelper.assembleCalFields(calFields, null, edited);
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
            return Collections.emptyList();
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public List<WarnCalFieldBo> loadAllSceneFieldCalFieldsForBo(DynamicObject sceneDy) {
        try {
            DynamicObject[] sceneFieldCalFields = this.loadAllFieldCalFieldsBySourceId(sceneDy.getPkValue());
            List<WarnCalFieldBo> objTplFieldCalFields = this.loadAllFieldCalFieldsBySourceIdForBo(sceneDy.getDynamicObject("warnobjtpl").getPkValue(), true);
            objTplFieldCalFields.addAll(CalFieldHelper.assembleCalFields(sceneFieldCalFields, objTplFieldCalFields, true));
            return objTplFieldCalFields;
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
            return Collections.emptyList();
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public List<WarnCalFieldBo> loadAllSchemeCalFieldsForBo(DynamicObject sceneDy, DynamicObject schemeDy) {
        try {
            DynamicObject[] schemeCalFields = this.loadSchemeCalFieldBySchemeId(schemeDy.getPkValue());
            List<WarnCalFieldBo> sceneCalFieldBos = this.loadAllSceneFieldCalFieldsForBo(sceneDy);
            return CalFieldHelper.assembleCalFields(schemeCalFields, sceneCalFieldBos, true);
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
            return Collections.emptyList();
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public String getControlTypeByValueType(String valueType) {
        try {
            DataTypeEnum dataTypeEnum = DataTypeEnum.of((String)valueType);
            String controlType = FieldControlType.TEXT.getValue();
            switch (dataTypeEnum) {
                case LONG: {
                    controlType = FieldControlType.BIGINT.getValue();
                    break;
                }
                case BIGDECIMAL: {
                    controlType = FieldControlType.DECIMAL.getValue();
                    break;
                }
                case INTEGER: {
                    controlType = FieldControlType.INTEGER.getValue();
                    break;
                }
                case BOOLEAN: {
                    controlType = FieldControlType.CHECKBOX.getValue();
                    break;
                }
            }
            return controlType;
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
            return "";
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public boolean deleteCalField(String deleteCalFieldNumber, List<WarnCalFieldBo> allCalFieldBos, StringBuilder errorMsg) {
        try {
            boolean deleteError;
            StringBuilder refCalFieldNames = new StringBuilder();
            for (WarnCalFieldBo calculateFieldBo : allCalFieldBos) {
                if (!calculateFieldBo.getRefCalculateFields().stream().anyMatch(field -> HRStringUtils.equals((String)deleteCalFieldNumber, (String)field.getFieldNumber()))) continue;
                refCalFieldNames.append(calculateFieldBo.getFieldName().getLocaleValue()).append(",");
            }
            boolean bl = deleteError = refCalFieldNames.length() > 0;
            if (deleteError) {
                String msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u8be5\u8ba1\u7b97\u5b57\u6bb5\u88ab%s\u8ba1\u7b97\u5b57\u6bb5\u5f15\u7528\u3002", (String)"WarnExpFieldService_0", (String)"hrmp-hrcs-warn-business", (Object[])new Object[0]), refCalFieldNames.substring(0, refCalFieldNames.length() - 1));
                errorMsg.append(msg);
            } else {
                allCalFieldBos.removeIf(field -> HRStringUtils.equals((String)deleteCalFieldNumber, (String)field.getFieldNumber()));
            }
            return !deleteError;
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
            return false;
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public void saveCalFieldsForWarnObjTpl(boolean isWarnObjTplUpdate, Long sourceId, List<WarnCalFieldBo> calFields) {
        try {
            Map<Object, DynamicObject> calFieldsLoadMap = Collections.emptyMap();
            boolean warnObjRefByScene = false;
            if (isWarnObjTplUpdate) {
                DynamicObject[] calFieldLoads = this.loadAllFieldCalFieldsBySourceId(sourceId);
                calFieldsLoadMap = Arrays.stream(calFieldLoads).collect(Collectors.toMap(DataEntityBase::getPkValue, dy -> dy));
                warnObjRefByScene = WarnObjTplService.getInstance().isWarnObjRefByScene(sourceId);
            }
            this.assembleAndSaveCalFields(sourceId, calFields, calFieldsLoadMap, warnObjRefByScene);
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public void saveCalFieldsForScene(boolean isSceneUpdate, Object sourceId, List<WarnCalFieldBo> calFields) {
        try {
            Map<Object, DynamicObject> calFieldsLoadMap = Collections.emptyMap();
            boolean sceneRefByScheme = false;
            if (isSceneUpdate) {
                DynamicObject[] calFieldLoads = this.loadAllFieldCalFieldsBySourceId(sourceId);
                calFieldsLoadMap = Arrays.stream(calFieldLoads).collect(Collectors.toMap(DataEntityBase::getPkValue, dy -> dy));
                sceneRefByScheme = WarningSceneService.getInstance().isWarnObjRefByScheme(sourceId);
            }
            this.assembleAndSaveCalFields(sourceId, calFields, calFieldsLoadMap, sceneRefByScheme);
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public void saveCalFieldForSchemeHighCondition(Long warnSchemeId, List<WarnCalFieldBo> calFields) {
        try {
            DynamicObject[] calFieldLoads = this.loadSchemeCalFieldBySchemeId(warnSchemeId);
            Map<Object, DynamicObject> calFieldMap = Arrays.stream(calFieldLoads).collect(Collectors.toMap(DataEntityBase::getPkValue, dy -> dy));
            this.assembleAndSaveCalFields(warnSchemeId, calFields, calFieldMap, false);
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void assembleAndSaveCalFields(Object sourceId, List<WarnCalFieldBo> calFields, Map<Object, DynamicObject> calFieldsLoadMap, boolean isRef) {
        HRBaseServiceHelper calFieldHelper = new HRBaseServiceHelper("hrcs_warncalfield");
        DynamicObjectCollection calFieldCol = new DynamicObjectCollection();
        ArrayList deleteIds = Lists.newArrayListWithCapacity((int)10);
        if (isRef) {
            for (WarnCalFieldBo warnCalFieldBo : calFields) {
                String id = warnCalFieldBo.getId();
                if (!HRStringUtils.isNotEmpty((String)id)) continue;
                DynamicObject calFieldDy = calFieldsLoadMap.get(Long.valueOf(id));
                boolean isSelected = calFieldDy.getBoolean("isselected");
                if (isSelected && !warnCalFieldBo.getSelected().booleanValue()) {
                    warnCalFieldBo.setSelected(Boolean.valueOf(false));
                }
                if (isSelected || !warnCalFieldBo.getSelected().booleanValue()) continue;
                warnCalFieldBo.setSelected(Boolean.valueOf(true));
            }
        }
        Set ids = calFields.stream().filter(calFieldBo -> HRStringUtils.isNotEmpty((String)calFieldBo.getId())).map(calFieldBo -> Long.valueOf(calFieldBo.getId())).collect(Collectors.toSet());
        for (DynamicObject dy : calFieldsLoadMap.values()) {
            Long id = dy.getLong("id");
            if (ids.contains(id)) continue;
            Optional<WarnCalFieldBo> calFieldBo2 = calFields.stream().filter(field -> HRStringUtils.isNotEmpty((String)field.getId())).filter(field -> Objects.equals(Long.valueOf(field.getId()), id)).findAny();
            if (isRef && calFieldBo2.isPresent() && calFieldBo2.get().getSelected().booleanValue()) continue;
            deleteIds.add(id);
        }
        long l = calFields.stream().filter(field -> HRStringUtils.isEmpty((String)field.getId())).count();
        long[] newIds = ORM.create().genLongIds("hrcs_warncalfield", (int)l);
        int index = 0;
        HashMap numberToIdMap = Maps.newHashMapWithExpectedSize((int)calFields.size());
        for (WarnCalFieldBo calField : calFields) {
            DynamicObjectCollection refFieldEntry;
            DynamicObject calFieldDy;
            String fieldSourceId = calField.getSourceId();
            if (HRStringUtils.isNotEmpty((String)fieldSourceId) && !String.valueOf(sourceId).equals(fieldSourceId)) continue;
            long calFieldId = 0L;
            if (HRStringUtils.isNotEmpty((String)calField.getId())) {
                calFieldId = Long.parseLong(calField.getId());
            }
            if ((calFieldDy = calFieldsLoadMap.get(calFieldId)) == null) {
                calFieldDy = calFieldHelper.generateEmptyDynamicObject();
                calFieldDy.set("id", (Object)newIds[index]);
                calField.setId(String.valueOf(newIds[index]));
                numberToIdMap.put(calField.getFieldNumber(), newIds[index]);
                ++index;
            } else if (HRStringUtils.isNotEmpty((String)calField.getId())) {
                numberToIdMap.put(calField.getFieldNumber(), Long.valueOf(calField.getId()));
            }
            calFieldDy.set("index", (Object)calField.getIndex());
            calFieldDy.set("number", (Object)calField.getFieldNumber());
            calFieldDy.set("name", (Object)calField.getFieldName());
            calFieldDy.set("type", (Object)calField.getType());
            calFieldDy.set("valuetype", (Object)calField.getValueType());
            calFieldDy.set("controltype", (Object)calField.getControlType());
            calFieldDy.set("expr", (Object)calField.getExpr());
            calFieldDy.set("viewexpr", (Object)calField.getViewExpr());
            calFieldDy.set("source", (Object)calField.getSource());
            calFieldDy.set("order", (Object)calField.getOrder());
            calFieldDy.set("isselected", (Object)calField.getSelected());
            calFieldDy.set("calmethod", (Object)calField.getCalMethod());
            calFieldDy.set("hidefield", (Object)calField.isHideField());
            calFieldDy.set("sourceid", sourceId);
            calFieldDy.set("confway", (Object)calField.getConfWay());
            calFieldDy.set("serviceclass", (Object)calField.getServiceClass());
            if (calFieldDy.getDataEntityState().getFromDatabase()) {
                refFieldEntry = calFieldDy.getDynamicObjectCollection("reffieldentry");
                refFieldEntry.clear();
            } else {
                refFieldEntry = calFieldHelper.generateEmptyEntryCollection(calFieldDy, "reffieldentry");
            }
            for (String refEntityFieldAlias : calField.getRefEntityFields()) {
                DynamicObject refExpFieldDy = calFieldHelper.generateEmptyEntryDynamicObject("reffieldentry");
                refExpFieldDy.set("reftype", (Object)"entityfield");
                refExpFieldDy.set("reffieldalias", (Object)refEntityFieldAlias);
                refFieldEntry.add((Object)refExpFieldDy);
            }
            calFieldCol.add((Object)calFieldDy);
        }
        Map<Long, DynamicObject> fieldDyMap = calFieldCol.stream().collect(Collectors.toMap(field -> field.getLong("id"), field -> field));
        for (WarnCalFieldBo calField : calFields) {
            List refCalculateFields = calField.getRefCalculateFields();
            for (WarnCalFieldBo refCalField : refCalculateFields) {
                DynamicObject refExpFieldDy = calFieldHelper.generateEmptyEntryDynamicObject("reffieldentry");
                refExpFieldDy.set("reftype", (Object)"calfield");
                Long refId = HRStringUtils.isNotEmpty((String)refCalField.getId()) ? Long.valueOf(Long.parseLong(refCalField.getId())) : (Long)numberToIdMap.get(refCalField.getFieldNumber());
                if (refId == 0L) continue;
                refExpFieldDy.set("refcalfield", (Object)refId);
                DynamicObject fieldDy = fieldDyMap.get(Long.valueOf(calField.getId()));
                DynamicObjectCollection refFieldDys = fieldDy.getDynamicObjectCollection("reffieldentry");
                refFieldDys.add((Object)refExpFieldDy);
            }
        }
        calFieldHelper.delete(deleteIds.toArray(new Object[0]));
        calFieldHelper.save(calFieldCol);
    }

    @ExcludeFromJacocoGeneratedReport
    public void deleteSchemeAdConditionCalField(long schemeId) {
        this.calFieldHelper.deleteByFilter(new QFilter[]{new QFilter("sourceid", "=", (Object)schemeId), new QFilter("source", "=", (Object)"warnscheme")});
    }
}

