/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.action;

import java.util.ArrayList;
import java.util.List;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.helper.EarlyWarnLogHelper;
import kd.hr.hrcs.common.model.earlywarn.log.EarlyWarnDetailLog;
import kd.hr.hrcs.common.model.earlywarn.log.WarnScheduleOperationType;
import kd.hr.hrcs.common.model.earlywarn.log.WarnScheduleStatus;

@ExcludeFromJacocoGeneratedReport
public class EngineLog {
    private String warnSchemeId;
    private String warnSceneId;
    private long earlyWarnLogId;
    private List<EarlyWarnDetailLog> detailLogs = new ArrayList<EarlyWarnDetailLog>();

    public static EngineLog getInstance(long earlyWarnLogId, String warnSchemeId, String warnSceneId, WarnScheduleOperationType operationType) {
        return new EngineLog(warnSchemeId, warnSceneId, earlyWarnLogId);
    }

    public static EngineLog getInstance(String warnSchemeId, String warnSceneId, WarnScheduleOperationType operationType) {
        long earlyWarnLogId = EarlyWarnLogHelper.createLog(warnSchemeId, warnSceneId, operationType);
        return new EngineLog(warnSchemeId, warnSceneId, earlyWarnLogId);
    }

    public EngineLog(String warnSchemeId, String warnSceneId, long earlyWarnLogId) {
        this.warnSchemeId = warnSchemeId;
        this.warnSceneId = warnSceneId;
        this.earlyWarnLogId = earlyWarnLogId;
    }

    public String getWarnSchemeId() {
        return this.warnSchemeId;
    }

    public void setWarnSchemeId(String warnSchemeId) {
        this.warnSchemeId = warnSchemeId;
    }

    public long getEarlyWarnLogId() {
        return this.earlyWarnLogId;
    }

    public void setEarlyWarnLogId(long earlyWarnLogId) {
        this.earlyWarnLogId = earlyWarnLogId;
    }

    public List<EarlyWarnDetailLog> getDetailLogs() {
        return this.detailLogs;
    }

    public void setDetailLogs(List<EarlyWarnDetailLog> detailLogs) {
        this.detailLogs = detailLogs;
    }

    public String getWarnSceneId() {
        return this.warnSceneId;
    }

    public void setWarnSceneId(String warnSceneId) {
        this.warnSceneId = warnSceneId;
    }

    public void logRecord(String execStep, String result) {
        EarlyWarnLogHelper.saveDetailLog(this.earlyWarnLogId, execStep, result);
    }

    public void logBatch(String execStep, String result) {
        EarlyWarnDetailLog log = EarlyWarnLogHelper.createBlankDetailLog(this.earlyWarnLogId, execStep, result);
        this.detailLogs.add(log);
    }

    public void batchSaveLogs() {
        EarlyWarnLogHelper.batchSaveDetailLogs(this.detailLogs);
        this.detailLogs.clear();
    }

    public void endRecord(WarnScheduleStatus status) {
        EarlyWarnLogHelper.endLog(this.earlyWarnLogId, status);
    }
}

