/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.action;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.query.util.QFilterUtilHR;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.action.EngineLog;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.action.IEarlyWarnAction;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.action.PermissionBo;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.EarlyWarnContext;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.message.WarnUserDataBo;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.receiver.ReceiverFieldResultBo;
import kd.hr.hrcs.common.model.earlywarn.ds.WarnDataRow;

@ExcludeFromJacocoGeneratedReport
public class PermissionAction
implements IEarlyWarnAction {
    public static final Log LOGGER = LogFactory.getLog(PermissionAction.class);
    private String ACTION_TAG_PERMISSION = ResManager.loadKDString((String)"\u6743\u9650\u8fc7\u6ee4\u52a8\u4f5c", (String)"PermissionAction_0", (String)"hrmp-hrcs-warn-business", (Object[])new Object[0]);

    @Override
    public void execute(EarlyWarnContext context, EngineLog log) {
        log.logRecord(this.ACTION_TAG_PERMISSION, ResManager.loadKDString((String)"\u5f00\u59cb\u5904\u7406\u6743\u9650\u8fc7\u6ee4...", (String)"PermissionAction_1", (String)"hrmp-hrcs-warn-business", (Object[])new Object[0]));
        DynamicObject warnScheme = context.getWarnScheme();
        DynamicObjectCollection roleEntryColl = warnScheme.getDynamicObjectCollection("rcroleentryentity");
        DynamicObjectCollection fixEntryColl = warnScheme.getDynamicObjectCollection("rcfixentryentity");
        ArrayList warnUserDataBoList = Lists.newArrayListWithExpectedSize((int)context.getUserCount());
        int chunkSize = 500;
        HashMap groupReceiver = Maps.newHashMapWithExpectedSize((int)16);
        DataSet dataSet = context.getDataSet();
        HashSet userNotPermIdS = Sets.newHashSetWithExpectedSize((int)16);
        HashSet userPermIdS = Sets.newHashSetWithExpectedSize((int)16);
        HashSet userRelationIdS = Sets.newHashSetWithExpectedSize((int)16);
        HashSet userRepeatIdS = Sets.newHashSetWithExpectedSize((int)16);
        this.buildPermIds(context, roleEntryColl, fixEntryColl, userNotPermIdS, userPermIdS, userRelationIdS);
        context.setUserRoleMap(null);
        context.setReceiverUserIds(null);
        userPermIdS.removeAll(userNotPermIdS);
        Iterator iterator = userRelationIdS.iterator();
        while (iterator.hasNext()) {
            Long userId = (Long)iterator.next();
            if (!userNotPermIdS.contains(userId) && !userPermIdS.contains(userId)) continue;
            userRepeatIdS.add(userId);
            iterator.remove();
        }
        List<ReceiverFieldResultBo> userRelationResult = context.getUserRelationResult();
        if (userRelationResult != null && userRelationResult.size() > 0) {
            int receiverSum = userRelationResult.stream().map(map -> map.getSuperiorPersonMap().size()).mapToInt(val -> val).sum();
            List userRelationSubList = Lists.newArrayListWithExpectedSize((int)(receiverSum / 100));
            if (userRelationResult.size() > 100) {
                userRelationSubList = Lists.partition(userRelationResult, (int)100);
            } else {
                userRelationSubList.add(userRelationResult);
            }
            for (List userRelationSub : userRelationSubList) {
                this.buildUserRelation(context, groupReceiver, dataSet, userNotPermIdS, userPermIdS, userRepeatIdS, userRelationSub, warnUserDataBoList);
            }
        }
        if (userNotPermIdS.size() > chunkSize) {
            List<Set<Long>> chunks = this.splitSet(userNotPermIdS, chunkSize);
            for (Set<Long> userNotPermIdSetS : chunks) {
                this.groupNotPermReceiver(groupReceiver, dataSet, userNotPermIdSetS, userRepeatIdS, warnUserDataBoList);
            }
        } else {
            this.groupNotPermReceiver(groupReceiver, dataSet, userNotPermIdS, userRepeatIdS, warnUserDataBoList);
        }
        if (userPermIdS.size() > chunkSize) {
            List<Set<Long>> chunks = this.splitSet(userPermIdS, chunkSize);
            for (Set<Long> userPermIdSetS : chunks) {
                this.groupPermReceiver(context, groupReceiver, dataSet, userPermIdSetS, userRepeatIdS, warnUserDataBoList);
            }
        } else {
            this.groupPermReceiver(context, groupReceiver, dataSet, userPermIdS, userRepeatIdS, warnUserDataBoList);
        }
        groupReceiver.clear();
        context.setWarnUserDataBoList(warnUserDataBoList);
        log.logRecord(this.ACTION_TAG_PERMISSION, ResManager.loadKDString((String)"\u6743\u9650\u8fc7\u6ee4\u6210\u529f", (String)"PermissionAction_2", (String)"hrmp-hrcs-warn-business", (Object[])new Object[0]));
    }

    private void buildUserRelation(EarlyWarnContext context, Map<Long, DataSet> groupReceiver, DataSet dataSet, Set<Long> userNotPermIdS, Set<Long> userPermIdS, Set<Long> userRepeatIdS, List<ReceiverFieldResultBo> userRelationResult, List<WarnUserDataBo> warnUserDataBoList) {
        groupReceiver.clear();
        for (ReceiverFieldResultBo receiverFieldResultBo : userRelationResult) {
            for (Long receiver : receiverFieldResultBo.getSuperiorPersonMap().values()) {
                DataSet dataSetRelation;
                String filter;
                if (receiver == null || receiver == 0L) continue;
                if (userRepeatIdS.contains(receiver)) {
                    filter = receiverFieldResultBo.getFieldAlias() + "=" + receiverFieldResultBo.getFiledId();
                    dataSetRelation = dataSet.copy().filter(filter);
                    this.unionDataSet(groupReceiver, receiver, dataSetRelation);
                    if (userNotPermIdS.contains(receiver)) {
                        this.unionDataSet(groupReceiver, receiver, dataSet.copy());
                        continue;
                    }
                    if (!userPermIdS.contains(receiver)) continue;
                    this.permReceiver(context, receiver, dataSet.copy(), groupReceiver);
                    continue;
                }
                filter = receiverFieldResultBo.getFieldAlias() + "=" + receiverFieldResultBo.getFiledId();
                dataSetRelation = dataSet.copy().filter(filter);
                this.unionDataSet(groupReceiver, receiver, dataSetRelation);
            }
        }
        this.transformUserData(groupReceiver, warnUserDataBoList);
    }

    public void transformUserData(Map<Long, DataSet> groupReceiver, List<WarnUserDataBo> warnUserDataBoList) {
        for (Map.Entry<Long, DataSet> entry : groupReceiver.entrySet()) {
            WarnUserDataBo warnUserDataBo = new WarnUserDataBo();
            DataSet dataSet = entry.getValue();
            dataSet = dataSet.distinct();
            RowMeta rowMeta = dataSet.getRowMeta();
            ArrayList listRow = Lists.newArrayListWithExpectedSize((int)10);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                listRow.add(new WarnDataRow(rowMeta, row));
            }
            dataSet.close();
            warnUserDataBo.setBodyList(listRow);
            warnUserDataBo.setReceiverUserId(entry.getKey());
            warnUserDataBoList.add(warnUserDataBo);
        }
    }

    private void groupPermReceiver(EarlyWarnContext context, Map<Long, DataSet> groupReceiver, DataSet dataSet, Set<Long> userPermIdS, Set<Long> userRepeatIdS, List<WarnUserDataBo> warnUserDataBoList) {
        groupReceiver.clear();
        for (Long userId : userPermIdS) {
            if (userId == null || userId == 0L || userRepeatIdS.contains(userId)) continue;
            this.permReceiver(context, userId, dataSet.copy(), groupReceiver);
        }
        this.transformUserData(groupReceiver, warnUserDataBoList);
    }

    private void groupNotPermReceiver(Map<Long, DataSet> groupReceiver, DataSet dataSet, Set<Long> userNotPermIdS, Set<Long> userRepeatIdS, List<WarnUserDataBo> warnUserDataBoList) {
        groupReceiver.clear();
        for (Long userId : userNotPermIdS) {
            if (userId == null || userId == 0L || userRepeatIdS.contains(userId)) continue;
            groupReceiver.put(userId, dataSet.copy());
        }
        this.transformUserData(groupReceiver, warnUserDataBoList);
    }

    public List<Set<Long>> splitSet(Set<Long> originalSet, int chunkSize) {
        ArrayList chunks = Lists.newArrayListWithCapacity((int)(originalSet.size() / chunkSize + 1));
        while (originalSet.size() > 0) {
            HashSet chunk = Sets.newHashSetWithExpectedSize((int)chunkSize);
            int size = Math.min(originalSet.size(), chunkSize);
            for (int i = 0; i < size; ++i) {
                chunk.add(originalSet.iterator().next());
                originalSet.remove(originalSet.iterator().next());
            }
            chunks.add(chunk);
        }
        return chunks;
    }

    private void buildPermIds(EarlyWarnContext context, DynamicObjectCollection roleEntryColl, DynamicObjectCollection fixEntryColl, Set<Long> userNotPermIdS, Set<Long> userPermIdS, Set<Long> userRelationIdS) {
        List<ReceiverFieldResultBo> list;
        List<Long> receiverUserIds = context.getReceiverUserIds();
        if (null != fixEntryColl && !fixEntryColl.isEmpty() && receiverUserIds != null && receiverUserIds.size() > 0) {
            for (Long l : receiverUserIds) {
                DynamicObject dynamicObject = fixEntryColl.stream().filter(col -> l.equals(col.getDynamicObject("rcfixuser").getLong("id"))).findAny().get();
                if (dynamicObject.getBoolean("rcfixperm")) {
                    userPermIdS.add(l);
                    continue;
                }
                userNotPermIdS.add(l);
            }
        }
        Map<String, List<Long>> userRoleMap = context.getUserRoleMap();
        if (null != roleEntryColl && !roleEntryColl.isEmpty() && userRoleMap != null && userRoleMap.size() > 0) {
            for (Map.Entry<String, List<Long>> entry : userRoleMap.entrySet()) {
                DynamicObject entryDy = roleEntryColl.stream().filter(col -> ((String)entry.getKey()).equalsIgnoreCase(col.getDynamicObject("rcroleentry").getString("id"))).findAny().get();
                if (entryDy.getBoolean("roleperm")) {
                    for (Long receiver : userRoleMap.get(entry.getKey())) {
                        userPermIdS.add(receiver);
                    }
                    continue;
                }
                for (Long receiver : userRoleMap.get(entry.getKey())) {
                    userNotPermIdS.add(receiver);
                }
            }
        }
        if ((list = context.getUserRelationResult()) != null && list.size() > 0) {
            for (ReceiverFieldResultBo receiverFieldResultBo : list) {
                userRelationIdS.addAll(receiverFieldResultBo.getSuperiorPersonMap().values());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void permReceiver(EarlyWarnContext context, Long userId, DataSet dataSet, Map<Long, DataSet> groupReceiver) {
        try {
            DynamicObject warnScene = context.getWarnScene();
            if (warnScene.getDynamicObject("warnfromentiy") == null || warnScene.getDynamicObject("warnbizappid") == null) {
                return;
            }
            String warnFromEntity = warnScene.getDynamicObject("warnfromentiy").getString("number");
            LOGGER.info("permReceiver_getDimMap_entity:{}", (Object)warnFromEntity);
            Map dimensionMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSPermManageService", (String)"getPropDimensionMappingByEntity", (Object[])new Object[]{warnFromEntity});
            LOGGER.info("permReceiver_getDimMap_data_entity:{},data:{}", (Object)warnFromEntity, (Object)dimensionMap);
            if (dimensionMap == null || dimensionMap.size() == 0) {
                LOGGER.warn("permReceiver_getDimMap_data_is_null,entity", (Object)warnFromEntity);
                return;
            }
            String warnBizAppId = warnScene.getDynamicObject("warnbizappid").getString("id");
            Map<String, PermissionBo> permissionBoMap = warnScene.getDynamicObjectCollection("warnrcpermentryentity").stream().map(row -> new PermissionBo(row.getDynamicObject("warnentityperm").getString("id"), row.getString("fieldalias"))).collect(Collectors.toMap(PermissionBo::getWarnEntityPerm, Function.identity()));
            HashMap params = Maps.newHashMapWithExpectedSize((int)2);
            params.put("hr_dataperm_needCheckDims", permissionBoMap.keySet().stream().map(Long::parseLong).collect(Collectors.toList()));
            params.put("hr_dataperm_ignoreDataRulePerm", "true");
            LOGGER.info("permReceiver_getPermissionData_param_is_userId:{},appId:{},entityId:{},params:{}", new Object[]{userId, warnBizAppId, warnFromEntity, params});
            QFilter dataPermQFilter = (QFilter)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSDataPermissionService", (String)"getDataRule", (Object[])new Object[]{userId, warnBizAppId, warnFromEntity, "47150e89000000ac", params});
            LOGGER.info("permReceiver_getPermissionData_data_{}", (Object)dataPermQFilter);
            if (null == dataPermQFilter) {
                LOGGER.warn("permReceiver_getPermissionData_data_is_null!userId:{}", (Object)userId);
                return;
            }
            QFilter warnFieldPermQFilter = this.convertPermQFilterFields(dataPermQFilter, dimensionMap, permissionBoMap);
            String whereSql = QFilterUtilHR.toQFilterString((QFilter)warnFieldPermQFilter, (boolean)true, (boolean)false, null, null, (int)1000);
            dataSet = dataSet.filter(whereSql);
        }
        catch (Exception exception) {
            LOGGER.error("PermissionAction.permReceiver_error", (Throwable)exception);
        }
        finally {
            this.unionDataSet(groupReceiver, userId, dataSet);
        }
    }

    private void unionDataSet(Map<Long, DataSet> groupReceiver, Long receiver, DataSet dataSet) {
        DataSet dataSetOld = groupReceiver.get(receiver);
        if (dataSetOld != null) {
            groupReceiver.put(receiver, dataSetOld.union(dataSet));
        } else {
            groupReceiver.put(receiver, dataSet);
        }
    }

    private QFilter convertPermQFilterFields(QFilter convertQFilter, Map<String, Map<String, Object>> dimensionMap, Map<String, PermissionBo> warnPermFieldMap) {
        Map<String, Object> dimensionDataMap;
        LOGGER.info("convertPermQFilterFields_original_qFilter_{}", (Object)convertQFilter);
        QFilter copy = convertQFilter.__copy(false);
        String property = copy.getProperty();
        if (HRStringUtils.isNotEmpty((String)property) && property.endsWith(".fbasedataid")) {
            property = property.substring(0, property.lastIndexOf("."));
        }
        if ((dimensionDataMap = dimensionMap.get(property)) != null) {
            String dimensionId = String.valueOf(dimensionDataMap.get("dimensionid"));
            PermissionBo permissionBo = warnPermFieldMap.get(dimensionId);
            if (permissionBo != null) {
                copy.__setProperty(permissionBo.getFieldAlias());
            } else {
                LOGGER.warn("convertPermQFilterFields_getPermissionBo_is_null_dimensionId_is_{}", (Object)dimensionId);
            }
        } else {
            LOGGER.warn("convertPermQFilterFields_getDimensionDataMap_is_null_property_is_{}", (Object)property);
        }
        List nests = convertQFilter.getNests(true);
        for (QFilter.QFilterNest nest : nests) {
            QFilter nestFilter = nest.getFilter();
            QFilter copyNestFilter = this.convertPermQFilterFields(nestFilter, dimensionMap, warnPermFieldMap);
            if (nest.isAnd()) {
                copy.and(copyNestFilter);
                continue;
            }
            copy.or(copyNestFilter);
        }
        return copy;
    }
}

