/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.serivce.impl;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDExceptionKit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.EarlyWarnEngine;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.action.EngineLog;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.serivce.IEarlyWarnService;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.WarnExecuteParamBo;
import kd.hr.hrcs.common.model.earlywarn.log.WarnScheduleOperationType;

@ExcludeFromJacocoGeneratedReport
public class EarlyWarnServiceImpl
implements IEarlyWarnService {
    private static Log logger = LogFactory.getLog(EarlyWarnServiceImpl.class);
    private static volatile EarlyWarnServiceImpl service = null;

    private EarlyWarnServiceImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EarlyWarnServiceImpl getInstance() {
        if (service != null) return service;
        Class<EarlyWarnServiceImpl> clazz = EarlyWarnServiceImpl.class;
        synchronized (EarlyWarnServiceImpl.class) {
            if (service != null) return service;
            service = new EarlyWarnServiceImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    private String getActionTag() {
        return ResManager.loadKDString((String)"\u9884\u8b66\u6267\u884c\u5fae\u670d\u52a1", (String)"EarlyWarnServiceImpl_0", (String)"hrmp-hrcs-warn-business", (Object[])new Object[0]);
    }

    @Override
    public void execute(WarnExecuteParamBo warnExecuteParamBo) {
        String operationType = warnExecuteParamBo.getOperationType();
        WarnScheduleOperationType type = WarnScheduleOperationType.getBy((String)operationType);
        long earlyWarnLogId = warnExecuteParamBo.getEarlyWarnLogId();
        Long warnSchemeId = warnExecuteParamBo.getWarnSchemeId();
        if (warnSchemeId == null || warnSchemeId == 0L) {
            logger.error("warn scheme id is null, can't be execute!");
            return;
        }
        Long warnSceneId = warnExecuteParamBo.getWarnSceneId();
        if (warnSceneId == null || warnSceneId == 0L) {
            logger.error("warn scene id is null, can't be execute!");
            return;
        }
        EngineLog log = EngineLog.getInstance(earlyWarnLogId, String.valueOf(warnSchemeId), String.valueOf(warnSceneId), type);
        log.logRecord(this.getActionTag(), ResManager.loadKDString((String)"\u9884\u8b66\u5fae\u670d\u52a1\u8c03\u7528\u6210\u529f\uff0c\u7b49\u5f85\u5f15\u64ce\u6267\u884c...", (String)"EarlyWarnServiceImpl_1", (String)"hrmp-hrcs-warn-business", (Object[])new Object[0]));
        try {
            EarlyWarnEngine engine = new EarlyWarnEngine(String.valueOf(warnSchemeId), String.valueOf(warnSceneId), log, operationType);
            engine.execute();
            log.logRecord(this.getActionTag(), ResManager.loadKDString((String)"\u9884\u8b66\u5fae\u670d\u52a1\u8c03\u7528\u5b8c\u6210...", (String)"EarlyWarnServiceImpl_2", (String)"hrmp-hrcs-warn-business", (Object[])new Object[0]));
        }
        catch (Throwable e) {
            String msg = e.getMessage();
            msg = msg == null ? "" : msg;
            String info = KDExceptionKit.formatErrorMessage((ErrorCode)new ErrorCode("500", msg), (Object[])new Object[]{e});
            log.logRecord(this.getActionTag(), String.format(ResManager.loadKDString((String)"\u9884\u8b66\u5fae\u670d\u52a1\u5f02\u5e38\uff1a%s", (String)"EarlyWarnServiceImpl_4", (String)"hrmp-hrcs-warn-business", (Object[])new Object[0]), info));
            logger.error(this.getActionTag(), e);
            throw e;
        }
    }
}

