/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.serivce.impl.message;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.DecimalProp;
import kd.bos.inte.api.IInteService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.service.ServiceFactory;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.message.HRMessageInfo;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.message.MsgFieldsTypes;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.serivce.impl.message.model.MsgFieldFormatBo;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.serivce.impl.message.model.MsgUserDateFormatBo;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.serivce.impl.message.systemparam.SystemParamCalc;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.serivce.util.StringTemplateParser;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.EarlyWarnContext;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.message.FixedValueSysParamBo;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.message.MessageContentConfigBo;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.message.MessageFieldTypesBo;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.message.MessageTableConfigBo;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.message.WarnUserDataBo;
import kd.hr.hrcs.common.constants.earlywarn.WarnMsgSysParamEnum;
import kd.hr.hrcs.common.model.earlywarn.WarnCalFieldBo;
import kd.hr.hrcs.common.model.earlywarn.ds.WarnDataRow;
import org.joda.time.DateTime;

@ExcludeFromJacocoGeneratedReport
public class MessageBuilderHelper {
    public static final Log log = LogFactory.getLog(MessageBuilderHelper.class);
    private static volatile MessageBuilderHelper service = null;

    private MessageBuilderHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MessageBuilderHelper getInstance() {
        if (service != null) return service;
        Class<MessageBuilderHelper> clazz = MessageBuilderHelper.class;
        synchronized (MessageBuilderHelper.class) {
            if (service != null) return service;
            service = new MessageBuilderHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public List<MessageContentConfigBo> buildMsgConf(Map<String, List<DynamicObject>> schemeTableConfigMap, DynamicObject[] warnMsgConfArr) {
        if (warnMsgConfArr == null || warnMsgConfArr.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList msgContentConfigList = Lists.newArrayListWithExpectedSize((int)warnMsgConfArr.length);
        for (DynamicObject warnMsgConf : warnMsgConfArr) {
            MessageContentConfigBo messageContentConfigBo = new MessageContentConfigBo();
            messageContentConfigBo.setChannel(warnMsgConf.getString("channel"));
            messageContentConfigBo.setMsgTitle(warnMsgConf.getString("msgtitle"));
            messageContentConfigBo.setMsgMain(warnMsgConf.getString("msgmain"));
            messageContentConfigBo.setMsgEnd(warnMsgConf.getString("msgconclusion"));
            messageContentConfigBo.setMsgTableTitle(warnMsgConf.getString("msgtabletitle"));
            if (schemeTableConfigMap.containsKey(warnMsgConf.getString("channel"))) {
                List<DynamicObject> tableConfigDyns = schemeTableConfigMap.get(warnMsgConf.getString("channel"));
                ArrayList msgTable = Lists.newArrayListWithExpectedSize((int)tableConfigDyns.size());
                for (DynamicObject tableConfigDyn : tableConfigDyns) {
                    if (HRStringUtils.isEmpty((String)tableConfigDyn.getString("titleline"))) continue;
                    MessageTableConfigBo messageTableConfigBo = new MessageTableConfigBo();
                    messageTableConfigBo.setLineTitle(tableConfigDyn.getString("titleline"));
                    messageTableConfigBo.setFieldName(tableConfigDyn.getString("dataline"));
                    msgTable.add(messageTableConfigBo);
                }
                messageContentConfigBo.setMsgTable(msgTable);
            }
            msgContentConfigList.add(messageContentConfigBo);
        }
        return msgContentConfigList;
    }

    public void transformUserData(EarlyWarnContext context) {
        ArrayList warnUserDataBoList = Lists.newArrayListWithExpectedSize((int)10);
        Map<Long, DataSet> groupReceiver = context.getGroupReceiver();
        for (Map.Entry<Long, DataSet> entry : groupReceiver.entrySet()) {
            WarnUserDataBo warnUserDataBo = new WarnUserDataBo();
            DataSet dataSet = entry.getValue();
            dataSet = dataSet.distinct();
            RowMeta rowMeta = dataSet.getRowMeta();
            ArrayList listRow = Lists.newArrayListWithExpectedSize((int)10);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                listRow.add(new WarnDataRow(rowMeta, row));
            }
            warnUserDataBo.setBodyList(listRow);
            warnUserDataBo.setReceiverUserId(entry.getKey());
            warnUserDataBoList.add(warnUserDataBo);
        }
        context.setWarnUserDataBoList(warnUserDataBoList);
    }

    public List<MessageFieldTypesBo> buildMsgFieldsTypes(EarlyWarnContext context) {
        ArrayList messageFieldTypesBoList = Lists.newArrayListWithExpectedSize((int)10);
        StringTemplateParser parser = new StringTemplateParser();
        List<MessageContentConfigBo> msgContentConfigList = context.getMsgContentConfigList();
        for (MessageContentConfigBo contentConfigBo : msgContentConfigList) {
            List<String> titleFields = parser.parseFields(contentConfigBo.getMsgTitle());
            List<String> mainFields = parser.parseFields(contentConfigBo.getMsgMain());
            List<String> endFields = parser.parseFields(contentConfigBo.getMsgEnd());
            MsgFieldsTypes msgFieldsTypesTitle = this.buildMsgFieldsTypes(titleFields);
            MsgFieldsTypes msgFieldsTypesMain = this.buildMsgFieldsTypes(mainFields);
            MsgFieldsTypes msgFieldsTypesEnd = this.buildMsgFieldsTypes(endFields);
            MessageFieldTypesBo messageFieldTypesBo = new MessageFieldTypesBo();
            messageFieldTypesBo.setChannel(contentConfigBo.getChannel());
            messageFieldTypesBo.setMsgFieldsTypesTitle(msgFieldsTypesTitle);
            messageFieldTypesBo.setMsgFieldsTypesMain(msgFieldsTypesMain);
            messageFieldTypesBo.setMsgFieldsTypesEnd(msgFieldsTypesEnd);
            List<MessageTableConfigBo> messageTableConfigBos = contentConfigBo.getMsgTable();
            if (CollectionUtils.isNotEmpty(messageTableConfigBos)) {
                ArrayList tableFields = Lists.newArrayListWithExpectedSize((int)10);
                for (MessageTableConfigBo messageTableConfigBo : messageTableConfigBos) {
                    String field = messageTableConfigBo.getFieldName();
                    if (!StringUtils.isNotEmpty((String)field)) continue;
                    tableFields.add(field);
                }
                if (CollectionUtils.isNotEmpty((Collection)tableFields)) {
                    MsgFieldsTypes msgFieldsTypesTable = this.buildMsgFieldsTypes(tableFields);
                    messageFieldTypesBo.setMsgFieldsTypesTable(msgFieldsTypesTable);
                }
            }
            messageFieldTypesBoList.add(messageFieldTypesBo);
        }
        return messageFieldTypesBoList;
    }

    public boolean hasFieldVariable(MessageFieldTypesBo messageFieldTypesBo, boolean isMergeMsg) {
        if (messageFieldTypesBo == null) {
            return false;
        }
        MsgFieldsTypes msgFieldsTypesTitle = messageFieldTypesBo.getMsgFieldsTypesTitle();
        MsgFieldsTypes msgFieldsTypesMain = messageFieldTypesBo.getMsgFieldsTypesMain();
        if (isMergeMsg) {
            MsgFieldsTypes msgFieldsTypesEnd = messageFieldTypesBo.getMsgFieldsTypesEnd();
            MsgFieldsTypes msgFieldsTypesTable = messageFieldTypesBo.getMsgFieldsTypesTable();
            return msgFieldsTypesTitle != null && !CollectionUtils.isEmpty(msgFieldsTypesTitle.getAllFields()) || msgFieldsTypesMain != null && !CollectionUtils.isEmpty(msgFieldsTypesMain.getAllFields()) || msgFieldsTypesEnd != null && !CollectionUtils.isEmpty(msgFieldsTypesEnd.getAllFields()) || msgFieldsTypesTable != null && !CollectionUtils.isEmpty(msgFieldsTypesTable.getAllFields());
        }
        return (msgFieldsTypesTitle != null && !CollectionUtils.isEmpty(msgFieldsTypesTitle.getAllFields()) || msgFieldsTypesMain != null) && !CollectionUtils.isEmpty(msgFieldsTypesMain.getAllFields());
    }

    public boolean hasSysParamWithUser(MessageFieldTypesBo messageFieldTypesBo, boolean isMergeMsg) {
        if (messageFieldTypesBo == null) {
            return false;
        }
        MsgFieldsTypes msgFieldsTypesTitle = messageFieldTypesBo.getMsgFieldsTypesTitle();
        MsgFieldsTypes msgFieldsTypesMain = messageFieldTypesBo.getMsgFieldsTypesMain();
        if (isMergeMsg) {
            MsgFieldsTypes msgFieldsTypesEnd = messageFieldTypesBo.getMsgFieldsTypesEnd();
            MsgFieldsTypes msgFieldsTypesTable = messageFieldTypesBo.getMsgFieldsTypesTable();
            return msgFieldsTypesTitle != null && !CollectionUtils.isEmpty(msgFieldsTypesTitle.getSysParamWithUser()) || msgFieldsTypesMain != null && !CollectionUtils.isEmpty(msgFieldsTypesMain.getSysParamWithUser()) || msgFieldsTypesEnd != null && !CollectionUtils.isEmpty(msgFieldsTypesEnd.getSysParamWithUser()) || msgFieldsTypesTable != null && !CollectionUtils.isEmpty(msgFieldsTypesTable.getSysParamWithUser());
        }
        return msgFieldsTypesTitle != null && !CollectionUtils.isEmpty(msgFieldsTypesTitle.getSysParamWithUser()) || msgFieldsTypesMain != null && !CollectionUtils.isEmpty(msgFieldsTypesMain.getSysParamWithUser());
    }

    public void buildSysParamsUserList(EarlyWarnContext context, List<HRMessageInfo> hrMessageInfoList, MessageFieldTypesBo messageFieldTypesBo) {
        ArrayList receiverUserIds = Lists.newArrayListWithCapacity((int)10);
        hrMessageInfoList.stream().forEach(e -> receiverUserIds.addAll(e.getReceiverUserIds()));
        if (CollectionUtils.isEmpty((Collection)receiverUserIds)) {
            return;
        }
        Map<Long, String> userIdNameMap = SystemParamCalc.getSysUserName(receiverUserIds);
        if (userIdNameMap == null || userIdNameMap.size() == 0) {
            return;
        }
        if (messageFieldTypesBo == null) {
            return;
        }
        boolean isMergeMsg = true;
        boolean hasSysParamWithUser = MessageBuilderHelper.getInstance().hasSysParamWithUser(messageFieldTypesBo, isMergeMsg);
        if (!hasSysParamWithUser) {
            return;
        }
        for (HRMessageInfo hrMessageInfo : hrMessageInfoList) {
            MessageBuilderHelper.getInstance().buildSysParamUser(userIdNameMap.get(hrMessageInfo.getReceiverUserIds().get(0)), hrMessageInfo, isMergeMsg);
        }
    }

    private void buildSysParamUser(String userName, HRMessageInfo hrMessageInfo, boolean isMergeMsg) {
        String msgMain;
        String receiverName = "\\[" + WarnMsgSysParamEnum.RECEIVER_NAME.getName() + "\\]";
        String msgTitle = hrMessageInfo.getTitle();
        if (StringUtils.isNotEmpty((String)msgTitle)) {
            hrMessageInfo.setTitle(this.commonReplaceAll(msgTitle, receiverName, userName));
        }
        if (StringUtils.isNotEmpty((String)(msgMain = hrMessageInfo.getMsgMain()))) {
            hrMessageInfo.setMsgMain(this.commonReplaceAll(msgMain, receiverName, userName));
        }
        if (isMergeMsg) {
            List<List<MessageTableConfigBo>> msgTableLists;
            String msgEnd = hrMessageInfo.getMsgEnd();
            if (StringUtils.isNotEmpty((String)msgEnd)) {
                hrMessageInfo.setMsgEnd(this.commonReplaceAll(msgEnd, receiverName, userName));
            }
            if (CollectionUtils.isEmpty(msgTableLists = hrMessageInfo.getMsgTableLists())) {
                return;
            }
            for (List<MessageTableConfigBo> msgTable : msgTableLists) {
                for (MessageTableConfigBo messageTableConfigBo : msgTable) {
                    String fieldName = messageTableConfigBo.getFieldName();
                    if (!WarnMsgSysParamEnum.RECEIVER_NAME.getName().equals(fieldName)) continue;
                    messageTableConfigBo.setFieldValue(userName);
                }
            }
        }
    }

    public MsgFieldsTypes buildMsgFieldsTypes(List<String> titleFields) {
        if (CollectionUtils.isEmpty(titleFields)) {
            return null;
        }
        MsgFieldsTypes msgFieldsTypes = new MsgFieldsTypes();
        msgFieldsTypes.setAllFields(titleFields);
        for (String field : titleFields) {
            if (StringUtils.isEmpty((String)field) || field.equals(WarnMsgSysParamEnum.TOTAL.getName()) || field.equals(WarnMsgSysParamEnum.SYS_DATE.getName()) || field.equals(WarnMsgSysParamEnum.SYS_TIME.getName())) continue;
            if (field.equals(WarnMsgSysParamEnum.RECEIVER_NAME.getName())) {
                ArrayList sysParamWithUser = msgFieldsTypes.getSysParamWithUser();
                if (sysParamWithUser == null) {
                    sysParamWithUser = Lists.newArrayListWithExpectedSize((int)titleFields.size());
                    msgFieldsTypes.setSysParamWithUser(sysParamWithUser);
                }
                sysParamWithUser.add((String)field);
                continue;
            }
            ArrayList commonFields = msgFieldsTypes.getCommonFields();
            if (commonFields == null) {
                commonFields = Lists.newArrayListWithExpectedSize((int)titleFields.size());
                msgFieldsTypes.setCommonFields(commonFields);
            }
            commonFields.add((String)field);
        }
        return msgFieldsTypes;
    }

    public String buildFixedValueSysParam(List<String> fields, String content, FixedValueSysParamBo fixedValueSysParamBo) {
        if (CollectionUtils.isNotEmpty(fields)) {
            for (String field : fields) {
                content = this.buildFixedValueSysParam(field, content, fixedValueSysParamBo);
            }
        }
        return content;
    }

    public String buildFixedValueSysParam(String field, String content, FixedValueSysParamBo fixedValueSysParamBo) {
        if (StringUtils.isEmpty((String)field)) {
            return content;
        }
        if (field.equals(WarnMsgSysParamEnum.SYS_DATE.getName())) {
            String sysDate = SystemParamCalc.getSysDate(fixedValueSysParamBo.getSysDate());
            content = this.commonReplaceAll(content, "\\[" + WarnMsgSysParamEnum.SYS_DATE.getName() + "\\]", sysDate);
        }
        if (field.equals(WarnMsgSysParamEnum.SYS_TIME.getName())) {
            String sysTime = SystemParamCalc.getSysTime(fixedValueSysParamBo.getSysDate());
            content = this.commonReplaceAll(content, "\\[" + WarnMsgSysParamEnum.SYS_TIME.getName() + "\\]", sysTime);
        }
        return content;
    }

    public String buildSysParamDataCount(String field, String content, int count) {
        if (StringUtils.isEmpty((String)field)) {
            return content;
        }
        if (count < 0) {
            count = 0;
        }
        if (field.equals(WarnMsgSysParamEnum.TOTAL.getName())) {
            String strCount = SystemParamCalc.getDataCount(count);
            content = this.commonReplaceAll(content, "\\[" + WarnMsgSysParamEnum.TOTAL.getName() + "\\]", strCount);
        }
        return content;
    }

    public Map<String, String> getAllFieldType(EarlyWarnContext context) {
        List<QueryFieldCommonBo> queryFieldList = context.getQueryFieldList();
        if (queryFieldList == null) {
            return null;
        }
        HashMap allFieldSNameTypes = Maps.newHashMapWithExpectedSize((int)16);
        for (QueryFieldCommonBo queryFieldCommonBo : queryFieldList) {
            allFieldSNameTypes.put("#" + queryFieldCommonBo.getFieldAlias(), queryFieldCommonBo.getValueType());
        }
        List<WarnCalFieldBo> calFieldList = context.getCalFieldList();
        if (calFieldList != null && calFieldList.size() > 0) {
            for (WarnCalFieldBo warnCalFieldBo : calFieldList) {
                String key = "#" + warnCalFieldBo.getFieldNumber();
                if (allFieldSNameTypes.containsKey(key)) continue;
                allFieldSNameTypes.put(key, warnCalFieldBo.getValueType());
            }
        }
        return allFieldSNameTypes;
    }

    public Map<String, MsgFieldFormatBo> getFieldFormatBoMap(EarlyWarnContext context) {
        List<QueryFieldCommonBo> queryFieldList = context.getQueryFieldList();
        if (queryFieldList == null) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        HashMap fieldFormatMap = Maps.newHashMapWithExpectedSize((int)queryFieldList.size());
        HashMap metaMap = Maps.newHashMapWithExpectedSize((int)queryFieldList.size());
        MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();
        for (QueryFieldCommonBo queryFieldCommonBo : queryFieldList) {
            DynamicProperty property;
            String entityNumber;
            if (DataTypeEnum.DATETIME.getDataTypeKey().equals(queryFieldCommonBo.getValueType()) || FieldControlType.TIME.getValue().equals(queryFieldCommonBo.getControlType())) {
                String entityId;
                entityNumber = queryFieldCommonBo.getEntityNumber();
                if (!HRStringUtils.isNotEmpty((String)entityNumber) || !HRStringUtils.isNotEmpty((String)queryFieldCommonBo.getFieldPath())) continue;
                String fieldNumber = queryFieldCommonBo.getFieldPath().replaceFirst(entityNumber + ".", "");
                FormMetadata runtimeMeta = (FormMetadata)metaMap.get(entityNumber);
                if (runtimeMeta == null && HRStringUtils.isNotEmpty((String)(entityId = MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Form)))) {
                    runtimeMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Form);
                    metaMap.put(entityNumber, runtimeMeta);
                }
                if (runtimeMeta == null) continue;
                List items = runtimeMeta.getItems();
                boolean find = false;
                for (ControlAp item : items) {
                    String key = item.getKey();
                    if (!(item instanceof FieldAp) || !fieldNumber.equals(key)) continue;
                    String displayFormatString = ((FieldAp)item).getDisplayFormatString();
                    String mask = ((FieldAp)item).getMask();
                    MsgFieldFormatBo formatBo = new MsgFieldFormatBo();
                    formatBo.setMask(mask);
                    formatBo.setDisplayFormatString(displayFormatString);
                    formatBo.setControlType(queryFieldCommonBo.getControlType());
                    fieldFormatMap.put("#" + queryFieldCommonBo.getFieldAlias(), formatBo);
                    find = true;
                    break;
                }
                if (find) continue;
                MsgFieldFormatBo formatBo = new MsgFieldFormatBo();
                formatBo.setControlType(queryFieldCommonBo.getControlType());
                fieldFormatMap.put("#" + queryFieldCommonBo.getFieldAlias(), formatBo);
                continue;
            }
            if (!FieldControlType.DECIMAL.getValue().equals(queryFieldCommonBo.getControlType()) || !HRStringUtils.isNotEmpty((String)(entityNumber = queryFieldCommonBo.getEntityNumber())) || !HRStringUtils.isNotEmpty((String)queryFieldCommonBo.getFieldPath())) continue;
            MainEntityType mainEntityType = mainEntityTypeUtil.getMainEntityType(entityNumber);
            String fieldNumber = queryFieldCommonBo.getFieldPath().replaceFirst(entityNumber + ".", "");
            if (mainEntityType == null || !((property = mainEntityType.getProperty(fieldNumber)) instanceof DecimalProp)) continue;
            MsgFieldFormatBo formatBo = new MsgFieldFormatBo();
            formatBo.setControlType(queryFieldCommonBo.getControlType());
            formatBo.setPrecision(((DecimalProp)property).getPrecision());
            formatBo.setScale(((DecimalProp)property).getScale());
            formatBo.setZeroShow(((DecimalProp)property).isZeroShow());
            fieldFormatMap.put("#" + queryFieldCommonBo.getFieldAlias(), formatBo);
        }
        return fieldFormatMap;
    }

    public MsgUserDateFormatBo getUserDateFormatBo(Long userId) {
        IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
        String dateFormatStr = service.getDateFormat(userId);
        Map timeFormatMap = service.getTimeFormat(Long.valueOf(RequestContext.get().getCurrUserId()));
        MsgUserDateFormatBo userDateFormatBo = new MsgUserDateFormatBo();
        String timeFormat = (String)timeFormatMap.get("timeFormat");
        userDateFormatBo.setDateFormat(dateFormatStr);
        userDateFormatBo.setDateTimeFormat(dateFormatStr + " " + timeFormat);
        userDateFormatBo.setTimeFormat(timeFormat);
        return userDateFormatBo;
    }

    public String buildCommonField(Map<String, String> commonFieldSNameTypes, String field, Row row, String content, boolean isTable, Map<String, MsgFieldFormatBo> dateFieldFormatMap, MsgUserDateFormatBo userDateFormat) {
        if (StringUtils.isEmpty((String)field) || field.length() < 2) {
            return content;
        }
        if (content == null) {
            return "";
        }
        String realFieldName = field.replaceAll("#", "");
        String strFieldValue = this.getStringFieldName(commonFieldSNameTypes, realFieldName, row, dateFieldFormatMap, userDateFormat);
        if (isTable) {
            return this.commonReplaceAll(content, field, strFieldValue);
        }
        return this.commonReplaceAll(content, "\\[" + field + "\\]", strFieldValue);
    }

    public String getStringFieldName(Map<String, String> commonFieldSNameTypes, String fieldName, Row row, Map<String, MsgFieldFormatBo> fieldFormatMap, MsgUserDateFormatBo userDateFormat) {
        String strFieldValue;
        String fieldType = commonFieldSNameTypes.get("#" + fieldName);
        if (DataTypeEnum.LONG.getDataTypeKey().equals(fieldType)) {
            Long lValue = row.getLong(fieldName);
            strFieldValue = lValue == null ? "" : String.valueOf(lValue);
        } else if (DataTypeEnum.STRING.getDataTypeKey().equals(fieldType)) {
            strFieldValue = row.getString(fieldName);
            if (strFieldValue == null) {
                strFieldValue = "";
            }
        } else if (DataTypeEnum.BOOLEAN.getDataTypeKey().equals(fieldType)) {
            Object bFiledValue = row.get(fieldName);
            strFieldValue = bFiledValue == null ? "" : String.valueOf(bFiledValue);
        } else if (DataTypeEnum.DATETIME.getDataTypeKey().equals(fieldType)) {
            Date dateFiledValue = row.getDate(fieldName);
            if (dateFiledValue == null) {
                strFieldValue = "";
            } else {
                MsgFieldFormatBo formatBo = fieldFormatMap.get("#" + fieldName);
                if (formatBo == null) {
                    strFieldValue = HRDateTimeUtils.format((Date)dateFiledValue, (String)"yyyy-MM-dd");
                } else {
                    String displayFormatString = formatBo.getDisplayFormatString();
                    String mask = formatBo.getMask();
                    String controlType = formatBo.getControlType();
                    if (HRStringUtils.isNotEmpty((String)displayFormatString)) {
                        try {
                            strFieldValue = HRDateTimeUtils.format((Date)dateFiledValue, (String)displayFormatString);
                            formatBo.setDateShowFormatMask(displayFormatString);
                        }
                        catch (Exception exception) {
                            log.error("getStringFieldName_format_date_error_", (Throwable)exception);
                            strFieldValue = displayFormatString;
                            formatBo.setDateShowFormatMask(displayFormatString);
                        }
                    } else if (HRStringUtils.isNotEmpty((String)mask)) {
                        try {
                            mask = mask.replace("D", "d");
                            strFieldValue = HRDateTimeUtils.format((Date)dateFiledValue, (String)mask);
                            formatBo.setDateShowFormatMask(mask);
                        }
                        catch (Exception exception) {
                            log.error("getStringFieldName_format_date_error_", (Throwable)exception);
                            strFieldValue = String.valueOf(dateFiledValue);
                        }
                    } else {
                        String userDateFormatStr = null;
                        if (FieldControlType.DATE.getValue().equals(controlType)) {
                            userDateFormatStr = userDateFormat.getDateFormat();
                        } else if (FieldControlType.DATE_TIME.getValue().equals(controlType)) {
                            userDateFormatStr = userDateFormat.getDateTimeFormat();
                        }
                        if (HRStringUtils.isNotEmpty((String)userDateFormatStr)) {
                            try {
                                strFieldValue = HRDateTimeUtils.format((Date)dateFiledValue, (String)userDateFormatStr);
                                formatBo.setDateShowFormatMask(userDateFormatStr);
                            }
                            catch (Exception exception) {
                                log.error("getStringFieldName_format_date_error_", (Throwable)exception);
                                strFieldValue = String.valueOf(dateFiledValue);
                            }
                        } else if (FieldControlType.DATE_TIME.getValue().equals(controlType)) {
                            strFieldValue = HRDateTimeUtils.format((Date)dateFiledValue, (String)"yyyy-MM-dd HH:mm:ss");
                            formatBo.setDateShowFormatMask("yyyy-MM-dd HH:mm:ss");
                        } else {
                            strFieldValue = HRDateTimeUtils.format((Date)dateFiledValue, (String)"yyyy-MM-dd");
                            formatBo.setDateShowFormatMask("yyyy-MM-dd");
                        }
                    }
                }
            }
        } else if (DataTypeEnum.BIGDECIMAL.getDataTypeKey().equals(fieldType)) {
            MsgFieldFormatBo fieldFormatBo;
            BigDecimal bdFiledValue = row.getBigDecimal(fieldName);
            strFieldValue = bdFiledValue == null ? "" : (BigDecimal.ZERO.compareTo(bdFiledValue = (fieldFormatBo = fieldFormatMap.get("#" + fieldName)) != null ? bdFiledValue.setScale(fieldFormatBo.getScale(), RoundingMode.HALF_UP) : bdFiledValue.setScale(10, RoundingMode.HALF_UP)) == 0 ? (fieldFormatBo != null && !fieldFormatBo.isZeroShow() ? "" : bdFiledValue.toPlainString()) : bdFiledValue.toPlainString());
        } else if (DataTypeEnum.INTEGER.getDataTypeKey().equals(fieldType)) {
            Integer iFiledValue = row.getInteger(fieldName);
            MsgFieldFormatBo formatBo = fieldFormatMap.get("#" + fieldName);
            if (formatBo != null && FieldControlType.TIME.getValue().equals(formatBo.getControlType())) {
                String mask = formatBo.getMask();
                String format = HRStringUtils.isNotEmpty((String)mask) ? mask : (HRStringUtils.isNotEmpty((String)userDateFormat.getTimeFormat()) ? userDateFormat.getTimeFormat() : "HH:mm:ss");
                if (iFiledValue == -1) {
                    strFieldValue = "";
                } else {
                    Date date = new DateTime().withTimeAtStartOfDay().withMillisOfDay(iFiledValue * 1000).toDate();
                    strFieldValue = HRDateTimeUtils.format((Date)date, (String)format);
                }
                formatBo.setDateShowFormatMask(format);
            } else {
                strFieldValue = iFiledValue == null ? "" : String.valueOf(iFiledValue);
            }
        } else {
            Object objValue;
            ILocaleString oFiledValue;
            strFieldValue = DataTypeEnum.LOCALESTRING.getDataTypeKey().equals(fieldType) ? ((oFiledValue = (ILocaleString)row.get(fieldName)) == null ? "" : String.valueOf(oFiledValue.getLocaleValue())) : ((objValue = row.get(fieldName)) != null && HRStringUtils.isNotEmpty((String)String.valueOf(objValue)) ? String.valueOf(objValue) : "");
        }
        return strFieldValue;
    }

    public String commonReplaceAll(String content, String regex, String replacement) {
        if (StringUtils.isEmpty((String)content)) {
            return "";
        }
        if (StringUtils.isEmpty((String)regex)) {
            return content;
        }
        if (replacement == null) {
            replacement = "";
        }
        try {
            content = content.replaceAll(regex, replacement);
            return content;
        }
        catch (Exception ex) {
            log.error("HR warn parse message error! content,{},regex{},replacement{},message: {}", new Object[]{content, regex, replacement, ex.getMessage()});
            return content;
        }
    }
}

