/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.serivce.impl.message;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Row;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.message.HRMessageInfo;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.message.MsgFieldsTypes;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.serivce.impl.message.AbstractMessageBuilder;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.serivce.impl.message.MessageBuilderHelper;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.serivce.impl.message.model.MsgFieldFormatBo;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.serivce.impl.message.model.MsgUserDateFormatBo;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.serivce.impl.message.systemparam.SystemParamCalc;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.EarlyWarnContext;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.message.FixedValueSysParamBo;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.message.MessageContentConfigBo;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.message.MessageFieldTypesBo;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.message.MessageTableConfigBo;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.message.WarnUserDataBo;
import kd.hr.hrcs.common.constants.earlywarn.WarnMsgSysParamEnum;

@ExcludeFromJacocoGeneratedReport
public class SplitMessageBuilder
extends AbstractMessageBuilder {
    private static volatile SplitMessageBuilder service = null;

    private SplitMessageBuilder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SplitMessageBuilder getInstance() {
        if (service != null) return service;
        Class<SplitMessageBuilder> clazz = SplitMessageBuilder.class;
        synchronized (SplitMessageBuilder.class) {
            if (service != null) return service;
            service = new SplitMessageBuilder();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    @Override
    public void buildMessage(EarlyWarnContext context) {
        Map<String, String> commonFieldSNameTypes = MessageBuilderHelper.getInstance().getAllFieldType(context);
        if (commonFieldSNameTypes == null) {
            return;
        }
        Map<String, MsgFieldFormatBo> fieldFormatBoMap = MessageBuilderHelper.getInstance().getFieldFormatBoMap(context);
        context.setFieldFormatBoMap(fieldFormatBoMap);
        List<MessageContentConfigBo> msgContentConfigList = context.getMsgContentConfigList();
        List<MessageFieldTypesBo> messageFieldTypesBoList = MessageBuilderHelper.getInstance().buildMsgFieldsTypes(context);
        ArrayList hrMessageInfoList = Lists.newArrayListWithExpectedSize((int)10);
        context.setHrMessageInfoList(hrMessageInfoList);
        for (MessageFieldTypesBo messageFieldTypesBo : messageFieldTypesBoList) {
            for (MessageContentConfigBo messageContentConfigBo : msgContentConfigList) {
                if (!MessageBuilderHelper.getInstance().hasFieldVariable(messageFieldTypesBo, true)) {
                    this.noParamBuildInfo(context, messageContentConfigBo, hrMessageInfoList);
                    return;
                }
                HRMessageInfo hrMessageInfo = this.buildFixedValueSysParams(messageContentConfigBo);
                hrMessageInfo.setChannel(messageContentConfigBo.getChannel());
                this.buildCommonFieldsAndTotal(hrMessageInfo, context, messageFieldTypesBo, commonFieldSNameTypes, hrMessageInfoList);
                MessageBuilderHelper.getInstance().buildSysParamsUserList(context, hrMessageInfoList, messageFieldTypesBo);
                this.buildContent(hrMessageInfoList);
            }
        }
    }

    private HRMessageInfo buildFixedValueSysParams(MessageContentConfigBo messageContentConfigBo) {
        List<MessageTableConfigBo> msgTable = messageContentConfigBo.getMsgTable();
        String msgTitle = messageContentConfigBo.getMsgTitle();
        String msgMain = messageContentConfigBo.getMsgMain();
        String msgEnd = messageContentConfigBo.getMsgEnd();
        HRMessageInfo hrMessageInfo = new HRMessageInfo();
        Date date = HRDateTimeUtils.getNowDateTime();
        FixedValueSysParamBo fixedValueSysParamBo = new FixedValueSysParamBo();
        fixedValueSysParamBo.setSysDate(date);
        msgTitle = this.buildFixedValueSysParams(msgTitle, fixedValueSysParamBo);
        hrMessageInfo.setTitle(msgTitle);
        msgMain = this.buildFixedValueSysParams(msgMain, fixedValueSysParamBo);
        hrMessageInfo.setMsgMain(msgMain);
        msgEnd = this.buildFixedValueSysParams(msgEnd, fixedValueSysParamBo);
        hrMessageInfo.setMsgEnd(msgEnd);
        this.buildTableFixedValueSysParam(msgTable, fixedValueSysParamBo);
        ArrayList msgTableLists = Lists.newArrayListWithExpectedSize((int)10);
        msgTableLists.add(msgTable);
        hrMessageInfo.setMsgTableLists(msgTableLists);
        return hrMessageInfo;
    }

    @Override
    public String buildFixedValueSysParams(String content, FixedValueSysParamBo fixedValueSysParamBo) {
        if (StringUtils.isEmpty((String)content) || fixedValueSysParamBo == null) {
            return StringUtils.getEmpty();
        }
        String sysDate = SystemParamCalc.getSysDate(fixedValueSysParamBo.getSysDate());
        content = MessageBuilderHelper.getInstance().commonReplaceAll(content, "\\[" + WarnMsgSysParamEnum.SYS_DATE.getName() + "\\]", sysDate);
        String sysTime = SystemParamCalc.getSysTime(fixedValueSysParamBo.getSysDate());
        content = MessageBuilderHelper.getInstance().commonReplaceAll(content, "\\[" + WarnMsgSysParamEnum.SYS_TIME.getName() + "\\]", sysTime);
        return content;
    }

    private void buildTableFixedValueSysParam(List<MessageTableConfigBo> msgTable, FixedValueSysParamBo fixedValueSysParamBo) {
        if (CollectionUtils.isEmpty(msgTable) || fixedValueSysParamBo == null) {
            return;
        }
        for (MessageTableConfigBo messageTableConfigBo : msgTable) {
            String fieldValue;
            String fieldName = messageTableConfigBo.getFieldName();
            if (StringUtils.isEmpty((String)fieldName)) continue;
            if (fieldName.equals(WarnMsgSysParamEnum.SYS_DATE.getName()) || fieldName.equals(WarnMsgSysParamEnum.SYS_TIME.getName())) {
                fieldValue = "[" + fieldName + "]";
                fieldValue = this.buildFixedValueSysParams(fieldValue, fixedValueSysParamBo);
            } else {
                fieldValue = fieldName;
            }
            messageTableConfigBo.setFieldValue(fieldValue);
        }
    }

    private void buildCommonFieldsAndTotal(HRMessageInfo hrMessageInfo, EarlyWarnContext context, MessageFieldTypesBo messageFieldTypesBo, Map<String, String> commonFieldSNameTypes, List<HRMessageInfo> hrMessageInfoList) {
        List<WarnUserDataBo> warnUserDataBoList = context.getWarnUserDataBoList();
        if (CollectionUtils.isEmpty(warnUserDataBoList)) {
            return;
        }
        Map<String, MsgFieldFormatBo> fieldFormatBoMap = context.getFieldFormatBoMap();
        MsgFieldsTypes msgFieldsTypesTitle = messageFieldTypesBo.getMsgFieldsTypesTitle();
        MsgFieldsTypes msgFieldsTypesMain = messageFieldTypesBo.getMsgFieldsTypesMain();
        MsgFieldsTypes msgFieldsTypesEnd = messageFieldTypesBo.getMsgFieldsTypesEnd();
        MsgFieldsTypes msgFieldsTypesTable = messageFieldTypesBo.getMsgFieldsTypesTable();
        List<String> titleCommonFields = null;
        if (msgFieldsTypesTitle != null) {
            titleCommonFields = msgFieldsTypesTitle.getCommonFields();
        }
        List<String> mainCommonFields = null;
        if (msgFieldsTypesMain != null) {
            mainCommonFields = msgFieldsTypesMain.getCommonFields();
        }
        List<String> endCommonFields = null;
        if (msgFieldsTypesEnd != null) {
            endCommonFields = msgFieldsTypesEnd.getCommonFields();
        }
        List<String> tableCommonFields = null;
        if (msgFieldsTypesTable != null) {
            tableCommonFields = msgFieldsTypesTable.getCommonFields();
        }
        List<List<MessageTableConfigBo>> msgTableLists = hrMessageInfo.getMsgTableLists();
        for (WarnUserDataBo warnUserDataBo : warnUserDataBoList) {
            MsgUserDateFormatBo userDateFormat;
            Map<String, List<Row>> bodyListGroupMap;
            List<Row> bodyList = warnUserDataBo.getBodyList();
            Long receiverUserId = warnUserDataBo.getReceiverUserId();
            if (CollectionUtils.isEmpty(bodyList) || receiverUserId == null || (bodyListGroupMap = this.buildGroupBodyList(commonFieldSNameTypes, bodyList, context, userDateFormat = MessageBuilderHelper.getInstance().getUserDateFormatBo(receiverUserId))) == null || bodyListGroupMap.isEmpty()) continue;
            for (Map.Entry<String, List<Row>> entry : bodyListGroupMap.entrySet()) {
                List<Row> groupRowList = entry.getValue();
                if (CollectionUtils.isEmpty(groupRowList)) continue;
                int count = groupRowList.size();
                HRMessageInfo hrMessageInfoNew = new HRMessageInfo();
                String newTitle = this.buildCommonFieldMapWithOutTable(titleCommonFields, hrMessageInfo.getTitle(), commonFieldSNameTypes, groupRowList, fieldFormatBoMap, userDateFormat);
                newTitle = MessageBuilderHelper.getInstance().buildSysParamDataCount(WarnMsgSysParamEnum.TOTAL.getName(), newTitle, count);
                hrMessageInfoNew.setTitle(newTitle);
                String newMain = this.buildCommonFieldMapWithOutTable(mainCommonFields, hrMessageInfo.getMsgMain(), commonFieldSNameTypes, groupRowList, fieldFormatBoMap, userDateFormat);
                newMain = MessageBuilderHelper.getInstance().buildSysParamDataCount(WarnMsgSysParamEnum.TOTAL.getName(), newMain, count);
                hrMessageInfoNew.setMsgMain(newMain);
                String newEnd = this.buildCommonFieldMapWithOutTable(endCommonFields, hrMessageInfo.getMsgEnd(), commonFieldSNameTypes, groupRowList, fieldFormatBoMap, userDateFormat);
                newEnd = MessageBuilderHelper.getInstance().buildSysParamDataCount(WarnMsgSysParamEnum.TOTAL.getName(), newEnd, count);
                hrMessageInfoNew.setMsgEnd(newEnd);
                List<List<MessageTableConfigBo>> newTableLists = this.buildCommonFieldMapForTable(commonFieldSNameTypes, tableCommonFields, msgTableLists, groupRowList, fieldFormatBoMap, userDateFormat);
                this.buildTableSysParamDataCount(newTableLists);
                hrMessageInfoNew.setMsgTableLists(newTableLists);
                hrMessageInfoNew.setReceiverUserIds(Lists.newArrayList((Object[])new Long[]{receiverUserId}));
                hrMessageInfoList.add(hrMessageInfoNew);
            }
        }
    }

    private void buildTableSysParamDataCount(List<List<MessageTableConfigBo>> newTableLists) {
        if (newTableLists == null || newTableLists.size() == 0) {
            return;
        }
        for (List<MessageTableConfigBo> messageTableConfigBoList : newTableLists) {
            if (CollectionUtils.isEmpty(messageTableConfigBoList)) continue;
            for (MessageTableConfigBo messageTableConfigBo : messageTableConfigBoList) {
                String fieldName = messageTableConfigBo.getFieldName();
                if (StringUtils.isEmpty((String)fieldName)) {
                    return;
                }
                if (!WarnMsgSysParamEnum.TOTAL.getName().equals(fieldName)) continue;
                messageTableConfigBo.setFieldValue(String.valueOf(newTableLists.size()));
            }
        }
    }

    private List<List<MessageTableConfigBo>> buildCommonFieldMapForTable(Map<String, String> commonFieldSNameTypes, List<String> tableCommonFields, List<List<MessageTableConfigBo>> msgTableLists, List<Row> groupRowList, Map<String, MsgFieldFormatBo> dateFieldFormatMap, MsgUserDateFormatBo userDateFormat) {
        if (CollectionUtils.isEmpty(msgTableLists) || CollectionUtils.isEmpty(groupRowList) && msgTableLists.size() != 1) {
            return null;
        }
        List<MessageTableConfigBo> messageTableConfigBos = msgTableLists.get(0);
        if (CollectionUtils.isEmpty(messageTableConfigBos)) {
            return null;
        }
        Set tableCommonFieldsSet = null;
        if (CollectionUtils.isNotEmpty(tableCommonFields)) {
            tableCommonFieldsSet = tableCommonFields.stream().collect(Collectors.toSet());
        }
        ArrayList newTableLists = Lists.newArrayListWithExpectedSize((int)10);
        for (Row row : groupRowList) {
            ArrayList newTableList = Lists.newArrayListWithExpectedSize((int)10);
            for (MessageTableConfigBo messageTableConfigBo : messageTableConfigBos) {
                MessageTableConfigBo newMessageTableConfigBo = new MessageTableConfigBo();
                String filedName = messageTableConfigBo.getFieldName();
                newMessageTableConfigBo.setLineTitle(messageTableConfigBo.getLineTitle());
                newMessageTableConfigBo.setFieldName(filedName);
                if (tableCommonFieldsSet != null && tableCommonFieldsSet.contains(filedName)) {
                    String filedValue = messageTableConfigBo.getFieldValue();
                    String newFieldValue = MessageBuilderHelper.getInstance().buildCommonField(commonFieldSNameTypes, filedName, row, filedValue, true, dateFieldFormatMap, userDateFormat);
                    newMessageTableConfigBo.setFieldValue(newFieldValue);
                } else {
                    newMessageTableConfigBo.setFieldValue(messageTableConfigBo.getFieldValue());
                }
                if (StringUtils.isNotEmpty((String)filedName) || filedName.length() >= 2) {
                    newMessageTableConfigBo.setOriginalValue(row.get(filedName.replaceAll("#", "")));
                }
                newTableList.add(newMessageTableConfigBo);
            }
            newTableLists.add(newTableList);
        }
        return newTableLists;
    }
}

