/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.serivce.impl.receiver.prerelation;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.serivce.impl.receiver.prerelation.ReceiverPreDeptLeaderProcessor;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.serivce.impl.receiver.prerelation.ReceiverPreLeaderProcessor;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.serivce.impl.receiver.prerelation.ReceiverPreSelfProcessor;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.EarlyWarnContext;
import kd.hr.hrcs.common.constants.earlywarn.ReceiverRelationType;
import org.apache.curator.shaded.com.google.common.collect.Lists;

@ExcludeFromJacocoGeneratedReport
public class ReceiverPreRelationProcessor {
    private static volatile ReceiverPreRelationProcessor service = null;

    private ReceiverPreRelationProcessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ReceiverPreRelationProcessor getInstance() {
        if (service != null) return service;
        Class<ReceiverPreRelationProcessor> clazz = ReceiverPreRelationProcessor.class;
        synchronized (ReceiverPreRelationProcessor.class) {
            if (service != null) return service;
            service = new ReceiverPreRelationProcessor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public void parseUsers(EarlyWarnContext context) {
        DataSet dataSet = context.getDataSet();
        DataSet dataSetSelf = dataSet.copy();
        DataSet dataSetLeader = dataSet.copy();
        DataSet dataSetDeptLeader = dataSet.copy();
        DynamicObject dynamicObject = context.getWarnScheme();
        DynamicObject dyWarnScene = context.getWarnScene();
        DynamicObjectCollection rcRelationEntryColl = dynamicObject.getDynamicObjectCollection("rcrelationentryentity");
        if (null == rcRelationEntryColl || rcRelationEntryColl.isEmpty()) {
            return;
        }
        Map<String, Set<String>> resultMap = this.groupReceiver(rcRelationEntryColl);
        ArrayList userResult = Lists.newArrayListWithExpectedSize((int)10);
        if (resultMap.containsKey(ReceiverRelationType.SELF.getType())) {
            userResult.addAll(ReceiverPreSelfProcessor.getInstance().parseUsersList(dataSetSelf, dyWarnScene, resultMap.get(ReceiverRelationType.SELF.getType())));
        } else {
            dataSetSelf.close();
        }
        if (resultMap.containsKey(ReceiverRelationType.LEADER.getType())) {
            userResult.addAll(ReceiverPreLeaderProcessor.getInstance().parseUsersList(dataSetLeader, dyWarnScene, resultMap.get(ReceiverRelationType.LEADER.getType())));
        } else {
            dataSetLeader.close();
        }
        if (resultMap.containsKey(ReceiverRelationType.DEPT_LEADER.getType())) {
            userResult.addAll(ReceiverPreDeptLeaderProcessor.getInstance().parseUsersList(dataSetDeptLeader, dyWarnScene, resultMap.get(ReceiverRelationType.DEPT_LEADER.getType())));
        } else {
            dataSetDeptLeader.close();
        }
        context.setUserRelationResult(userResult);
    }

    private Map<String, Set<String>> groupReceiver(DynamicObjectCollection dynamicObjectCollection) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dyEntry : dynamicObjectCollection) {
            this.buildRelationMap(resultMap, dyEntry);
        }
        return resultMap;
    }

    private void buildRelationMap(Map<String, Set<String>> resultMap, DynamicObject dyEntry) {
        String[] rcRelationShipArr;
        String rcRelationShips = dyEntry.getString("rcrelationship");
        if (StringUtils.isBlank((String)rcRelationShips)) {
            return;
        }
        for (String rcRelationShip : rcRelationShipArr = rcRelationShips.split(",")) {
            if (StringUtils.isBlank((String)rcRelationShip)) continue;
            HashSet rcFieldList = resultMap.get(rcRelationShip);
            if (rcFieldList == null) {
                rcFieldList = Sets.newHashSetWithExpectedSize((int)16);
                resultMap.put(rcRelationShip, rcFieldList);
            }
            rcFieldList.add(dyEntry.getString("rcuser"));
        }
    }
}

