/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.domain.service.earlywarn.model.msgpersist;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.message.HRMessageInfo;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.serivce.impl.message.model.MsgFieldFormatBo;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.EarlyWarnContext;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.message.MessageTableConfigBo;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.msgpersist.MsgDataHeadFieldBo;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.msgpersist.MsgDataReceiverBo;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.msgpersist.MsgDataRowBo;
import kd.hr.hrcs.common.model.earlywarn.WarnCalFieldBo;

public class MsgDataPersistBo {
    private static final Log LOGGER = LogFactory.getLog(MsgDataPersistBo.class);
    private static final HRBaseServiceHelper USER_HELPER = new HRBaseServiceHelper("bos_user");
    private String logId;
    private long warnSchemeId;
    private List<MsgDataHeadFieldBo> msgDataHeadFieldBos;
    private List<MsgDataRowBo> msgDataRowBos;
    private List<MsgDataReceiverBo> receiverBos;
    private String msgTitle;
    private String msgMain;
    private String msgEnd;

    public String getLogId() {
        return this.logId;
    }

    public void setLogId(String logId) {
        this.logId = logId;
    }

    public long getWarnSchemeId() {
        return this.warnSchemeId;
    }

    public void setWarnSchemeId(long warnSchemeId) {
        this.warnSchemeId = warnSchemeId;
    }

    public List<MsgDataReceiverBo> getReceiverBos() {
        return this.receiverBos;
    }

    public void setReceiverBos(List<MsgDataReceiverBo> receiverBos) {
        this.receiverBos = receiverBos;
    }

    public List<MsgDataHeadFieldBo> getMsgDataHeadFieldBos() {
        return this.msgDataHeadFieldBos;
    }

    public void setMsgDataHeadFieldBos(List<MsgDataHeadFieldBo> msgDataHeadFieldBos) {
        this.msgDataHeadFieldBos = msgDataHeadFieldBos;
    }

    public List<MsgDataRowBo> getMsgDataRowBos() {
        return this.msgDataRowBos;
    }

    public void setMsgDataRowBos(List<MsgDataRowBo> msgDataRowBos) {
        this.msgDataRowBos = msgDataRowBos;
    }

    public String getMsgTitle() {
        return this.msgTitle;
    }

    public void setMsgTitle(String msgTitle) {
        this.msgTitle = msgTitle;
    }

    public String getMsgMain() {
        return this.msgMain;
    }

    public void setMsgMain(String msgMain) {
        this.msgMain = msgMain;
    }

    public String getMsgEnd() {
        return this.msgEnd;
    }

    public void setMsgEnd(String msgEnd) {
        this.msgEnd = msgEnd;
    }

    public static MsgDataPersistBo buildPersistBo(EarlyWarnContext context, HRMessageInfo messageInfo) {
        List<Long> receiverUserIds;
        List<QueryFieldCommonBo> queryFieldList = context.getQueryFieldList();
        Map queryFieldCommonBoMap = queryFieldList.stream().collect(Collectors.toMap(QueryFieldCommonBo::getFieldAlias, Function.identity(), (x, y) -> y));
        List<WarnCalFieldBo> calFieldList = context.getCalFieldList();
        Map warnCalFieldBoMap = calFieldList.stream().collect(Collectors.toMap(WarnCalFieldBo::getFieldNumber, Function.identity(), (x, y) -> y));
        Map<String, MsgFieldFormatBo> fieldFormatBoMap = context.getFieldFormatBoMap();
        MsgDataPersistBo msgDataPersistBo = new MsgDataPersistBo();
        msgDataPersistBo.setLogId(String.valueOf(context.getEarlyWarnLogId()));
        msgDataPersistBo.setWarnSchemeId(Long.parseLong(String.valueOf(context.getWarnScheme().getPkValue())));
        msgDataPersistBo.setMsgTitle(messageInfo.getTitle());
        msgDataPersistBo.setMsgMain(messageInfo.getMsgMain());
        msgDataPersistBo.setMsgEnd(messageInfo.getMsgEnd());
        List<List<MessageTableConfigBo>> msgTableLists = messageInfo.getMsgTableLists();
        if (msgTableLists != null && !msgTableLists.isEmpty()) {
            ArrayList rowDataBos = Lists.newArrayListWithExpectedSize((int)msgTableLists.size());
            for (int line = 0; line < msgTableLists.size(); ++line) {
                List<MessageTableConfigBo> messageDataBos;
                List<MessageTableConfigBo> messageHeadConfigBos;
                if (line == 0 && (messageHeadConfigBos = msgTableLists.get(line)) != null && !messageHeadConfigBos.isEmpty()) {
                    ArrayList fieldBos = Lists.newArrayListWithExpectedSize((int)messageHeadConfigBos.size());
                    for (MessageTableConfigBo headConfigBo : messageHeadConfigBos) {
                        MsgFieldFormatBo fieldFormatBo;
                        MsgDataHeadFieldBo msgDataHeadFieldBo = new MsgDataHeadFieldBo();
                        msgDataHeadFieldBo.setFieldAlias(headConfigBo.getFieldName().replaceFirst("#", ""));
                        msgDataHeadFieldBo.setFieldName(headConfigBo.getLineTitle());
                        QueryFieldCommonBo queryFieldCommonBo = (QueryFieldCommonBo)queryFieldCommonBoMap.get(msgDataHeadFieldBo.getFieldAlias());
                        if (queryFieldCommonBo != null) {
                            msgDataHeadFieldBo.setDataType(queryFieldCommonBo.getValueType());
                            msgDataHeadFieldBo.setControlType(queryFieldCommonBo.getControlType());
                            msgDataHeadFieldBo.setComplexType(queryFieldCommonBo.getComplexType());
                            msgDataHeadFieldBo.setFieldPath(queryFieldCommonBo.getFieldPath());
                            msgDataHeadFieldBo.setEntityNumber(queryFieldCommonBo.getEntityNumber());
                            msgDataHeadFieldBo.setBaseDataNum(queryFieldCommonBo.getBaseDataNum());
                            if (HRStringUtils.isNotEmpty((String)queryFieldCommonBo.getEntityNumber())) {
                                msgDataHeadFieldBo.setFieldPath(queryFieldCommonBo.getFieldPath().replaceFirst(queryFieldCommonBo.getEntityNumber() + ".", ""));
                            }
                        } else {
                            WarnCalFieldBo warnCalFieldBo = (WarnCalFieldBo)warnCalFieldBoMap.get(msgDataHeadFieldBo.getFieldAlias());
                            if (warnCalFieldBo != null) {
                                msgDataHeadFieldBo.setDataType(warnCalFieldBo.getValueType());
                            } else {
                                msgDataHeadFieldBo.setDataType(DataTypeEnum.STRING.getDataTypeKey());
                            }
                        }
                        if ((fieldFormatBo = fieldFormatBoMap.get(headConfigBo.getFieldName())) != null) {
                            msgDataHeadFieldBo.setPrecision(fieldFormatBo.getPrecision());
                            msgDataHeadFieldBo.setScale(fieldFormatBo.getScale());
                            msgDataHeadFieldBo.setMask(fieldFormatBo.getMask());
                            msgDataHeadFieldBo.setDisplayDateFormatString(fieldFormatBo.getDisplayFormatString());
                            msgDataHeadFieldBo.setDateShowFormatMask(fieldFormatBo.getDateShowFormatMask());
                            msgDataHeadFieldBo.setZeroShow(fieldFormatBo.isZeroShow());
                        }
                        fieldBos.add(msgDataHeadFieldBo);
                    }
                    LOGGER.info("setMsgDataHeadFieldBos_{}", (Object)fieldBos);
                    msgDataPersistBo.setMsgDataHeadFieldBos(fieldBos);
                }
                if ((messageDataBos = msgTableLists.get(line)) == null) continue;
                List<MsgDataHeadFieldBo> msgDataHeadFieldBos = msgDataPersistBo.getMsgDataHeadFieldBos();
                MsgDataRowBo rowBo = new MsgDataRowBo();
                ArrayList columnData = Lists.newArrayListWithExpectedSize((int)messageDataBos.size());
                LOGGER.info("messageDataBos_size_{}", (Object)messageDataBos.size());
                for (int index = 0; index < messageDataBos.size(); ++index) {
                    Object originalValue;
                    MessageTableConfigBo messageDataBo = messageDataBos.get(index);
                    MsgDataHeadFieldBo msgDataHeadFieldBo = msgDataHeadFieldBos.get(index);
                    String fieldValue = messageDataBo.getFieldValue();
                    if (DataTypeEnum.BOOLEAN.getDataTypeKey().equals(msgDataHeadFieldBo.getDataType())) {
                        String yes = ResManager.loadKDString((String)"\u662f", (String)"MsgDataPersistBo_0", (String)"hrmp-hrcs-warn-business", (Object[])new Object[0]);
                        fieldValue = fieldValue == null ? "false" : String.valueOf(yes.equals(fieldValue));
                    } else if (DataTypeEnum.DATETIME.getDataTypeKey().equals(msgDataHeadFieldBo.getDataType())) {
                        originalValue = messageDataBo.getOriginalValue();
                        if (originalValue instanceof Date) {
                            fieldValue = String.valueOf(((Date)originalValue).getTime());
                        }
                    } else if (FieldControlType.TIME.getValue().equals(msgDataHeadFieldBo.getControlType()) && (originalValue = messageDataBo.getOriginalValue()) instanceof Integer) {
                        fieldValue = String.valueOf(originalValue);
                    }
                    columnData.add(fieldValue);
                }
                rowBo.setColumnData(columnData);
                rowDataBos.add(rowBo);
            }
            msgDataPersistBo.setMsgDataRowBos(rowDataBos);
        }
        if ((receiverUserIds = messageInfo.getReceiverUserIds()) != null && !receiverUserIds.isEmpty()) {
            receiverUserIds.removeIf(Objects::isNull);
            receiverUserIds.removeIf(id -> id == 0L);
            DynamicObject[] userDys = USER_HELPER.queryOriginalArray("id,name", new QFilter[]{new QFilter("id", "in", receiverUserIds)});
            Map<Object, String> userMap = Arrays.stream(userDys).collect(Collectors.toMap(dy -> dy.get("id"), dy -> dy.getString("name")));
            ArrayList receiverBos = Lists.newArrayListWithExpectedSize((int)receiverUserIds.size());
            for (Long receiverUserId : receiverUserIds) {
                MsgDataReceiverBo receiverBo = new MsgDataReceiverBo();
                receiverBo.setReceiverId(String.valueOf(receiverUserId));
                String userName = userMap.get(receiverUserId);
                receiverBo.setReceiverName(userName);
                receiverBos.add(receiverBo);
            }
            msgDataPersistBo.setReceiverBos(receiverBos);
        }
        return msgDataPersistBo;
    }

    public String toString() {
        return "MsgDataPersistBo{logId='" + this.logId + '\'' + ", warnSchemeId=" + this.warnSchemeId + ", msgDataHeadFieldBos=" + this.msgDataHeadFieldBos + ", msgDataRowBos=" + this.msgDataRowBos + ", receiverBos=" + this.receiverBos + ", msgTitle='" + this.msgTitle + '\'' + ", msgMain='" + this.msgMain + '\'' + ", msgEnd='" + this.msgEnd + '\'' + '}';
    }
}

