/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.domain.service.earlywarn.plan;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.inte.service.InteServiceImpl;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.schedule.api.RepeatModeEnum;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.plan.EarlyWarningTask;
import kd.hr.hrcs.common.constants.earlywarn.WarnRepeatPeriodEnum;

@ExcludeFromJacocoGeneratedReport
public class WarnJobAndPlanService {
    private static final Log LOGGER = LogFactory.getLog(WarnJobAndPlanService.class);
    private static volatile WarnJobAndPlanService service = null;
    private static final String JOB_NUMBER_PREFIX = "hr_ew_job_";
    private static final String PLAN_NUMBER_PREFIX = "hr_ew_plan_";
    private static final String APP = "hrcs";

    private WarnJobAndPlanService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WarnJobAndPlanService getInstance() {
        if (service != null) return service;
        Class<WarnJobAndPlanService> clazz = WarnJobAndPlanService.class;
        synchronized (WarnJobAndPlanService.class) {
            if (service != null) return service;
            service = new WarnJobAndPlanService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    protected String getNamePreFix() {
        return ResManager.loadKDString((String)"HR\u9884\u8b66", (String)"WarnJobAndPlanService_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
    }

    protected String getTaskClassName() {
        return EarlyWarningTask.class.getName();
    }

    public void createJobAndPlan(DynamicObject dynamicObject) {
        try {
            this.removeOldJobAndPlan(dynamicObject);
            String jobId = this.createJob(dynamicObject);
            this.createPlan(dynamicObject, jobId);
        }
        catch (Exception exp) {
            LOGGER.error("createJobAndPlan error: {}", (Object)exp.getMessage());
            LOGGER.error((Throwable)exp);
            throw new KDBizException(exp.getMessage());
        }
    }

    private void removeOldJobAndPlan(DynamicObject dynamicObject) {
        String oldJobId;
        String[] planIds;
        ScheduleServiceHelper scheduleServiceHelper = new ScheduleServiceHelper();
        String oldPlanId = dynamicObject.getString("planid");
        if (StringUtils.isNotEmpty((String)oldPlanId) && (planIds = oldPlanId.split(",")) != null) {
            for (String planId : planIds) {
                ScheduleServiceHelper.deletePlan((String)planId);
            }
        }
        if (StringUtils.isNotEmpty((String)(oldJobId = dynamicObject.getString("jobid")))) {
            ScheduleServiceHelper.deleteJob((String)oldJobId);
        }
    }

    private String createJob(DynamicObject dynamicObject) {
        String schemeNumber = dynamicObject.getString("number");
        String schemeName = dynamicObject.getString("name");
        String jobNumber = JOB_NUMBER_PREFIX + schemeNumber;
        JobInfo jobInfo = new JobInfo();
        String jobId = UUID.randomUUID().toString();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId(APP);
        jobInfo.setJobType(JobType.BIZ);
        jobInfo.setTaskClassname(this.getTaskClassName());
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setName(this.getNamePreFix() + "job_" + schemeName);
        jobInfo.setId(jobId);
        jobInfo.setNumber(jobNumber);
        jobInfo.setEnable(true);
        HashMap mapParam = Maps.newHashMapWithExpectedSize((int)1);
        Long schemeId = dynamicObject.getLong("id");
        mapParam.put("warnSchemeId", String.valueOf(schemeId));
        DynamicObject warn_scene = dynamicObject.getDynamicObject("warnscene");
        mapParam.put("warnSceneId", warn_scene.getLong("id"));
        jobInfo.setParams((Map)mapParam);
        dynamicObject.set("jobid", (Object)jobId);
        return ScheduleServiceHelper.createJob((JobInfo)jobInfo);
    }

    private void createPlan(DynamicObject dynamicObject, String jobId) {
        Boolean enableNewVersion;
        String schemeNumber = dynamicObject.getString("number");
        String schemeName = dynamicObject.getString("name");
        Date startDate = dynamicObject.getDate("startdate");
        Calendar startTime = Calendar.getInstance();
        startTime.setTime(startDate);
        Date endDate = dynamicObject.getDate("enddate");
        Calendar endTime = Calendar.getInstance();
        endTime.setTime(endDate);
        DynamicObject timeZone = dynamicObject.getDynamicObject("timezone");
        String planNumber = PLAN_NUMBER_PREFIX + schemeNumber;
        PlanInfo planInfo = new PlanInfo();
        planInfo.setPeriod(1);
        planInfo.setJobId(jobId);
        planInfo.setNumber(planNumber);
        planInfo.setName(this.getNamePreFix() + "plan_" + schemeName);
        endTime.add(11, 23);
        endTime.add(12, 59);
        endTime.add(13, 59);
        planInfo.setStartTime(startTime);
        planInfo.setEndTime(endTime);
        try {
            planInfo.getClass().getDeclaredField("timeZoneId");
            Method method = planInfo.getClass().getDeclaredMethod("setTimeZoneId", Long.TYPE);
            method.invoke((Object)planInfo, timeZone.getLong("id"));
            enableNewVersion = Boolean.TRUE;
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            enableNewVersion = Boolean.FALSE;
        }
        String repeatPeriod = dynamicObject.getString("repeatperiod");
        if (WarnRepeatPeriodEnum.ByDays.getPeriod().equals(repeatPeriod)) {
            planInfo.setRepeatMode(RepeatModeEnum.ByDays);
            this.processMonitorTimeByDay(planInfo, dynamicObject, enableNewVersion);
        } else if (WarnRepeatPeriodEnum.ByWeeks.getPeriod().equals(repeatPeriod)) {
            this.processWeekPlan(planInfo, dynamicObject, enableNewVersion);
        } else {
            if (WarnRepeatPeriodEnum.ByMonths.getPeriod().equals(repeatPeriod)) {
                List<PlanInfo> planInfoList = this.processMonthPlan(planInfo, dynamicObject, enableNewVersion);
                StringBuilder sbPlanId = new StringBuilder();
                for (PlanInfo planInfoMonth : planInfoList) {
                    String planId = ScheduleServiceHelper.createPlan((PlanInfo)planInfoMonth);
                    sbPlanId.append(planId);
                    sbPlanId.append(",");
                }
                dynamicObject.set("planid", (Object)sbPlanId.toString());
                return;
            }
            if (WarnRepeatPeriodEnum.ByYears.getPeriod().equals(repeatPeriod)) {
                this.processYearPlan(planInfo, dynamicObject, enableNewVersion);
            }
        }
        String planId = ScheduleServiceHelper.createPlan((PlanInfo)planInfo);
        dynamicObject.set("planid", (Object)planId);
    }

    private int calculateDayDifByTimeZone(DynamicObject dynamicObject, Boolean enableNewVersion) {
        String monitorTime = dynamicObject.getString("monitortime");
        DynamicObject timeZone = dynamicObject.getDynamicObject("timezone");
        if (timeZone == null || enableNewVersion.booleanValue()) {
            return 0;
        }
        InteServiceImpl inteServiceImpl = new InteServiceImpl();
        int difHours = this.calculateTimeZoneDifference(inteServiceImpl.getSysTimezone().getString("number"), timeZone.getString("number"));
        if (difHours == 0) {
            return 0;
        }
        int zoneTime = Integer.parseInt(monitorTime) + difHours;
        if (zoneTime < 0) {
            return -1;
        }
        if (zoneTime > 23) {
            return 1;
        }
        return 0;
    }

    private StringBuilder processMonitorTime(DynamicObject dynamicObject, Boolean enableNewVersion) {
        String monitorTime = dynamicObject.getString("monitortime");
        StringBuilder cronExpression = new StringBuilder("0 0 ");
        InteServiceImpl inteServiceImpl = new InteServiceImpl();
        int difHours = 0;
        if (dynamicObject.getDynamicObject("timezone") != null && !enableNewVersion.booleanValue()) {
            difHours = this.calculateTimeZoneDifference(inteServiceImpl.getSysTimezone().getString("number"), dynamicObject.getDynamicObject("timezone").getString("number"));
        }
        int zoneTime = (24 + Integer.parseInt(monitorTime) + difHours) % 24;
        cronExpression.append(zoneTime);
        return cronExpression;
    }

    private int calculateTimeZoneDifference(String timeZone1, String timeZone2) {
        int difference = 0;
        try {
            if (HRStringUtils.isEmpty((String)timeZone1) || HRStringUtils.isEmpty((String)timeZone2) || timeZone1.equals(timeZone2)) {
                return difference;
            }
            TimeZone tz1 = TimeZone.getTimeZone(timeZone1);
            TimeZone tz2 = TimeZone.getTimeZone(timeZone2);
            difference = tz1.getRawOffset() / 3600000 - tz2.getRawOffset() / 3600000;
        }
        catch (Exception e) {
            LOGGER.error("process timezone error.");
            LOGGER.error((Throwable)e);
        }
        return difference;
    }

    private void processMonitorTimeByDay(PlanInfo planInfo, DynamicObject dynamicObject, Boolean enableNewVersion) {
        StringBuilder cronExpression = this.processMonitorTime(dynamicObject, enableNewVersion);
        cronExpression.append(" * * ?");
        planInfo.setCronExpression(cronExpression.toString());
        dynamicObject.set("weekday", null);
        dynamicObject.set("monthday", null);
        dynamicObject.set("yearday", null);
    }

    private void processWeekPlan(PlanInfo planInfo, DynamicObject dynamicObject, Boolean enableNewVersion) {
        planInfo.setRepeatMode(RepeatModeEnum.ByWeeks);
        String weekdays = dynamicObject.getString("weekday");
        if (StringUtils.isEmpty((String)weekdays)) {
            return;
        }
        StringBuilder cronExpression = this.processMonitorTime(dynamicObject, enableNewVersion);
        cronExpression.append(" ? * ");
        int cursorDay = this.calculateDayDifByTimeZone(dynamicObject, enableNewVersion);
        String wkStr = this.removeFirstAndLastString(weekdays);
        StringBuilder stringBuilder = new StringBuilder();
        if (HRStringUtils.isNotEmpty((String)wkStr)) {
            String[] wks = wkStr.split(",");
            for (int idx = 0; idx < wks.length; ++idx) {
                if (!HRStringUtils.isNotEmpty((String)wks[idx])) continue;
                try {
                    if (idx > 0) {
                        stringBuilder.append(",");
                    }
                    if (cursorDay != 0) {
                        stringBuilder.append((Integer.parseInt(wks[idx]) - 1 + cursorDay + 7) % 7 + 1);
                        continue;
                    }
                    stringBuilder.append(wks[idx]);
                    continue;
                }
                catch (Exception exp) {
                    LOGGER.error("processWeekPlan error, wkStr ={}", (Object)wkStr);
                }
            }
        }
        cronExpression.append((CharSequence)stringBuilder);
        planInfo.setCronExpression(cronExpression.toString());
        dynamicObject.set("monthday", null);
        dynamicObject.set("yearday", null);
    }

    private List<PlanInfo> processMonthPlan(PlanInfo planInfo, DynamicObject dynamicObject, Boolean enableNewVersion) {
        planInfo.setRepeatMode(RepeatModeEnum.ByMonths);
        String monthDays = dynamicObject.getString("monthday");
        if (StringUtils.isEmpty((String)monthDays)) {
            return null;
        }
        String[] stringsMonthDays = monthDays.split(",");
        if (stringsMonthDays == null || stringsMonthDays.length == 0) {
            return null;
        }
        Set setMonthDays = Arrays.stream(stringsMonthDays).filter(day -> StringUtils.isNotEmpty((String)day)).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(setMonthDays)) {
            return null;
        }
        HashSet newSetMonthDays = new HashSet(16);
        int cursorDay = this.calculateDayDifByTimeZone(dynamicObject, enableNewVersion);
        if (cursorDay != 0) {
            for (String mDays : stringsMonthDays) {
                if (!StringUtils.isNotEmpty((String)mDays)) continue;
                try {
                    if ("L".equals(mDays) || cursorDay == 0) {
                        newSetMonthDays.add(mDays);
                        continue;
                    }
                    newSetMonthDays.add(String.valueOf((Integer.parseInt(mDays) - 1 + cursorDay + 31) % 31 + 1));
                }
                catch (Exception exp) {
                    LOGGER.error("processMonthPlan error, monthDays ={}", (Object)monthDays);
                }
            }
            setMonthDays = newSetMonthDays;
        }
        dynamicObject.set("weekday", null);
        dynamicObject.set("yearday", null);
        ArrayList planInfoList = Lists.newArrayListWithExpectedSize((int)10);
        StringBuilder cronExpression = this.processMonitorTime(dynamicObject, enableNewVersion);
        if (setMonthDays.contains("L")) {
            cronExpression.append(" L * ?");
            planInfo.setCronExpression(cronExpression.toString());
            planInfo.setDaysExp("L");
            planInfoList.add(planInfo);
            if (setMonthDays.size() > 1) {
                PlanInfo newPlanInfo = this.copyPlanInfo(planInfo);
                StringBuilder newCronExpression = this.processMonitorTime(dynamicObject, enableNewVersion);
                newCronExpression.append(" ");
                StringBuilder sbDaysExp = new StringBuilder();
                int count = 1;
                for (String day2 : setMonthDays) {
                    if (!StringUtils.isNotEmpty((String)day2) || day2.equals("L")) continue;
                    if (sbDaysExp.length() > 0) {
                        sbDaysExp.append(",");
                    }
                    sbDaysExp.append(day2);
                    ++count;
                }
                newCronExpression.append((CharSequence)sbDaysExp);
                newCronExpression.append(" * ?");
                newPlanInfo.setCronExpression(newCronExpression.toString());
                newPlanInfo.setDaysExp(sbDaysExp.toString());
                planInfoList.add(newPlanInfo);
            }
        } else {
            StringBuilder sbDaysExp = new StringBuilder();
            int count = 1;
            for (String day3 : setMonthDays) {
                if (!StringUtils.isNotEmpty((String)day3) || day3.equals("L")) continue;
                if (sbDaysExp.length() > 0) {
                    sbDaysExp.append(",");
                }
                sbDaysExp.append(day3);
                ++count;
            }
            cronExpression.append(" ");
            cronExpression.append((CharSequence)sbDaysExp);
            cronExpression.append(" * ?");
            planInfo.setCronExpression(cronExpression.toString());
            planInfo.setDaysExp(monthDays);
            planInfoList.add(planInfo);
        }
        return planInfoList;
    }

    private PlanInfo copyPlanInfo(PlanInfo planInfo) {
        PlanInfo newPlanInfo = new PlanInfo();
        newPlanInfo.setPeriod(planInfo.getPeriod());
        newPlanInfo.setJobId(planInfo.getJobId());
        newPlanInfo.setNumber(planInfo.getNumber() + "_1");
        newPlanInfo.setName(planInfo.getName() + "_1");
        newPlanInfo.setRepeatMode(planInfo.getRepeatMode());
        newPlanInfo.setStartTime(planInfo.getStartTime());
        newPlanInfo.setEndTime(planInfo.getEndTime());
        return newPlanInfo;
    }

    private void processYearPlan(PlanInfo planInfo, DynamicObject dynamicObject, Boolean enableNewVersion) {
        planInfo.setRepeatMode(RepeatModeEnum.ByYears);
        StringBuilder cronExpression = this.processMonitorTime(dynamicObject, enableNewVersion);
        String monthDays = dynamicObject.getString("yearday");
        String cronMonthDay = " 1 1 ?";
        if (StringUtils.isNotEmpty((String)monthDays)) {
            String[] strMonthDay;
            int cursorDay = this.calculateDayDifByTimeZone(dynamicObject, enableNewVersion);
            if (cursorDay != 0) {
                monthDays = this.getTimezoneDayOfYear(monthDays, cursorDay);
            }
            if ((strMonthDay = monthDays.split("-")) != null && strMonthDay.length == 2) {
                String strMonth = strMonthDay[0];
                String strDay = strMonthDay[1];
                try {
                    int month = Integer.parseInt(strMonth);
                    int day = Integer.parseInt(strDay);
                    if (month >= 1 && month <= 12 && day >= 1 && day <= 31) {
                        cronMonthDay = " " + day + " " + month + " ?";
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        cronExpression.append(cronMonthDay);
        planInfo.setCronExpression(cronExpression.toString());
        dynamicObject.set("weekday", null);
        dynamicObject.set("monthday", null);
    }

    private String removeFirstAndLastString(String str) {
        if (StringUtils.isEmpty((String)str) || str.length() < 2) {
            return str;
        }
        return str.substring(1, str.length() - 1);
    }

    private String getTimezoneDayOfYear(int month, int dayOfMonth, int days) {
        String key = month + "-" + dayOfMonth;
        return this.getTimezoneDayOfYear(key, days);
    }

    private String getTimezoneDayOfYear(String dayKey, int days) {
        if (days == 0) {
            return dayKey;
        }
        List<String> dayOfYearList = this.getDayOfYearList(Boolean.FALSE);
        if (dayOfYearList.contains(dayKey)) {
            int idx = dayOfYearList.indexOf(dayKey);
            int newIdx = (idx + days + dayOfYearList.size()) % dayOfYearList.size();
            return dayOfYearList.get(newIdx);
        }
        return dayKey;
    }

    private List<String> getDayOfYearList(Boolean isLeapYear) {
        ArrayList<String> dayOfYearList = new ArrayList<String>(10);
        int days = isLeapYear != false ? 366 : 365;
        int month = 1;
        int dayOfMonth = 1;
        Set<Integer> commonMonths = this.get30Months();
        Set<Integer> greaterMonths = this.get31Months();
        for (int cursor = 0; cursor < days; ++cursor) {
            dayOfYearList.add(month + "-" + dayOfMonth);
            if (dayOfMonth == 31 && greaterMonths.contains(month) || dayOfMonth == 30 && commonMonths.contains(month) || month == 2 && (isLeapYear.booleanValue() && dayOfMonth == 29 || !isLeapYear.booleanValue() && dayOfMonth == 28)) {
                dayOfMonth = 1;
                ++month;
                continue;
            }
            ++dayOfMonth;
        }
        return dayOfYearList;
    }

    private Set<Integer> get30Months() {
        HashSet<Integer> months = new HashSet<Integer>(16);
        months.addAll(Arrays.asList(4, 6, 9, 11));
        return months;
    }

    private Set<Integer> get31Months() {
        HashSet<Integer> months = new HashSet<Integer>(16);
        months.addAll(Arrays.asList(1, 3, 5, 7, 8, 10, 12));
        return months;
    }
}

