/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.domain.service.earlywarn.query;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.labelandreport.HRFilterUtil;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.common.constants.earlywarn.WarningSceneConstants;
import kd.hr.hrcs.common.model.earlywarn.WarnCalFieldBo;
import kd.hr.hrcs.common.model.earlywarn.WarnJoinEntityBo;
import kd.hr.hrcs.common.model.earlywarn.WarnQueryFieldBo;

@ExcludeFromJacocoGeneratedReport
public class WarnQFilterBuildUtils
implements WarningSceneConstants {
    private static final Log LOG = LogFactory.getLog(WarnQFilterBuildUtils.class);

    public static QFilter getWarnSceneQFilters(String dataFilterStr, List<WarnJoinEntityBo> joinEntityBos, List<WarnQueryFieldBo> queryFieldBos) {
        try {
            if (HRStringUtils.isNotEmpty((String)dataFilterStr)) {
                String mainEntity = null;
                for (WarnJoinEntityBo joinEntityBo : joinEntityBos) {
                    if (!"main".equals(joinEntityBo.getType())) continue;
                    mainEntity = joinEntityBo.getEntityAlias();
                    break;
                }
                QFilter qFilter = HRFilterUtil.condition2QFilter4HRReport((String)dataFilterStr, (String)SerializationUtils.toJsonString(queryFieldBos));
                Set<String> queryFieldAlias = queryFieldBos.stream().map(QueryFieldCommonBo::getFieldAlias).collect(Collectors.toSet());
                return WarnQFilterBuildUtils.checkAndChangeHRFilterProperty(qFilter, mainEntity, queryFieldAlias);
            }
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
        }
        return QFilter.of((String)"1=1", (Object[])new Object[0]);
    }

    public static QFilter getWarnSchemeAdConditionQFilter(WarnCalFieldBo adConditionCalField) {
        if (adConditionCalField != null) {
            try {
                return new QFilter(adConditionCalField.getFieldNumber(), "=", (Object)Boolean.TRUE);
            }
            catch (Exception exception) {
                LOG.error("error:", (Throwable)exception);
            }
        }
        return QFilter.of((String)"1=1", (Object[])new Object[0]);
    }

    private static QFilter checkAndChangeHRFilterProperty(QFilter qFilter, String mainEntityAlias, Set<String> queryFieldAlias) {
        if (qFilter == null) {
            return null;
        }
        String property = qFilter.getProperty();
        if (!queryFieldAlias.contains(property)) {
            String[] splitKeys = property.split("\\.");
            String entityAlias = splitKeys[0];
            if (entityAlias.equals(mainEntityAlias)) {
                property = property.replaceAll(entityAlias + ".", "");
            } else {
                if (splitKeys.length > 2) {
                    splitKeys[1] = "";
                }
                StringBuilder propertyBuilder = new StringBuilder();
                for (int index = 0; index < splitKeys.length; ++index) {
                    String splitKey = splitKeys[index];
                    if (!HRStringUtils.isNotEmpty((String)splitKey)) continue;
                    propertyBuilder.append(splitKey);
                    if (index == splitKeys.length - 1) continue;
                    propertyBuilder.append('.');
                }
                property = propertyBuilder.toString();
            }
            qFilter.__setProperty(property);
        }
        List nests = qFilter.getNests(true);
        for (QFilter.QFilterNest nest : nests) {
            QFilter nestFilter = nest.getFilter();
            WarnQFilterBuildUtils.checkAndChangeHRFilterProperty(nestFilter, mainEntityAlias, queryFieldAlias);
        }
        return qFilter;
    }
}

