/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.domain.service.earlywarn.queryfield;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hrcs.common.constants.earlywarn.WarnQueryFieldConstants;
import kd.hr.hrcs.common.model.earlywarn.WarnQueryFieldBo;

@ExcludeFromJacocoGeneratedReport
public class QueryFieldHelper
implements WarnQueryFieldConstants {
    private static final String META_NUMBER_BOS_ENTITY_OBJECT = "bos_entityobject";

    public static List<WarnQueryFieldBo> assembleQueryFields(List<DynamicObject> queryFieldList) {
        ArrayList queryFields = Lists.newArrayListWithCapacity((int)queryFieldList.size());
        MainEntityTypeUtil entityTypeUtil = new MainEntityTypeUtil();
        HRBaseServiceHelper entityHelper = new HRBaseServiceHelper(META_NUMBER_BOS_ENTITY_OBJECT);
        Set entityNums = queryFieldList.stream().map(dy -> dy.getString("entitynumber")).collect(Collectors.toSet());
        DynamicObjectCollection entityDys = entityHelper.queryOriginalCollection(String.join((CharSequence)",", "name", "number"), new QFilter[]{new QFilter("number", "in", entityNums)});
        Map<String, String> entityNumMap = entityDys.stream().collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy.getString("name")));
        for (DynamicObject queryFieldDy : queryFieldList) {
            Map baseDataNumAndPkType;
            WarnQueryFieldBo queryField = new WarnQueryFieldBo();
            queryField.setId(queryFieldDy.getString("id"));
            queryField.setSource(queryFieldDy.getString("source"));
            queryField.setSourceId(queryFieldDy.getString("sourceid"));
            queryField.setChangeShowName(queryFieldDy.getBoolean("ischangeshowname"));
            String entityNumber = queryFieldDy.getString("entitynumber");
            queryField.setEntityNumber(entityNumber);
            String fieldAlias = queryFieldDy.getString("fieldalias");
            if (!queryField.isVirtualEntityField()) {
                String nameSuffix = "";
                if (fieldAlias.contains("\u03b4")) {
                    nameSuffix = fieldAlias.substring(fieldAlias.indexOf(948), fieldAlias.indexOf(46));
                }
                String entityName = entityNumMap.get(entityNumber);
                entityName = entityName + nameSuffix;
                queryField.setEntityName(entityName);
            }
            OrmLocaleValue fieldName = (OrmLocaleValue)queryFieldDy.getLocaleString("fieldname");
            queryField.setFieldName(AnalyseObjectUtil.getLocaleString((OrmLocaleValue)fieldName));
            queryField.setFieldAlias(fieldAlias);
            queryField.setFieldPath(queryFieldDy.getString("fieldpath"));
            String complexType = queryFieldDy.getString("complextype");
            queryField.setComplexType(complexType);
            if (queryField.isVirtualEntityField()) {
                queryField.setFieldNumber(queryField.getFieldAlias());
                if (AnalyseObjectUtil.isBaseDataType((String)complexType)) {
                    baseDataNumAndPkType = AnalyseObjectUtil.parseFieldAliasGetBaseDataNumAndPkType((String)queryField.getFieldPath().split("\\.")[0], (String)queryField.getFieldPath(), (MainEntityTypeUtil)entityTypeUtil);
                    queryField.setBaseDataNum((String)baseDataNumAndPkType.get("baseDataNum"));
                    queryField.setBaseDataIdType((String)baseDataNumAndPkType.get("pkType"));
                } else {
                    queryField.setBaseDataNum(queryField.getFieldPath().split("\\.")[0]);
                }
            } else {
                queryField.setFieldNumber(QueryFieldHelper.getFieldShortNumber(entityNumber, fieldAlias, complexType));
                if (AnalyseObjectUtil.isBaseDataType((String)complexType)) {
                    baseDataNumAndPkType = AnalyseObjectUtil.parseFieldAliasGetBaseDataNumAndPkType((String)entityNumber, (String)fieldAlias, (MainEntityTypeUtil)entityTypeUtil);
                    queryField.setBaseDataNum((String)baseDataNumAndPkType.get("baseDataNum"));
                    queryField.setBaseDataIdType((String)baseDataNumAndPkType.get("pkType"));
                }
            }
            queryField.setValueType(queryFieldDy.getString("valuetype"));
            queryField.setControlType(queryFieldDy.getString("controltype"));
            queryField.setSelectedField(Boolean.TRUE);
            queryFields.add(queryField);
        }
        Map fieldBoMap = queryFields.stream().collect(Collectors.toMap(QueryFieldCommonBo::getFieldAlias, Function.identity(), (oldBo, newBo) -> {
            if ("warnscene".equals(oldBo.getSource())) {
                return oldBo;
            }
            if ("warnscene".equals(newBo.getSource())) {
                return newBo;
            }
            return oldBo;
        }));
        return Lists.newArrayList(fieldBoMap.values());
    }

    private static String getFieldShortNumber(String entityNumber, String fieldAlias, String fieldComplexType) {
        if (AnalyseObjectUtil.isBaseDataType((String)fieldComplexType) && fieldAlias.contains(".")) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            String[] aliasArr = fieldAlias.split("\\.");
            if (aliasArr.length > 2) {
                String parentFieldName = aliasArr[aliasArr.length - 3];
                IDataEntityProperty parentProp = (IDataEntityProperty)dataEntityType.getAllFields().get(parentFieldName);
                if (parentProp instanceof BasedataProp) {
                    return aliasArr[aliasArr.length - 3] + "." + aliasArr[aliasArr.length - 2] + "." + aliasArr[aliasArr.length - 1];
                }
            }
            return aliasArr[aliasArr.length - 2] + "." + aliasArr[aliasArr.length - 1];
        }
        return fieldAlias.substring(fieldAlias.lastIndexOf(46) + 1);
    }
}

