/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.domain.service.earlywarn.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.common.model.earlywarn.WarnBaseConditionBo;
import kd.hr.hrcs.common.model.earlywarn.vo.WarnBaseConditionReturnVo;

public class WarnCommonConditionUtils {
    private static final Log LOG = LogFactory.getLog(WarnCommonConditionUtils.class);

    @ExcludeFromJacocoGeneratedReport
    public static Map<String, List<String>> getReferCommonConditionToSchemeName(Long sceneId) {
        try {
            DynamicObject[] dbData;
            if (sceneId == null || sceneId == 0L) {
                return Collections.emptyMap();
            }
            HashMap ruleValueUniqueToSchemeName = Maps.newHashMapWithExpectedSize((int)16);
            HRBaseServiceHelper schemeHelper = new HRBaseServiceHelper("hrcs_warnscheme");
            for (DynamicObject dy : dbData = schemeHelper.queryOriginalArray(String.join((CharSequence)",", Lists.newArrayList((Object[])new String[]{"name", "basecondition"})), new QFilter[]{new QFilter("warnscene", "=", (Object)sceneId)})) {
                String baseStr = dy.getString("basecondition");
                if (!HRStringUtils.isNotEmpty((String)baseStr)) continue;
                WarnBaseConditionReturnVo baseConditionVo = (WarnBaseConditionReturnVo)SerializationUtils.fromJsonString((String)baseStr, WarnBaseConditionReturnVo.class);
                List baseConditionBos = baseConditionVo.getBaseConditionBos();
                for (WarnBaseConditionBo baseConditionBo : baseConditionBos) {
                    String ruleValueUnique = baseConditionBo.getRuleValueUnique();
                    String selectValue = baseConditionBo.getSelectValue();
                    if (!HRStringUtils.isNotEmpty((String)selectValue) || !HRStringUtils.isNotEmpty((String)ruleValueUnique)) continue;
                    ruleValueUniqueToSchemeName.putIfAbsent(ruleValueUnique, Lists.newArrayListWithExpectedSize((int)dbData.length));
                    ruleValueUniqueToSchemeName.computeIfPresent(ruleValueUnique, (oldKey, list) -> {
                        list.add(dy.getString("name"));
                        return list;
                    });
                }
            }
            return ruleValueUniqueToSchemeName;
        }
        catch (Exception exception) {
            LOG.error("error:", (Throwable)exception);
            return Collections.emptyMap();
        }
    }
}

