/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.activity;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import org.apache.commons.lang3.StringUtils;

@ExcludeFromJacocoGeneratedReport
public class ActivityFieldTreePlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
TreeNodeCheckListener {
    public static final String CustParamKey_TreeNodes = "treenodes";
    public static final String SELECT_FIELD_NUMBER = "selectFieldNumber";
    public static final String Key_btnOK = "btnok";
    public static final String Key_btnCancel = "btncancel";
    public static final String Key_TreeView = "tv_fields";
    private static final String SELECT_FIELD_VALUE = "selectfieldvalue";
    private static final String SELECT_FIELD_NAME = "selectfieldname";
    private static final String ACTIVITY_ID = "activityid";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{Key_btnOK, Key_btnCancel});
        TreeView tv = (TreeView)this.getView().getControl(Key_TreeView);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        TreeView tv = (TreeView)this.getView().getControl(Key_TreeView);
        boolean flag = (Boolean)this.getView().getFormShowParameter().getCustomParam("multiFlag");
        tv.setMulti(flag);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String json = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_TreeNodes);
        String oldSelectFieldValue = (String)this.getView().getFormShowParameter().getCustomParam(SELECT_FIELD_VALUE);
        String oldSelectFieldName = (String)this.getView().getFormShowParameter().getCustomParam(SELECT_FIELD_NAME);
        this.getModel().setValue(SELECT_FIELD_VALUE, (Object)oldSelectFieldValue);
        this.getModel().setValue(SELECT_FIELD_NAME, (Object)oldSelectFieldName);
        this.getView().updateView(SELECT_FIELD_VALUE);
        this.getView().updateView(SELECT_FIELD_NAME);
        if (StringUtils.isNotBlank((CharSequence)json)) {
            this.fillTreeNodes(json);
        } else {
            this.addTreeRootNode();
        }
        int rowIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("rowindex");
        if (rowIndex == 0) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SELECT_FIELD_VALUE, SELECT_FIELD_NAME});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if (Key_btnOK.equalsIgnoreCase(ctlSource.getKey())) {
            boolean flag = (Boolean)this.getView().getFormShowParameter().getCustomParam("multiFlag");
            if (!flag) {
                String currNodeId = (String)this.getModel().getValue(SELECT_FIELD_VALUE);
                String currNodeName = (String)this.getModel().getValue(SELECT_FIELD_NAME);
                HashMap returnMap = Maps.newHashMapWithExpectedSize((int)2);
                if (StringUtils.isNotBlank((CharSequence)currNodeId)) {
                    returnMap.put("currNodeId", currNodeId);
                    returnMap.put("currNodeName", currNodeName);
                }
                this.getView().returnDataToParent((Object)returnMap);
            } else {
                TreeView tv = (TreeView)this.getView().getControl(Key_TreeView);
                tv.getTreeState().getSelectedNodeId();
                List selectedNodes = tv.getTreeState().getSelectedNodes();
                List filterNodes = selectedNodes.stream().filter(node -> {
                    boolean isparent = (Boolean)node.get("isParent");
                    return !isparent;
                }).collect(Collectors.toList());
                this.getView().returnDataToParent(filterNodes);
            }
            this.getView().close();
        } else if (Key_btnCancel.equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        }
    }

    public void treeNodeClick(TreeNodeEvent treeNodeEvent) {
        String currNodeValue = (String)treeNodeEvent.getNodeId();
        TreeView treeView = (TreeView)treeNodeEvent.getSource();
        Map focusNode = treeView.getTreeState().getFocusNode();
        this.getModel().setValue(SELECT_FIELD_VALUE, (Object)currNodeValue);
        this.getModel().setValue(SELECT_FIELD_NAME, focusNode.get("text"));
    }

    public void treeNodeDoubleClick(TreeNodeEvent e) {
        String currNodeId = (String)e.getNodeId();
        if ("0".equals(currNodeId)) {
            currNodeId = "";
        }
        if (StringUtils.isBlank((CharSequence)currNodeId)) {
            return;
        }
        String currNodeName = (String)this.getModel().getValue(SELECT_FIELD_NAME);
        HashMap returnMap = Maps.newHashMapWithExpectedSize((int)2);
        if (StringUtils.isNotBlank((CharSequence)currNodeId)) {
            returnMap.put("currNodeId", currNodeId);
            returnMap.put("currNodeName", currNodeName);
        }
        this.getView().returnDataToParent((Object)returnMap);
        this.getView().close();
    }

    public void treeNodeCheck(TreeNodeCheckEvent e) {
        TreeView treeView = (TreeView)e.getSource();
        List checkedNodeIds = treeView.getTreeState().getCheckedNodeIds();
        if (checkedNodeIds != null) {
            checkedNodeIds.remove("0");
        }
    }

    private void fillTreeNodes(String strJson) {
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)strJson, TreeNode.class);
        TreeView tree = (TreeView)this.getView().getControl(Key_TreeView);
        tree.addNode(rootNode);
    }

    private void addTreeRootNode() {
        TreeNode root = new TreeNode("", "0", ResManager.loadKDString((String)"\u5355\u636e\u5b57\u6bb5\u5217\u8868", (String)"SubEntitySelectFieldList_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        TreeView tree = (TreeView)this.getView().getControl(Key_TreeView);
        tree.addNode(root);
    }
}

