/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.datarule;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.GetFilterFieldsParameter;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.IFormView;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hrcs.bussiness.service.perm.HRPermCacheMgr;
import kd.hr.hrcs.bussiness.service.perm.PermNotifyService;
import kd.hr.hrcs.bussiness.servicehelper.perm.log.DataRuleLogServiceHelper;
import kd.hr.hrcs.common.constants.perm.PermFormCommonUtil;
import kd.hr.hrcs.common.constants.perm.log.DataRuleLogModel;

public class HRDataRuleEditPlugin
extends HRDataBaseEdit {
    private static final Log LOGGER = LogFactory.getLog(HRDataRuleEditPlugin.class);
    private static final String IS_UPDATE = "isUpdate";
    private static final String ORIGINAL_RULE = "originalRule";

    public void afterLoadData(EventObject evt) {
        super.afterLoadData(evt);
        this.getView().setEnable(Boolean.FALSE, new String[]{"entitynum"});
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        boolean visible = true;
        if (OperationStatus.VIEW.equals((Object)status)) {
            visible = false;
        }
        PermFormCommonUtil.setFilterGridAddBtnVisible((IFormView)this.getView(), (String)"filtergridap", (boolean)visible);
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        String prevFocusEntNum = (String)this.getView().getFormShowParameter().getCustomParam("fsp_custom_param_entitynum");
        if (HRStringUtils.isNotEmpty((String)prevFocusEntNum)) {
            this.getModel().setValue("entitynum", (Object)prevFocusEntNum);
            this.getView().setEnable(Boolean.FALSE, new String[]{"entitynum"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"entitynum"});
        }
        this.getPageCache().put(IS_UPDATE, "1");
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        this.refreshFilterGrid();
        this.getPageCache().put(ORIGINAL_RULE, (String)this.getModel().getValue("rule"));
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        super.propertyChanged(evt);
        String propName = evt.getProperty().getName();
        if (HRStringUtils.equals((String)"entitynum", (String)propName)) {
            this.clearDataPermFilterGrid();
            this.refreshFilterGrid();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate op;
        String operateKey;
        if (args.getSource() instanceof AbstractOperate && HRStringUtils.equals((String)"save", (String)(operateKey = (op = (AbstractOperate)args.getSource()).getOperateKey()))) {
            this.doSave(args);
            try {
                Object pkValue;
                boolean changeFlag;
                OperationStatus status = this.getView().getFormShowParameter().getStatus();
                if (status.equals((Object)OperationStatus.EDIT) && (changeFlag = this.compareFilterCondition(pkValue = this.getModel().getDataEntity().getPkValue()))) {
                    this.getPageCache().put("operate", "edit");
                    DataRuleLogModel dataRuleLogModel = DataRuleLogServiceHelper.getDataRuleLogModel((Object)pkValue, (boolean)true);
                    this.getPageCache().put("beforeData", SerializationUtils.toJsonString((Object)dataRuleLogModel));
                }
            }
            catch (Exception exception) {
                LOGGER.error("save datarule beforeDoOperation error", (Throwable)exception);
            }
        }
    }

    private String getFilterCondition() {
        String ruleStr;
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        FilterCondition fc = filterGrid.getFilterGridState().getFilterCondition();
        fc.getFilterRow();
        if (fc != null && !CollectionUtils.isEmpty((Collection)fc.getFilterRow()) && HRStringUtils.isNotEmpty((String)(ruleStr = SerializationUtils.toJsonString((Object)fc)))) {
            return ruleStr;
        }
        return "";
    }

    private boolean compareFilterCondition(Object pkValue) {
        HRBaseServiceHelper dataRuleServiceHelper = new HRBaseServiceHelper("hrcs_datarule");
        DynamicObject dynamicObject = dataRuleServiceHelper.queryOne(pkValue);
        String beforelEntryNumber = dynamicObject.getString("entitynum.number");
        String beforeRule = dynamicObject.getString("rule");
        String nowFilterCondition = this.getFilterCondition();
        boolean changeFlag = DataRuleLogServiceHelper.compareFilterControls((String)beforelEntryNumber, (String)beforeRule, (String)nowFilterCondition);
        return changeFlag;
    }

    private void doSave(BeforeDoOperationEventArgs args) {
        String ruleStr;
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
        FilterCondition fc = filterGrid.getFilterGridState().getFilterCondition();
        boolean canSave = false;
        if (fc != null && !CollectionUtils.isEmpty((Collection)fc.getFilterRow()) && HRStringUtils.isNotEmpty((String)(ruleStr = SerializationUtils.toJsonString((Object)fc)))) {
            this.getModel().setValue("rule", (Object)ruleStr);
            canSave = true;
        }
        if (!canSave) {
            args.setCancel(true);
            String errorInfo = ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u89c4\u5219\u3002", (String)"HRDataRuleEditPlugin_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
            args.setCancelMessage(errorInfo);
            this.getView().showErrorNotification(errorInfo);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getSource() instanceof AbstractOperate) {
            AbstractOperate op = (AbstractOperate)args.getSource();
            String operateKey = op.getOperateKey();
            if (args.getOperationResult().isSuccess() && HRStringUtils.equals((String)"save", (String)operateKey)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"entitynum"});
                this.modifyNotify();
                try {
                    String operate = this.getPageCache().get("operate");
                    List successPkIds = args.getOperationResult().getSuccessPkIds();
                    if (!CollectionUtils.isEmpty((Collection)successPkIds) && "edit".equals(operate)) {
                        DataRuleLogModel dataRuleLogModel = DataRuleLogServiceHelper.getDataRuleLogModel(successPkIds.get(0), (boolean)false);
                        String beforeDataStr = this.getPageCache().get("beforeData");
                        DataRuleLogModel beforeData = (DataRuleLogModel)SerializationUtils.fromJsonString((String)beforeDataStr, DataRuleLogModel.class);
                        dataRuleLogModel.setBeforeDataRuleModel(beforeData);
                        DataRuleLogServiceHelper.dataRuleLogInit((String)"modify", (DataRuleLogModel)dataRuleLogModel);
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("save datarule afterDoOperation error", (Throwable)exception);
                }
            }
        }
    }

    private void clearDataPermFilterGrid() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        FilterCondition filterCondition = new FilterCondition();
        filterGrid.SetValue(filterCondition);
        filterCondition = null;
        filterGrid.SetValue(filterCondition);
        this.getView().updateView("filtergridap");
    }

    private void refreshFilterGrid() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject entityObj = dataEntity.getDynamicObject("entitynum");
        if (entityObj == null) {
            return;
        }
        String entityNum = String.valueOf(entityObj.getPkValue());
        String ruleStr = dataEntity.getString("rule");
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
        filterGrid.setEntityNumber(entityNum);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        GetFilterFieldsParameter fieldsParameter = new GetFilterFieldsParameter((IDataEntityType)entityType);
        fieldsParameter.setNeedMulBasedataField(true);
        List filterColumns = EntityTypeUtil.createFilterColumns((GetFilterFieldsParameter)fieldsParameter);
        filterGrid.setFilterColumns(filterColumns);
        if (HRStringUtils.isNotEmpty((String)ruleStr)) {
            FilterCondition fc = (FilterCondition)SerializationUtils.fromJsonString((String)ruleStr, FilterCondition.class);
            filterGrid.SetValue(fc);
        }
        this.getView().updateView("filtergridap");
    }

    private void modifyNotify() {
        String rule;
        String originalRule;
        if (HRStringUtils.isEmpty((String)this.getPageCache().get(IS_UPDATE)) && !HRStringUtils.equals((String)(originalRule = this.getPageCache().get(ORIGINAL_RULE)), (String)(rule = (String)this.getModel().getValue("rule")))) {
            Long dataRuleId = (Long)this.getModel().getDataEntity().getPkValue();
            PermNotifyService.notifyByDataRule((Long)dataRuleId);
            String[] dataRuleCacheKeyArr = new String[]{HRPermCacheMgr.getTypeByPrefix((String)"BS_HR_PERM_DATA_RULE"), HRPermCacheMgr.getTypeByPrefix((String)"BS_HR_PERM_BD_DATA_RULE")};
            HRPermCacheMgr.clearCache((String[])dataRuleCacheKeyArr);
        }
    }
}

