/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.datarule;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.datarule.HRDataRuleServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.datarule.HRDataRuleTreeSearchServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.datarule.HRDataRuleTreeServiceHelper;

public class HREntityTreeListPlugin
extends StandardTreeListPlugin
implements TreeNodeQueryListener {
    private HRDataRuleTreeServiceHelper treeHelper;

    public void initialize() {
        super.initialize();
        TreeView treeView = this.getTreeView();
        this.treeHelper = new HRDataRuleTreeServiceHelper(treeView);
        treeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.treeHelper.reBuildWholeTree();
    }

    public void search(SearchEnterEvent evt) {
        String searchText = evt.getText();
        if (HRStringUtils.isEmpty((String)searchText)) {
            this.treeHelper.reBuildWholeTree();
            this.getPageCache().put("lefttree_search_mode", "false");
        } else {
            TreeView treeView = this.getTreeView();
            HRDataRuleTreeSearchServiceHelper.reBuildTreeBySearchKey((TreeView)treeView, (String)searchText);
            this.getPageCache().put("lefttree_search_mode", "true");
        }
        this.getView().updateView("treeview");
    }

    public void setFilter(SetFilterEvent evt) {
        super.setFilter(evt);
        String leftTreeQFilterJson = this.getPageCache().get("lefttree_qfilter_json");
        if (HRStringUtils.isNotEmpty((String)leftTreeQFilterJson)) {
            evt.getQFilters().add(QFilter.fromSerializedString((String)leftTreeQFilterJson));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent itemClick) {
        super.beforeItemClick(itemClick);
        String itemKey = itemClick.getItemKey();
        if (HRStringUtils.equals((String)"tblnew", (String)itemKey) && !this.isSelectEntityNode()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"HREntityTreeListPlugin_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            itemClick.setCancel(true);
            return;
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent evt) {
        super.beforeShowBill(evt);
        TreeView tv = (TreeView)this.getControl("treeview");
        Map map = tv.getTreeState().getFocusNode();
        BillShowParameter bsp = evt.getParameter();
        if (bsp.getStatus().equals((Object)OperationStatus.ADDNEW) && this.isSelectEntityNode()) {
            String entityId = String.valueOf(map.get("id")).split("_split_")[1];
            String appId = String.valueOf(map.get("parentid")).split("_split_")[1];
            if (bsp.getCustomParams() == null) {
                bsp.setCustomParams(Collections.emptyMap());
            }
            Map entityInfoMap = HRDataRuleServiceHelper.getBizObjectById((String)entityId);
            bsp.setCustomParam("fsp_custom_param_appId", (Object)appId);
            bsp.setCustomParam("fsp_custom_param_entitynum", entityInfoMap.get("number"));
        }
    }

    public void treeNodeClick(TreeNodeEvent treeNodeEvent) {
        String nodeId = (String)treeNodeEvent.getNodeId();
        String parentNodeId = (String)treeNodeEvent.getParentNodeId();
        TreeView leftTree = (TreeView)treeNodeEvent.getSource();
        String id = String.valueOf(nodeId);
        if (HRStringUtils.equals((String)"1010", (String)id)) {
            this.getPageCache().remove("lefttree_qfilter_json");
            return;
        }
        boolean isSearchMode = HRStringUtils.equals((String)this.getPageCache().get("lefttree_search_mode"), (String)"true");
        String[] idArr = id.split("_split_");
        if (idArr.length < 2) {
            TreeNode rootNode = new TreeNode();
            rootNode.setId("1010");
            leftTree.focusNode(rootNode);
            return;
        }
        String nodeIdPrefix = idArr[0];
        String trueId = idArr[1];
        List formIdList = Lists.newArrayListWithCapacity((int)16);
        if (HRStringUtils.equals((String)"1", (String)nodeIdPrefix)) {
            formIdList = HRDataRuleServiceHelper.getEntityNumByCloudId((String)trueId);
            if (!isSearchMode) {
                leftTree.queryTreeNodeChildren(parentNodeId, nodeId);
            }
        } else if (HRStringUtils.equals((String)"2", (String)nodeIdPrefix)) {
            formIdList = HRDataRuleServiceHelper.getEntityNumByAppId((String)trueId);
            if (!isSearchMode) {
                leftTree.queryTreeNodeChildren(parentNodeId, nodeId);
            }
        } else if (HRStringUtils.equals((String)"3", (String)nodeIdPrefix)) {
            Map map = HRDataRuleServiceHelper.getBizObjectById((String)trueId);
            formIdList = Lists.newArrayList((Object[])new String[]{(String)map.get("number")});
        }
        QFilter qFilter = new QFilter("entitynum", "in", (Object)formIdList);
        this.getPageCache().put("lefttree_qfilter_json", qFilter.toSerializedString());
    }

    public void queryTreeNodeChildren(TreeNodeEvent event) {
        if (event.getNodeId() != null) {
            String nodeId = event.getNodeId().toString();
            this.treeHelper.handleExpandNodeClick(nodeId);
        }
    }

    private TreeView getTreeView() {
        return (TreeView)this.getView().getControl("treeview");
    }

    private boolean isSelectEntityNode() {
        Map map = this.getTreeView().getTreeState().getFocusNode();
        if (map == null) {
            return false;
        }
        return map.get("id") == null || "3".equals(String.valueOf(map.get("id")).split("_split_")[0]);
    }
}

