/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.econtract;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.time.Duration;
import java.time.LocalTime;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.Donothing;
import kd.bos.ext.form.control.CountDown;
import kd.bos.ext.form.control.events.CountDownEvent;
import kd.bos.ext.form.control.events.CountDownListener;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.PasswordEncryptUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.HRAppCacheImpl;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hrcs.bussiness.service.econtract.ChargeLicGrpServiceHelper;
import kd.hr.hrcs.bussiness.service.econtract.ChargeMessageServiceHelper;
import kd.hr.hrcs.bussiness.service.econtract.EcontractChargeServiceHelper;
import org.apache.http.conn.ConnectTimeoutException;

public class ChargeRegisterPlugin
extends HRDataBaseEdit
implements CountDownListener {
    private static final Log LOGGER = LogFactory.getLog(ChargeRegisterPlugin.class);
    private static final Map<String, String> PARAM_MAP = new HashMap<String, String>(16);
    private static final HRAppCacheImpl APP_CACHE = (HRAppCacheImpl)HRAppCache.get((String)"hrcs");
    private static final String HRCS_CHARGE_GETVERIFICATIONNUMBER = "hrcs_charge_getcode";
    private static int DEFAULT_CONNECTIONTIMEOUT = Integer.getInteger("httpclient.connectionTimeout", 3000);
    private static int DEFAULT_READTIMEOUT = 65000;
    private static final String MESSAGE_TEMPLATE_CODE_COMPANYSTATUS_CHANGED = "hrcs_charge_enterprise_reregistration_remind";
    private static final String MESSAGE_TEMPLATE_CODE_LINKNAME_CHANGED = "hrcs_charge_linkname_change_remind";
    private static final String ACCESS_TOKEN_REGEX = "^(?![A-Za-z0-9]+$)(?![a-z0-9\\W]+$)(?![A-Za-z\\W]+$)(?![A-Z0-9\\W]+$)[a-zA-Z0-9\\W]{16,50}$";
    private static final String REGISTER_PREFIX = "charge_register_";
    private static final Pattern ACCESS_TOKEN_PTN = Pattern.compile("^(?![A-Za-z0-9]+$)(?![a-z0-9\\W]+$)(?![A-Za-z\\W]+$)(?![A-Z0-9\\W]+$)[a-zA-Z0-9\\W]{16,50}$");
    private static final int RETRY_TIMES = 10;

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        BillShowParameter billShowParameter = (BillShowParameter)args.getSource();
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_chargeregister");
        DynamicObject dynamicObject = helper.queryOne(new QFilter[0]);
        if (dynamicObject != null) {
            billShowParameter.setPkId(dynamicObject.getPkValue());
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        CountDown countdown = (CountDown)this.getView().getControl("countdownap");
        countdown.addCountDownListener((CountDownListener)this);
    }

    public void onCountDownEnd(CountDownEvent evt) {
        super.onCountDownEnd(evt);
        this.getView().setEnable(Boolean.TRUE, new String[]{"getcode"});
        this.getView().updateView("getcode");
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"countdownap"});
        this.getView().updateView("countdownap");
        this.getModel().setDataChanged(false);
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        if (pkValue == null || pkValue == 0L) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bindtid", "tid"});
            return;
        }
        DynamicObject chargeInfo = EcontractChargeServiceHelper.getChargeInfo((Object)pkValue);
        if ("0".equals(chargeInfo.getString("userstatus")) || HRStringUtils.isEmpty((String)chargeInfo.getString("userstatus"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bindtid", "tid"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bindtid"});
            String tid = chargeInfo.getString("tid");
            if (HRStringUtils.isEmpty((String)tid)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"tid"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"tid"});
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        DynamicObject entity = this.getModel().getDataEntity();
        if (HRStringUtils.isEmpty((String)entity.getString("userstatus"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"unbind", "getcode", "bind", "code", "changelinkuser"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"register"});
            TextEdit code = (TextEdit)this.getView().getControl("code");
            code.setMustInput(false);
        } else if ("0".equals(entity.getString("userstatus"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"username", "orgname", "orgsimplename", "email", "linkuser"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"register", "unbind", "save"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"getcode", "bind", "accesstoken", "code", "changelinkuser"});
            TextEdit code = (TextEdit)this.getView().getControl("code");
            code.setMustInput(true);
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"username", "password", "orgname", "orgsimplename", "email", "url", "orgurl", "linkuser"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"register", "getcode", "bind", "code", "accesstoken", "save"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"unbind", "changelinkuser"});
            TextEdit code = (TextEdit)this.getView().getControl("code");
            code.setMustInput(false);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (!(args.getSource() instanceof Donothing)) {
            return;
        }
        Donothing source = (Donothing)args.getSource();
        String operateKey = source.getOperateKey();
        if (operateKey.equals("register")) {
            boolean isInvalidUsername = this.isBlankOrContainsBlankChar("username");
            if (isInvalidUsername) {
                args.setCancel(true);
                return;
            }
            boolean isInvalidPassword = this.isBlankOrContainsBlankChar("password");
            if (isInvalidPassword) {
                args.setCancel(true);
                return;
            }
            boolean isInvalidOrgname = this.isBlankOrContainsBlankChar("orgname");
            if (isInvalidOrgname) {
                args.setCancel(true);
                return;
            }
            boolean isInvalidOrgsimplatename = this.isBlankOrContainsBlankChar("orgsimplename");
            if (isInvalidOrgsimplatename) {
                args.setCancel(true);
                return;
            }
            if (this.isInvalidAccesstoken()) {
                args.setCancel(true);
                return;
            }
            boolean isInvalidEmail = this.isBlankOrContainsBlankChar("email");
            if (isInvalidEmail) {
                args.setCancel(true);
                return;
            }
            String email = this.getModel().getValue("email").toString().trim();
            if (email.length() > 320) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u90ae\u7bb1\u4e0d\u80fd\u8d85\u8fc7320\u4e2a\u5b57\u7b26\u3002", (String)"ChargeRegisterPlugin_8", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if (operateKey.equals("getcode")) {
            boolean isInvalidPassword = this.isBlankOrContainsBlankChar("password");
            if (isInvalidPassword) {
                args.setCancel(true);
                return;
            }
            String hrcsChargeVerificationNumber = (String)APP_CACHE.get(HRCS_CHARGE_GETVERIFICATIONNUMBER, String.class);
            if (HRStringUtils.isNotEmpty((String)hrcsChargeVerificationNumber) && hrcsChargeVerificationNumber.equals("1")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ChargeRegisterPlugin_5", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if (operateKey.equals("bind")) {
            boolean isInvalidPassword = this.isBlankOrContainsBlankChar("password");
            if (isInvalidPassword) {
                args.setCancel(true);
                return;
            }
            String verifyCode = (String)this.getModel().getValue("code");
            if (HRStringUtils.isEmpty((String)verifyCode)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u9a8c\u8bc1\u7801\u3002", (String)"ChargeRegisterPlugin_9", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (this.isInvalidAccesstoken()) {
                args.setCancel(true);
                return;
            }
        } else if (operateKey.equals("bindtid")) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("hrcs_chargebindtid");
            Object value = this.getModel().getValue("tid");
            showParameter.setCustomParam("tid", value);
            showParameter.setCustomParam("id", this.getModel().getDataEntity().getPkValue());
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bindtid"));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
    }

    private boolean isInvalidAccesstoken() {
        boolean isInvalidAccesstoken = this.isBlankOrContainsBlankChar("accesstoken");
        if (isInvalidAccesstoken) {
            return true;
        }
        String accessToken = this.getModel().getValue("accesstoken").toString().trim();
        Matcher matcher1 = ACCESS_TOKEN_PTN.matcher(accessToken);
        if (!matcher1.matches()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"AccessToken\u4e0d\u7b26\u5408\u5bc6\u7801\u590d\u6742\u6027\u53ca\u957f\u5ea6\u8981\u6c42\uff0816~50\u4f4d\u5b57\u7b26\uff0c\u5927\u5c0f\u5199\u53ca\u6570\u5b57\u3001\u7279\u6b8a\u7b26\u53f7\u6df7\u5408\uff09", (String)"ChargeRegisterPlugin_7", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperationResult() == null) {
            return;
        }
        if (!afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            return;
        }
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        DynamicObject entity = this.getModel().getDataEntity();
        String chargeDomain = EcontractChargeServiceHelper.getChargeDoman();
        switch (operateKey) {
            case "register": {
                this.registerToCharge(entity, chargeDomain);
                break;
            }
            case "unbind": {
                this.unbindCompany(entity);
                break;
            }
            case "getcode": {
                this.getSmsCode(entity, chargeDomain);
                break;
            }
            case "bind": {
                this.registerToBind(entity, chargeDomain);
                break;
            }
            case "changelinkuser": {
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("hrcs_chargelinkuser");
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "chargelinkuser_callback");
                parameter.setCloseCallBack(closeCallBack);
                this.getView().showForm(parameter);
                break;
            }
            case "save": {
                this.updateCompany(entity);
                break;
            }
        }
    }

    private void updateCompany(DynamicObject entity) {
        entity.set("password", null);
        entity.set("accesstoken", null);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_chargeregister");
        helper.updateOne(entity);
        this.getView().updateView();
    }

    private void getSmsCode(DynamicObject entity, String chargeDomain) {
        String url = chargeDomain + "/tenant/cloud_auth/bind_woshou_account.do";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(PARAM_MAP.get("username"), entity.getString("username"));
        param.put("password", entity.getString("password"));
        String result = null;
        try {
            if (this.isChargeTimeoutMock("getCode")) {
                LOGGER.info("getCode chargeTimeoutMockStart,is ready to sleep {}ms", (Object)DEFAULT_READTIMEOUT);
                Thread.sleep(DEFAULT_READTIMEOUT);
                LOGGER.info("getCode chargeTimeoutMockEnd", (Object)DEFAULT_READTIMEOUT);
            } else {
                result = HttpClientUtils.post((String)url, null, param, (int)DEFAULT_CONNECTIONTIMEOUT, (int)DEFAULT_READTIMEOUT);
            }
        }
        catch (ConnectTimeoutException connectException) {
            LOGGER.info(MessageFormat.format("kd.hr.hrcs.formplugin.web.econtract.ChargeRegisterPlugin.getSmsCode http get connectException, result: {0}", new Object[]{connectException}));
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bbf\u95ee\u8bb8\u53ef\u670d\u52a1\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u7f51\u7edc\u73af\u5883\u662f\u5426\u901a\u7545\uff0c\u6216\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u8fdb\u884c\u7f51\u7edc\u73af\u5883\u4f9d\u8d56\u68c0\u67e5\uff0c\u53c2\u89c1\u793e\u533a\u5e2e\u52a9\u6587\u6863\u300a\u7535\u5b50\u5408\u540c\u6574\u4f53\u6d41\u7a0b\u8bf4\u660e\u300b\u3002", (String)"EContractSignChartPlugin_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        }
        catch (Exception exception) {
            LOGGER.error(MessageFormat.format("ChargeRegisterPlugin http get error : {0}", url), (Throwable)exception);
            this.getView().showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u8ba1\u8d39\u7cfb\u7edf\u5931\u8d25\uff1a{0}\u3002", (String)"ChargeRegisterPlugin_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), exception.getMessage()));
        }
        JSONObject data = this.analysisResult(result);
        if (data != null) {
            this.getView().showSuccessNotification(JSON.parseObject((String)result).getString("info"));
            this.getView().setEnable(Boolean.FALSE, new String[]{"getcode"});
            this.getView().updateView();
            APP_CACHE.put(HRCS_CHARGE_GETVERIFICATIONNUMBER, (Object)"1", 60);
            CountDown countdown = (CountDown)this.getView().getControl("countdownap");
            countdown.setDuration(60);
            countdown.start();
        }
    }

    private void unbindCompany(DynamicObject entity) {
        this.ubindChargeTid();
        entity.set("userstatus", (Object)"0");
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_chargeregister");
        helper.updateOne(entity);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u89e3\u7ed1\u6210\u529f", (String)"ChargeRegisterPlugin_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.getModel().setValue("accesstoken", null);
        this.getModel().setValue("code", null);
        this.getView().setEnable(Boolean.TRUE, new String[]{"getcode", "password"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"code"});
        this.getView().updateView();
        ChargeMessageServiceHelper.sendSms((String)MESSAGE_TEMPLATE_CODE_COMPANYSTATUS_CHANGED, (DynamicObject)entity, null);
    }

    private boolean ubindChargeTid() {
        DynamicObject chargeInfo = EcontractChargeServiceHelper.getChargeInfo((Object)this.getModel().getDataEntity().getPkValue());
        String tid = chargeInfo.getString("tid");
        if (HRStringUtils.isEmpty((String)tid)) {
            return true;
        }
        LOGGER.info("tid->{}", (Object)tid);
        JSONObject unbindInfo = EcontractChargeServiceHelper.unBindTid((String)tid);
        LOGGER.info("unbindInfo->{}", (Object)unbindInfo);
        boolean success = (Boolean)unbindInfo.get((Object)"success");
        if (!success) {
            Object msg = unbindInfo.get((Object)"msg");
            if (Objects.nonNull(msg) && msg instanceof String) {
                String errorInfo = (String)msg;
                this.getView().showErrorNotification(errorInfo);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a\u6216\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"ChargeBindTidPlugin_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        EcontractChargeServiceHelper.updateChargeTid((Object)this.getModel().getDataEntity().getPkValue(), (String)"");
        this.visableFalseTid();
        return true;
    }

    private void visableFalseTid() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"bindtid", "tid"});
    }

    public void closedCallBack(ClosedCallBackEvent cloEvt) {
        super.closedCallBack(cloEvt);
        if (HRStringUtils.equals((String)cloEvt.getActionId(), (String)"chargelinkuser_callback")) {
            Map selectedBosUserMap = (Map)cloEvt.getReturnData();
            if (selectedBosUserMap == null) {
                return;
            }
            Long bosUserId = (Long)selectedBosUserMap.get("bosUserId");
            DynamicObject entity = this.getModel().getDataEntity();
            if (entity.getLong("linkuser.id") == bosUserId.longValue()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8054\u7cfb\u4eba\u53d8\u66f4\u540e\uff0c\u4e0d\u80fd\u4e0e\u53d8\u66f4\u524d\u76f8\u540c\u3002", (String)"ChargeRegisterPlugin_11", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                return;
            }
            ChargeMessageServiceHelper.sendSms((String)MESSAGE_TEMPLATE_CODE_LINKNAME_CHANGED, (DynamicObject)entity, (Map)selectedBosUserMap);
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_chargeregister");
            HashSet<String> userStatusSet = new HashSet<String>();
            userStatusSet.add("0");
            userStatusSet.add("1");
            DynamicObject dbChargeCompanyDy = helper.loadDynamicObject(new QFilter("userstatus", "in", userStatusSet));
            String currLinkName = dbChargeCompanyDy.getLocaleString("linkuser.name").getLocaleValue();
            String targetLinkName = selectedBosUserMap.get("bosUserName").toString();
            String message = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u6210\u529f\uff0c\u4f01\u4e1a\u4fe1\u606f\u6ce8\u518c\u8054\u7cfb\u4eba\u5df2\u4ece%1$s\u53d8\u66f4\u4e3a%2$s\u3002", (String)"ChargeRegisterPlugin_12", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), currLinkName, targetLinkName);
            this.getView().showSuccessNotification(message);
            entity.set("linkuser", (Object)bosUserId);
            helper.saveOne(entity);
            this.getView().updateView();
        } else if (HRStringUtils.equals((String)cloEvt.getActionId(), (String)"bindtid")) {
            String successFlag;
            this.getView().invokeOperation("refresh");
            Object returnData = cloEvt.getReturnData();
            if (returnData instanceof String && "success".equals(successFlag = (String)returnData)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7ed1\u5b9a\u6210\u529f\u3002", (String)"ChargeBindTidPlugin_7", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private boolean isBlankOrContainsBlankChar(String key) {
        String passwordLocalValue = ((IDataEntityProperty)this.getModel().getDataEntityType().getProperties().get((Object)key)).getDisplayName().getLocaleValue();
        String password = (String)this.getModel().getValue(key);
        if (HRStringUtils.isEmpty((String)password)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%1$s\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ChargeRegisterPlugin_15", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), passwordLocalValue));
            return true;
        }
        if ((password = password.trim()).contains(" ")) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ChargeRegisterPlugin_10", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), passwordLocalValue));
            return true;
        }
        return false;
    }

    private void registerToBind(DynamicObject entity, String chargeDomain) {
        boolean thirdApps = this.isThirdApps(entity);
        if (!thirdApps) {
            return;
        }
        boolean isUpdatecharge = true;
        String updatecharge = SystemPropertyUtils.getProptyByTenant((String)"kd.hr.hrcs.econtract.updatecharge", (String)RequestContext.get().getTenantId());
        if (HRStringUtils.isNotEmpty((String)updatecharge)) {
            isUpdatecharge = Boolean.parseBoolean(updatecharge);
        }
        boolean isBind = true;
        if (isUpdatecharge) {
            isBind = this.bind(chargeDomain, entity);
        }
        if (isBind) {
            APP_CACHE.put(HRCS_CHARGE_GETVERIFICATIONNUMBER, (Object)"0");
            entity.set("userstatus", (Object)"1");
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_chargeregister");
            helper.saveOne(entity);
            this.getView().updateView();
            ChargeMessageServiceHelper.sendSms((String)MESSAGE_TEMPLATE_CODE_COMPANYSTATUS_CHANGED, (DynamicObject)entity, null);
        }
    }

    private boolean bind(String chargeDomain, DynamicObject entity) {
        boolean isBind = true;
        String url = chargeDomain + "/tenant/cloud_auth/bind_woshou_account.do";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(PARAM_MAP.get("serviceid"), entity.getString("serviceid"));
        param.put(PARAM_MAP.get("url"), RequestContext.get().getClientFullContextPath());
        param.put("password", entity.getString("password").trim());
        param.put("ver_code", entity.getString("code"));
        param.put("tenantid", RequestContext.get().getTenantId());
        param.put("accountId", RequestContext.get().getAccountId());
        param.put("appId", "shr_charge");
        param.put("appSecuret", entity.getString("accesstoken"));
        param.put("user", "administrator");
        param.put("from", "2");
        String result = null;
        try {
            if (this.isChargeTimeoutMock("oldRegister")) {
                LOGGER.info("oldRegister chargeTimeoutMockStart,is ready to sleep {}ms", (Object)DEFAULT_READTIMEOUT);
                Thread.sleep(DEFAULT_READTIMEOUT);
                LOGGER.info("oldRegister chargeTimeoutMockEnd", (Object)DEFAULT_READTIMEOUT);
            } else {
                result = HttpClientUtils.post((String)url, null, param, (int)DEFAULT_CONNECTIONTIMEOUT, (int)DEFAULT_READTIMEOUT);
            }
        }
        catch (ConnectTimeoutException connectException) {
            LOGGER.info(MessageFormat.format("kd.hr.hrcs.formplugin.web.econtract.ChargeRegisterPlugin.bind http get connectException, result: {0}", new Object[]{connectException}));
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bbf\u95ee\u8bb8\u53ef\u670d\u52a1\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u7f51\u7edc\u73af\u5883\u662f\u5426\u901a\u7545\uff0c\u6216\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u8fdb\u884c\u7f51\u7edc\u73af\u5883\u4f9d\u8d56\u68c0\u67e5\uff0c\u53c2\u89c1\u793e\u533a\u5e2e\u52a9\u6587\u6863\u300a\u7535\u5b50\u5408\u540c\u6574\u4f53\u6d41\u7a0b\u8bf4\u660e\u300b\u3002", (String)"EContractSignChartPlugin_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        }
        catch (Exception exception) {
            LOGGER.error(MessageFormat.format("ChargeRegisterPlugin http get error : {0}", url), (Throwable)exception);
            this.getView().showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u8ba1\u8d39\u7cfb\u7edf\u5931\u8d25\uff1a{0}\u3002", (String)"ChargeRegisterPlugin_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), exception.getMessage()));
        }
        JSONObject data = this.analysisResult(result);
        if (data == null) {
            isBind = false;
        } else {
            entity.set("servicekey", (Object)data.getString(PARAM_MAP.get("servicekey")));
            entity.set("serviceid", (Object)data.getString(PARAM_MAP.get("serviceid")));
            this.getView().showSuccessNotification(JSON.parseObject((String)result).getString("info"));
        }
        return isBind;
    }

    private boolean isChargeTimeoutMock(String key) {
        boolean isChargeTimeout = false;
        String updatecharge = SystemPropertyUtils.getProptyByTenant((String)("kd.hr.hrcs.chargeapi.mock." + key + ".enable"), (String)RequestContext.get().getTenantId());
        if (HRStringUtils.isNotEmpty((String)updatecharge)) {
            isChargeTimeout = Boolean.parseBoolean(updatecharge);
        }
        return isChargeTimeout;
    }

    private void registerToCharge(DynamicObject entity, String chargeDomain) {
        Integer times = (Integer)APP_CACHE.get(REGISTER_PREFIX + RequestContext.get().getTenantId(), Integer.class);
        if (times != null && times >= 10) {
            this.getView().showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u9519\u8bef\u6b21\u6570\u5df2\u8d85\u8fc7{0}\u6b21\uff0c\u6ce8\u518c\u670d\u52a1\u6682\u65f6\u9501\u5b9a\uff0c\u8bf7\u4e8e\u6b21\u65e5\u91cd\u65b0\u6ce8\u518c\u3002", (String)"ChargeRegisterPlugin_13", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), 10));
            return;
        }
        boolean thirdApps = this.isThirdApps(entity);
        if (!thirdApps) {
            return;
        }
        boolean isUpdatecharge = true;
        String updatecharge = SystemPropertyUtils.getProptyByTenant((String)"kd.hr.hrcs.econtract.updatecharge", (String)RequestContext.get().getTenantId());
        if (HRStringUtils.isNotEmpty((String)updatecharge)) {
            isUpdatecharge = Boolean.parseBoolean(updatecharge);
        }
        boolean isRegister = true;
        if (isUpdatecharge) {
            isRegister = this.register(chargeDomain, entity);
        }
        LOGGER.info("registerToCharge isRegister={}", (Object)isRegister);
        if (isRegister) {
            entity.set("userstatus", (Object)"1");
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_chargeregister");
            helper.saveOne(entity);
            ChargeLicGrpServiceHelper.saveNewDetail((Long)entity.getLong("id"));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6ce8\u518c\u6210\u529f", (String)"ChargeRegisterPlugin_3", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            this.getView().updateView();
            ChargeMessageServiceHelper.sendSms((String)MESSAGE_TEMPLATE_CODE_COMPANYSTATUS_CHANGED, (DynamicObject)entity, null);
        }
    }

    private boolean isThirdApps(DynamicObject entity) {
        HRBaseServiceHelper openApiHelper = new HRBaseServiceHelper("openapi_3rdapps");
        DynamicObject openApi = openApiHelper.queryOne("syspwd,modifier,modifytime", new QFilter[]{new QFilter("number", "=", (Object)"shr_charge"), new QFilter("enable", "=", (Object)"1")});
        LOGGER.info(MessageFormat.format("get open app is {0}", openApi));
        if (HRObjectUtils.isEmpty((Object)openApi)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u7b2c\u4e09\u65b9\u5e94\u7528\u3002", (String)"ChargeRegisterPlugin_4", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            return false;
        }
        openApi.set("syspwd", (Object)PasswordEncryptUtil.getEncryptePasswordWithSalt((String)entity.getString("accesstoken").trim()));
        openApi.set("modifier", (Object)RequestContext.get().getCurrUserId());
        openApi.set("modifytime", (Object)new Date());
        openApiHelper.saveOne(openApi);
        return true;
    }

    private boolean register(String chargeDomain, DynamicObject entity) {
        boolean isRegister = true;
        String accessToken = entity.getString("accesstoken").trim();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(PARAM_MAP.get("username"), entity.getString("username"));
        param.put("password", entity.getString("password"));
        param.put(PARAM_MAP.get("orgname"), entity.getString("orgname"));
        param.put(PARAM_MAP.get("orgsimplename"), entity.getString("orgsimplename"));
        param.put(PARAM_MAP.get("url"), RequestContext.get().getClientFullContextPath());
        param.put(PARAM_MAP.get("orgurl"), entity.getString("orgurl"));
        param.put(PARAM_MAP.get("email"), entity.getString("email"));
        param.put("tenantid", RequestContext.get().getTenantId());
        param.put("accountId", RequestContext.get().getAccountId());
        param.put("appId", "shr_charge");
        param.put("appSecuret", accessToken);
        param.put("user", "administrator");
        param.put("from", "2");
        LOGGER.info("register map={}", (Object)JSON.toJSONString(param).replace(accessToken, ""));
        String url = chargeDomain + "/tenant/cloud_auth/sign_enterprise.do";
        String result = null;
        try {
            if (this.isChargeTimeoutMock("newRegister")) {
                LOGGER.info("newRegister chargeTimeoutMockStart,is ready to sleep {}ms", (Object)DEFAULT_READTIMEOUT);
                Thread.sleep(DEFAULT_READTIMEOUT);
                LOGGER.info("newRegister chargeTimeoutMockEnd", (Object)DEFAULT_READTIMEOUT);
            } else {
                result = HttpClientUtils.post((String)url, null, param, (int)DEFAULT_CONNECTIONTIMEOUT, (int)DEFAULT_READTIMEOUT);
            }
        }
        catch (ConnectTimeoutException connectException) {
            LOGGER.info(MessageFormat.format("kd.hr.hrcs.formplugin.web.econtract.ChargeRegisterPlugin.register http get connectException, result: {0}", new Object[]{connectException}));
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bbf\u95ee\u8bb8\u53ef\u670d\u52a1\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u7f51\u7edc\u73af\u5883\u662f\u5426\u901a\u7545\uff0c\u6216\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u8fdb\u884c\u7f51\u7edc\u73af\u5883\u4f9d\u8d56\u68c0\u67e5\uff0c\u53c2\u89c1\u793e\u533a\u5e2e\u52a9\u6587\u6863\u300a\u7535\u5b50\u5408\u540c\u6574\u4f53\u6d41\u7a0b\u8bf4\u660e\u300b\u3002", (String)"EContractSignChartPlugin_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        }
        catch (Exception exception) {
            LOGGER.error(MessageFormat.format("ChargeRegisterPlugin http get error : {0}", url), (Throwable)exception);
            this.getView().showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u8ba1\u8d39\u7cfb\u7edf\u5931\u8d25\uff1a{0}\u3002", (String)"ChargeRegisterPlugin_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), exception.getMessage()));
            isRegister = false;
        }
        JSONObject data = this.analysisRegisterResult(result, entity);
        if (data == null) {
            isRegister = false;
        } else {
            entity.set("servicekey", (Object)data.getString(PARAM_MAP.get("servicekey")));
            entity.set("serviceid", (Object)data.getString(PARAM_MAP.get("serviceid")));
            entity.set("secretKey", (Object)data.getString(PARAM_MAP.get("secretKey")));
        }
        return isRegister;
    }

    private JSONObject analysisRegisterResult(String result, DynamicObject entity) {
        JSONObject jsonObject = this.getJsonResultObj(result);
        if (jsonObject == null) {
            return null;
        }
        Integer code = jsonObject.getInteger("code");
        String cacheKey = REGISTER_PREFIX + RequestContext.get().getTenantId();
        if (code != null && code.equals(0)) {
            LOGGER.info("------------------ChargeRegisterPlugin code==0");
            APP_CACHE.remove(cacheKey);
            LOGGER.info("------------------ChargeRegisterPlugin remove");
            return jsonObject.getJSONObject("data");
        }
        int timeout = (int)Duration.between(LocalTime.now(), LocalTime.of(23, 59, 59)).getSeconds() + 1;
        Integer times = (Integer)APP_CACHE.get(cacheKey, Integer.class);
        times = times == null ? 1 : times + 1;
        LOGGER.info("------------------ChargeRegisterPlugin code==" + code + ";timeout=" + timeout);
        APP_CACHE.put(cacheKey, (Object)times, timeout);
        this.getView().showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u9519\u8bef\uff1a{0}\uff0c\u5269\u4f59\u6b21\u6570\uff1a{1}\u6b21\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u4e91\u901a\u884c\u8bc1\u8d26\u6237\u548c\u5bc6\u7801\u3002", (String)"ChargeRegisterPlugin_14", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), jsonObject.getString("info"), 10 - times));
        return null;
    }

    private JSONObject analysisResult(String result) {
        JSONObject jsonObject = this.getJsonResultObj(result);
        if (jsonObject == null) {
            return null;
        }
        Integer code = jsonObject.getInteger("code");
        if (code != null && code.equals(0)) {
            return jsonObject.getJSONObject("data");
        }
        this.getView().showErrorNotification(jsonObject.getString("info"));
        return null;
    }

    private JSONObject getJsonResultObj(String result) {
        JSONObject jsonObject;
        if (HRStringUtils.isEmpty((String)result)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u670d\u52a1\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"ChargeRegisterPlugin_6", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            return null;
        }
        try {
            jsonObject = JSON.parseObject((String)result);
        }
        catch (RuntimeException ex) {
            LOGGER.info(MessageFormat.format("ChargeRegisterPluginResolve smsResult error\uff1a{0}", result));
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u670d\u52a1\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"ChargeRegisterPlugin_6", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            return null;
        }
        String status = jsonObject.getString("status");
        if (HRStringUtils.isNotEmpty((String)status) && !status.startsWith("2")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u670d\u52a1\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"ChargeRegisterPlugin_6", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            return null;
        }
        return jsonObject;
    }

    static {
        PARAM_MAP.put("username", "username");
        PARAM_MAP.put("orgname", "name");
        PARAM_MAP.put("orgsimplename", "simple_name");
        PARAM_MAP.put("url", "domain");
        PARAM_MAP.put("orgurl", "homepage");
        PARAM_MAP.put("email", "email");
        PARAM_MAP.put("code", "code");
        PARAM_MAP.put("servicekey", "service_key");
        PARAM_MAP.put("serviceid", "service_id");
    }
}

