/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.econtract;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hrcs.bussiness.servicehelper.econtract.KeywordMappingServiceHelper;

public class CommonVariableListPlugin
extends HRDataBaseList {
    private static final Log LOGGER = LogFactory.getLog(CommonVariableListPlugin.class);
    private static Map<Long, DynamicObject> tplVariableConfigMap = Maps.newHashMapWithExpectedSize((int)16);

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"new", (CharSequence)formOperate.getOperateKey())) {
            BillShowParameter fsp = new BillShowParameter();
            Map<String, Object> params = this.getParamsMap();
            fsp.setCustomParams(params);
            fsp.setFormId("hrcs_commonvariable");
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "new"));
            this.getView().showForm((FormShowParameter)fsp);
            args.setCancel(true);
        } else if (StringUtils.equals((CharSequence)"tplvariableconfig", (CharSequence)formOperate.getOperateKey())) {
            BillShowParameter fsp = new BillShowParameter();
            Map<String, Object> params = this.getParamsMap();
            fsp.setCustomParams(params);
            fsp.setFormId("hrcs_tplvariableconfig");
            fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)fsp);
        } else if (HRStringUtils.equals((String)"delete", (String)formOperate.getOperateKey())) {
            String formNumber = (String)this.getView().getFormShowParameter().getCustomParam("formnumber");
            ((AbstractOperate)args.getSource()).getOption().setVariableValue("deleteParam", formNumber);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getPageCache().remove("cachFlag");
    }

    public void packageData(PackageDataEvent packageDataEvt) {
        super.packageData(packageDataEvt);
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)packageDataEvt.getSource();
        String fieldKey = columnDesc.getFieldKey();
        if (HRStringUtils.equals((String)fieldKey, (String)"ruletext")) {
            String cachFlag = this.getPageCache().get("cachFlag");
            if (HRStringUtils.isEmpty((String)cachFlag)) {
                tplVariableConfigMap = KeywordMappingServiceHelper.getAllTplVariableConfigMap();
                this.getPageCache().put("cachFlag", "1");
            }
            long rowId = packageDataEvt.getRowData().getLong("id");
            try {
                HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hrcs_commonvariable");
                DynamicObject dynamicObject = hrBaseServiceHelper.queryOne((Object)rowId);
                Long relateEntityId = dynamicObject.getLong("relateentityid");
                if (relateEntityId == 0L) {
                    String formId = this.getView().getFormShowParameter().getFormId();
                    String preText = "bos_listf7".equals(formId) ? ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u53d8\u91cf\u5c5e\u6027\uff1a", (String)"CommonVariablePlugin_3", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6620\u5c04key\uff1a", (String)"CommonVariablePlugin_7", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
                    String key = ResManager.loadKDString((String)"%s", (String)"CommonVariablePlugin_4", (String)"hrmp-hrcs-formplugin", (Object[])new Object[]{dynamicObject.getString("custkey")});
                    String buildFilterDesc = preText + key;
                    packageDataEvt.setFormatValue((Object)buildFilterDesc);
                } else {
                    String entityNumber = dynamicObject.getString("entitynumber");
                    String entityField = dynamicObject.getString("entityfield");
                    String ruleStr = dynamicObject.getString("filtercondition");
                    DynamicObject tplVariableConfig = KeywordMappingServiceHelper.getTplVariableConfig((Object)relateEntityId);
                    String isEntry = tplVariableConfig.getString("isentry");
                    String entryNumber = tplVariableConfig.getString("entrynumber");
                    ArrayList pathList = Lists.newArrayListWithCapacity((int)16);
                    String[] split = entityField.split("\\.");
                    if ("1".equals(isEntry)) {
                        KeywordMappingServiceHelper.getPrePathList((String)entryNumber, (String[])split, (ArrayList)pathList);
                    } else {
                        KeywordMappingServiceHelper.getPrePathList((String)entityNumber, (String[])split, (ArrayList)pathList);
                    }
                    Collections.reverse(pathList);
                    String entityPath = KeywordMappingServiceHelper.getdisplayEntityPath((long)relateEntityId, (ArrayList)pathList, tplVariableConfigMap);
                    String entityMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u5c5e\u6027\uff1a", (String)"CommonVariablePlugin_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
                    String buildFilterDesc = KeywordMappingServiceHelper.buildFilterDesc((String)(entityMsg + entityPath), (String)entityNumber, (String)ruleStr, (String)relateEntityId.toString());
                    packageDataEvt.setFormatValue((Object)buildFilterDesc);
                }
            }
            catch (Exception exception) {
                LOGGER.error("CommonVariableListPlugin.packageData error rowId={}", (Object)rowId);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("new".equals(actionId)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void setFilter(SetFilterEvent event) {
        Object configEnter = this.getView().getFormShowParameter().getCustomParam("configEnter");
        if (null != configEnter) {
            List filters = event.getQFilters();
            QFilter statusFilter = new QFilter("enable", "not in", (Object)"0");
            filters.add(statusFilter);
        }
    }

    private Map<String, Object> getParamsMap() {
        Map originalCustParams = this.getView().getFormShowParameter().getCustomParams();
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.putAll(originalCustParams);
        return params;
    }
}

