/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.econtract;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Button;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRBaseDataCommonEdit;
import kd.hr.hrcs.bussiness.service.econtract.ChargeLicGrpServiceHelper;
import kd.hr.hrcs.bussiness.service.econtract.ChargeSiteService;
import kd.hr.hrcs.bussiness.service.econtract.EcontractWarnConfigService;

public class EContractWarnConfigPlugin
extends HRBaseDataCommonEdit {
    private static final Log LOGGER = LogFactory.getLog(EContractWarnConfigPlugin.class);
    private static EcontractWarnConfigService warnConfigService = new EcontractWarnConfigService();
    private static String WARN_NUMBER = "warnnumber";
    private static String HRCS_WARNCONFIG = "hrcs_warnconfig";
    private static String MODIFY_PERMITEM_ID = "4715a0df000000ac";
    public static final String SUCCESS = "success";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        HRBaseServiceHelper helper = new HRBaseServiceHelper(HRCS_WARNCONFIG);
        DynamicObject dynamicObject = helper.generateEmptyDynamicObject();
        MainEntityType mainType = (MainEntityType)dynamicObject.getDataEntityType();
        EntityType type = (EntityType)mainType.getAllEntities().get("entryentity");
        DynamicObjectCollection entryDys = dynamicObject.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection allWarnConfigData = warnConfigService.queryOriginalAll();
        if (!allWarnConfigData.isEmpty()) {
            entryDys.addAll((Collection)allWarnConfigData.stream().map(warnConfig -> this.getWarnConfigData(type, warnConfig.get("id"), warnConfig.get("seqnumber"), warnConfig.get("warnvalue"), warnConfig.get(WARN_NUMBER))).collect(Collectors.toList()));
        }
        IDataModel model = this.getModel();
        model.setValue("entryentity", (Object)entryDys);
        boolean modifyPermission = this.getModifyPermission();
        if (modifyPermission) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnclose"});
        } else {
            int size = entryDys.size();
            for (int i = 0; i < size; ++i) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"warnvalue"});
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"createnewrow", "deleterow", "btnok", "btncancel"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"btnclose"});
        }
    }

    private DynamicObject getWarnConfigData(EntityType type, Object id, Object seq, Object wanrValue, Object warnNumber) {
        DynamicObject warnConfig = (DynamicObject)type.createInstance();
        warnConfig.set("id", id);
        warnConfig.set("seq", seq);
        warnConfig.set("warnvalue", wanrValue);
        warnConfig.set(WARN_NUMBER, warnNumber);
        return warnConfig;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        this.getModel().getDataChanged();
        String desc = this.getModel().getChangeDesc();
        if (HRStringUtils.isNotEmpty((String)desc)) {
            super.beforeClosed(e);
        }
    }

    private boolean getModifyPermission() {
        long userId = RequestContext.get().getCurrUserId();
        boolean modifyPermission = PermissionServiceHelper.checkPermission((Long)userId, (String)"hrcs", (String)HRCS_WARNCONFIG, (String)MODIFY_PERMITEM_ID);
        LOGGER.info("EContractWarnConfigPlugin getModifyPermission permission={}, userId={}.", (Object)modifyPermission, (Object)userId);
        return modifyPermission;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (!(source instanceof Button)) {
            return;
        }
        String name = ((Button)source).getKey();
        if (!"btnok".equals(name)) {
            return;
        }
        boolean modifyPermission = this.getModifyPermission();
        if (!modifyPermission) {
            return;
        }
        DynamicObject dyn = this.getModel().getDataEntity();
        DynamicObjectCollection allEntryEntities = (DynamicObjectCollection)dyn.get("entryentity");
        ArrayList warnValueList = new ArrayList(allEntryEntities.size());
        List allEntitiesList = allEntryEntities.stream().filter(ele -> this.isValidWarnConfigData(warnValueList, (DynamicObject)ele)).collect(Collectors.toList());
        if (allEntryEntities.size() != allEntitiesList.size()) {
            return;
        }
        DynamicObject[] allInDb = warnConfigService.queryAll();
        if (allInDb == null || allInDb.length == 0) {
            warnConfigService.saveNew(allEntitiesList);
        } else {
            Map<Boolean, List<DynamicObject>> entryMap = allEntitiesList.stream().collect(Collectors.partitioningBy(ele -> (Long)ele.get("id") == 0L));
            List<DynamicObject> updateEntryList = entryMap.get(false);
            Map<Long, DynamicObject> updateEntryMap = updateEntryList.stream().collect(Collectors.toMap(ele -> (Long)ele.get("id"), ele -> ele));
            List<DynamicObject> addEntryList = entryMap.get(true);
            List needChangeList = Arrays.stream(allInDb).filter(ele -> {
                DynamicObject entryDo = (DynamicObject)updateEntryMap.get(ele.get("id"));
                if (entryDo == null) {
                    return true;
                }
                boolean isNotChanged = entryDo.getInt("warnvalue") == ele.getInt("warnvalue");
                return !isNotChanged;
            }).collect(Collectors.toList());
            if (!needChangeList.isEmpty()) {
                List<DynamicObject> updateDoList;
                Map<Boolean, List<DynamicObject>> dbMap = needChangeList.stream().collect(Collectors.partitioningBy(ele -> {
                    Object id = ele.get("id");
                    return updateEntryMap.containsKey(id);
                }));
                List<DynamicObject> deleteDoList = dbMap.get(false);
                if (!deleteDoList.isEmpty()) {
                    warnConfigService.deleteByFilter(deleteDoList.stream().map(ele -> (Long)ele.get("id")).collect(Collectors.toList()));
                }
                if (!(updateDoList = dbMap.get(true)).isEmpty()) {
                    int availabledSite = this.getLicCnt("licnum");
                    updateDoList.forEach(ele -> {
                        DynamicObject entryDo = (DynamicObject)updateEntryMap.get(ele.get("id"));
                        ele.set("warnvalue", entryDo.get("warnvalue"));
                        int warnNumber = entryDo.getInt(WARN_NUMBER);
                        ele.set(WARN_NUMBER, (Object)warnNumber);
                        if (warnNumber <= availabledSite) {
                            ele.set("sendwarnmsgflag", (Object)0);
                            ele.set("warnmsgsendtime", null);
                        }
                    });
                    warnConfigService.update(updateDoList);
                }
            }
            if (!addEntryList.isEmpty()) {
                warnConfigService.saveNew(addEntryList);
            }
        }
        this.getModel().setDataChanged(false);
        this.getView().updateView();
        this.getView().returnDataToParent((Object)SUCCESS);
        this.getView().close();
    }

    private boolean isValidWarnConfigData(List<String> warnValueList, DynamicObject warnConfigData) {
        String warnValue = (String)warnConfigData.get("warnvalue");
        if (HRStringUtils.isEmpty((String)warnValue)) {
            return false;
        }
        if (warnValueList.contains(warnValue)) {
            return false;
        }
        warnValueList.add(warnValue);
        Integer warnNumber = (Integer)warnConfigData.get(WARN_NUMBER);
        return warnNumber != 0;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        DynamicObject dynamicObject = changeData.getDataEntity();
        String newValStr = (String)changeData.getNewValue();
        if ("".equals(newValStr)) {
            dynamicObject.set(WARN_NUMBER, (Object)0);
        } else {
            int newVal = Integer.parseInt(newValStr);
            int warnNumber = warnConfigService.calcWarnNumber(newVal, this.getLicCnt("buylicnum"));
            dynamicObject.set(WARN_NUMBER, (Object)warnNumber);
        }
        this.getView().updateView();
    }

    private int getLicCnt(String type) {
        DynamicObject chargeSite = ChargeSiteService.getDynamicObject();
        if (chargeSite == null) {
            return 0;
        }
        DynamicObject licGrpDetail = ChargeLicGrpServiceHelper.getLicGrpDetail((Long)chargeSite.getLong("id"));
        if (licGrpDetail == null) {
            return 0;
        }
        return licGrpDetail.getInt(type);
    }
}

