/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.econtract;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.common.model.econtract.EContEntityField;

public class EntityFieldMappingProvider
extends ListDataProvider {
    private List<EContEntityField> entityFieldList;
    private boolean isClickNode;
    private String selectIndexStr;
    private String selectFieldNumber;

    public EntityFieldMappingProvider(List<EContEntityField> entityFieldList, boolean isClickNode, String selectFieldNumber) {
        this.entityFieldList = entityFieldList;
        this.isClickNode = isClickNode;
        this.selectFieldNumber = selectFieldNumber;
    }

    public DynamicObjectCollection getData(int start, int limit) {
        HRBaseServiceHelper mappingHelper = new HRBaseServiceHelper("hrcs_entityfieldmp");
        ArrayList totalListData = Lists.newArrayListWithCapacity((int)16);
        if (this.entityFieldList == null || this.entityFieldList.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u672a\u641c\u7d22\u5230\u7b26\u5408\u6761\u4ef6\u7684\u5b57\u6bb5\u3002", (String)"EntityFieldMappingProvider_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        List qFilters = this.getQFilters();
        List<Object> filteredEntityFieldList = qFilters == null || qFilters.isEmpty() ? this.entityFieldList : this.entityFieldList.stream().filter(entityField -> {
            QFilter qFilter;
            boolean isShow = true;
            Iterator iterator = qFilters.iterator();
            while (iterator.hasNext() && (isShow = this.decideIsShowByFilter(qFilter = (QFilter)iterator.next(), (EContEntityField)entityField, isShow))) {
            }
            return isShow;
        }).collect(Collectors.toList());
        for (int i = 0; i < filteredEntityFieldList.size(); ++i) {
            EContEntityField entityField2 = filteredEntityFieldList.get(i);
            DynamicObject row2 = mappingHelper.generateEmptyDynamicObject();
            row2.set("number", (Object)entityField2.getNumber());
            row2.set("name", (Object)entityField2.getLocalName());
            row2.set("entityname", (Object)entityField2.getEntityLongName());
            row2.set("id", (Object)SerializationUtils.toJsonString((Object)entityField2));
            if (HRStringUtils.equals((String)row2.getString("number"), (String)this.selectFieldNumber)) {
                this.selectIndexStr = String.valueOf(i);
            }
            totalListData.add(row2);
        }
        if (this.isClickNode()) {
            start = 0;
        }
        List subList = Lists.newArrayListWithCapacity((int)16);
        if (start + limit < totalListData.size()) {
            subList = totalListData.subList(start, start + limit);
        } else if (totalListData.size() - 1 == start) {
            subList.add(totalListData.get(start));
        } else {
            subList = totalListData.subList(start, totalListData.size());
        }
        DynamicObjectCollection listData = new DynamicObjectCollection();
        subList.forEach(row -> listData.add(row));
        if (listData.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u672a\u641c\u7d22\u5230\u7b26\u5408\u6761\u4ef6\u7684\u5b57\u6bb5\u3002", (String)"EntityFieldMappingProvider_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        return listData;
    }

    private boolean decideIsShowByFilter(QFilter qFilter, EContEntityField entityField, boolean isShow) {
        String originValue = (String)qFilter.getOriginValue();
        String[] filterCon = originValue.split("#");
        String value = filterCon[1];
        if (value.contains("\b")) {
            String[] valueFinal;
            for (String singleValue : valueFinal = value.split("\b")) {
                isShow = false;
                if (filterCon[0].contains("number") && !filterCon[0].contains("name")) {
                    if (!entityField.getNumber().contains(singleValue)) continue;
                    isShow = true;
                } else if (!filterCon[0].contains("number") && filterCon[0].contains("name")) {
                    if (!entityField.getLocalName().contains(singleValue)) continue;
                    isShow = true;
                } else {
                    if (!entityField.getNumber().contains(singleValue) && !entityField.getLocalName().contains(singleValue)) continue;
                    isShow = true;
                }
                break;
            }
        } else if (filterCon[0].contains("number") && !filterCon[0].contains("name")) {
            if (!entityField.getNumber().contains(value)) {
                isShow = false;
            }
        } else if (!filterCon[0].contains("number") && filterCon[0].contains("name")) {
            if (!entityField.getLocalName().contains(value)) {
                isShow = false;
            }
        } else if (!entityField.getNumber().contains(value) && !entityField.getLocalName().contains(value)) {
            isShow = false;
        }
        return isShow;
    }

    public boolean isClickNode() {
        return this.isClickNode;
    }

    public void setClickNode(boolean clickNode) {
        this.isClickNode = clickNode;
    }

    public String getSelectIndexStr() {
        return this.selectIndexStr;
    }
}

