/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.esign;

import com.alibaba.fastjson.JSONArray;
import com.google.common.base.Joiner;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.Save;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.OpBizRuleSetServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hrcs.bussiness.service.esign.api.AcrossCorporateAuth;
import kd.hr.hrcs.bussiness.service.esign.api.CorporateSealQuery;
import kd.hr.hrcs.bussiness.service.esign.bo.SealAuthInfo;
import kd.hr.hrcs.bussiness.service.esign.constant.ESignSealAuthEditPage;
import kd.hr.hrcs.bussiness.service.esign.factory.BaseESignSrvFactory;
import kd.hr.hrcs.bussiness.service.esign.factory.ServiceRouter;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.util.ResponseUtil;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.util.SealUtil;
import kd.hr.hrcs.bussiness.service.esign.res.ResponseData;
import kd.hr.hrcs.bussiness.service.esign.util.ESignAppCfgUtil;
import kd.hr.hrcs.bussiness.service.esign.util.ESignCOAuthUtil;
import kd.hr.hrcs.bussiness.service.esign.util.ESignCOSealMgrUtil;
import kd.hr.hrcs.bussiness.service.esign.util.ESignDBServiceUtil;
import kd.hr.hrcs.formplugin.common.HrcsFormpluginRes;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;

public class ESignSeaAuthEdit
extends HRDataBaseEdit
implements ESignSealAuthEditPage {
    private static final Log LOGGER = LogFactory.getLog(ESignSeaAuthEdit.class);

    public void afterCreateNewData(EventObject e) {
        String appNumber;
        String corporateNumber;
        DynamicObject coAuthDyn;
        super.afterCreateNewData(e);
        String uuid = UUID.randomUUID().toString().replace("-", "");
        this.getModel().setValue("number", (Object)uuid);
        this.getModel().setValue("name", (Object)uuid);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long spId = (Long)formShowParameter.getCustomParam("spId");
        if (ObjectUtils.isNotEmpty((Object)spId)) {
            this.getModel().setValue("esignsp", (Object)spId);
        }
        if (ObjectUtils.isEmpty((Object)(coAuthDyn = ESignCOAuthUtil.getCOAuthDyn((String)(corporateNumber = (String)formShowParameter.getCustomParam("corporateNumber")), (String)(appNumber = (String)formShowParameter.getCustomParam("appNumber")))))) {
            Long corporateId = ESignCOSealMgrUtil.getCorporateId((String)corporateNumber);
            this.getModel().setValue("authcompany", (Object)corporateId);
        } else {
            this.getModel().setValue("authcompany", coAuthDyn.get("authapp.corporate.id"));
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getModel().setDataChanged(false);
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate fo = (FormOperate)args.getSource();
        switch (fo.getOperateKey()) {
            case "save": {
                DynamicObject[] eSignCoSealDyns;
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                Long spId = (Long)formShowParameter.getCustomParam("spId");
                DynamicObject authCompanyDyn = (DynamicObject)this.getModel().getValue("authcompany");
                Long mainCorpId = (Long)authCompanyDyn.getPkValue();
                BaseESignSrvFactory baseESignSrvFactory = ServiceRouter.getSrvFactory((Long)spId, (Long)mainCorpId);
                AcrossCorporateAuth acrossCorporateAuth = baseESignSrvFactory.getAcrossCorporateAuth();
                JSONArray customParam = (JSONArray)formShowParameter.getCustomParam("sealIds");
                HashSet sealPkIds = new HashSet(customParam);
                HashMap<String, String> otherCheckDatas = new HashMap<String, String>(sealPkIds.size());
                HashBasedTable dataTable = HashBasedTable.create();
                for (DynamicObject coSealDyn : eSignCoSealDyns = ESignDBServiceUtil.eSignCOSealService.loadDynamicObjectArray(sealPkIds.toArray())) {
                    String corporateId = coSealDyn.getString("corporate_id");
                    String appId = coSealDyn.getString("esignapp_id");
                    HashSet<Object> sealIds = (HashSet<Object>)dataTable.get((Object)appId, (Object)corporateId);
                    if (CollectionUtils.isEmpty((Collection)sealIds)) {
                        sealIds = new HashSet<Object>(8);
                    }
                    Object sealId = coSealDyn.get("sealid");
                    sealIds.add(sealId);
                    dataTable.put((Object)appId, (Object)corporateId, sealIds);
                    otherCheckDatas.put(String.valueOf(sealId), coSealDyn.getString("number"));
                }
                Set cells = dataTable.cellSet();
                if (cells.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u652f\u6301\u9009\u62e9\u4e00\u4e2a\u4f01\u4e1a\u6388\u6743\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)HrcsFormpluginRes.ESignSeaAuthEdit_1.resId(), (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                ArrayList<String> errMsg = new ArrayList<String>(sealPkIds.size());
                ORM orm = ORM.create();
                long[] pkIds = orm.genLongIds("hrcs_esignsealauth", eSignCoSealDyns.length);
                HashMap<String, Long> sealIdMappingPkId = new HashMap<String, Long>(6);
                for (Table.Cell cell : cells) {
                    HashSet<String> rpcCheckSealIds = new HashSet<String>(sealPkIds.size());
                    Set sealIds = (Set)cell.getValue();
                    Long corporateId = Long.valueOf((String)cell.getColumnKey());
                    String openCorpId = ESignAppCfgUtil.getOwnerOpenCorpId((Long)spId, (Long)corporateId);
                    String businessId = acrossCorporateAuth.getCurBusinessId();
                    Map dbFreeSignInfos = ESignCOSealMgrUtil.getAuthAllSeals((Long)spId, (Long)corporateId, (Long)mainCorpId, (String)openCorpId, (String)businessId);
                    boolean isExistAuthedSeals = false;
                    Set<Object> dbFreeSignInfoKeys = new HashSet(0);
                    if (MapUtils.isNotEmpty((Map)dbFreeSignInfos)) {
                        isExistAuthedSeals = true;
                        dbFreeSignInfoKeys = dbFreeSignInfos.keySet();
                    }
                    long currUserId = RequestContext.get().getCurrUserId();
                    DynamicObjectCollection addDyns = new DynamicObjectCollection();
                    for (int i = 0; i < eSignCoSealDyns.length; ++i) {
                        DynamicObject dynamicObject = eSignCoSealDyns[i];
                        String sealId = dynamicObject.getString("sealid");
                        if (isExistAuthedSeals) {
                            sealIdMappingPkId.put(sealId, dynamicObject.getLong("id"));
                            String freeSignInfoKey = ESignCOSealMgrUtil.buildFreeSignInfoKey((String)openCorpId, (String)sealId, (String)businessId);
                            if (dbFreeSignInfoKeys.contains(freeSignInfoKey)) {
                                DynamicObject authedSealDyn = (DynamicObject)dbFreeSignInfos.get(freeSignInfoKey);
                                String authStatus = authedSealDyn.getString("authstatus");
                                if ("0".equals(authStatus)) continue;
                                if ("1".equals(authStatus)) {
                                    Date endDate = authedSealDyn.getDate("endtime");
                                    if (endDate.getTime() - new Date().getTime() >= 0L) {
                                        errMsg.add(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5f53\u524d\u9009\u62e9\u7684\u5370\u7ae0\u5df2\u6388\u6743\u81ea\u52a8\u7b7e\u7f72\uff0c\u65e0\u9700\u91cd\u590d\u6388\u6743\u3002", (String)HrcsFormpluginRes.ESignSeaAuthEdit_2.resId(), (String)"hrmp-hrcs-business", (Object[])new Object[0]), otherCheckDatas.get(sealId)));
                                        continue;
                                    }
                                    rpcCheckSealIds.add(sealId);
                                    continue;
                                }
                                if (!"2".equals(authStatus)) continue;
                                rpcCheckSealIds.add(sealId);
                                continue;
                            }
                        }
                        if (CollectionUtils.isNotEmpty(errMsg)) continue;
                        DynamicObject dyn = ESignDBServiceUtil.eSignSealAuthService.generateEmptyDynamicObject();
                        long pkId = pkIds[i];
                        dyn.set("id", (Object)pkId);
                        dyn.set("esignsp", (Object)spId);
                        dyn.set("authcompany", (Object)mainCorpId);
                        dyn.set("seal", dynamicObject.get("id"));
                        dyn.set("auttype", (Object)"1");
                        dyn.set("authrange", (Object)"1");
                        dyn.set("authstatus", (Object)"0");
                        dyn.set("enable", (Object)"1");
                        dyn.set("creator", (Object)currUserId);
                        dyn.set("createtime", (Object)TimeServiceHelper.now());
                        sealIdMappingPkId.put(sealId, pkId);
                        addDyns.add((Object)dyn);
                    }
                    if (CollectionUtils.isNotEmpty(rpcCheckSealIds)) {
                        CorporateSealQuery corporateSealQuery = baseESignSrvFactory.getCorporateSealQuery();
                        Set errSealIds = SealUtil.checkCOSealAuth((Long)spId, (Long)mainCorpId, rpcCheckSealIds, (Long)corporateId, (String)openCorpId, (CorporateSealQuery)corporateSealQuery, (boolean)true);
                        if (!CollectionUtils.isNotEmpty((Collection)errSealIds)) continue;
                        for (String errSealId : errSealIds) {
                            errMsg.add(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5f53\u524d\u9009\u62e9\u7684\u5370\u7ae0\u5df2\u6388\u6743\u81ea\u52a8\u7b7e\u7f72\uff0c\u65e0\u9700\u91cd\u590d\u6388\u6743\u3002", (String)HrcsFormpluginRes.ESignSeaAuthEdit_2.resId(), (String)"hrmp-hrcs-business", (Object[])new Object[0]), otherCheckDatas.get(errSealId)));
                        }
                        continue;
                    }
                    if (CollectionUtils.isNotEmpty(errMsg)) {
                        this.getView().showMessage(ResManager.loadKDString((String)"\u5370\u7ae0\u6388\u6743\u5931\u8d25", (String)HrcsFormpluginRes.ESignSeaAuthEdit_3.resId(), (String)"hrmp-hrcs-business", (Object[])new Object[0]), Joiner.on((String)"\r\n").join(errMsg), MessageTypes.Default);
                        return;
                    }
                    SealAuthInfo sealAuthInfo = new SealAuthInfo(openCorpId, sealIds);
                    sealAuthInfo.setSealIdMappingPkId(sealIdMappingPkId);
                    ResponseData sealFreeSignUrlResponseData = acrossCorporateAuth.getSealFreeSignUrl(sealAuthInfo);
                    if (ResponseUtil.invokeFail((ResponseData)sealFreeSignUrlResponseData)) {
                        LOGGER.warn("AcrossCorporateAuth().getSealFreeSignUrl({}, \"\") fail", (Object)sealIds);
                        throw new KDBizException(sealFreeSignUrlResponseData.getMsg());
                    }
                    ESignDBServiceUtil.eSignSealAuthService.save(addDyns);
                    this.getModel().setDataChanged(false);
                    this.getView().openUrl((String)sealFreeSignUrlResponseData.getData());
                    this.getView().close();
                }
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (formOperate instanceof Save && StringUtils.equals((CharSequence)"save", (CharSequence)formOperate.getOperateKey()) && args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            OpBizRuleSetServiceHelper.clearCache();
            HashMap returnData = new HashMap(0);
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }
}

