/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.flow;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class SystemCapabilityEdit
extends HRDataBaseEdit {
    private static final String META_NUMBER_TREE_FIELD_F7 = "hbp_treefield_f7";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit objectPropertyText = (TextEdit)this.getView().getControl("inobjectpropertyname");
        objectPropertyText.addClickListener((ClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BillShowParameter baseShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        if (baseShowParameter.getPkId() != null) {
            DynamicObjectCollection inParams = this.getModel().getEntryEntity("inparam");
            for (DynamicObject inParam : inParams) {
                String propertyNumber;
                String metaNumber;
                MainEntityType mainEntityType;
                DynamicProperty property;
                DynamicObject bizObj;
                String inParamType = inParam.getString("inparamtype");
                if (!"enum".equals(inParamType) || Objects.isNull(bizObj = inParam.getDynamicObject("inparambizobject")) || !Objects.nonNull(property = (mainEntityType = EntityMetadataCache.getDataEntityType((String)(metaNumber = bizObj.getString("number")))).getProperty(propertyNumber = inParam.getString("inobjectproperty")))) continue;
                this.getModel().setValue("inobjectpropertyname", (Object)property.getDisplayName().getLocaleValue(), inParam.getInt("seq") - 1);
            }
            this.getModel().setDataChanged(false);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof TextEdit) {
            TextEdit source = (TextEdit)evt.getSource();
            String entryKey = source.getEntryKey();
            if (OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
                return;
            }
            if ("inparam".equals(entryKey)) {
                EntryGrid inParam = (EntryGrid)this.getView().getControl("inparam");
                int[] selectRows = inParam.getSelectRows();
                if (selectRows == null || selectRows.length == 0) {
                    return;
                }
                int rowNum = selectRows[0];
                String fieldKey = source.getKey();
                if (HRStringUtils.equals((String)"inobjectpropertyname", (String)fieldKey)) {
                    DynamicObject bizObj = (DynamicObject)this.getModel().getValue("inparambizobject", rowNum);
                    if (Objects.isNull(bizObj)) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8f93\u5165\u53c2\u6570\u7b2c%1$s\u884c\u4e1a\u52a1\u5bf9\u8c61\u5b57\u6bb5\uff0c\u518d\u9009\u62e9\u8f93\u5165\u53c2\u6570\u7b2c%2$s\u884c\u4e1a\u52a1\u5bf9\u8c61\u5b57\u6bb5\u3002", (String)"SystemCapabilityEdit_4", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), rowNum + 1));
                        return;
                    }
                    String metaNumber = bizObj.getString("number");
                    TreeNode treeNode = this.getComboControlsBuildTreeNode(metaNumber);
                    String selectField = (String)this.getModel().getValue("inobjectproperty", rowNum);
                    String formTitle = ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u679a\u4e3e\u5c5e\u6027\u9009\u62e9", (String)"SystemCapabilityEdit_5", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
                    String selectFieldDisplayName = (String)this.getModel().getValue("inobjectproperty", rowNum);
                    this.openSelectFieldF7(rowNum, "inobjectpropertyname", treeNode, formTitle, selectField, selectFieldDisplayName);
                }
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection inParams = this.getModel().getEntryEntity("inparam");
        for (DynamicObject param : inParams) {
            int seq = param.getInt("seq") - 1;
            if ("enum".equals(param.get("inparamtype"))) {
                this.getView().setEnable(Boolean.TRUE, seq, new String[]{"inparambizobject", "inobjectpropertyname"});
                continue;
            }
            if ("bizObject".equals(param.get("inparamtype"))) {
                this.getView().setEnable(Boolean.FALSE, seq, new String[]{"inobjectpropertyname"});
                continue;
            }
            this.getView().setEnable(Boolean.FALSE, seq, new String[]{"inparambizobject", "inobjectpropertyname"});
        }
        DynamicObjectCollection outParams = this.getModel().getEntryEntity("outparam");
        for (DynamicObject param : outParams) {
            if ("bizObject".equals(param.get("outparamtype"))) continue;
            int seq = param.getInt("seq") - 1;
            this.getView().setEnable(Boolean.FALSE, seq, new String[]{"outparambizobject"});
        }
        this.reUpdateServiceOrPluginNameControl();
    }

    private void reUpdateServiceOrPluginNameControl() {
        LocaleString emptyTip;
        LocaleString localeName;
        DynamicProperty property = this.getModel().getDataEntityType().getProperty("serviceorpluginname");
        Object capabilityType = this.getModel().getValue("capabilitytype");
        HashMap fieldMap = Maps.newHashMapWithExpectedSize((int)2);
        HashMap itemMap = Maps.newHashMapWithExpectedSize((int)1);
        if ("1".equals(capabilityType)) {
            localeName = ResManager.getLocaleString((String)"\u63d2\u4ef6", (String)"SystemCapabilityEdit_0", (String)"hrmp-hrcs-formplugin");
            emptyTip = ResManager.getLocaleString((String)"\u63d2\u4ef6\u5168\u8def\u5f84\u540d\uff0c\u5f00\u53d1\u63d0\u4f9b", (String)"SystemCapabilityEdit_1", (String)"hrmp-hrcs-formplugin");
        } else {
            localeName = ResManager.getLocaleString((String)"\u670d\u52a1\u7c7b", (String)"SystemCapabilityEdit_2", (String)"hrmp-hrcs-formplugin");
            emptyTip = ResManager.getLocaleString((String)"\u5fae\u670d\u52a1\u7c7b\u540d\uff0c\u5f00\u53d1\u63d0\u4f9b", (String)"SystemCapabilityEdit_3", (String)"hrmp-hrcs-formplugin");
        }
        fieldMap.put("caption", localeName);
        itemMap.put("emptytip", emptyTip);
        property.setDisplayName(localeName);
        fieldMap.put("item", itemMap);
        this.getView().updateControlMetadata("serviceorpluginname", (Map)fieldMap);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if ("bizapp".equals(fieldKey)) {
            DynamicObject bizApp = (DynamicObject)this.getModel().getValue(fieldKey);
            if (Objects.nonNull(bizApp)) {
                this.getModel().setValue("bizcloud", bizApp.get("bizcloud.id"));
            } else {
                this.getModel().setValue("bizcloud", null);
            }
        } else if ("inparamtype".equals(fieldKey)) {
            ChangeData inParamTypeChange = changeSet[0];
            int rowIndex = inParamTypeChange.getRowIndex();
            if ("enum".equals(inParamTypeChange.getNewValue())) {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"inparambizobject", "inobjectpropertyname"});
            } else if ("bizObject".equals(inParamTypeChange.getNewValue())) {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"inparambizobject"});
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"inobjectpropertyname"});
                this.getModel().setValue("inobjectproperty", null, rowIndex);
                this.getModel().setValue("inobjectpropertyname", null, rowIndex);
            } else {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"inparambizobject", "inobjectpropertyname"});
                this.getModel().setValue("inparambizobject", null, rowIndex);
                this.getModel().setValue("inobjectproperty", null, rowIndex);
                this.getModel().setValue("inobjectpropertyname", null, rowIndex);
            }
        } else if ("outparamtype".equals(fieldKey)) {
            ChangeData outParamTypeChange = changeSet[0];
            int rowIndex = outParamTypeChange.getRowIndex();
            if ("bizObject".equals(outParamTypeChange.getNewValue())) {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"outparambizobject"});
            } else {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"outparambizobject"});
                this.getModel().setValue("outparambizobject", null, rowIndex);
            }
        } else if ("inobjectpropertyname".equals(fieldKey)) {
            ChangeData inParamTypeChange = changeSet[0];
            int rowIndex = inParamTypeChange.getRowIndex();
            if (Objects.isNull(inParamTypeChange.getNewValue()) || HRStringUtils.isEmpty((String)String.valueOf(inParamTypeChange.getNewValue()))) {
                this.getModel().setValue("inobjectproperty", null, rowIndex);
            }
        } else if ("capabilitytype".equals(fieldKey)) {
            this.reUpdateServiceOrPluginNameControl();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.contains("inobjectpropertyname")) {
            int selectRowIndex = Integer.parseInt(actionId.split("_")[1]);
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            if (returnData != null) {
                this.getModel().setValue("inobjectproperty", returnData.get("selectValue"), selectRowIndex);
                this.getModel().setValue("inobjectpropertyname", returnData.get("selectDisplayName"), selectRowIndex);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        DynamicObjectCollection inParams = this.getModel().getDataEntity(true).getDynamicObjectCollection("inparam");
        for (DynamicObject inParam : inParams) {
            DataEntityState dataEntityState = inParam.getDataEntityState();
            for (IDataEntityProperty iDataEntityProperty : dataEntityState.getBizChangedProperties()) {
                String name = iDataEntityProperty.getName();
                if (!"inobjectproperty".equals(name)) continue;
                dataEntityState.setBizChanged(iDataEntityProperty.getOrdinal(), false);
            }
        }
        super.beforeClosed(e);
    }

    public void afterAddRow(AfterAddRowEventArgs rowEventArgs) {
        super.afterAddRow(rowEventArgs);
        String entryName = rowEventArgs.getEntryProp().getName();
        RowDataEntity[] rowDataEntities = rowEventArgs.getRowDataEntities();
        if (Objects.nonNull(rowDataEntities) && rowDataEntities.length > 0) {
            for (RowDataEntity rowData : rowDataEntities) {
                int rowIndex = rowData.getRowIndex();
                if ("inparam".equals(entryName)) {
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"inparambizobject", "inobjectpropertyname"});
                    continue;
                }
                if (!"outparam".equals(entryName)) continue;
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"outparambizobject"});
            }
        }
    }

    private TreeNode getComboControlsBuildTreeNode(String metaNumber) {
        List comboNodes;
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)metaNumber);
        TreeNode rootNode = new TreeNode("", metaNumber, dataEntityType.getDisplayName().getLocaleValue());
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        if (Objects.nonNull(properties) && !properties.isEmpty() && !(comboNodes = properties.stream().filter(property -> property instanceof ComboProp).map(property -> new TreeNode(metaNumber, property.getName(), property.getDisplayName().getLocaleValue())).collect(Collectors.toList())).isEmpty()) {
            rootNode.addChildren(comboNodes);
        }
        return rootNode;
    }

    private void openSelectFieldF7(int rowNum, String backField, TreeNode fieldTreeNode, String formTitle, String selectValue, String selectFieldDisplayName) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(META_NUMBER_TREE_FIELD_F7);
        String nodesJson = SerializationUtils.toJsonString((Object)fieldTreeNode);
        showParameter.getCustomParams().put("treeNodes", nodesJson);
        showParameter.getCustomParams().put("selectValue", selectValue);
        showParameter.getCustomParams().put("formTitle", formTitle);
        showParameter.getCustomParams().put("selectDisplayName", selectFieldDisplayName);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, backField + "_" + rowNum));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }
}

