/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.hismodel;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.CloseCheckFormPlugin;
import kd.hr.hrcs.common.constants.hismodel.HisEntityDependentConstants;
import kd.hr.hrcs.common.model.hismodel.HisEDEntityConditionVO;
import kd.hr.hrcs.common.model.hismodel.HisEDEntityRelVO;

@ExcludeFromJacocoGeneratedReport
public class EDEntityRelationConfigPlugin
extends CloseCheckFormPlugin
implements HisEntityDependentConstants {
    private static final String ENTRY = "relationconditions";
    private static final String LEFT = "left";
    private static final String RIGHT = "right";
    private static final String LEFT_PROP = "leftprop";
    private static final String RIGHT_PROP = "rightprop";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit entityEdit = (TextEdit)this.getControl(LEFT);
        entityEdit.addClickListener((ClickListener)this);
        TextEdit joinEntityEdit = (TextEdit)this.getControl(RIGHT);
        joinEntityEdit.addClickListener((ClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        HisEDEntityRelVO hisEDEntityRelVO = this.getEntityRelation();
        if (hisEDEntityRelVO != null && hisEDEntityRelVO.getConditionList().size() > 0) {
            List conditions = hisEDEntityRelVO.getConditionList();
            int createRows = conditions.size() - 1;
            if (createRows > 0) {
                this.getModel().batchCreateNewEntryRow(ENTRY, createRows);
            }
            int i = 0;
            for (HisEDEntityConditionVO conditionVO : conditions) {
                DynamicProperty rightFieldProp;
                String rightDisplayName;
                DynamicProperty fieldProp = this.getFieldProp(hisEDEntityRelVO.getLeftEntityNum(), conditionVO.getLeftProp());
                String leftDisplayName = this.getFieldName(fieldProp);
                if (HRStringUtils.isEmpty((String)leftDisplayName) || HRStringUtils.isEmpty((String)(rightDisplayName = this.getFieldName(rightFieldProp = this.getFieldProp(hisEDEntityRelVO.getRightEntityNum(), conditionVO.getRightProp()))))) continue;
                this.getModel().setValue("id", (Object)conditionVO.getConditionId(), i);
                this.getModel().setValue(LEFT, (Object)leftDisplayName, i);
                this.getModel().setValue(LEFT_PROP, (Object)conditionVO.getLeftProp(), i);
                this.getModel().setValue("leftfieldtype", (Object)fieldProp.getPropertyType().getName(), i);
                this.getModel().setValue(RIGHT, (Object)rightDisplayName, i);
                this.getModel().setValue(RIGHT_PROP, (Object)conditionVO.getRightProp(), i);
                this.getModel().setValue("rightfieldtype", (Object)rightFieldProp.getPropertyType().getName(), i);
                ++i;
            }
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        map.put("columnResizeMode", "preset");
        this.getView().updateControlMetadata(ENTRY, (Map)map);
        this.getModel().setDataChanged(false);
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof TextEdit) {
            String fieldType;
            String entityName;
            String entityNum;
            String key = ((TextEdit)evt.getSource()).getKey();
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("hrcs_selectentityfields");
            HisEDEntityRelVO hisEDEntityRelVO = this.getEntityRelation();
            if (hisEDEntityRelVO == null || HRStringUtils.isEmpty((String)hisEDEntityRelVO.getLeftEntityNum()) || HRStringUtils.isEmpty((String)hisEDEntityRelVO.getRightEntityNum())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b9e\u4f53\u3002", (String)"EDEntityRelationConfigPlugin_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                return;
            }
            if (LEFT.equals(key)) {
                entityNum = hisEDEntityRelVO.getLeftEntityNum();
                entityName = hisEDEntityRelVO.getLeftEntityName();
                fieldType = (String)this.getModel().getValue("rightfieldtype");
            } else {
                entityNum = hisEDEntityRelVO.getRightEntityNum();
                entityName = hisEDEntityRelVO.getRightEntityName();
                fieldType = (String)this.getModel().getValue("leftfieldtype");
            }
            parameter.setCustomParam("entityNum", (Object)entityNum);
            parameter.setCustomParam("entityName", (Object)entityName);
            parameter.setCustomParam("fieldType", (Object)fieldType);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectFields"));
            this.getView().showForm(parameter);
            this.getPageCache().put("entryFieldKey", key);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"ok")) {
            if (!this.validateData()) {
                args.setCancel(true);
                return;
            }
            HisEDEntityRelVO entityRelation = this.getEntityRelation();
            if (entityRelation == null) {
                entityRelation = new HisEDEntityRelVO();
            }
            ArrayList conditions = Lists.newArrayListWithCapacity((int)10);
            DynamicObjectCollection conditionEntry = this.getModel().getEntryEntity(ENTRY);
            for (DynamicObject conditionDy : conditionEntry) {
                HisEDEntityConditionVO row = new HisEDEntityConditionVO();
                row.setLeftProp(conditionDy.getString(LEFT_PROP));
                row.setCompareType(conditionDy.getString("comparetype"));
                row.setRightProp(conditionDy.getString(RIGHT_PROP));
                row.setConditionId(conditionDy.getString("id"));
                conditions.add(row);
            }
            if (conditionEntry.isEmpty()) {
                entityRelation.setLeftEntityNum(null);
                entityRelation.setRightEntityNum(null);
                entityRelation.setConditionList(null);
            } else {
                entityRelation.setConditionList((List)conditions);
            }
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)entityRelation));
            this.closeConfirmStatus = true;
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData;
        super.closedCallBack(evt);
        if (HRStringUtils.equals((String)evt.getActionId(), (String)"selectFields") && (returnData = evt.getReturnData()) != null) {
            Map returnDataMap = (Map)returnData;
            int currentRow = this.getModel().getEntryCurrentRowIndex(ENTRY);
            String entryFieldKey = this.getPageCache().get("entryFieldKey");
            if (HRStringUtils.equals((String)entryFieldKey, (String)LEFT)) {
                this.getModel().setValue(entryFieldKey, returnDataMap.get("displayName"), currentRow);
                this.getModel().setValue(LEFT_PROP, returnDataMap.get("number"), currentRow);
                this.getModel().setValue("leftfieldtype", returnDataMap.get("fieldType"), currentRow);
            } else {
                this.getModel().setValue(RIGHT, returnDataMap.get("displayName"), currentRow);
                this.getModel().setValue(RIGHT_PROP, returnDataMap.get("number"), currentRow);
                this.getModel().setValue("rightfieldtype", returnDataMap.get("fieldType"), currentRow);
            }
        }
    }

    private boolean validateData() {
        boolean isEmpty = false;
        for (DynamicObject row : this.getModel().getEntryEntity(ENTRY)) {
            String left = row.getString(LEFT);
            String right = row.getString(RIGHT);
            if (!HRStringUtils.isEmpty((String)left) && !HRStringUtils.isEmpty((String)right)) continue;
            isEmpty = true;
            break;
        }
        if (isEmpty) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u5173\u8054\u6761\u4ef6\u3002", (String)"SetEntityRelationPlugin_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private HisEDEntityRelVO getEntityRelation() {
        String relationStr = this.getPageCache().get("relation");
        if (HRStringUtils.isEmpty((String)relationStr)) {
            relationStr = (String)this.getView().getFormShowParameter().getCustomParam("relation");
            this.getPageCache().put("relation", relationStr);
        }
        HisEDEntityRelVO hisEDEntityRelVO = null;
        if (HRStringUtils.isNotEmpty((String)relationStr)) {
            hisEDEntityRelVO = (HisEDEntityRelVO)SerializationUtils.fromJsonString((String)relationStr, HisEDEntityRelVO.class);
        }
        return hisEDEntityRelVO;
    }

    private String getFieldName(DynamicProperty property) {
        return property.getDisplayName().getLocaleValue();
    }

    private DynamicProperty getFieldProp(String entityNum, String fieldNum) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityNum);
        return dataEntityType.getProperty(fieldNum);
    }
}

