/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.hismodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hrcs.bussiness.service.hismodel.model.constant.HisSystemConstants;
import kd.hr.hrcs.bussiness.servicehelper.hismodel.HisVerCpColCfgServiceHelper;

public class HisVerCpColCfgEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener,
RowClickEventListener,
HisSystemConstants {
    private static final String ENTRY_ROW_CLICK = "A";
    private static final String AFTER_BIND_DATA = "B";
    private static final String PROPERTY_CHANGED = "C";
    private static final String AFTER_DO_OPERATION = "D";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit entityEdit = (BasedataEdit)this.getView().getControl("entitytype");
        entityEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addClickListener((ClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.rebuildEntry(false, AFTER_BIND_DATA);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String chgProp = args.getProperty().getName();
        if (StringUtils.equals((CharSequence)"entitytype", (CharSequence)chgProp)) {
            this.clearAllEntryInfo();
            this.rebuildEntry(true, PROPERTY_CHANGED);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        this.rebuildEntry(true, ENTRY_ROW_CLICK);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        this.buildSaveEntry();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        this.rebuildEntry(false, AFTER_DO_OPERATION);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"entitytype"});
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey = evt.getProperty().getName();
        if (HRStringUtils.equals((String)fieldKey, (String)"entitytype")) {
            QFilter hisF7QFilter = HisVerCpColCfgServiceHelper.buildHisF7Filter();
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_vercpcolcfg");
            DynamicObject[] verCpDEntityIds = helper.queryOriginalArray("entitytype.dentityid", new QFilter[]{new QFilter("entitytype", "is not null", null)});
            List hisF7DEntityIds = (List)hisF7QFilter.getValue();
            for (int i = 0; i < verCpDEntityIds.length; ++i) {
                hisF7DEntityIds.remove(verCpDEntityIds[i].get("entitytype.dentityid"));
            }
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(new QFilter("dentityid", "in", (Object)hisF7DEntityIds));
        }
    }

    public void rebuildEntry(boolean isSelectRow, String actionFlag) {
        DynamicObject entityType = (DynamicObject)this.getModel().getValue("entitytype");
        if (Objects.isNull(entityType)) {
            return;
        }
        String entityNumber = entityType.getString("number");
        Map entityCols = HisVerCpColCfgServiceHelper.getEntityVerCpCol((String)entityNumber);
        Map<String, Integer> selectColFlag = this.buildSelectColFlag(isSelectRow, entityCols);
        this.showEntryInfo(entityCols);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        if (CollectionUtils.isEmpty(selectColFlag)) {
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            if (PROPERTY_CHANGED.equals(actionFlag) && OperationStatus.ADDNEW.equals((Object)status)) {
                entryGrid.selectRows(this.initSelectRows(entityNumber), 0);
            }
        } else {
            int[] selectRowIdx = this.buildSelectRowIdx(selectColFlag);
            entryGrid.selectRows(selectRowIdx, 0);
        }
    }

    private void buildSaveEntry() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        HashMap<String, Integer> selectCol = new HashMap<String, Integer>(selectRows.length);
        DynamicObjectCollection entityVerCpEntry = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < selectRows.length; ++i) {
            DynamicObject entry = (DynamicObject)entityVerCpEntry.get(selectRows[i]);
            selectCol.put(entry.getString("colflag"), entry.getInt("colseq"));
        }
        if (!CollectionUtils.isEmpty(selectCol)) {
            IDataModel model = this.getModel();
            int newEntryRowCount = selectCol.size();
            int oldEntryRowCount = model.getEntryRowCount("entryentity");
            model.deleteEntryRows("entryentity", this.getIntArray(oldEntryRowCount));
            model.setDataChanged(false);
            this.getView().updateView("entryentity");
            model.batchCreateNewEntryRow("entryentity", newEntryRowCount);
            int idx = 0;
            model.beginInit();
            for (Map.Entry entry : selectCol.entrySet()) {
                model.setValue("colflag", entry.getKey(), idx);
                model.setValue("colseq", entry.getValue(), idx);
                ++idx;
            }
            model.endInit();
            this.getView().updateView("entryentity");
        }
    }

    private void clearAllEntryInfo() {
        IDataModel model = this.getModel();
        int oldEntryRowCount = model.getEntryRowCount("entryentity");
        model.deleteEntryRows("entryentity", this.getIntArray(oldEntryRowCount));
        model.setDataChanged(false);
        this.getView().updateView("entryentity");
    }

    private Map<String, Integer> buildSelectColFlag(boolean isSelectRow, Map<String, Map<String, Object>> entityCols) {
        HashMap<String, Integer> selectColFlag = new HashMap<String, Integer>(16);
        DynamicObjectCollection entityVerCpEntry = this.getModel().getEntryEntity("entryentity");
        if (isSelectRow) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            for (int i = 0; i < selectRows.length; ++i) {
                DynamicObject currRow = (DynamicObject)entityVerCpEntry.get(selectRows[i]);
                selectColFlag.put(currRow.getString("colflag"), currRow.getInt("colseq"));
            }
        } else {
            for (int i = 0; i < entityVerCpEntry.size(); ++i) {
                DynamicObject entityVerCp = (DynamicObject)entityVerCpEntry.get(i);
                if (!entityCols.containsKey(entityVerCp.getString("colflag"))) continue;
                selectColFlag.put(entityVerCp.getString("colflag"), entityVerCp.getInt("colseq"));
            }
        }
        return selectColFlag;
    }

    private int[] buildSelectRowIdx(Map<String, Integer> selectColFlag) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        int[] selectRowIdx = new int[selectColFlag.size()];
        int i = 0;
        IDataModel model = this.getModel();
        for (Map.Entry<String, Integer> entry : selectColFlag.entrySet()) {
            for (int rowIdx = 0; rowIdx < entryEntity.size(); ++rowIdx) {
                if (!StringUtils.equals((CharSequence)entry.getKey(), (CharSequence)((DynamicObject)entryEntity.get(rowIdx)).getString("colflag"))) continue;
                selectRowIdx[i] = rowIdx;
                model.setValue("colseq", (Object)selectColFlag.get(entry.getKey()), rowIdx);
                break;
            }
            ++i;
        }
        model.setDataChanged(false);
        this.getView().updateView("entryentity");
        return selectRowIdx;
    }

    private void showEntryInfo(Map<String, Map<String, Object>> entityCols) {
        IDataModel model = this.getModel();
        int newEntryRowCount = entityCols.size();
        int oldEntryRowCount = model.getEntryRowCount("entryentity");
        model.deleteEntryRows("entryentity", this.getIntArray(oldEntryRowCount));
        model.setDataChanged(false);
        this.getView().updateView("entryentity");
        model.batchCreateNewEntryRow("entryentity", newEntryRowCount);
        int idx = 0;
        DynamicObject entityType = (DynamicObject)this.getModel().getValue("entitytype");
        boolean entityIsCtrl = HisVerCpColCfgServiceHelper.chkEntityIsCtrl((String)entityType.getString("number"));
        for (Map.Entry<String, Map<String, Object>> entry : entityCols.entrySet()) {
            model.setValue("colflag", (Object)entry.getKey(), idx);
            model.setValue("colname", entry.getValue().get("colname"), idx);
            model.setValue("coltype", entry.getValue().get("coltype"), idx);
            String colType = (String)entry.getValue().get("coltype");
            if (HisVerCpColCfgServiceHelper.isShowCol((String)entry.getKey(), (boolean)entityIsCtrl, (String)colType)) {
                model.setValue("isdefault", (Object)"1", idx);
            }
            ++idx;
        }
        model.setDataChanged(false);
        this.getView().updateView("entryentity");
    }

    private int[] getIntArray(int rowCount) {
        int[] intArray = new int[rowCount];
        for (int rowI = 0; rowI < intArray.length; ++rowI) {
            intArray[rowI] = rowI;
        }
        return intArray;
    }

    private int[] initSelectRows(String entityNumber) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return new int[0];
        }
        boolean entityIsCtrl = HisVerCpColCfgServiceHelper.chkEntityIsCtrl((String)entityNumber);
        ArrayList<String> defaultCols = new ArrayList<String>();
        for (int i = 0; i < entryEntity.size(); ++i) {
            String colType;
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            String colFlag = entry.getString("colflag");
            if (!HisVerCpColCfgServiceHelper.isShowCol((String)colFlag, (boolean)entityIsCtrl, (String)(colType = entry.getString("coltype")))) continue;
            defaultCols.add(colFlag);
        }
        int[] selectRows = new int[defaultCols.size()];
        block1: for (int selectRowIdx = 0; selectRowIdx < defaultCols.size(); ++selectRowIdx) {
            for (int rowIdx = 0; rowIdx < entryEntity.size(); ++rowIdx) {
                String colFlag = ((DynamicObject)entryEntity.get(rowIdx)).getString("colflag");
                if (!StringUtils.equals((CharSequence)colFlag, (CharSequence)((CharSequence)defaultCols.get(selectRowIdx)))) continue;
                selectRows[selectRowIdx] = rowIdx;
                continue block1;
            }
        }
        return selectRows;
    }
}

