/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.label;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hrcs.common.constants.label.LabelConstants;

@ExcludeFromJacocoGeneratedReport
public class HRLblFieldTypeTreeListPlugin
extends AbstractTreeListPlugin {
    private static final Log LOGGER = LogFactory.getLog(HRLblFieldTypeTreeListPlugin.class);
    private static final String CURRENT_MODULE_NAME = "hrmp-hrcs-formplugin";
    private static final String OP_ASSIGN_TYPE = "assigntype";
    private static final String BAR_REFRESH = "bar_refresh";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        if (this.isLookup()) {
            return;
        }
        this.addClickListeners(new String[]{"btndel", "btnedit", "btnnew", "searchap"});
        this.addItemClickListeners(new String[]{"tbmain"});
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener(see -> {
            IPageCache pageCache = this.getView().getPageCache();
            TreeView tv = (TreeView)this.getView().getControl("treeview");
            String searchText = see.getText();
            LOGGER.info(String.format(ResManager.loadKDString((String)"\u5feb\u901f\u5b9a\u4f4d\u56e0\u5b50\u5206\u7c7b\uff0c\u6587\u672c\u201c%s\u201d\u3002", (String)"HRLblFieldTypeTreeListPlugin_8", (String)CURRENT_MODULE_NAME, (Object[])new Object[0]), searchText));
            if (StringUtils.isEmpty((String)searchText)) {
                return;
            }
            List treeNodeInfos = SerializationUtils.fromJsonStringToList((String)pageCache.get("treeNodeInfos"), String[].class);
            ArrayList<String[]> searchResult = new ArrayList<String[]>(treeNodeInfos.size());
            for (String[] treeNodeInfo : treeNodeInfos) {
                if (!treeNodeInfo[1].contains(searchText)) continue;
                searchResult.add(treeNodeInfo);
            }
            if (CollectionUtils.isEmpty(searchResult)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u67e5\u8be2\u7ed3\u679c\u3002", (String)"HRLblFieldTypeTreeListPlugin_0", (String)CURRENT_MODULE_NAME, (Object[])new Object[0]));
            } else {
                String[] searchInfo = (String[])searchResult.get(0);
                TreeNode treeNode = new TreeNode();
                treeNode.setId(searchInfo[0]);
                pageCache.put("searchIndex", "1");
                tv.focusNode(treeNode);
                tv.treeNodeClick(treeNode.getParentid(), treeNode.getId());
            }
        });
    }

    public void initializeTree(EventObject e) {
        super.initializeTree(e);
        if (this.isLookup()) {
            return;
        }
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Long labelObjectId = (Long)showParameter.getCustomParam("labelObjectId");
        if (labelObjectId == null) {
            LOGGER.error(ResManager.loadKDString((String)"\u4e0a\u9001\u7684\u6253\u6807\u5b9e\u4f53id\u4e3a\u7a7a", (String)"HRLblFieldTypeTreeListPlugin_9", (String)CURRENT_MODULE_NAME, (Object[])new Object[0]));
            return;
        }
        LOGGER.info(String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u6253\u6807\u5b9e\u4f53\u56e0\u5b50\u5206\u7c7b\u7ba1\u7406 - [%s]", (String)"HRLblFieldTypeTreeListPlugin_10", (String)CURRENT_MODULE_NAME, (Object[])new Object[0]), labelObjectId));
        HRBaseServiceHelper labelObjectHelper = new HRBaseServiceHelper("hrcs_labelobject");
        QFilter[] filter = new QFilter[]{new QFilter("id", "=", (Object)labelObjectId)};
        DynamicObject labelObject = labelObjectHelper.queryOne(filter);
        if (null == labelObject || null == labelObject.getPkValue()) {
            LOGGER.error(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u6253\u6807\u5b9e\u4f53\u4fe1\u606f\u51fa\u9519\uff0c \u67e5\u8be2ID\u201c%s\u201d\u3002", (String)"HRLblFieldTypeTreeListPlugin_11", (String)CURRENT_MODULE_NAME, (Object[])new Object[0]), labelObjectId));
            return;
        }
        String labelObjectName = labelObject.getString("name");
        this.getPageCache().put("label_object_id", String.valueOf(labelObjectId));
        this.getPageCache().put("treeRootId", String.valueOf(labelObjectId));
        this.getPageCache().put("label_object_name", labelObjectName);
        TreeNode root = this.initTypeTree();
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
        this.getView().setVisible(Boolean.FALSE, new String[]{"cardview"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedFactors = listView.getSelectedRows();
        String operateKey = evt.getOperateKey();
        if (OP_ASSIGN_TYPE.equals(operateKey)) {
            this.popAssignForm(selectedFactors);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        if (BAR_REFRESH.equals(key)) {
            this.initTypeTree();
        }
    }

    public void click(EventObject evt) {
        String btnKey;
        TreeView tv = (TreeView)this.getControl("treeview");
        String currentNodeId = (String)this.getTreeModel().getCurrentNodeId();
        switch (btnKey = ((Control)evt.getSource()).getKey()) {
            case "btndel": {
                this.deleteFactorType(tv);
                break;
            }
            case "btnedit": {
                this.editAction(currentNodeId);
                break;
            }
            case "btnnew": {
                this.createFactorType();
                break;
            }
        }
    }

    private void popAssignForm(ListSelectedRowCollection selectedFactors) {
        if (selectedFactors.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u52fe\u9009\u9700\u8981\u5f52\u7f6e\u7684\u56e0\u5b50", (String)"HRLblFieldTypeTreeListPlugin_1", (String)CURRENT_MODULE_NAME, (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> factorIds = new ArrayList<Long>(selectedFactors.size());
        for (ListSelectedRow item : selectedFactors) {
            factorIds.add((Long)item.getPrimaryKeyValue());
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("hrcs_lblassignfieldtype");
        fsp.setCustomParam("label_object_id", (Object)this.getPageCache().get("treeRootId"));
        fsp.setCustomParam("field_id_list", factorIds);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "ASSIGN_FIELD_TYPE_CALLBACK");
        fsp.setCloseCallBack(closeCallBack);
        this.getView().showForm(fsp);
    }

    private void editAction(String currentNodeId) {
        if (!this.validateDeleteAndEditType(currentNodeId)) {
            return;
        }
        BaseShowParameter formShowParameter = this.createFormShowParameter(currentNodeId);
        formShowParameter.setPkId(this.getTreeModel().getCurrentNodeId());
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.setCustomParam("operate", (Object)"edit");
        HashMap<String, String> parentInfo = new HashMap<String, String>(16);
        parentInfo.put("value", currentNodeId);
        formShowParameter.setCustomParam("tree_curr_id", parentInfo);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    protected BaseShowParameter createFormShowParameter(String currentNodeId) {
        BaseShowParameter formShowParameter = new BaseShowParameter();
        formShowParameter.setFormId("hrcs_lblfieldtype");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.getCustomParams().put("treeRootId", this.getPageCache().get("treeRootId"));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "CHG_FIELD_TYPE_CALLBACK");
        formShowParameter.setCloseCallBack(closeCallBack);
        formShowParameter.setCustomParam("id", (Object)currentNodeId);
        return formShowParameter;
    }

    public void setFilter(SetFilterEvent e) {
        e.setOrderBy("createtime desc");
    }

    protected QFilter nodeClickFilter() {
        if (this.isLookup()) {
            return null;
        }
        String labelObjectIdStr = this.getPageCache().get("label_object_id");
        TreeView tv = (TreeView)this.getControl("treeview");
        QFilter filter = new QFilter("labelobjectid", "=", (Object)Long.parseLong(labelObjectIdStr));
        filter = filter.and("isdefaultfield", "=", (Object)"0");
        String focusNodeId = tv.getTreeState().getFocusNodeId();
        if (focusNodeId != null && !"-1".equals(focusNodeId)) {
            filter.and("fieldtypeid", "=", (Object)Long.parseLong(focusNodeId));
        }
        return filter;
    }

    private boolean isLookup() {
        boolean isLookup = false;
        if (this.getView().getFormShowParameter() instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            isLookup = listShowParameter.isLookUp();
        }
        return isLookup;
    }

    private void createFactorType() {
        BaseShowParameter fsp = this.createFormShowParameter(null);
        this.getView().showForm((FormShowParameter)fsp);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String callbackKey;
        super.closedCallBack(e);
        switch (callbackKey = e.getActionId()) {
            case "CHG_FIELD_TYPE_CALLBACK": {
                this.initTypeTree();
                break;
            }
            case "ASSIGN_FIELD_TYPE_CALLBACK": {
                this.clickFocusNode();
                break;
            }
        }
    }

    private void deleteFactorType(TreeView tv) {
        String focusNodeId = tv.getTreeState().getFocusNodeId();
        if (!this.validateDeleteAndEditType(focusNodeId)) {
            return;
        }
        LOGGER.info(String.format(ResManager.loadKDString((String)"\u5220\u9664\u56e0\u5b50\u5206\u7c7b:%s", (String)"HRLblFieldTypeTreeListPlugin_14", (String)CURRENT_MODULE_NAME, (Object[])new Object[0]), focusNodeId));
        QFilter[] filters = new QFilter[]{new QFilter("fieldtypeid", "=", (Object)Long.valueOf(focusNodeId))};
        HRBaseServiceHelper objectFieldServiceHelper = new HRBaseServiceHelper("hrcs_lblobjectfield");
        if (objectFieldServiceHelper.isExists(filters)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u5f53\u524d\u5206\u7c7b\u4e0b\u5b58\u5728\u56e0\u5b50\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"HRLblFieldTypeTreeListPlugin_6", (String)CURRENT_MODULE_NAME, (Object[])new Object[0]));
            return;
        }
        try {
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)"hrcs_lblfieldtype", (Object[])new Long[]{Long.parseLong(focusNodeId)}, (OperateOption)OperateOption.create());
            if (!operationResult.isSuccess()) {
                this.getView().showErrorNotification(((OperateErrorInfo)((ValidateResult)operationResult.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().get(0)).getMessage());
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format(ResManager.loadKDString((String)"\u5220\u9664\u56e0\u5b50\u5206\u7c7b\u51fa\u9519:%s", (String)"HRLblFieldTypeTreeListPlugin_12", (String)CURRENT_MODULE_NAME, (Object[])new Object[0]), focusNodeId), (Throwable)e);
        }
        this.initTypeTree();
    }

    private boolean validateDeleteAndEditType(String typeId) {
        if (this.getPageCache().get("treeRootId") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u5916\u5c42\u6ca1\u9009\u6253\u6807\u5b9e\u4f53", (String)"HRLblFieldTypeTreeListPlugin_5", (String)CURRENT_MODULE_NAME, (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isEmpty((String)typeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u7684\u5206\u7c7b\u8282\u70b9\u3002", (String)"HRLblFieldTypeTreeListPlugin_2", (String)CURRENT_MODULE_NAME, (Object[])new Object[0]));
            return false;
        }
        if (String.valueOf(LabelConstants.VAL_DEFAULT_NODE_ID).equals(typeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4fee\u6539\u201c\u672a\u5206\u7c7b\u201d\u8282\u70b9\u3002", (String)"HRLblFieldTypeTreeListPlugin_4", (String)CURRENT_MODULE_NAME, (Object[])new Object[0]));
            return false;
        }
        if ("-1".equals(typeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u64cd\u4f5c\u6839\u8282\u70b9\u3002", (String)"HRLblFieldTypeTreeListPlugin_3", (String)CURRENT_MODULE_NAME, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private TreeNode initTypeTree() {
        TreeNode root = new TreeNode();
        String labelObjectName = this.getPageCache().get("label_object_name");
        String labelObjectIdStr = this.getPageCache().get("label_object_id");
        if (StringUtils.isEmpty((String)labelObjectIdStr)) {
            return root;
        }
        ArrayList<String[]> treeNodeInfos = new ArrayList<String[]>(8);
        TreeView tv = (TreeView)this.getControl("treeview");
        Map focusNodeMap = tv.getTreeState().getFocusNode();
        tv.deleteAllNodes();
        root = new TreeNode("", "-1", labelObjectName);
        root.setIsOpened(true);
        tv.addNode(root);
        String[] rootInfo = new String[]{root.getId(), root.getText(), root.getParentid()};
        treeNodeInfos.add(rootInfo);
        ArrayList<Long> idList = new ArrayList<Long>(10);
        idList.add(Long.parseLong(labelObjectIdStr));
        idList.add(0L);
        LOGGER.info(ResManager.loadKDString((String)"\u8bbe\u7f6e\u56e0\u5b50\u5206\u7c7b\u7684\u5b50\u8282\u70b9", (String)"HRLblFieldTypeTreeListPlugin_13", (String)CURRENT_MODULE_NAME, (Object[])new Object[0]));
        QFilter[] factorTypeFilters = new QFilter[]{new QFilter("labelobjectid", "in", idList)};
        DynamicObjectCollection factorTypeCollection = QueryServiceHelper.query((String)"hrcs_lblfieldtype", (String)"id,name,number", (QFilter[])factorTypeFilters, (String)"id desc");
        ArrayList<TreeNode> subnodeList = new ArrayList<TreeNode>(10);
        if (factorTypeCollection != null && factorTypeCollection.size() > 0) {
            for (DynamicObject factorType : factorTypeCollection) {
                TreeNode node = new TreeNode("-1", factorType.get("id").toString(), factorType.getString("name"));
                node.setIsOpened(false);
                tv.addNode(node);
                subnodeList.add(node);
                String[] nodeInfo = new String[]{node.getId(), node.getText(), node.getParentid()};
                treeNodeInfos.add(nodeInfo);
            }
        }
        root.setChildren(subnodeList);
        if (!CollectionUtils.isEmpty(treeNodeInfos)) {
            this.getPageCache().put("treeNodeInfos", SerializationUtils.toJsonString(treeNodeInfos));
        }
        if (!CollectionUtils.isEmpty((Map)focusNodeMap)) {
            TreeNode focusNode = new TreeNode();
            String id = (String)focusNodeMap.get("id");
            String parentid = (String)focusNodeMap.get("parentid");
            focusNode.setParentid(parentid);
            focusNode.setId(id);
            tv.focusNode(focusNode);
            tv.treeNodeClick(focusNode.getParentid(), focusNode.getId());
        } else {
            tv.focusNode(root);
            tv.treeNodeClick(root.getParentid(), root.getId());
        }
        return root;
    }

    private void clickFocusNode() {
        TreeView tv = (TreeView)this.getControl("treeview");
        Map focusNodeMap = tv.getTreeState().getFocusNode();
        if (!CollectionUtils.isEmpty((Map)focusNodeMap)) {
            TreeNode focusNode = new TreeNode();
            String id = (String)focusNodeMap.get("id");
            String parentid = (String)focusNodeMap.get("parentid");
            focusNode.setParentid(parentid);
            focusNode.setId(id);
            tv.focusNode(focusNode);
            tv.treeNodeClick(focusNode.getParentid(), focusNode.getId());
        } else {
            String labelObjectName = this.getPageCache().get("label_object_name");
            TreeNode root = new TreeNode("", "-1", labelObjectName);
            tv.focusNode(root);
            tv.treeNodeClick(root.getParentid(), root.getId());
        }
    }
}

