/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.label;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.model.label.BaseLabelResult;
import kd.hr.hbp.common.model.label.LabelInfo;
import kd.hr.hbp.common.model.label.LabelSceneInfo;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRBaseDataCommonEdit;
import kd.hr.hrcs.bussiness.service.label.APILabelServiceHelper;
import kd.hr.hrcs.bussiness.service.label.LabelSceneServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.label.LblHelperConstants;

public class LabelApiTestPlugin
extends HRBaseDataCommonEdit
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(LabelApiTestPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit labelScene = (BasedataEdit)this.getView().getControl("labelscene");
        labelScene.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit labelvaluef7 = (BasedataEdit)this.getView().getControl("labelvaluef7");
        labelvaluef7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit label = (BasedataEdit)this.getView().getControl("label");
        label.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit labelValue = (BasedataEdit)this.getView().getControl("labelvalues");
        labelValue.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Button buttonLabelScene = (Button)this.getView().getControl("buttonlabenscene");
        buttonLabelScene.addClickListener((ClickListener)this);
        Button buttonSaveLabel = (Button)this.getView().getControl("buttonsavelabel");
        buttonSaveLabel.addClickListener((ClickListener)this);
        Button buttonSearchLabel = (Button)this.getView().getControl("buttonsearchlabel");
        buttonSearchLabel.addClickListener((ClickListener)this);
        Button buttonsearchlabelobj = (Button)this.getView().getControl("buttonsearchlabelobj");
        buttonsearchlabelobj.addClickListener((ClickListener)this);
        Button buttonsearchlabels = (Button)this.getView().getControl("buttonsearchlabels");
        buttonsearchlabels.addClickListener((ClickListener)this);
        Button buttonlabelvalue = (Button)this.getView().getControl("buttonlabelvalue");
        buttonlabelvalue.addClickListener((ClickListener)this);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if ("labelvaluef7".equals(actionId) && selectedRows != null) {
            DynamicObject[] labelValueDyns = LblHelperConstants.labelValueServiceHelper.query("id,value", new QFilter[]{new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues())});
            try {
                this.getModel().setValue("apiresult", (Object)HRJSONUtils.toString((Object)labelValueDyns));
                this.getView().updateView("apiresult");
            }
            catch (IOException exp) {
                logger.error((Throwable)exp);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if (!HRStringUtils.equals((String)fieldKey, (String)"labelscene")) {
            if (HRStringUtils.equals((String)fieldKey, (String)"labelvalues")) {
                int curIdx = this.getModel().getEntryCurrentRowIndex("labelscene");
                DynamicObjectCollection labelrows = this.getEntityRows("labelentry");
                if (labelrows != null && labelrows.size() > curIdx) {
                    ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                    ArrayList<QFilter> filterList = new ArrayList<QFilter>();
                    filterList.add(new QFilter("label", "=", (Object)((DynamicObject)this.getModel().getValue("label", curIdx)).getLong("id")));
                    showParameter.getListFilterParameter().setQFilters(filterList);
                }
            } else if (HRStringUtils.equals((String)fieldKey, (String)"labelvaluef7")) {
                DynamicObject labelScene = this.getModel().getDataEntity().getDynamicObject("labelscene");
                if ("add".equals(this.getModel().getDataEntity().getString("labelvaluef7type")) && labelScene == null) {
                    this.getView().showTipNotification("please select label scene first.");
                } else {
                    this.openLabelValueF7();
                }
                beforeF7SelectEvent.setCancel(true);
            }
        }
    }

    private void openLabelValueF7() {
        DynamicObject labelScene = this.getModel().getDataEntity().getDynamicObject("labelscene");
        if ("add".equals(this.getModel().getDataEntity().getString("labelvaluef7type")) && labelScene == null) {
            this.getView().showTipNotification("please select label scene first.");
            return;
        }
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"hrcs_labelvaluedisplay", (boolean)true, (int)0, (boolean)true);
        showParameter.setCaption(ResManager.loadKDString((String)"\u6807\u7b7e", (String)"LabelApiTestPlugin_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        showParameter.setFormId("hrcs_labelvaluetreelistf7");
        showParameter.setBillFormId("hrcs_labelvaluedisplay");
        if (labelScene != null) {
            showParameter.setCustomParam("sceneId", (Object)labelScene.getLong("id"));
        }
        if (this.getModel().getDataEntity().getDynamicObject("labelobject") != null) {
            showParameter.setCustomParam("labelObjectId", (Object)this.getModel().getDataEntity().getDynamicObject("labelobject").getLong("id"));
        }
        showParameter.setCustomParam("type", (Object)this.getModel().getDataEntity().getString("labelvaluef7type"));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "labelvaluef7"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String changeKey = args.getProperty().getName();
        Object newValue = args.getChangeSet()[0].getNewValue();
        if ("labelscene".equals(changeKey)) {
            DynamicObject labelScene = (DynamicObject)newValue;
            this.refreshLabelEntry(labelScene.getString("number"));
        } else if ("labelvalues".equals(changeKey) && args.getChangeSet().length > 0) {
            int rowIndex = args.getChangeSet()[0].getRowIndex();
            MulBasedataDynamicObjectCollection collection = (MulBasedataDynamicObjectCollection)newValue;
            StringBuilder sb = new StringBuilder();
            collection.forEach(item -> sb.append(item.getDynamicObject("fbasedataid").getString("value")).append("; "));
            this.getModel().setValue("labelvaluedisplay", (Object)sb.toString(), rowIndex);
            this.getView().updateView("labelentry");
        }
    }

    private DynamicObjectCollection getEntityRows(String entityKey) {
        IFormView billView = this.getView();
        IDataModel billModel = billView.getModel();
        return billModel.getEntryEntity(entityKey);
    }

    private void refreshLabelEntry(String sceneNumber) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        LabelSceneInfo labelSceneInfo = LabelSceneServiceHelper.getLabelSceneInfo((String)sceneNumber);
        if (labelSceneInfo != null && labelSceneInfo.getLabelList() != null && labelSceneInfo.getLabelList().size() > 0) {
            int idx;
            DynamicObjectCollection labelrows = this.getEntityRows("labelentry");
            int preLabelCount = labelrows.size();
            for (idx = preLabelCount - 1; idx > -1; --idx) {
                this.getModel().deleteEntryRow("labelentry", idx);
            }
            for (idx = 0; idx < labelSceneInfo.getLabelList().size(); ++idx) {
                LabelInfo labelInfo = (LabelInfo)labelSceneInfo.getLabelList().get(idx);
                this.getModel().insertEntryRow("labelentry", idx);
                this.getModel().setValue("label", (Object)labelInfo.getLabelId(), idx);
            }
        }
        model.endInit();
        this.getView().updateView("labelentry");
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String itemKey = ((Control)evt.getSource()).getKey();
        Object apiResult = null;
        String sceneNumber = "";
        if ("buttonsearchlabel".equals(itemKey)) {
            DynamicObject labelObject = this.getModel().getDataEntity().getDynamicObject("labelobject");
            DynamicObject labelDyn = this.getModel().getDataEntity().getDynamicObject("labeldyn");
            apiResult = APILabelServiceHelper.getLabelResult((Long)labelObject.getLong("id"), (Long)labelDyn.getLong("id"), null, (int)0, (int)20);
        } else if ("buttonsearchlabelobj".equals(itemKey)) {
            String entitynumber = this.getModel().getDataEntity().getString("entitynumber");
            apiResult = APILabelServiceHelper.queryLabelObjectsByEntityNumber((String)entitynumber);
        } else if ("buttonsearchlabels".equals(itemKey)) {
            apiResult = APILabelServiceHelper.getLabels(null, null, null, (int)0, (int)2000);
        } else if ("buttonlabelvalue".equals(itemKey)) {
            this.openLabelValueF7();
        } else {
            DynamicObject labelScene = this.getModel().getDataEntity().getDynamicObject("labelscene");
            if (labelScene == null) {
                this.getView().showTipNotification("please select label scene first.");
                return;
            }
            sceneNumber = labelScene.getString("number");
            if ("buttonlabenscene".equals(itemKey)) {
                apiResult = LabelSceneServiceHelper.getLabelSceneInfo((String)sceneNumber);
                try {
                    apiResult = HRJSONUtils.toString((Object)apiResult);
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                    logger.error((Throwable)e);
                }
            } else if ("buttonsavelabel".equals(itemKey)) {
                String bizid = this.getModel().getDataEntity().getString("bizid");
                if (bizid == null || "".equals(bizid)) {
                    this.getView().showTipNotification("please input business object ID first.");
                    return;
                }
                boolean isReplace = this.getModel().getDataEntity().getBoolean("isreplace");
                Map result = APILabelServiceHelper.batchSaveLabels((String)sceneNumber, (Long)RequestContext.get().getCurrUserId(), this.getLabelResult(sceneNumber, bizid), (boolean)isReplace);
                if (result.containsKey("labels")) {
                    result.put("labels", SerializationUtils.toJsonString(result.get("labels")));
                }
                apiResult = result;
            }
        }
        this.getModel().setValue("apiresult", (Object)String.valueOf(apiResult));
        this.getView().updateView("apiresult");
    }

    private List<BaseLabelResult> getLabelResult(String sceneNumber, String bizId) {
        ArrayList<BaseLabelResult> labelResultList = new ArrayList<BaseLabelResult>(16);
        BaseLabelResult labelResult = new BaseLabelResult();
        labelResult.setId((Object)bizId);
        labelResult.setSceneNumber(sceneNumber);
        DynamicObjectCollection labelRows = this.getEntityRows("labelentry");
        labelRows.forEach(labelRow -> {
            DynamicObjectCollection labelValues = labelRow.getDynamicObjectCollection("labelvalues");
            labelValues.forEach(labelValueItem -> labelResult.addModelLabel(Long.valueOf(labelRow.getDynamicObject("label").getLong("id")), Long.valueOf(labelValueItem.getDynamicObject("fbasedataid").getLong("id")), labelValueItem.getDynamicObject("fbasedataid").getString("value"), new Date(), Long.valueOf(RequestContext.get().getCurrUserId())));
        });
        labelResultList.add(labelResult);
        return labelResultList;
    }
}

