/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.label;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.label.LabelObjectServiceHelper;
import kd.hr.hrcs.bussiness.util.GenFieldUtil;
import kd.hr.hrcs.common.constants.label.LblStrategyConstants;
import org.apache.commons.lang3.tuple.Pair;

public class LabelDownTemplatePlugin
extends AbstractFormPlugin
implements LblStrategyConstants {
    private static final String KEY_BASE_ENTITY = "baseEntityMap";
    protected static final String KEY_FIELD_KEY = "fieldKeyList";
    protected String targetKey = "flexpanelap";

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter showParameter = (FormShowParameter)e.getSource();
        FlexPanelAp fieldFlex = this.getFieldFlex(showParameter);
        HashMap mapHead = Maps.newHashMapWithExpectedSize((int)2);
        mapHead.put("id", this.targetKey);
        mapHead.put("items", fieldFlex.createControl().get("items"));
        e.getItems().add(mapHead);
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        GenFieldUtil.onGetControl((OnGetControlArgs)e, (IFormView)this.getView());
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType newMainType;
        MainEntityType oldMainType = e.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LabelDownTemplatePlugin", exp.getMessage()), new Object[0]);
        }
        this.registerDynamicProps(newMainType);
        e.setNewEntityType(newMainType);
    }

    public void beforeBindData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        FlexPanelAp fieldFlex = this.getFieldFlex(formShowParameter);
        Container myFldPanel = (Container)this.getView().getControl(this.targetKey);
        myFldPanel.getItems().addAll(((Container)fieldFlex.buildRuntimeControl()).getItems());
        this.getView().createControlIndex(myFldPanel.getItems());
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("save".equals(afterDoOperationEventArgs.getOperateKey())) {
            String fieldStr = (String)this.getView().getFormShowParameter().getCustomParam(KEY_FIELD_KEY);
            Map fieldKeyMap = (Map)SerializationUtils.fromJsonString((String)fieldStr, Map.class);
            HashMap resultMap = Maps.newHashMapWithExpectedSize((int)1);
            QFilter filter = null;
            for (Map.Entry fieldKeyEntry : fieldKeyMap.entrySet()) {
                QFilter subFilter = GenFieldUtil.getQFilter((String)((String)fieldKeyEntry.getKey()), (String)((String)fieldKeyEntry.getValue()), (IFormView)this.getView());
                if (filter != null) {
                    filter.and(subFilter);
                    continue;
                }
                filter = subFilter;
            }
            resultMap.put("importFilter", filter);
            this.getView().returnDataToParent((Object)resultMap);
            this.getView().close();
        }
    }

    private FlexPanelAp getFieldFlex(FormShowParameter formShowParameter) {
        Long lblObjId = Long.parseLong((String)formShowParameter.getCustomParam("labelobject"));
        DynamicObject lblObjConfig = LabelObjectServiceHelper.getLblObjConfig((Long)lblObjId);
        DynamicObjectCollection entry = lblObjConfig.getDynamicObjectCollection("manualentryentity");
        DynamicObject[] joinEntities = LabelObjectServiceHelper.getJoinEntities((Long)lblObjId);
        Set mainEntityAliasSet = Arrays.stream(joinEntities).filter(je -> HRStringUtils.equals((String)"main", (String)je.getString("type"))).map(je -> je.getString("entityalias")).collect(Collectors.toSet());
        int index = 0;
        LinkedHashMap baseEntityMap = Maps.newLinkedHashMapWithExpectedSize((int)entry.size());
        HashMap fieldMapList = Maps.newHashMapWithExpectedSize((int)entry.size());
        FlexPanelAp flexPanelApTop = new FlexPanelAp();
        flexPanelApTop.setKey("flexpanelap");
        flexPanelApTop.setId(flexPanelApTop.getKey());
        for (DynamicObject row : entry) {
            FieldAp fieldAp;
            boolean rowBoolean = row.getBoolean("manualsearchfield");
            if (!rowBoolean) continue;
            String entityNumber = row.getString("manualentitynumberalias");
            String fieldNumber = row.getString("manualfieldnumber");
            String fieldKey = entityNumber + "." + fieldNumber;
            DynamicProperty property = GenFieldUtil.getBindEntityProperty((String)fieldKey);
            String displayName = row.getString("manualdisplayname");
            if (HRStringUtils.isEmpty((String)displayName)) {
                displayName = row.getString("manualfieldname");
            }
            if (mainEntityAliasSet.contains(entityNumber)) {
                fieldKey = fieldNumber;
            }
            if ((fieldAp = GenFieldUtil.getFieldAp((DynamicProperty)property, (Map)baseEntityMap, (int)index)).getField() == null) {
                Pair numberFieldAp = GenFieldUtil.getNumberFieldAp((DynamicProperty)property, (int)index);
                FieldAp left = (FieldAp)numberFieldAp.getLeft();
                FieldAp right = (FieldAp)numberFieldAp.getRight();
                FlexPanelAp flexPanelAp = this.getNumberFlex(left, right, displayName);
                flexPanelApTop.getItems().add(flexPanelAp);
                fieldMapList.put(left.getKey(), fieldKey);
                fieldMapList.put(right.getKey(), fieldKey);
            } else {
                fieldAp.setName(new LocaleString(displayName));
                flexPanelApTop.getItems().add(fieldAp);
                fieldMapList.put(fieldAp.getKey(), fieldKey);
            }
            ++index;
        }
        formShowParameter.setCustomParam(KEY_BASE_ENTITY, (Object)SerializationUtils.toJsonString((Object)baseEntityMap));
        formShowParameter.setCustomParam(KEY_FIELD_KEY, (Object)SerializationUtils.toJsonString((Object)fieldMapList));
        return flexPanelApTop;
    }

    private FlexPanelAp getNumberFlex(FieldAp left, FieldAp right, String displayName) {
        left.setName(new LocaleString(displayName));
        left.setWidth(new LocaleString("95px"));
        FlexPanelAp flexPanelAp0 = new FlexPanelAp();
        flexPanelAp0.setKey("flexPanelApTop" + left.getKey());
        flexPanelAp0.setGrow(0);
        flexPanelAp0.getItems().add(left);
        FlexPanelAp flexPanelAp2 = new FlexPanelAp();
        flexPanelAp2.setKey("flexPanelAp" + left.getKey());
        flexPanelAp2.setWidth(new LocaleString("40px"));
        flexPanelAp2.setHeight(new LocaleString("100%"));
        flexPanelAp2.setJustifyContent("center");
        flexPanelAp2.setAlignItems("center");
        flexPanelAp2.setWrap(false);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setLeft("-30px");
        style.setMargin(margin);
        flexPanelAp2.setStyle(style);
        LabelAp labelAp = new LabelAp();
        labelAp.setKey("labelAp" + left.getKey());
        labelAp.setName(new LocaleString("~"));
        flexPanelAp2.getItems().add(labelAp);
        flexPanelAp0.getItems().add(flexPanelAp2);
        right.setWidth(new LocaleString("95px"));
        Style style2 = new Style();
        Padding padding = new Padding();
        padding.setTop("15px");
        style2.setPadding(padding);
        right.setStyle(style2);
        flexPanelAp0.getItems().add(right);
        return flexPanelAp0;
    }

    private void registerDynamicProps(MainEntityType newMainType) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String fieldStr = (String)formShowParameter.getCustomParam(KEY_FIELD_KEY);
        Map fieldKeyMap = (Map)SerializationUtils.fromJsonString((String)fieldStr, Map.class);
        String baseEntityMapStr = (String)formShowParameter.getCustomParam(KEY_BASE_ENTITY);
        Map baseEntityMap = (Map)SerializationUtils.fromJsonString((String)baseEntityMapStr, Map.class);
        for (Map.Entry fieldEntry : fieldKeyMap.entrySet()) {
            List fieldPropertyList = GenFieldUtil.getFieldPropertyList((String)((String)fieldEntry.getKey()), (String)((String)fieldEntry.getKey()), (Map)baseEntityMap, (boolean)true);
            for (DynamicProperty property : fieldPropertyList) {
                newMainType.addProperty(property);
            }
        }
    }
}

