/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.label;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.PagerClickEvent;
import kd.bos.form.events.PagerClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.CreateListColumnsListener;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.list.plugin.IListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.LikeHint;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.label.LabelDataService;
import kd.hr.hrcs.bussiness.servicehelper.label.LabelPolicyServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.label.LabelServiceHelper;
import kd.hr.hrcs.common.constants.label.LabelTypeEnum;

public class LabelHitResultPlugin
extends AbstractListPlugin
implements CreateListColumnsListener,
PagerClickListener,
IListPlugin,
ListRowClickListener {
    private static final LabelServiceHelper labelServiceHelper = new LabelServiceHelper();
    private static final Log logger = LogFactory.getLog(LabelHitResultPlugin.class);
    private static final LabelPolicyServiceHelper labelPolicyServiceHelper = new LabelPolicyServiceHelper();
    private static final String FILTER_KEY = "filter_key";
    private static final String CURRENT_PAGE_KEY = "current_page_key";
    private static final String PAGE_SIZE_KEY = "page_size_key";
    private static final String COLUMN_INFO_KEY = "column_info_key";
    private static final String EMPTY_DYNAMIC_OBJECT_COLLECTION = "empty_dynamic_object_collection";
    private static final String CREATE_TIME = "createTime";
    private static final String NUMBER_SHOW = "numberShow";
    private static final String BAR_EXECUTEHIS = "executehis";

    public void setFilter(SetFilterEvent setFilterEvent) {
        List column;
        List qFilters = setFilterEvent.getQFilters();
        if (qFilters != null && !qFilters.isEmpty() && ((column = (List)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(COLUMN_INFO_KEY))) == null || column.isEmpty())) {
            return;
        }
        this.getPageCache().put(FILTER_KEY, SerializationUtils.serializeToBase64((Object)qFilters));
        super.setFilter(setFilterEvent);
    }

    private static void rebuildFilter(QFilter qFilter, List<Map<String, Object>> column, DynamicObject label) {
        if (qFilter == null) {
            return;
        }
        column.forEach(map -> {
            if (map.get(NUMBER_SHOW).equals(qFilter.getProperty())) {
                qFilter.__setProperty(map.get("number").toString());
                if ("LabelResult".equals(qFilter.getProperty())) {
                    if (label != null && LabelTypeEnum.MODEL.getType().equals(label.getString("type"))) {
                        qFilter.__setProperty("labels.labelValueName.keyword");
                    }
                    if (label != null && LabelTypeEnum.FACT.getType().equals(label.getString("type"))) {
                        qFilter.__setProperty("labels.labelBizValue.keyword");
                    }
                } else if ("LabelTime".equals(qFilter.getProperty())) {
                    qFilter.__setProperty("labels.createTime.keyword");
                } else {
                    qFilter.__setProperty("fields." + map.get("number").toString() + ".keyword");
                }
            }
        });
        List nests = qFilter.getNests(true);
        for (QFilter.QFilterNest nest : nests) {
            LabelHitResultPlugin.rebuildFilter(nest.getFilter(), column, label);
        }
    }

    public void initialize() {
        super.initialize();
        this.setPolicyId();
        BillList billlist = (BillList)this.getView().getControl("billlistap");
        billlist.addCreateListColumnsListener((CreateListColumnsListener)this);
        billlist.addPagerClickListener((PagerClickListener)this);
    }

    public void createListColumns(BeforeCreateListColumnsArgs beforeCreateListColumnsArgs) {
        List columns = beforeCreateListColumnsArgs.getListColumns();
        long policyId = this.getPolicyId();
        long objectId = labelPolicyServiceHelper.getObjectIdByPolicyId(policyId);
        List<Map<String, Object>> columnList = this.getColumnList(objectId);
        if (columnList.isEmpty()) {
            return;
        }
        ArrayList list = new ArrayList(10);
        for (int i = 0; i < columnList.size() && i <= 30; ++i) {
            String numberShow = "result_textfield" + i;
            String name = columnList.get(i).get("name").toString();
            String number = columnList.get(i).get("number").toString();
            int index = Integer.parseInt(columnList.get(i).get("index").toString());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("number", number);
            map.put("name", name);
            map.put(NUMBER_SHOW, numberShow);
            list.add(map);
            ListColumn colText = this.createListColumn(numberShow, name, index);
            colText.setParentViewKey("kded_listgridviewap");
            columns.add(colText);
        }
        this.getPageCache().put(COLUMN_INFO_KEY, SerializationUtils.serializeToBase64(list));
    }

    private ListColumn createListColumn(String key, String caption, int colIndex) {
        ListColumn col = new ListColumn();
        col.setCaption(new LocaleString(caption));
        col.setKey(key);
        col.setListFieldKey(key);
        col.setFieldName(key);
        col.setSeq(colIndex);
        col.setColumnOrder(true);
        col.setColumnFilter(true);
        col.setBlankFieldCanOrderAndFilter(true);
        return col;
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public int getRealCount() {
                return LabelHitResultPlugin.this.countCollection();
            }

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection dynamicObjectCollection;
                DynamicObjectCollection data = LabelHitResultPlugin.this.getEmptyDynamicCollection();
                if (data == null) {
                    LabelHitResultPlugin.this.putEmptyDynamicCollection(super.getData(start, limit));
                }
                if ((dynamicObjectCollection = LabelHitResultPlugin.this.getCollection(start, limit)).isEmpty()) {
                    return LabelHitResultPlugin.this.getEmptyDynamicCollection();
                }
                return dynamicObjectCollection;
            }
        });
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        if (BAR_EXECUTEHIS.equals(key)) {
            String policyIdStr = this.getPageCache().get("labelpolicy");
            String pageId = SessionManager.getCurrent().get(this.getView().getPageId() + "showForm" + policyIdStr);
            IFormView recordView = this.getView().getView(pageId);
            if (!HRStringUtils.isEmpty((String)pageId) && recordView != null) {
                IClientViewProxy service = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                service.addAction("activate", (Object)pageId);
            } else {
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setFormId("bos_list");
                showParameter.setBillFormId("hrcs_labelpolicytask");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setCustomParam("label", (Object)Long.valueOf(policyIdStr));
                SessionManager.getCurrent().put(this.getView().getPageId() + "showForm" + policyIdStr, showParameter.getPageId());
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }

    private int countCollection() {
        return labelServiceHelper.countResult(this.getPolicyId(), this.getFilterList());
    }

    private DynamicObjectCollection getCollection(int start, int limit) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_labelresultshow");
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        List<QFilter> qFilterList = this.getFilterList();
        Map<String, QFilter> labelQFilters = this.getLabelQFilter();
        String colStr = this.getPageCache().get(COLUMN_INFO_KEY);
        if (HRStringUtils.isEmpty((String)colStr)) {
            return new DynamicObjectCollection();
        }
        List column = (List)SerializationUtils.deSerializeFromBase64((String)colStr);
        if (column == null || column.isEmpty()) {
            return new DynamicObjectCollection();
        }
        ArrayList<String> selects = new ArrayList<String>(10);
        for (Map map2 : column) {
            if ("LabelTime".equals(map2.get("number"))) {
                selects.add(CREATE_TIME);
                continue;
            }
            if ("LabelResult".equals(map2.get("number"))) {
                selects.add("labels.labelValueName");
                selects.add("labels.labelBizValue");
                selects.add("labels.createTime");
                selects.add("labels.creatorId");
                continue;
            }
            if ("LabelPerson".equals(map2.get("number"))) {
                selects.add("creatorId");
                continue;
            }
            selects.add("fields." + map2.get("number"));
        }
        DynamicObject labelPolicyDyn = labelPolicyServiceHelper.getPolicy(this.getPolicyId());
        String taskNumber = null;
        if (labelPolicyDyn != null && "1".equals(labelPolicyDyn.getString("worktype"))) {
            taskNumber = "hand";
        }
        List labelHitResult = labelServiceHelper.getLabelHitResult(Long.valueOf(this.getPolicyId()), selects.toArray(new String[selects.size()]), qFilterList, start, limit, taskNumber);
        logger.info("label result->labelHitResult:{}", (Object)labelHitResult);
        if (labelHitResult == null || labelHitResult.isEmpty()) {
            return new DynamicObjectCollection();
        }
        long labelId = labelPolicyServiceHelper.getLabelByPolicyId(this.getPolicyId());
        DynamicObject label = labelServiceHelper.getLabel(labelId);
        HashMap personMap = new HashMap(16);
        List list = (List)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(COLUMN_INFO_KEY));
        List fieldList = list.stream().map(map -> map.get("number").toString()).collect(Collectors.toList());
        HRBaseServiceHelper serviceHelper1 = new HRBaseServiceHelper("bos_user");
        labelHitResult.forEach(map -> {
            ArrayList labelResultMap = (ArrayList)map.get("labels");
            for (Map labelResultInfo : labelResultMap) {
                DynamicObject object = helper.generateEmptyDynamicObject();
                fieldList.forEach(field -> {
                    if (field.equals("LabelTime")) {
                        object.set(this.getShowNumber((String)field), labelResultInfo.get(CREATE_TIME));
                    } else if (field.equals("LabelResult")) {
                        if (label != null && LabelTypeEnum.MODEL.getType().equals(label.getString("type"))) {
                            object.set(this.getShowNumber((String)field), (Object)(labelResultInfo.get("labelValueName") == null ? "" : labelResultInfo.get("labelValueName").toString()));
                        } else if (label != null && LabelTypeEnum.FACT.getType().equals(label.getString("type"))) {
                            object.set(this.getShowNumber((String)field), (Object)(labelResultInfo.get("labelBizValue") == null ? "" : labelResultInfo.get("labelBizValue").toString()));
                        } else {
                            object.set(this.getShowNumber((String)field), (Object)"");
                        }
                    } else if (field.equals("LabelPerson")) {
                        if (labelResultInfo.containsKey("creatorId") && labelResultInfo.get("creatorId") != null && !"".equals(labelResultInfo.get("creatorId"))) {
                            if (personMap.containsKey(String.valueOf(labelResultInfo.get("creatorId")))) {
                                object.set(this.getShowNumber((String)field), personMap.get(String.valueOf(labelResultInfo.get("creatorId"))));
                            } else {
                                DynamicObject user = serviceHelper1.queryOne((Object)Long.parseLong(String.valueOf(labelResultInfo.get("creatorId"))));
                                object.set(this.getShowNumber((String)field), (Object)user.getString("name"));
                                personMap.put(String.valueOf(labelResultInfo.get("creatorId")), user.getString("name"));
                            }
                        }
                    } else if (map.containsKey("fields") && map.get("fields") != null) {
                        ArrayList fieldsMap = (ArrayList)map.get("fields");
                        object.set(this.getShowNumber((String)field), ((Map)fieldsMap.get(0)).get(field));
                    }
                });
                if (labelQFilters != null && labelQFilters.size() > 0) {
                    boolean filterFlag = true;
                    for (Map.Entry entry : labelQFilters.entrySet()) {
                        if (((String)entry.getKey()).equals("labels.labelBizValue.keyword")) {
                            if (this.processQFilter(object.getString(this.getShowNumber("LabelResult")), (QFilter)labelQFilters.get("labels.labelBizValue.keyword"))) continue;
                            filterFlag = false;
                            continue;
                        }
                        if (((String)entry.getKey()).equals("labels.labelValueName.keyword")) {
                            if (this.processQFilter(object.getString(this.getShowNumber("LabelResult")), (QFilter)labelQFilters.get("labels.labelValueName.keyword"))) continue;
                            filterFlag = false;
                            continue;
                        }
                        if (!((String)entry.getKey()).equals("labels.createTime.keyword") || this.processQFilter(object.getString(this.getShowNumber("LabelTime")), (QFilter)labelQFilters.get("labels.createTime.keyword"))) continue;
                        filterFlag = false;
                    }
                    if (!filterFlag) continue;
                    dynamicObjectCollection.add((Object)object);
                    continue;
                }
                dynamicObjectCollection.add((Object)object);
            }
        });
        return dynamicObjectCollection;
    }

    private boolean processQFilter(String value, QFilter qFilter) {
        if (qFilter == null) {
            return true;
        }
        if (qFilter.getCP().equals("like")) {
            if (qFilter.getOriginValue() == null || HRStringUtils.isEmpty((String)qFilter.getOriginValue().toString())) {
                return true;
            }
            if (HRStringUtils.isEmpty((String)value)) {
                return false;
            }
            LikeHint likeHint = (LikeHint)qFilter.getQFilterHint();
            if (likeHint.isAppendLeftPercent() && likeHint.isAppendRightPercent()) {
                return value.contains(qFilter.getOriginValue().toString());
            }
            if (likeHint.isAppendLeftPercent()) {
                return value.startsWith(qFilter.getOriginValue().toString());
            }
            if (likeHint.isAppendRightPercent()) {
                return value.endsWith(qFilter.getOriginValue().toString());
            }
        } else {
            if (qFilter.getCP().equals("not like")) {
                if ((value == null || HRStringUtils.isEmpty((String)value)) && qFilter.getOriginValue() != null && HRStringUtils.isNotEmpty((String)qFilter.getOriginValue().toString())) {
                    return false;
                }
                if (value == null || HRStringUtils.isEmpty((String)value) || qFilter.getOriginValue() != null && HRStringUtils.isNotEmpty((String)qFilter.getOriginValue().toString())) {
                    return true;
                }
                return !value.contains(qFilter.getOriginValue().toString());
            }
            if (qFilter.getCP().equals("=")) {
                if ((value == null || HRStringUtils.isEmpty((String)value)) && qFilter.getOriginValue() != null && HRStringUtils.isNotEmpty((String)qFilter.getOriginValue().toString())) {
                    return true;
                }
                if (value == null || HRStringUtils.isEmpty((String)value) || qFilter.getOriginValue() != null && HRStringUtils.isNotEmpty((String)qFilter.getOriginValue().toString())) {
                    return false;
                }
                return value.equals(qFilter.getOriginValue().toString());
            }
            if (qFilter.getCP().equals("!=")) {
                if ((value == null || HRStringUtils.isEmpty((String)value)) && qFilter.getOriginValue() != null && HRStringUtils.isNotEmpty((String)qFilter.getOriginValue().toString())) {
                    return false;
                }
                if (value == null || HRStringUtils.isEmpty((String)value) || qFilter.getOriginValue() != null && HRStringUtils.isNotEmpty((String)qFilter.getOriginValue().toString())) {
                    return true;
                }
                return !value.equals(qFilter.getOriginValue().toString());
            }
            if (qFilter.getCP().equals("is null")) {
                return value == null || HRStringUtils.isEmpty((String)value);
            }
            if (qFilter.getCP().equals("is not null")) {
                return value != null && HRStringUtils.isNotEmpty((String)value);
            }
        }
        return true;
    }

    private Map<String, QFilter> getLabelQFilter() {
        HashMap<String, QFilter> labelQFilters = new HashMap<String, QFilter>(16);
        List<QFilter> qFilters = this.getFilterList();
        if (qFilters != null && qFilters.size() > 0) {
            for (QFilter qFilter : qFilters) {
                this.calcLabelQFilter(qFilter, labelQFilters);
            }
        }
        return labelQFilters;
    }

    private void calcLabelQFilter(QFilter qFilter, Map<String, QFilter> labelQFilters) {
        if (qFilter == null) {
            return;
        }
        if (qFilter.getProperty().equalsIgnoreCase("labels.createTime.keyword") || qFilter.getProperty().equalsIgnoreCase("labels.labelBizValue.keyword") || qFilter.getProperty().equalsIgnoreCase("labels.labelValueName.keyword")) {
            labelQFilters.put(qFilter.getProperty(), qFilter);
        }
        if (qFilter.getNests(false) != null && qFilter.getNests(false).size() > 0) {
            this.calcLabelQFilter(qFilter.getNests(false), labelQFilters);
        }
    }

    private void calcLabelQFilter(List<QFilter.QFilterNest> qFilters, Map<String, QFilter> labelQFilters) {
        if (qFilters != null && qFilters.size() > 0) {
            for (QFilter.QFilterNest qFilter : qFilters) {
                this.calcLabelQFilter(qFilter.getFilter(), labelQFilters);
            }
        }
    }

    private void putEmptyDynamicCollection(DynamicObjectCollection dynamicObjects) {
        this.getPageCache().put(EMPTY_DYNAMIC_OBJECT_COLLECTION, SerializationUtils.serializeToBase64((Object)dynamicObjects));
    }

    private DynamicObjectCollection getEmptyDynamicCollection() {
        String empty = this.getPageCache().get(EMPTY_DYNAMIC_OBJECT_COLLECTION);
        if (HRStringUtils.isEmpty((String)empty)) {
            return null;
        }
        return (DynamicObjectCollection)SerializationUtils.deSerializeFromBase64((String)empty);
    }

    private List<QFilter> getFilterList() {
        List qFilterList = (List)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(FILTER_KEY));
        long labelId = labelPolicyServiceHelper.getLabelByPolicyId(this.getPolicyId());
        DynamicObject label = labelServiceHelper.getLabel(labelId);
        if (qFilterList != null && !qFilterList.isEmpty()) {
            List column = (List)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(COLUMN_INFO_KEY));
            if (column == null || column.isEmpty()) {
                return qFilterList;
            }
            LabelHitResultPlugin.rebuildFilter((QFilter)qFilterList.get(0), column, label);
        }
        logger.info("label result->filter:{},policy:{},label:{}", new Object[]{qFilterList, this.getPolicyId(), label});
        return qFilterList;
    }

    private long getPolicyId() {
        String policy = this.getPageCache().get("labelpolicy");
        long policyId = 0L;
        if (!HRStringUtils.isEmpty((String)policy)) {
            policyId = Long.parseLong(policy);
        }
        return policyId;
    }

    private void setPolicyId() {
        FormShowParameter formShowParameterView = this.getView().getFormShowParameter();
        Object policyId = formShowParameterView.getCustomParams().get("label");
        if (policyId != null) {
            this.getPageCache().put("labelpolicy", policyId.toString());
        } else {
            this.getPageCache().put("labelpolicy", "0");
        }
    }

    private String getShowNumber(String number) {
        String numberShow = "";
        List list = (List)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(COLUMN_INFO_KEY));
        if (list == null || list.isEmpty()) {
            return numberShow;
        }
        for (Map map : list) {
            if (!number.equals(map.get("number"))) continue;
            numberShow = map.get(NUMBER_SHOW).toString();
            break;
        }
        return numberShow;
    }

    private List<Map<String, Object>> getColumnList(Long objectId) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        DynamicObject mainEntity = LabelPolicyServiceHelper.getEntryByObjectId((Long)objectId);
        String mainEntityAlias = mainEntity.getString("entityalias");
        DynamicObjectCollection dynamicObjectCollection = labelServiceHelper.listLabelShowDy(objectId);
        LabelDataService labelDataService = new LabelDataService(objectId.longValue(), true);
        List fieldApList = labelDataService.getFieldApList(labelDataService.getFieldKeyPropMap());
        HashMap displayField = new HashMap(16);
        if (fieldApList != null && fieldApList.size() > 0) {
            fieldApList.forEach(fieldAp -> {
                if (fieldAp.getKey().indexOf("_dm6h7z_") > 0) {
                    fieldAp.setKey(fieldAp.getKey().replaceAll("_dm6h7z_", "@"));
                }
                displayField.put(fieldAp.getKey(), fieldAp);
            });
        }
        if (dynamicObjectCollection == null || dynamicObjectCollection.isEmpty()) {
            return list;
        }
        HashSet fieldKeySet = new HashSet(16);
        DynamicObject labelPolicyDyn = labelPolicyServiceHelper.getPolicy(this.getPolicyId());
        dynamicObjectCollection.forEach(dynamicObject -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", HRStringUtils.isEmpty((String)dynamicObject.getString("displaydisplayname")) ? dynamicObject.getString("displayfieldname") : dynamicObject.getString("displaydisplayname"));
            map.put("index", dynamicObject.getInt("seq"));
            if (HRStringUtils.isEmpty((String)dynamicObject.getString("displayentitynumberalias"))) {
                if (labelPolicyDyn != null && "0".equals(labelPolicyDyn.getString("worktype"))) {
                    if (!"LabelPerson".equals(dynamicObject.getString("displayfieldnumber"))) {
                        map.put("number", dynamicObject.getString("displayfieldnumber"));
                    }
                } else {
                    map.put("number", dynamicObject.getString("displayfieldnumber"));
                }
            } else if (mainEntityAlias.equals(dynamicObject.getString("displayentitynumberalias"))) {
                String baseFieldKey = dynamicObject.getString("displayfieldnumber");
                String f7FieldKey = dynamicObject.getString("displayfieldnumber").replaceAll("\\.", "@");
                String entryKey = "";
                if (baseFieldKey.indexOf(".") > 0) {
                    entryKey = mainEntityAlias + "@" + baseFieldKey.substring(0, baseFieldKey.indexOf("."));
                }
                if (displayField.containsKey(baseFieldKey)) {
                    map.put("number", baseFieldKey);
                } else if (displayField.containsKey(f7FieldKey)) {
                    map.put("number", f7FieldKey);
                    map.put("name", HRStringUtils.isEmpty((String)dynamicObject.getString("displaydisplayname")) ? ((FieldAp)displayField.get(f7FieldKey)).getName() : dynamicObject.getString("displaydisplayname"));
                } else if (displayField.containsKey(entryKey)) {
                    map.put("number", entryKey);
                    map.put("name", ((FieldAp)displayField.get(entryKey)).getName());
                }
            } else {
                String tempFieldKey = this.getFieldKey((DynamicObject)dynamicObject, displayField);
                if (tempFieldKey != null) {
                    map.put("number", tempFieldKey);
                    map.put("name", ((FieldAp)displayField.get(tempFieldKey)).getName());
                }
            }
            if (map.containsKey("number") && !fieldKeySet.contains(String.valueOf(map.get("number")))) {
                fieldKeySet.add(String.valueOf(map.get("number")));
                list.add(map);
            }
        });
        return list;
    }

    private String getFieldKey(DynamicObject displayFieldDyn, Map<String, FieldAp> displayFieldMap) {
        String joinEntityNumberAlias = displayFieldDyn.getString("displayentitynumberalias");
        String tempKey = joinEntityNumberAlias + "@" + displayFieldDyn.getString("displayfieldnumber");
        String[] splitKeys = tempKey.split("\\.");
        if (displayFieldMap.containsKey(splitKeys[0])) {
            return splitKeys[0];
        }
        if (displayFieldMap.containsKey(joinEntityNumberAlias)) {
            return joinEntityNumberAlias;
        }
        if (displayFieldMap.containsKey(tempKey = tempKey.replaceAll("\\.", "@"))) {
            return tempKey;
        }
        return null;
    }

    public void pagerClick(PagerClickEvent pagerClickEvent) {
        this.getPageCache().put(CURRENT_PAGE_KEY, pagerClickEvent.getCurrentPageIndex() + "");
        this.getPageCache().put(PAGE_SIZE_KEY, pagerClickEvent.getPageRows() + "");
    }

    public void afterBindData(EventObject e) {
        DynamicObject labelPolicyDyn;
        super.afterBindData(e);
        long policyId = this.getPolicyId();
        if (!(policyId == 0L || (labelPolicyDyn = labelPolicyServiceHelper.getPolicy(policyId)) != null && "0".equals(labelPolicyDyn.getString("worktype")))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_EXECUTEHIS});
        }
    }
}

