/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.label;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.data.ImportLogHelper;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hrcs.bussiness.service.label.excel.LabelImportFailedSheetHandler;
import kd.hr.hrcs.bussiness.service.label.excel.LabelImportService;
import kd.hr.hrcs.bussiness.service.label.excel.LabelImportSheetHandler;
import kd.hr.hrcs.common.utils.ImportFileUtil;

public class LabelImportPlugin
extends BatchImportPlugin {
    private static final Log LOG = LogFactory.getLog(LabelImportPlugin.class);
    private IFormView view;
    private Long lblObjId;
    private Long lblId;
    private LabelImportService labelImportService;
    private Map<String, List<String>> labelData;
    private ImportLogger importLogger;

    public void setLblId(Long lblId) {
        this.lblId = lblId;
    }

    public void setLblObjId(Long lblObjId) {
        this.lblObjId = lblObjId;
    }

    public IFormView getView() {
        return this.view;
    }

    public void setView(IFormView view) {
        this.view = view;
    }

    public Map<String, List<String>> getLabelData() {
        return this.labelData;
    }

    public void setLabelData(Map<String, List<String>> labelData) {
        this.labelData = labelData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void resolveExcel() {
        String localPath = null;
        for (String url : this.ctx.getAllUrls()) {
            this.importLogger = this.ctx.getLogger(url);
            LOG.info("LabelImportPlugin-resolveExcel-url:{}", (Object)url);
            localPath = ImportFileUtil.downloadFile((String)url);
            LOG.info("LabelImportPlugin-resolveExcel-localPath:{}", (Object)localPath);
            ExcelReader excelReader = new ExcelReader();
            try (FileInputStream inputStream = new FileInputStream(new File(ImportFileUtil.checkUrl((String)"tempfile", (String)localPath)));){
                LabelImportSheetHandler labelImportSheetHandler = new LabelImportSheetHandler(this.ctx, url);
                excelReader.read((InputStream)inputStream, (SheetHandler)labelImportSheetHandler);
            }
            this.ctx.setResolveComplete(url);
            try {
                ImportFileUtil.deleteLocalTempFile((String)localPath);
            }
            catch (IOException ex) {
                LOG.error("LabelImportPlugin--outputFailedForData error,", (Throwable)ex);
            }
            continue;
            catch (Exception exc) {
                try {
                    ImportLogger logger = this.ctx.getLogger(url);
                    String errMessage = exc.getMessage();
                    if (exc instanceof KDBizException) {
                        logger.log(Integer.valueOf(0), errMessage);
                    } else {
                        logger.log(Integer.valueOf(3), ImportLogger.formatException((Throwable)exc));
                    }
                    LOG.error("LabelImportPlugin-resolveExcel-error", (Throwable)exc);
                    JSONObject json = new JSONObject();
                    json.put("errCode", (Object)errMessage);
                    this.ctx.getDataQueue(url).add(new ImportBillData(json, 0, 0, null));
                }
                catch (Throwable throwable) {
                    this.ctx.setResolveComplete(url);
                    try {
                        ImportFileUtil.deleteLocalTempFile(localPath);
                    }
                    catch (IOException ex) {
                        LOG.error("LabelImportPlugin--outputFailedForData error,", (Throwable)ex);
                    }
                    throw throwable;
                }
                this.ctx.setResolveComplete(url);
                try {
                    ImportFileUtil.deleteLocalTempFile((String)localPath);
                }
                catch (IOException ex) {
                    LOG.error("LabelImportPlugin--outputFailedForData error,", (Throwable)ex);
                }
            }
        }
    }

    protected void importData() {
        LOG.info("PermInitImportPlugin--begin to importData");
        this.importData(this.ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void importData(ImportContext conf) {
        this.labelImportService = new LabelImportService(this.view, this.lblObjId, this.lblId);
        try {
            for (String url : conf.getAllUrls()) {
                LinkedBlockingQueue dataQ = conf.getDataQueue(url);
                ArrayList delRows = new ArrayList();
                ImportLogger importLogger = conf.getLogger(url);
                importLogger.setDelRows(delRows);
                this.fetchQueueData(conf, url, dataQ);
            }
        }
        finally {
            HashMap urlMap = Maps.newHashMapWithExpectedSize((int)2);
            HashMap<String, Object> retdata = new HashMap<String, Object>();
            retdata.put("complete", Boolean.TRUE);
            retdata.put("info", this.ctx.getUrlLoggers());
            int total = 0;
            int failed = 0;
            for (String url : this.ctx.getAllUrls()) {
                ImportLogger logger = this.ctx.getLogger(url);
                total += logger.getTotal();
                failed += logger.getFailed();
                if (!this.hasErrorLine()) continue;
                this.outputFailedForData(url, logger, false, urlMap);
                this.outputFailedForData(url, logger, true, urlMap);
            }
            ImportLogHelper.logAll((Object)this.ctx.getLogId(), (String)JSON.toJSONString(retdata), (int)total, (int)failed);
            String allErrUrl = (String)urlMap.get("allErrFileUrl");
            String errUrl = (String)urlMap.get("errFileUrl");
            this.labelImportService.feedbackProgress(true, allErrUrl, errUrl);
        }
    }

    private boolean hasErrorLine() {
        Collection values = this.importLogger.getLogCache().values();
        for (List value : values) {
            if (value.size() <= 0) continue;
            return true;
        }
        return false;
    }

    private void fetchQueueData(ImportContext conf, String url, LinkedBlockingQueue<ImportBillData> dataQ) {
        int timeout = 0;
        ArrayList<ImportBillData> allRowdatas = new ArrayList<ImportBillData>();
        while (!(conf.isResolveComplete(url) && dataQ.isEmpty() || timeout > 500)) {
            ArrayList<ImportBillData> rowdatas = new ArrayList<ImportBillData>();
            int lastLeftCount = rowdatas.size();
            int needCount = 5000 - lastLeftCount;
            if (needCount > 0) {
                ImportBillData rowData;
                try {
                    rowData = dataQ.poll(2L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    continue;
                }
                if (rowData == null || rowData.isEmpty()) {
                    ++timeout;
                    continue;
                }
                rowdatas.add(rowData);
                dataQ.drainTo(rowdatas, needCount);
                rowdatas.removeIf(ImportBillData::isEmpty);
                allRowdatas.addAll(rowdatas);
            }
            timeout = 0;
        }
        if (allRowdatas.size() > 0 && conf.isResolveComplete(url)) {
            this.ctx.feedbackProgress(25, null, null);
            this.importBatchData(allRowdatas);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void outputFailedForData(String url, ImportLogger importLogger, boolean isAll, Map<String, String> urlMap) {
        block23: {
            String localPath = null;
            localPath = url.contains("http") ? ImportFileUtil.downloadTempFile((String)url) : ImportFileUtil.downloadFile((String)url);
            LOG.info("PermInitImportPlugin resolveExcel localPath:{}", (Object)localPath);
            try (FileInputStream inputStream = new FileInputStream(new File(ImportFileUtil.checkUrl((String)"tempfile", (String)localPath)));){
                new ExcelReader().read((InputStream)inputStream, (SheetHandler)new LabelImportFailedSheetHandler(importLogger, isAll, urlMap, this.lblObjId, this.lblId));
            }
            try {
                ImportFileUtil.deleteLocalTempFile((String)localPath);
            }
            catch (IOException ex) {
                LOG.error("PermInitImportPlugin--outputFailedForData error,", (Throwable)ex);
            }
            break block23;
            catch (Exception ex) {
                try {
                    LOG.error("PermInitImportPlugin--outputFailedForData error,", (Throwable)ex);
                    importLogger.log(Integer.valueOf(0), (Throwable)ex);
                }
                catch (Throwable throwable) {
                    try {
                        ImportFileUtil.deleteLocalTempFile(localPath);
                    }
                    catch (IOException ex2) {
                        LOG.error("PermInitImportPlugin--outputFailedForData error,", (Throwable)ex2);
                    }
                    throw throwable;
                }
                try {
                    ImportFileUtil.deleteLocalTempFile((String)localPath);
                }
                catch (IOException ex3) {
                    LOG.error("PermInitImportPlugin--outputFailedForData error,", (Throwable)ex3);
                }
            }
        }
    }

    private void importBatchData(List<ImportBillData> rowDataList) {
        try {
            LOG.info("LabelImportPlugin-importBatchData-data:{}", rowDataList);
            this.labelImportService.setTotalCount(rowDataList.size());
            this.labelImportService.validate(rowDataList, this.importLogger, this.labelData);
            Map logCache = this.importLogger.getLogCache();
            List dataList = rowDataList.stream().filter(rd -> !logCache.containsKey(rd.getData().getInteger("rowNum"))).map(ImportBillData::getData).collect(Collectors.toList());
            this.labelImportService.setSucceedCount(dataList.size());
            this.labelImportService.addData2Cache(dataList);
            this.setSuccessFlag("success");
        }
        catch (Throwable throwable) {
            this.getView().getPageCache().put("currentStatus", "terminator");
            this.setCacheError();
            this.setSuccessFlag("failed");
            LOG.error("LabelImportPlugin-- importBatchData error:", throwable);
        }
    }

    private void setCacheError() {
        IPageCache cache = (IPageCache)this.view.getService(IPageCache.class);
        String cachedLogStr = cache.get("Cached_Import_Logger");
        JSONObject map = StringUtils.isNotBlank((CharSequence)cachedLogStr) ? JSON.parseObject((String)cachedLogStr) : new JSONObject();
        map.put("sysError", (Object)"1");
        cachedLogStr = JSON.toJSONString((Object)map);
        cache.put("Cached_Import_Logger", cachedLogStr);
        cache.saveChanges();
    }

    private void setSuccessFlag(String msg) {
        IPageCache cache = (IPageCache)this.view.getService(IPageCache.class);
        cache.put("success", msg);
    }
}

