/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.label;

import java.util.EventObject;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.events.ListHyperLinkClickEvent;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hrcs.formplugin.web.label.dataprovider.LabelValueProvider;

public class LabelRelListPlugin
extends HRDataBaseList {
    private static final String BAR_EDITINDEX = "bar_editindex";
    private static final String CURRENT_MODULE = "hrmp-hrcs-formplugin";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{BAR_EDITINDEX});
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new LabelValueProvider());
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.setOrderBy("index");
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        if (BAR_EDITINDEX.equals(key)) {
            IListView listView = (IListView)this.getView();
            ListSelectedRowCollection selectedRows = listView.getSelectedRows();
            this.editIndex(selectedRows);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (BAR_EDITINDEX.equals(e.getActionId())) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void editIndex(ListSelectedRowCollection selectedRows) {
        if (selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u52fe\u9009\u9700\u8981\u4fee\u6539\u7684\u5173\u8054\u9879", (String)"LabelRelListPlugin_0", (String)CURRENT_MODULE, (Object[])new Object[0]));
            return;
        }
        if (selectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e00\u6b21\u53ea\u80fd\u4fee\u6539\u4e00\u4e2a\u5173\u8054\u9879\u7684\u6392\u5e8f\u53f7", (String)"LabelRelListPlugin_1", (String)CURRENT_MODULE, (Object[])new Object[0]));
            return;
        }
        Object relId = selectedRows.get(0).getPrimaryKeyValue();
        BaseShowParameter bsp = new BaseShowParameter();
        bsp.setPkId(relId);
        bsp.setHasRight(true);
        bsp.setFormId("hrcs_labelobjectrel");
        String title = ResManager.loadKDString((String)"\u7f16\u8f91\u6392\u5e8f\u53f7", (String)"LabelRelListPlugin_2", (String)CURRENT_MODULE, (Object[])new Object[0]);
        bsp.setCaption(title);
        bsp.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, BAR_EDITINDEX);
        bsp.setCloseCallBack(callBack);
        bsp.setStatus(OperationStatus.EDIT);
        this.getView().showForm((FormShowParameter)bsp);
    }

    public void hyperLinkClick(ListHyperLinkClickEvent e) {
        e.getKey();
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillListHyperLinkClickEvent listEvt = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        if ("label_number".equals(listEvt.getFieldName())) {
            ListSelectedRow currentRow = listEvt.getCurrentRow();
            Long relId = (Long)currentRow.getPrimaryKeyValue();
            HRBaseServiceHelper relServiceHelper = new HRBaseServiceHelper("hrcs_labelobjectrel");
            QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)relId)};
            DynamicObject relObject = relServiceHelper.queryOne("label", filters);
            Object labelId = relObject.get("label.id");
            BaseShowParameter bsp = new BaseShowParameter();
            bsp.setPkId(labelId);
            bsp.setHasRight(true);
            bsp.getCustomParams().put("labelNumber", relObject.getString("label.number"));
            bsp.setFormId("hrcs_label");
            bsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            bsp.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)bsp);
            args.setCancel(true);
        }
    }
}

